/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/

package org.jboss.portal.test.framework.server;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.Iterator;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 6136 $
 */
public class NodeManager
{

   /** The nodes. */
   private final Map nodeMap;

   public NodeManager(List nodes)
   {
      this.nodeMap = new HashMap();
      for (Iterator i = nodes.iterator();i.hasNext();)
      {
         Node node = (Node)i.next();
         nodeMap.put(node.getId(), node);
      }
   }

   public Collection getNodes()
   {
      return nodeMap.values();
   }

   public Node[] getNodes(NodeId[] nodeIds)
   {
      if (nodeIds == null)
      {
         throw new IllegalArgumentException("No null node ids accepted");
      }
      Node[] nodes = new Node[nodeIds.length];
      for (int i = 0;i < nodeIds.length;i++)
      {
         NodeId nodeId = nodeIds[i];
         if (nodeId == null)
         {
            throw new IllegalArgumentException("No null node id accepted");
         }
         nodes[i] = getNode(nodeId);
      }
      return nodes;
   }

   public Node getNode(NodeId nodeId)
   {
      if (nodeId == null)
      {
         throw new IllegalArgumentException("No null node id accepted");
      }
      return (Node)nodeMap.get(nodeId);
   }
}
