/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/

package org.jboss.portal.test.framework.server;

import java.io.Serializable;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 6136 $
 */
public class NodeId implements Serializable
{

   /** . */
   public static final NodeId DEFAULT = new NodeId("default");

   /** . */
   public static final NodeId PORTS_01 = new NodeId("ports-01");

   /** . */
   public static final NodeId PORTS_02 = new NodeId("ports-02");

   /** . */
   private final String value;

   public NodeId(String value)
   {
      if (value == null)
      {
         throw new IllegalArgumentException("No null value accepted");
      }
      this.value = value;
   }

   public String toString()
   {
      return value;
   }

   public boolean equals(Object o)
   {
      if (this == o)
      {
         return true;
      }
      if (o instanceof NodeId)
      {
         NodeId that = (NodeId)o;
         return value.equals(that.value);
      }
      return false;
   }

   public int hashCode()
   {
      return value.hashCode();
   }

   /**
    * Return the current node id.
    *
    * @return the current node id
    * @throws IllegalStateException if not in a node context
    */
   public static NodeId locate() throws IllegalStateException
   {
      // Legacy jboss server name
      String nodeName = System.getProperty("jboss.server.name");

      // Otherwise use a system property specified in the command line
      if (nodeName != null)
      {
         nodeName = System.getProperty("test.node.name");
      }

      // If nothing is specified we assume it is the default one
      if (nodeName == null)
      {
         nodeName = "default";
      }

      //
      if ("default".equals(nodeName))
      {
         return DEFAULT;
      }
      else if ("ports-01".equals(nodeName))
      {
         return PORTS_01;
      }
      else if ("ports-02".equals(nodeName))
      {
         return PORTS_02;
      }
      else
      {
         throw new IllegalStateException("Cannot determine node id " + nodeName);
      }
   }
}
