/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.test.framework.embedded;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.common.xml.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DSConfig {
    private String name;
    private String description;
    private String host;
    private String port;
    private String contextFactory;
    private String adminDN;
    private String adminPassword;
    private String configFile;
    private String populateLdif;
    private String cleanUpDN;

    public DSConfig(String name, String description, String host, String port, String contextFactory, String adminDN, String adminPass, String configFile, String populateLdif, String cleanUpDN) {
        this.name = name;
        this.description = description;
        this.host = host;
        this.port = port;
        this.contextFactory = contextFactory;
        this.adminDN = adminDN;
        this.adminPassword = adminPass;
        this.configFile = configFile;
        this.populateLdif = populateLdif;
        this.cleanUpDN = cleanUpDN;
    }

    public String toString() {
        return new StringBuffer().append("[").append(this.description).append("]/[").append(this.host).append(":").append(this.port).append("]").toString();
    }

    public static DSConfig obtainConfig(String directories, String directoryName) throws Exception {
        if (directoryName != null && directoryName.length() > 0) {
            DSConfig[] configs;
            URL url = Thread.currentThread().getContextClassLoader().getResource(directories);
            for (DSConfig config : configs = DSConfig.fromXML(url)) {
                if (!config.getName().equals(directoryName)) continue;
                return config;
            }
            throw new IllegalStateException("Could not obtain Config for {directoryName:directories} - {" + directoryName + ":" + directories + "}");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DSConfig[] fromXML(URL url) throws Exception {
        ArrayList<DSConfig> configs = new ArrayList<DSConfig>();
        BufferedInputStream in = null;
        try {
            in = IOTools.safeBufferedWrapper((InputStream)url.openStream());
            Document doc = XMLTools.getDocumentBuilderFactory().newDocumentBuilder().parse(in);
            Iterator i = XMLTools.getChildrenIterator((Element)doc.getDocumentElement(), (String)"directory");
            while (i.hasNext()) {
                Element childElt = (Element)i.next();
                Element nm = XMLTools.getUniqueChild((Element)childElt, (String)"directory-name", (boolean)true);
                Element desc = XMLTools.getUniqueChild((Element)childElt, (String)"description", (boolean)true);
                Element config = XMLTools.getUniqueChild((Element)childElt, (String)"config-file", (boolean)true);
                Element h = XMLTools.getUniqueChild((Element)childElt, (String)"host", (boolean)true);
                Element p = XMLTools.getUniqueChild((Element)childElt, (String)"port", (boolean)true);
                Element context = XMLTools.getUniqueChild((Element)childElt, (String)"context-factory", (boolean)true);
                Element admin = XMLTools.getUniqueChild((Element)childElt, (String)"admin-dn", (boolean)true);
                Element password = XMLTools.getUniqueChild((Element)childElt, (String)"admin-password", (boolean)true);
                Element populate = XMLTools.getUniqueChild((Element)childElt, (String)"populate-ldif", (boolean)true);
                Element cleanup = XMLTools.getUniqueChild((Element)childElt, (String)"cleanup-dn", (boolean)true);
                String name = XMLTools.asString((Element)nm);
                String description = XMLTools.asString((Element)desc);
                String configFile = XMLTools.asString((Element)config);
                String host = XMLTools.asString((Element)h);
                String port = XMLTools.asString((Element)p);
                String contextFactory = XMLTools.asString((Element)context);
                String adminDN = XMLTools.asString((Element)admin);
                String adminPassword = XMLTools.asString((Element)password);
                String populateLdif = XMLTools.asString((Element)populate);
                String cleanUpDN = XMLTools.asString((Element)cleanup);
                DSConfig dsCfg = new DSConfig(name, description, host, port, contextFactory, adminDN, adminPassword, configFile, populateLdif, cleanUpDN);
                configs.add(dsCfg);
            }
            DSConfig[] dSConfigArray = configs.toArray(new DSConfig[configs.size()]);
            return dSConfigArray;
        }
        finally {
            IOTools.safeClose((InputStream)in);
        }
    }

    public String getURL() {
        return new StringBuffer("ldap://").append(this.getHost()).append(":").append(this.getPort()).toString();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getContextFactory() {
        return this.contextFactory;
    }

    public void setContextFactory(String contextFactory) {
        this.contextFactory = contextFactory;
    }

    public String getAdminDN() {
        return this.adminDN;
    }

    public void setAdminDN(String adminDN) {
        this.adminDN = adminDN;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPopulateLdif() {
        return this.populateLdif;
    }

    public void setPopulateLdif(String populateLdif) {
        this.populateLdif = populateLdif;
    }

    public String getCleanUpDN() {
        return this.cleanUpDN;
    }

    public void setCleanUpDN(String cleanUpDN) {
        this.cleanUpDN = cleanUpDN;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }
}

