/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/

package org.jboss.portal.test.framework.deployment;

import org.jboss.portal.test.framework.server.Node;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.io.File;

/**
 * Client side view of deployment.
 *
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 7954 $
 */
public class Deployer
{

   /** . */
   private static final org.jboss.logging.Logger log = org.jboss.logging.Logger.getLogger(Deployer.class);

   /** . */
   private Map<URL,Deployment> deployments;

   public void create()
   {
   }

   public void start()
   {
      // Should check that the deployer agent is here
      deployments = new HashMap<URL,Deployment>();
   }

   public void stop()
   {
      for (URL url : new ArrayList<URL>(deployments.keySet()))
      {
         undeploy(url);
      }

      //
      deployments = null;
   }

   public void destroy()
   {
   }

   public void deploy(String parentName, String childName, Node node) throws Exception
   {
      deploy(parentName, childName, new Node[]{node});
   }

   public void deploy(File parent, String childName, Node node) throws Exception
   {
      deploy(parent, childName, new Node[]{node});
   }

   public void deploy(String parentName, String childName, Node[] nodes) throws Exception
   {
      deploy(new File(parentName), childName, nodes);
   }

   public void deploy(File parent, String childName, Node[] nodes) throws Exception
   {
      File file = new File(parent, childName);
      if (!file.exists())
      {
         String msg = "Cannot deploy inexisting file " + file.getAbsolutePath();
         log.error(msg);
         throw new IllegalArgumentException(msg);
      }

      //
      deploy(file.toURL(), nodes);
   }

   public void deploy(String url, Node node) throws Exception
   {
      deploy(url, new Node[]{node});
   }

   public void deploy(URL url, Node node) throws Exception
   {
      deploy(url, new Node[]{node});
   }

   public void deploy(URL url, Node[] nodes) throws Exception
   {
      Deployment deployment = new Deployment(nodes, url);
      deployment.deploy();
      deployments.put(url, deployment);
   }

   public void deploy(String url, Node[] nodes) throws Exception
   {
      this.deploy(new URL(url), nodes);
   }

   public void undeploy(URL url)
   {
      Deployment deployment = deployments.remove(url);
      if (deployment != null)
      {
         deployment.undeploy();
      }
   }

   public void undeploy(String parentName, String childName) throws Exception
   {
      undeploy(new File(parentName), childName);
   }

   public void undeploy(File parent, String childName) throws Exception
   {
      undeploy(new File(parent, childName).toURL());
   }

   public void undeploy(String url) throws Exception
   {
      this.undeploy(new URL(url));
   }
}
