/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.test.framework.runner;

import org.jboss.portal.test.framework.deployment.Deployer;
import org.jboss.portal.test.framework.server.NodeManager;
import org.jboss.portal.test.framework.server.NodeId;
import org.jboss.portal.test.framework.mc.TestRuntimeContext;
import org.apache.log4j.Appender;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.Level;
import org.apache.log4j.ConsoleAppender;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.AssertionFailedError;

import java.net.URL;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public class BaseRunner implements Test
{

   static
   {
      Appender appender = new ConsoleAppender(new SimpleLayout());
      org.jboss.logging.Logger.getRoot().addAppender(appender);
      org.jboss.logging.Logger.getRoot().setLevel(Level.INFO);
   }

   /** . */
   private static final int STOPPED = 0;

   /** . */
   private static final int FAILED = 1;

   /** . */
   private static final int STARTED = 2;

   /** The injected deployer. */
   private Deployer deployer;

   /** . */
   private NodeManager nodeManager;

   /** . */
   private TestRuntimeContext runtimeContext;

   /** . */
   private String archivePath;

   /** . */
//   private JUnitAdapter adapter;

   /** . */
   private int state;

   /** . */
   private Integer testCaseCount;

   /** . */
//   private RemoteTestDriverClient testDriverClient;

   /** The node id list used for this test suite. */
   private NodeId[] nodeIds;

   public BaseRunner(String beansDescriptorLocation)
   {
      this(beansDescriptorLocation, new NodeId[]{NodeId.DEFAULT});
   }

   public BaseRunner(String beansDescriptorLocation, NodeId[] nodeIds)
   {
      this.runtimeContext = new TestRuntimeContext(beansDescriptorLocation);
      this.runtimeContext.addBean("TestBean", this);
      this.archivePath = System.getProperty("test.root");
      this.state = STOPPED;
      this.nodeIds = nodeIds;
   }

   public String getArchivePath()
   {
      return archivePath;
   }

   public Deployer getDeployer()
   {
      return deployer;
   }

   public void setDeployer(Deployer deployer)
   {
      this.deployer = deployer;
   }

   public NodeManager getNodeManager()
   {
      return nodeManager;
   }

   public void setNodeManager(NodeManager nodeManager)
   {
      this.nodeManager = nodeManager;
   }

//   public RemoteTestDriverClient getTestDriverClient()
//   {
//      return testDriverClient;
//   }
//
//   public void setTestDriverClient(RemoteTestDriverClient testDriverClient)
//   {
//      this.testDriverClient = testDriverClient;
//   }

   private void startContext() throws Exception
   {
      runtimeContext.start();
   }

   private void stopContext()
   {
      runtimeContext.stop();
   }

   private void startIfNeeded() throws Exception
   {
      if (state == STOPPED)
      {
         try
         {
            startContext();

            // Configure driver further more (todo find a way to do that int the bean assembly)
            // testDriverClient.setInitialNodeId(nodeIds[0]);
            // testDriverClient.setArchivePath(archivePath);
            // testDriverClient.setNodeManager(nodeManager);

            // Get optional parametrization
            // TestParametrization parametrization = JUnitAdapter.getParametrization();

            //
            // adapter = new JUnitAdapter(testDriverClient, parametrization);
            state = STARTED;
         }
         finally
         {
            if (state == STOPPED)
            {
               state = FAILED;
            }
         }
      }
   }

   private void stopIfNeeded()
   {
      if (state == STARTED)
      {
         try
         {
            stopContext();
            state = STOPPED;
         }
         catch (Exception e)
         {
            e.printStackTrace();
         }
         finally
         {
            if (state == STARTED)
            {
               state = FAILED;
            }
            // adapter = null;
         }
      }
   }

   private Exception e;

   public int countTestCases()
   {
      if (testCaseCount == null)
      {
         try
         {
            startIfNeeded();
            // testCaseCount = new Integer(adapter.countTestCases());
         }
         catch (Exception e)
         {
            testCaseCount = new Integer(1);
            this.e = e;
         }
      }
      return testCaseCount.intValue();
   }

   public void run(TestResult testResult)
   {
      if (e == null)
      {
         try
         {
            startIfNeeded();
            // adapter.run(testResult);
         }
         catch (Exception e)
         {
            this.e = e;
         }
         finally
         {
            stopIfNeeded();
         }
      }
      if (e != null)
      {
         AssertionFailedError afe = new AssertionFailedError();
         afe.initCause(e);
         throw afe;
      }
   }

   protected void startRunner() throws Exception
   {
   }

   protected void stopRunner() throws Exception
   {
   }

   public final void create() throws Exception
   {
   }

   public final void start() throws Exception
   {
      startRunner();
   }

   public final void stop()
   {
      try
      {
         stopRunner();
      }
      catch (Exception e)
      {
         //
      }
   }

   public final void destroy()
   {
   }

   protected void deploy(URL url) throws Exception
   {
      getDeployer().deploy(url, getNodeManager().getNodes(nodeIds));
   }

   protected void undeploy(URL url)
   {
      getDeployer().undeploy(url);
   }
}
