/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.test.framework.common;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jboss.portal.test.framework.common.Log4JWriter;
import org.jboss.portal.test.framework.common.MultiValuedPropertyMap;
import org.jboss.portal.test.framework.common.ParameterValidation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tools {
    public static final int DEFAULT_BUFFER_SIZE = 512;
    public static final Logger log = Logger.getLogger(Tools.class);
    public static final String VMID = Tools.VMID();
    public static final Enumeration EMPTY_ENUMERATION = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    };
    public static final Iterator EMPTY_ITERATOR = new Iterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    };
    public static final ResourceBundle EMPTY_BUNDLE = new ResourceBundle(){

        protected Object handleGetObject(String key) {
            return null;
        }

        public Enumeration getKeys() {
            return EMPTY_ENUMERATION;
        }
    };

    private static String VMID() {
        try {
            BigInteger bi = BigInteger.valueOf(0L);
            byte[] address = InetAddress.getLocalHost().getAddress();
            for (int i = 0; i < 4; ++i) {
                bi = bi.shiftLeft(8);
                bi = bi.add(BigInteger.valueOf(address[i]));
            }
            bi = bi.shiftLeft(32);
            int code = System.identityHashCode(new Object());
            bi = bi.add(BigInteger.valueOf(code));
            byte[] bytes = bi.toByteArray();
            StringBuffer buffer = new StringBuffer();
            char[] chars = "0123456789ABCDEF".toCharArray();
            for (int i = 0; i < bytes.length; ++i) {
                buffer.append(chars[(bytes[i] & 0xF0) >> 4]).append(chars[bytes[i] & 0xF]);
            }
            return buffer.toString();
        }
        catch (UnknownHostException e) {
            e.printStackTrace(System.err);
            throw new Error("Cannot create VMID");
        }
    }

    public static <E> Enumeration<E> emptyEnumeration() {
        return EMPTY_ENUMERATION;
    }

    public static <E> Iterator<E> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static <E> Enumeration<E> toEnumeration(final Iterator<E> iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException();
        }
        return new Enumeration<E>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public E nextElement() {
                return iterator.next();
            }
        };
    }

    public static <E> Enumeration<E> toEnumeration(final E[] objects) {
        if (objects == null) {
            throw new IllegalArgumentException();
        }
        return new Enumeration<E>(){
            int index = 0;

            @Override
            public boolean hasMoreElements() {
                return this.index < objects.length;
            }

            @Override
            public E nextElement() {
                if (this.index < objects.length) {
                    return objects[this.index++];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public static <E> Enumeration<E> toEnumeration(final E o) {
        return new Enumeration<E>(){
            boolean hasMore = true;

            @Override
            public boolean hasMoreElements() {
                return this.hasMore;
            }

            @Override
            public E nextElement() {
                if (!this.hasMore) {
                    throw new NoSuchElementException();
                }
                this.hasMore = false;
                return o;
            }
        };
    }

    public static <E> Set<E> toSet(Enumeration<E> e) {
        if (e == null) {
            throw new IllegalArgumentException();
        }
        HashSet<E> set = new HashSet<E>();
        while (e.hasMoreElements()) {
            set.add(e.nextElement());
        }
        return set;
    }

    public static <E> Set<E> toSet(E ... objects) {
        if (objects == null) {
            throw new IllegalArgumentException();
        }
        HashSet<E> set = new HashSet<E>();
        for (E object : objects) {
            set.add(object);
        }
        return set;
    }

    public static <E> Set<E> toSet(Iterator<E> iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException();
        }
        return Tools.toSet(iterator, false);
    }

    public static <E> Set<E> toSet(Iterator<E> iterator, boolean preserveOrder) {
        if (iterator == null) {
            throw new IllegalArgumentException();
        }
        HashSet set = preserveOrder ? new LinkedHashSet() : new HashSet();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static <E> List<E> toList(Enumeration<E> e) {
        if (e == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<E> list = new ArrayList<E>();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        return list;
    }

    public static <E> List<E> toList(Iterator<E> iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<E> list = new ArrayList<E>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static <E> List<E> toList(E ... objects) {
        if (objects == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<E> list = new ArrayList<E>(objects.length);
        for (E object : objects) {
            list.add(object);
        }
        return list;
    }

    @Deprecated
    public static Object[] toArray(Iterator i) {
        return Tools.toList(i).toArray();
    }

    public static <E> Iterator<E> iterator(final E o) {
        return new Iterator<E>(){
            boolean done = false;

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            public E next() {
                if (this.done) {
                    throw new NoSuchElementException("Already iterated");
                }
                this.done = true;
                return o;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("read only");
            }
        };
    }

    public static <E> Iterator<E> iterator(E ... objects) throws IllegalArgumentException {
        if (objects == null) {
            throw new IllegalArgumentException("No null object array");
        }
        return Tools.iterator(objects, 0, objects.length);
    }

    public static <E> Iterator<E> iterator(final E[] objects, final int from, final int to) throws IllegalArgumentException {
        if (objects == null) {
            throw new IllegalArgumentException("No null object array");
        }
        if (from > to || from < 0 || to > objects.length) {
            throw new IllegalArgumentException("Invalid range [" + from + "," + to + "] for array of length " + objects.length);
        }
        return new Iterator<E>(){
            int index;
            {
                this.index = from;
            }

            @Override
            public boolean hasNext() {
                return this.index < to;
            }

            @Override
            public E next() {
                if (this.index >= to) {
                    throw new NoSuchElementException("Index is greater than the array length");
                }
                return objects[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("read only");
            }
        };
    }

    public static int computeStringHash(int hash, String s) {
        for (char c : s.toCharArray()) {
            hash = 31 * hash + c;
        }
        return hash;
    }

    public static byte[] md5(String text) {
        if (text == null) {
            throw new NullPointerException("null text");
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(text.getBytes());
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)"Cannot find MD5 algorithm", (Throwable)e);
            throw new RuntimeException("Cannot find MD5 algorithm");
        }
    }

    public static String md5AsHexString(String text) {
        return Tools.toHexString(Tools.md5(text));
    }

    public static String hashAndEncodeString(String text, String algorithm, String encoding) throws NoSuchAlgorithmException {
        if (text == null) {
            throw new NullPointerException("null text");
        }
        if (algorithm == null) {
            throw new NullPointerException("null algorithm");
        }
        if (encoding == null) {
            throw new NullPointerException("null encoding");
        }
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.update(text.getBytes());
        byte[] encoded = md.digest();
        if ("HEX".equalsIgnoreCase(encoding)) {
            return Tools.toHexString(encoded);
        }
        throw new IllegalArgumentException("Not supported encoding: " + encoding);
    }

    public static String toHexString(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("byte array must not be null");
        }
        StringBuffer hex = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            hex.append(Character.forDigit((bytes[i] & 0xF0) >> 4, 16));
            hex.append(Character.forDigit(bytes[i] & 0xF, 16));
        }
        return hex.toString();
    }

    public static byte[] fromHexString(String hex) {
        if (hex == null) {
            throw new IllegalArgumentException("Hex string must not be null");
        }
        if (hex.length() % 2 == 1) {
            throw new IllegalArgumentException("Hex string length is not even : " + hex.length());
        }
        int index = 0;
        byte[] bytes = new byte[hex.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            byte value;
            char clow;
            int low;
            char chigh;
            int high;
            if ((high = Character.digit(chigh = hex.charAt(index++), 16)) == -1) {
                throw new IllegalArgumentException("Hex string contains a bad char : " + chigh);
            }
            if ((low = Character.digit(clow = hex.charAt(index++), 16)) == -1) {
                throw new IllegalArgumentException("Hex string contains a bad char : " + clow);
            }
            bytes[i] = value = (byte)((high << 4) + low);
        }
        return bytes;
    }

    public static String generateTemporaryHash(String value, long time) {
        if (value == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return Tools.md5AsHexString(value + calendar.getTimeInMillis());
    }

    public static boolean confirmTemporaryHash(String hash, String value, long time) {
        if (hash == null) {
            return false;
        }
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        String expected = Tools.md5AsHexString(value + calendar.getTimeInMillis());
        if (expected.equals(hash)) {
            return true;
        }
        calendar.add(11, -1);
        expected = Tools.md5AsHexString(value + calendar.getTimeInMillis());
        return expected.equals(hash);
    }

    public static String getShortNameOf(Class clazz) {
        return clazz.getSimpleName();
    }

    public static String getPackageOf(Class clazz) {
        String name = clazz.getName();
        int index = name.lastIndexOf(46);
        name = index != -1 ? name.substring(0, index) : "";
        return name;
    }

    public static String buildClassLoaderInfo(ClassLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException("no loader");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("ClassLoader[Name=").append(loader.getClass().getName());
        buffer.append(",HashCode=").append(loader.hashCode());
        buffer.append(",IdentityHashCode=").append(System.identityHashCode(loader));
        if (loader instanceof URLClassLoader) {
            URLClassLoader urlLoader = (URLClassLoader)loader;
            URL[] urls = urlLoader.getURLs();
            for (int i = 0; i < urls.length; ++i) {
                URL url = urls[i];
                buffer.append(",URL(").append(i).append(")=").append(url);
            }
        }
        try {
            Class<?> uclClass = Thread.currentThread().getContextClassLoader().loadClass("org.jboss.mx.loading.UnifiedClassLoader");
            Class<?> loaderClass = loader.getClass();
            if (uclClass.isAssignableFrom(loaderClass)) {
                URL url = (URL)loaderClass.getMethod("getURL", new Class[0]).invoke((Object)loader, new Object[0]);
                buffer.append(",GetURL=").append(url);
            }
        }
        catch (Exception e) {
            log.error((Object)"Cannot get UCL infos", (Throwable)e);
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static String dumpClassLoaderHierarchyInfo(ClassLoader loader) {
        StringWriter writer = new StringWriter();
        Tools.dumpClassLoaderHierarchyInfo(writer, loader);
        return writer.toString();
    }

    public static void dumpClassLoaderHierarchyInfo(Writer writer, ClassLoader loader) {
        if (writer == null) {
            throw new IllegalArgumentException("no writer");
        }
        if (loader == null) {
            throw new IllegalArgumentException("no loader");
        }
        PrintWriter pw = null;
        pw = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        pw.println("<classloader-dump>");
        while (loader != null) {
            pw.println(Tools.buildClassLoaderInfo(loader));
            loader = loader.getParent();
        }
        pw.print("</classloader-dump>");
        pw.flush();
    }

    public static void dumpClassLoaderHierarchyInfo(Logger log, ClassLoader loader) {
        Log4JWriter writer = new Log4JWriter(log, Level.DEBUG);
        Tools.dumpClassLoaderHierarchyInfo(writer, loader);
    }

    public static void dumpClassLoaderHierarchyInfo(Logger log, Level level, ClassLoader loader) {
        Log4JWriter writer = new Log4JWriter(log, level);
        Tools.dumpClassLoaderHierarchyInfo(writer, loader);
    }

    public static String replace(String string, String pattern, String replacement) {
        StringBuffer buffer = new StringBuffer(string.length());
        int previous = 0;
        int current = string.indexOf(pattern);
        while (current != -1) {
            buffer.append(string.substring(previous, current));
            buffer.append(replacement);
            previous = current + pattern.length();
            current = string.indexOf(pattern, previous);
        }
        buffer.append(string.substring(previous));
        return buffer.toString();
    }

    public static <E> E[] appendTo(E[] array, E o) throws IllegalArgumentException, ClassCastException {
        if (array == null) {
            throw new IllegalArgumentException();
        }
        Class<?> componentType = array.getClass().getComponentType();
        if (o != null && !componentType.isAssignableFrom(o.getClass())) {
            throw new ClassCastException("Object with class " + o.getClass().getName() + " cannot be casted to class " + componentType.getName());
        }
        Object[] copy = (Object[])Array.newInstance(componentType, array.length + 1);
        System.arraycopy(array, 0, copy, 0, array.length);
        copy[array.length] = o;
        return copy;
    }

    public static boolean safeEquals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static String replaceAllInstancesOfBoundedString(String initial, String prefix, String suffix, String replacement) {
        return Tools.replaceBoundedString(initial, prefix, suffix, replacement, true, false);
    }

    public static String replaceBoundedString(String initial, String prefix, String suffix, String replacement, boolean replaceIfBoundedStringEmpty, boolean keepBoundaries) {
        if (initial == null || initial.length() == 0) {
            return initial;
        }
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty(prefix, "prefix", "Tools.replaceBoundedString");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty(suffix, "suffix", "Tools.replaceBoundedString");
        ParameterValidation.throwIllegalArgExceptionIfNull(replacement, "replacement");
        StringBuffer tmp = new StringBuffer(initial);
        int prefixIndex = tmp.indexOf(prefix);
        int suffixLength = suffix.length();
        int prefixLength = prefix.length();
        while (prefixIndex != -1) {
            int suffixIndex = tmp.indexOf(suffix, prefixIndex);
            if (suffixIndex != -1 && (replaceIfBoundedStringEmpty || suffixIndex != prefixIndex + prefixLength)) {
                if (keepBoundaries) {
                    tmp.delete(prefixIndex + prefixLength, suffixIndex);
                    tmp.insert(prefixIndex + prefixLength, replacement);
                } else {
                    tmp.delete(prefixIndex, suffixIndex + suffixLength);
                    tmp.insert(prefixIndex, replacement);
                }
            }
            prefixIndex = tmp.indexOf(prefix, prefixIndex + prefixLength);
        }
        return tmp.toString();
    }

    public static boolean isContainedIn(Object value, Object[] array) {
        if (value == null) {
            return false;
        }
        if (array != null) {
            for (Object anArray : array) {
                if (!value.equals(anArray)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> T safeCast(Object value, Class<T> type) {
        if (value == null) {
            return null;
        }
        if (type.isAssignableFrom(value.getClass())) {
            return type.cast(value);
        }
        return null;
    }

    public static <T> MultiValuedPropertyMap<T> emptyMultiValuedPropertyMap() {
        return new MultiValuedPropertyMap<T>(){

            @Override
            public T getValue(String key) throws IllegalArgumentException {
                if (key == null) {
                    throw new IllegalArgumentException("Key cannot be null");
                }
                return null;
            }

            @Override
            public List<T> getValues(String key) throws IllegalArgumentException {
                if (key == null) {
                    throw new IllegalArgumentException("Key cannot be null");
                }
                return null;
            }

            @Override
            public void addValue(String key, T value) throws IllegalArgumentException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setValue(String key, T value) throws IllegalArgumentException {
                throw new UnsupportedOperationException();
            }

            @Override
            public Set<String> keySet() {
                return Collections.emptySet();
            }

            @Override
            public int size() {
                return 0;
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void append(MultiValuedPropertyMap<T> appended) throws IllegalArgumentException {
                throw new UnsupportedOperationException();
            }
        };
    }
}

