/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.test.framework.embedded;

import java.io.BufferedInputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.jboss.portal.test.framework.common.io.IOTools;
import org.jboss.portal.test.framework.common.xml.XMLTools;
import org.jboss.resource.adapter.jdbc.local.LocalTxDataSource;
import org.jboss.resource.connectionmanager.CachedConnectionManagerReference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DataSourceSupport {
    private TransactionManager transactionManager;
    private CachedConnectionManagerReference connectionManagerReference;
    private Config config;
    private String jndiName = "java:/DefaultDS";
    private LocalTxDataSource ds;

    public DataSourceSupport(Config cfg) {
        this.config = cfg;
    }

    public DataSourceSupport() {
        this(new Config("", "", "", "", ""));
    }

    public void create() {
    }

    public void start() throws Exception {
        this.ds = new LocalTxDataSource();
        this.ds.setConnectionURL(this.config.getConnectionURL());
        this.ds.setDriverClass(this.config.getDriverClass());
        this.ds.setUserName(this.config.getUserName());
        this.ds.setPassword(this.config.getPassword());
        this.ds.setJndiName(this.jndiName);
        this.ds.setMaxSize(10);
        this.ds.setMinSize(0);
        this.ds.setBlockingTimeout(1000);
        this.ds.setIdleTimeout(10000L);
        this.ds.setTransactionManager(this.transactionManager);
        this.ds.setCachedConnectionManager(this.connectionManagerReference);
        this.ds.setInitialContextProperties(new Hashtable());
        this.ds.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if ("org.hsqldb.jdbcDriver".equals(this.config.driverClass)) {
            try {
                DataSource ds = (DataSource)new InitialContext().lookup(this.jndiName);
                Connection conn = null;
                Statement st = null;
                try {
                    conn = ds.getConnection();
                    st = conn.createStatement();
                    st.execute("SHUTDOWN");
                }
                catch (Throwable throwable) {
                    IOTools.safeClose(st);
                    IOTools.safeClose(conn);
                    throw throwable;
                }
                IOTools.safeClose(st);
                IOTools.safeClose(conn);
            }
            catch (Exception e) {
                System.out.println("was not able to shutdown hsqldb");
                e.printStackTrace();
            }
        }
        this.ds = null;
    }

    public void destroy() {
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public CachedConnectionManagerReference getConnectionManagerReference() {
        return this.connectionManagerReference;
    }

    public void setConnectionManagerReference(CachedConnectionManagerReference connectionManagerReference) {
        this.connectionManagerReference = connectionManagerReference;
    }

    public static class Config {
        private String name;
        private String connectionURL;
        private String driverClass;
        private String userName;
        private String password;

        public Config(String name, String connectionURL, String driverClass, String userName, String password) {
            this.name = name;
            this.connectionURL = connectionURL;
            this.driverClass = driverClass;
            this.userName = userName;
            this.password = password;
        }

        public Config() {
        }

        public String getName() {
            return this.name;
        }

        public String getConnectionURL() {
            return this.connectionURL;
        }

        public String getDriverClass() {
            return this.driverClass;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getPassword() {
            return this.password;
        }

        public String toString() {
            return "Datasource[" + this.name + "]";
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setConnectionURL(String connectionURL) {
            this.connectionURL = connectionURL;
        }

        public void setDriverClass(String driverClass) {
            this.driverClass = driverClass;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Config[] fromXML(URL url) throws Exception {
            ArrayList<Config> configs = new ArrayList<Config>();
            BufferedInputStream in = null;
            try {
                in = IOTools.safeBufferedWrapper(url.openStream());
                Document doc = XMLTools.getDocumentBuilderFactory().newDocumentBuilder().parse(in);
                Iterator<Element> i = XMLTools.getChildrenIterator(doc.getDocumentElement(), "datasource");
                while (i.hasNext()) {
                    Element childElt = i.next();
                    Element nameElt = XMLTools.getUniqueChild(childElt, "datasource-name", false);
                    if (nameElt == null) {
                        System.out.println("XML element datasource-name is not present, trying deprecated display-name element instead, you should fix your datasources.xml");
                        nameElt = XMLTools.getUniqueChild(childElt, "display-name", true);
                    }
                    Element connectionURLElt = XMLTools.getUniqueChild(childElt, "connection-url", true);
                    Element driverClassElt = XMLTools.getUniqueChild(childElt, "driver-class", true);
                    Element userNameElt = XMLTools.getUniqueChild(childElt, "user-name", true);
                    Element passwordElt = XMLTools.getUniqueChild(childElt, "password", true);
                    String name = XMLTools.asString(nameElt);
                    String connectionURL = XMLTools.asString(connectionURLElt);
                    String driverClass = XMLTools.asString(driverClassElt);
                    String userName = XMLTools.asString(userNameElt);
                    String password = XMLTools.asString(passwordElt);
                    Config dsCfg = new Config(name, connectionURL, driverClass, userName, password);
                    configs.add(dsCfg);
                }
                Config[] configArray = configs.toArray(new Config[configs.size()]);
                return configArray;
            }
            finally {
                IOTools.safeClose(in);
            }
        }

        public static Config obtainConfig(String datasources, String dataSourceName) throws Exception {
            Config[] configs;
            URL url = Thread.currentThread().getContextClassLoader().getResource(datasources);
            for (Config config : configs = Config.fromXML(url)) {
                if (!config.getName().equals(dataSourceName)) continue;
                return config;
            }
            throw new IllegalStateException("Could not obtain Config for {datasourceName:datasources} - {" + dataSourceName + ":" + datasources + "}");
        }
    }
}

