/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.test.framework.impl.generic.server;

import org.jboss.portal.test.framework.server.Node;
import org.jboss.portal.test.framework.server.NodeId;
import org.jboss.portal.test.framework.impl.generic.config.ServerConfig;
import org.jboss.portal.test.framework.impl.generic.config.NodeConfig;
import org.jboss.portal.test.framework.impl.generic.config.ServiceConfig;
import org.jboss.portal.test.framework.impl.generic.agent.GenericTestAgent;
import org.jboss.portal.test.framework.agent.TestAgent;

import java.net.URL;
import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public class GenericNodeFactory
{

   /** . */
   private final URL serverConfigURL;

   /** . */
   private String serverName;

   /** . */
   private final Map nodes;

   public GenericNodeFactory(String serverConfigLocation, String serverName)
   {
      if (serverConfigLocation == null)
      {
         throw new IllegalArgumentException("No null servers.xml location accepted");
      }
      if (serverName == null)
      {
         throw new IllegalArgumentException("No null server name accepted");
      }

      //
      URL serverConfigURL = Thread.currentThread().getContextClassLoader().getResource(serverConfigLocation);
      if (serverConfigURL == null)
      {
         throw new IllegalArgumentException("No invalid servers.xml location=" + serverConfigLocation  + " accepted");
      }

      //
      this.serverName = serverName;
      this.serverConfigURL = serverConfigURL;
      this.nodes = new HashMap();
   }

   public String getServerName()
   {
      return serverName;
   }

   public URL getServerConfigURL()
   {
      return serverConfigURL;
   }

   public void start() throws Exception
   {
      Map cfgs = ServerConfig.createConfigs(serverConfigURL);

      // Get the appropriate config
      ServerConfig serverCfg = (ServerConfig)cfgs.get(serverName);

      //
      if (serverCfg == null)
      {
         throw new IllegalStateException("Cannot start the node factory because the config for the server " + serverName + " has not been found");
      }

      //
      for (Iterator i = serverCfg.getNodes().values().iterator();i.hasNext();)
      {
         NodeConfig nodeCfg = (NodeConfig)i.next();

         //
         Map serviceLookupMap = new HashMap();
         for (Iterator j = nodeCfg.getServices().values().iterator();j.hasNext();)
         {
            ServiceConfig serviceCfg = (ServiceConfig)j.next();
            GenericServiceLookup serviceLookup = new GenericRemoteServiceLookup(serviceCfg.getURI(), serviceCfg.getInterfaceClass());
            serviceLookupMap.put(serviceCfg.getName(), serviceLookup);
         }

         //
         GenericTestAgent testAgent = new GenericTestAgent();
         testAgent.setAuthenticationConfig(nodeCfg.getAuthentication());
         testAgent.setDeployerConfig(nodeCfg.getDeployer());
         serviceLookupMap.put(TestAgent.SERVICE_ID, testAgent);

         //
         GenericNode node = new GenericNode(nodeCfg.getId(), serviceLookupMap);
         nodes.put(node.getId(), node);
      }
   }

   public Node getNode(String nodeId)
   {
      return (Node)nodes.get(new NodeId(nodeId));
   }
}
