/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.test.framework.impl.generic.server;

import org.jboss.portal.test.framework.server.ServiceLookupFailedException;
import org.jboss.remoting.transporter.TransporterClient;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public class GenericRemoteServiceLookup extends GenericServiceLookup
{

   /** . */
   private final String locatorURI;

   /** . */
   private final String serviceInterface;

   public GenericRemoteServiceLookup(String locatorURI, String serviceInterface)
   {
      this.locatorURI = locatorURI;
      this.serviceInterface = serviceInterface;
   }

   public Object lookupService() throws ServiceLookupFailedException
   {
      try
      {
         Class proxyInterface = Thread.currentThread().getContextClassLoader().loadClass(serviceInterface);
         return TransporterClient.createTransporterClient(locatorURI, proxyInterface);
      }
      catch (ClassNotFoundException e)
      {
         throw new ServiceLookupFailedException(e);
      }
      catch (Exception e)
      {
         throw new ServiceLookupFailedException(e);
      }
   }
}
