/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/

package org.jboss.portal.test.framework.server;

import java.util.Map;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 6136 $
 */
public class Node
{

   /** . */
   protected final NodeId id;

   /** . */
   protected final Map serviceLookups;

   public Node(String id, Map serviceLookups)
   {
      this.id = new NodeId(id);
      this.serviceLookups = serviceLookups;
   }

   /**
    * Returns the node id.
    *
    * @return the node id
    */
   public NodeId getId()
   {
      return id;
   }

   public Object lookupService(String serviceId) throws ServiceLookupFailedException
   {
      ServiceLookup lookup = (ServiceLookup)serviceLookups.get(serviceId);

      //
      if (lookup == null)
      {
         throw new ServiceLookupFailedException("No service lookup bound under the service id " + serviceId);
      }

      //
      return lookup.lookupService();
   }

   public String toString()
   {
      return "Node[" + id + "]";
   }
}
