/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Locale;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.StringManager;
import org.apache.coyote.ActionCode;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;

public class InputBuffer
extends Reader
implements ByteChunk.ByteInputChannel,
CharChunk.CharInputChannel {
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.connector");
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public final int INITIAL_STATE = 0;
    public final int CHAR_STATE = 1;
    public final int BYTE_STATE = 2;
    private ByteChunk bb;
    private CharChunk cb;
    private int state = 0;
    private boolean closed = false;
    private boolean eof = false;
    private String enc;
    private boolean gotEnc = false;
    protected HashMap<String, B2CConverter> encoders = new HashMap();
    protected B2CConverter conv;
    private org.apache.coyote.Request coyoteRequest;
    private Request request;
    private int markPos = -1;
    private int size = -1;

    public InputBuffer(Request request) {
        this(request, 8192);
    }

    public InputBuffer(Request request, int size) {
        this.request = request;
        this.size = size;
        this.bb = new ByteChunk(size);
        this.bb.setLimit(size);
        this.bb.setByteInputChannel(this);
        this.cb = new CharChunk(size);
        this.cb.setLimit(size);
        this.cb.setOptimizedWrite(false);
        this.cb.setCharInputChannel(this);
    }

    public void setRequest(org.apache.coyote.Request coyoteRequest) {
        this.coyoteRequest = coyoteRequest;
    }

    public org.apache.coyote.Request getRequest() {
        return this.coyoteRequest;
    }

    public void recycle() {
        this.state = 0;
        if (this.cb.getChars().length > this.size) {
            this.cb = new CharChunk(this.size);
            this.cb.setLimit(this.size);
            this.cb.setOptimizedWrite(false);
            this.cb.setCharInputChannel(this);
        } else {
            this.cb.recycle();
        }
        this.markPos = -1;
        this.bb.recycle();
        this.closed = false;
        this.eof = false;
        if (this.conv != null) {
            this.conv.recycle();
        }
        this.gotEnc = false;
        this.enc = null;
    }

    public void clearEncoders() {
        this.encoders.clear();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isEof() {
        return this.eof;
    }

    public int available() {
        if (this.eof || this.closed) {
            return -1;
        }
        int available = 0;
        if (this.state != 1) {
            available = this.bb.getLength();
            if (this.request.isEventMode() && available == 0) {
                try {
                    this.coyoteRequest.action(ActionCode.ACTION_AVAILABLE, null);
                    available = this.realReadBytes(null, 0, 0);
                }
                catch (IOException e) {}
            }
        } else {
            available = this.cb.getLength();
            if (this.request.isEventMode() && available == 0) {
                try {
                    this.coyoteRequest.action(ActionCode.ACTION_AVAILABLE, null);
                    available = this.realReadChars(null, 0, this.cb.getBuffer().length);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return available;
    }

    public int getAvailable() {
        if (this.eof || this.closed) {
            return -1;
        }
        int available = 0;
        available = this.state != 1 ? this.bb.getLength() : this.cb.getLength();
        return available;
    }

    @Override
    public int realReadBytes(byte[] cbuf, int off, int len) throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.coyoteRequest == null) {
            return -1;
        }
        if (this.state == 0) {
            this.state = 2;
        }
        try {
            int n = this.coyoteRequest.doRead(this.bb);
            if (n < 0) {
                this.eof = true;
            }
            return n;
        }
        catch (IOException e) {
            throw new ClientAbortException(e);
        }
    }

    public int readByte() throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        return this.bb.substract();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        return this.bb.substract(b, off, len);
    }

    public void setEncoding(String s) {
        this.enc = s;
    }

    @Override
    public int realReadChars(char[] cbuf, int off, int len) throws IOException {
        if (!this.gotEnc) {
            this.setConverter();
        }
        if (this.bb.getLength() <= 0 && this.realReadBytes(this.bb.getBytes(), 0, this.bb.getBytes().length) < 0) {
            return -1;
        }
        if (this.markPos == -1) {
            this.cb.setOffset(0);
            this.cb.setEnd(0);
        } else {
            this.cb.makeSpace(this.bb.getLength());
            if (this.cb.getBuffer().length - this.cb.getEnd() == 0) {
                this.cb.setOffset(0);
                this.cb.setEnd(0);
                this.markPos = -1;
            }
        }
        this.state = 1;
        this.conv.convert(this.bb, this.cb);
        return this.cb.getLength();
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        return this.cb.substract();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        return this.cb.substract(cbuf, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        if (n < 0L) {
            throw new IllegalArgumentException();
        }
        long nRead = 0L;
        while (nRead < n) {
            if ((long)this.cb.getLength() >= n) {
                this.cb.setOffset(this.cb.getStart() + (int)n);
                nRead = n;
                continue;
            }
            this.cb.setOffset(this.cb.getEnd());
            int toRead = 0;
            toRead = (long)this.cb.getChars().length < n - (nRead += (long)this.cb.getLength()) ? this.cb.getChars().length : (int)(n - nRead);
            int nb = this.realReadChars(this.cb.getChars(), 0, toRead);
            if (nb >= 0) continue;
            break;
        }
        return nRead;
    }

    @Override
    public boolean ready() throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        return this.available() > 0;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        if (this.cb.getLength() <= 0) {
            this.cb.setOffset(0);
            this.cb.setEnd(0);
        } else if (this.cb.getBuffer().length > 2 * this.size && this.cb.getLength() < this.cb.getStart()) {
            System.arraycopy(this.cb.getBuffer(), this.cb.getStart(), this.cb.getBuffer(), 0, this.cb.getLength());
            this.cb.setEnd(this.cb.getLength());
            this.cb.setOffset(0);
        }
        if (this.cb.getStart() + readAheadLimit > this.cb.getLimit()) {
            this.cb.setLimit(this.cb.getStart() + readAheadLimit);
        }
        this.markPos = this.cb.getStart();
    }

    @Override
    public void reset() throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        if (this.state == 1) {
            if (this.markPos < 0) {
                throw new IOException();
            }
            this.cb.setOffset(this.markPos);
        } else {
            this.bb.recycle();
        }
    }

    public void checkConverter() throws IOException {
        if (!this.gotEnc) {
            this.setConverter();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void setConverter() throws IOException {
        if (this.coyoteRequest != null) {
            this.enc = this.coyoteRequest.getCharacterEncoding();
        }
        this.gotEnc = true;
        this.enc = this.enc == null ? "ISO-8859-1" : this.enc.toUpperCase(Locale.US);
        this.conv = this.encoders.get(this.enc);
        if (this.conv == null) {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                try {
                    this.conv = (B2CConverter)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            return new B2CConverter(InputBuffer.this.enc);
                        }
                    });
                }
                catch (PrivilegedActionException ex) {
                    e = ex.getException();
                    if (!(e instanceof IOException)) ** GOTO lbl16
                    throw (IOException)e;
                }
            } else {
                this.conv = new B2CConverter(this.enc);
            }
lbl16:
            // 3 sources

            this.encoders.put(this.enc, this.conv);
        }
    }
}

