/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.rewrite;

import java.util.Calendar;
import org.apache.catalina.connector.Request;
import org.apache.naming.resources.CacheEntry;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.jboss.web.rewrite.Resolver;

public class TomcatResolver
extends Resolver {
    protected Request request = null;

    public TomcatResolver(Request request) {
        this.request = request;
    }

    @Override
    public String resolve(String key) {
        if (key.equals("HTTP_USER_AGENT")) {
            return this.request.getHeader("user-agent");
        }
        if (key.equals("HTTP_REFERER")) {
            return this.request.getHeader("referer");
        }
        if (key.equals("HTTP_COOKIE")) {
            return this.request.getHeader("cookie");
        }
        if (key.equals("HTTP_FORWARDED")) {
            return this.request.getHeader("forwarded");
        }
        if (key.equals("HTTP_HOST")) {
            int index;
            String host = this.request.getHeader("host");
            int n = index = host != null ? host.indexOf(58) : -1;
            if (index != -1) {
                host = host.substring(0, index);
            }
            return host;
        }
        if (key.equals("HTTP_PROXY_CONNECTION")) {
            return this.request.getHeader("proxy-connection");
        }
        if (key.equals("HTTP_ACCEPT")) {
            return this.request.getHeader("accept");
        }
        if (key.equals("REMOTE_ADDR")) {
            return this.request.getRemoteAddr();
        }
        if (key.equals("REMOTE_HOST")) {
            return this.request.getRemoteHost();
        }
        if (key.equals("REMOTE_PORT")) {
            return String.valueOf(this.request.getRemotePort());
        }
        if (key.equals("REMOTE_USER")) {
            return this.request.getRemoteUser();
        }
        if (key.equals("REMOTE_IDENT")) {
            return this.request.getRemoteUser();
        }
        if (key.equals("REQUEST_METHOD")) {
            return this.request.getMethod();
        }
        if (key.equals("SCRIPT_FILENAME")) {
            return this.request.getRealPath(this.request.getServletPath());
        }
        if (key.equals("REQUEST_PATH")) {
            return this.request.getRequestPathMB().toString();
        }
        if (key.equals("CONTEXT_PATH")) {
            return this.request.getContextPath();
        }
        if (key.equals("SERVLET_PATH")) {
            return TomcatResolver.emptyStringIfNull(this.request.getServletPath());
        }
        if (key.equals("PATH_INFO")) {
            return TomcatResolver.emptyStringIfNull(this.request.getPathInfo());
        }
        if (key.equals("QUERY_STRING")) {
            return TomcatResolver.emptyStringIfNull(this.request.getQueryString());
        }
        if (key.equals("AUTH_TYPE")) {
            return this.request.getAuthType();
        }
        if (key.equals("DOCUMENT_ROOT")) {
            return this.request.getRealPath("/");
        }
        if (key.equals("SERVER_NAME")) {
            return this.request.getLocalName();
        }
        if (key.equals("SERVER_ADDR")) {
            return this.request.getLocalAddr();
        }
        if (key.equals("SERVER_PORT")) {
            return String.valueOf(this.request.getLocalPort());
        }
        if (key.equals("SERVER_PROTOCOL")) {
            return this.request.getProtocol();
        }
        if (key.equals("SERVER_SOFTWARE")) {
            return "tomcat";
        }
        if (key.equals("THE_REQUEST")) {
            return this.request.getMethod() + " " + this.request.getRequestURI() + " " + this.request.getProtocol();
        }
        if (key.equals("REQUEST_URI")) {
            return this.request.getRequestURI();
        }
        if (key.equals("REQUEST_FILENAME")) {
            return this.request.getPathTranslated();
        }
        if (key.equals("HTTPS")) {
            return this.request.isSecure() ? "on" : "off";
        }
        if (key.equals("TIME_YEAR")) {
            return String.valueOf(Calendar.getInstance().get(1));
        }
        if (key.equals("TIME_MON")) {
            return String.valueOf(Calendar.getInstance().get(2));
        }
        if (key.equals("TIME_DAY")) {
            return String.valueOf(Calendar.getInstance().get(5));
        }
        if (key.equals("TIME_HOUR")) {
            return String.valueOf(Calendar.getInstance().get(11));
        }
        if (key.equals("TIME_MIN")) {
            return String.valueOf(Calendar.getInstance().get(12));
        }
        if (key.equals("TIME_SEC")) {
            return String.valueOf(Calendar.getInstance().get(13));
        }
        if (key.equals("TIME_WDAY")) {
            return String.valueOf(Calendar.getInstance().get(7));
        }
        if (key.equals("TIME")) {
            return FastHttpDateFormat.getCurrentDate();
        }
        return null;
    }

    @Override
    public String resolveEnv(String key) {
        return System.getProperty(key);
    }

    @Override
    public String resolveSsl(String key) {
        return null;
    }

    @Override
    public String resolveHttp(String key) {
        return this.request.getHeader(key);
    }

    @Override
    public boolean resolveResource(int type, String name) {
        ProxyDirContext resources = (ProxyDirContext)this.request.getContext().getResources();
        CacheEntry cacheEntry = resources.lookupCache(name);
        if (!cacheEntry.exists) {
            return false;
        }
        switch (type) {
            case 0: {
                return cacheEntry.resource == null;
            }
            case 1: {
                return cacheEntry.resource != null;
            }
            case 2: {
                return cacheEntry.resource != null && cacheEntry.attributes.getContentLength() > 0L;
            }
        }
        return false;
    }

    private static final String emptyStringIfNull(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }
}

