/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.coyote.Adapter;
import org.apache.coyote.Constants;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.RequestGroupInfo;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.ajp.AjpProcessor;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.net.JIoEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.res.StringManager;
import org.jboss.logging.Logger;

public class AjpProtocol
implements ProtocolHandler,
MBeanRegistration {
    protected static Logger log = Logger.getLogger(AjpProtocol.class);
    protected static StringManager sm = StringManager.getManager("org.apache.coyote.ajp");
    protected ObjectName tpOname;
    protected ObjectName rgOname;
    protected JIoEndpoint endpoint = new JIoEndpoint();
    protected Hashtable attributes = new Hashtable();
    private Adapter adapter;
    private AjpConnectionHandler cHandler = new AjpConnectionHandler(this);
    protected int processorCache = -1;
    protected boolean tomcatAuthentication = true;
    protected String requiredSecret = null;
    protected int packetSize = 8192;
    protected int keepAliveTimeout = -1;
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public AjpProtocol() {
        this.setSoLinger(-1);
        this.setSoTimeout(-1);
        this.setTcpNoDelay(true);
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("ajpprotocol.setattribute", name, value));
        }
        this.attributes.put(name, value);
    }

    @Override
    public Object getAttribute(String key) {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("ajpprotocol.getattribute", key));
        }
        return this.attributes.get(key);
    }

    @Override
    public Iterator getAttributeNames() {
        return this.attributes.keySet().iterator();
    }

    @Override
    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public Adapter getAdapter() {
        return this.adapter;
    }

    @Override
    public boolean hasIoEvents() {
        return false;
    }

    @Override
    public void init() throws Exception {
        this.endpoint.setName(this.getName());
        this.endpoint.setHandler(this.cHandler);
        try {
            this.endpoint.init();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("ajpprotocol.endpoint.initerror"), (Throwable)ex);
            throw ex;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("ajpprotocol.init", this.getName()));
        }
    }

    @Override
    public void start() throws Exception {
        if (this.domain != null) {
            try {
                this.tpOname = new ObjectName(this.domain + ":" + "type=ThreadPool,name=" + this.getName());
                Registry.getRegistry(null, null).registerComponent((Object)this.endpoint, this.tpOname, null);
            }
            catch (Exception e) {
                log.error((Object)"Can't register threadpool");
            }
            this.rgOname = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=" + this.getName());
            Registry.getRegistry(null, null).registerComponent((Object)this.cHandler.global, this.rgOname, null);
        }
        try {
            this.endpoint.start();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("ajpprotocol.endpoint.starterror"), (Throwable)ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("ajpprotocol.start", this.getName()));
        }
    }

    @Override
    public void pause() throws Exception {
        try {
            this.endpoint.pause();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("ajpprotocol.endpoint.pauseerror"), (Throwable)ex);
            throw ex;
        }
        RequestInfo[] states = this.cHandler.global.getRequestProcessors();
        int retry = 0;
        boolean done = false;
        block4: while (!done && retry < Constants.MAX_PAUSE_WAIT) {
            ++retry;
            done = true;
            for (int i = 0; i < states.length; ++i) {
                if (states[i].getStage() != 3) continue;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                done = false;
                continue block4;
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("ajpprotocol.pause", this.getName()));
        }
    }

    @Override
    public void resume() throws Exception {
        try {
            this.endpoint.resume();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("ajpprotocol.endpoint.resumeerror"), (Throwable)ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("ajpprotocol.resume", this.getName()));
        }
    }

    @Override
    public void destroy() throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("ajpprotocol.stop", this.getName()));
        }
        this.endpoint.destroy();
        if (this.tpOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.tpOname);
        }
        if (this.rgOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.rgOname);
        }
    }

    public String getName() {
        String encodedAddr = "";
        if (this.getAddress() != null) {
            encodedAddr = "" + this.getAddress();
            if (encodedAddr.startsWith("/")) {
                encodedAddr = encodedAddr.substring(1);
            }
            encodedAddr = URLEncoder.encode(encodedAddr) + "-";
        }
        return "ajp-" + encodedAddr + this.endpoint.getPort();
    }

    public int getProcessorCache() {
        return this.processorCache;
    }

    public void setProcessorCache(int processorCache) {
        this.processorCache = processorCache;
    }

    public Executor getExecutor() {
        return this.endpoint.getExecutor();
    }

    public void setExecutor(Executor executor) {
        this.endpoint.setExecutor(executor);
    }

    public int getMaxThreads() {
        return this.endpoint.getMaxThreads();
    }

    public void setMaxThreads(int maxThreads) {
        this.endpoint.setMaxThreads(maxThreads);
    }

    public int getThreadPriority() {
        return this.endpoint.getThreadPriority();
    }

    public void setThreadPriority(int threadPriority) {
        this.endpoint.setThreadPriority(threadPriority);
    }

    public int getBacklog() {
        return this.endpoint.getBacklog();
    }

    public void setBacklog(int backlog) {
        this.endpoint.setBacklog(backlog);
    }

    public int getPort() {
        return this.endpoint.getPort();
    }

    public void setPort(int port) {
        this.endpoint.setPort(port);
    }

    public InetAddress getAddress() {
        return this.endpoint.getAddress();
    }

    public void setAddress(InetAddress ia) {
        this.endpoint.setAddress(ia);
    }

    public boolean getTcpNoDelay() {
        return this.endpoint.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.endpoint.setTcpNoDelay(tcpNoDelay);
    }

    public int getSoLinger() {
        return this.endpoint.getSoLinger();
    }

    public void setSoLinger(int soLinger) {
        this.endpoint.setSoLinger(soLinger);
    }

    public int getSoTimeout() {
        return this.endpoint.getSoTimeout();
    }

    public void setSoTimeout(int soTimeout) {
        this.endpoint.setSoTimeout(soTimeout);
    }

    public boolean getTomcatAuthentication() {
        return this.tomcatAuthentication;
    }

    public void setTomcatAuthentication(boolean tomcatAuthentication) {
        this.tomcatAuthentication = tomcatAuthentication;
    }

    public void setRequiredSecret(String requiredSecret) {
        this.requiredSecret = requiredSecret;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public void setPacketSize(int packetSize) {
        this.packetSize = packetSize;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int timeout) {
        this.keepAliveTimeout = timeout;
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    protected static class AjpConnectionHandler
    implements JIoEndpoint.Handler {
        protected AjpProtocol proto;
        protected AtomicLong registerCount = new AtomicLong(0L);
        protected RequestGroupInfo global = new RequestGroupInfo();
        protected ConcurrentHashMap<Socket, AjpProcessor> connections = new ConcurrentHashMap();
        protected ConcurrentLinkedQueue<AjpProcessor> recycledProcessors = new ConcurrentLinkedQueue<AjpProcessor>(){
            protected AtomicInteger size = new AtomicInteger(0);

            @Override
            public boolean offer(AjpProcessor processor) {
                boolean offer = AjpConnectionHandler.this.proto.processorCache == -1 ? true : this.size.get() < AjpConnectionHandler.this.proto.processorCache;
                boolean result = false;
                if (offer && (result = super.offer(processor))) {
                    this.size.incrementAndGet();
                }
                if (!result) {
                    AjpConnectionHandler.this.unregister(processor);
                }
                return result;
            }

            @Override
            public AjpProcessor poll() {
                AjpProcessor result = (AjpProcessor)super.poll();
                if (result != null) {
                    this.size.decrementAndGet();
                }
                return result;
            }

            @Override
            public void clear() {
                AjpProcessor next = this.poll();
                while (next != null) {
                    AjpConnectionHandler.this.unregister(next);
                    next = this.poll();
                }
                super.clear();
                this.size.set(0);
            }
        };

        public AjpConnectionHandler(AjpProtocol proto) {
            this.proto = proto;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JIoEndpoint.Handler.SocketState event(Socket socket, SocketStatus status) {
            AjpProcessor result = this.connections.get(socket);
            JIoEndpoint.Handler.SocketState state = JIoEndpoint.Handler.SocketState.CLOSED;
            if (result != null) {
                result.startProcessing();
                try {
                    state = result.event(status);
                }
                catch (SocketException e) {
                    AjpProcessor.log.debug((Object)sm.getString("ajpprotocol.proto.socketexception.debug"), (Throwable)e);
                }
                catch (IOException e) {
                    AjpProcessor.log.debug((Object)sm.getString("ajpprotocol.proto.ioexception.debug"), (Throwable)e);
                }
                catch (Throwable e) {
                    AjpProcessor.log.error((Object)sm.getString("ajpprotocol.proto.error"), e);
                }
                finally {
                    if (state != JIoEndpoint.Handler.SocketState.LONG) {
                        this.connections.remove(socket);
                        this.recycledProcessors.offer(result);
                    } else if (this.proto.endpoint.isRunning()) {
                        this.proto.endpoint.getEventPoller().add(socket, result.getTimeout(), result.getResumeNotification(), false);
                    }
                    result.endProcessing();
                }
            }
            return state;
        }

        @Override
        public JIoEndpoint.Handler.SocketState process(Socket socket) {
            AjpProcessor processor = this.recycledProcessors.poll();
            try {
                JIoEndpoint.Handler.SocketState state;
                if (processor == null) {
                    processor = this.createProcessor();
                }
                if ((state = processor.process(socket)) == JIoEndpoint.Handler.SocketState.LONG) {
                    this.connections.put(socket, processor);
                    this.proto.endpoint.getEventPoller().add(socket, processor.getTimeout(), processor.getResumeNotification(), false);
                } else {
                    this.recycledProcessors.offer(processor);
                }
                return state;
            }
            catch (SocketException e) {
                log.debug((Object)sm.getString("ajpprotocol.proto.socketexception.debug"), (Throwable)e);
            }
            catch (IOException e) {
                log.debug((Object)sm.getString("ajpprotocol.proto.ioexception.debug"), (Throwable)e);
            }
            catch (Throwable e) {
                log.error((Object)sm.getString("ajpprotocol.proto.error"), e);
            }
            this.recycledProcessors.offer(processor);
            return JIoEndpoint.Handler.SocketState.CLOSED;
        }

        protected AjpProcessor createProcessor() {
            AjpProcessor processor = new AjpProcessor(this.proto.packetSize, this.proto.endpoint);
            processor.setAdapter(this.proto.adapter);
            processor.setTomcatAuthentication(this.proto.tomcatAuthentication);
            processor.setRequiredSecret(this.proto.requiredSecret);
            processor.setKeepAliveTimeout(this.proto.keepAliveTimeout);
            this.register(processor);
            return processor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void register(AjpProcessor processor) {
            if (this.proto.getDomain() != null) {
                AjpConnectionHandler ajpConnectionHandler = this;
                synchronized (ajpConnectionHandler) {
                    try {
                        long count = this.registerCount.incrementAndGet();
                        RequestInfo rp = processor.getRequest().getRequestProcessor();
                        rp.setGlobalProcessor(this.global);
                        ObjectName rpName = new ObjectName(this.proto.getDomain() + ":type=RequestProcessor,worker=" + this.proto.getName() + ",name=AjpRequest" + count);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Register " + rpName));
                        }
                        Registry.getRegistry(null, null).registerComponent((Object)rp, rpName, null);
                        rp.setRpName(rpName);
                    }
                    catch (Exception e) {
                        log.warn((Object)"Error registering request");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void unregister(AjpProcessor processor) {
            if (this.proto.getDomain() != null) {
                AjpConnectionHandler ajpConnectionHandler = this;
                synchronized (ajpConnectionHandler) {
                    try {
                        RequestInfo rp = processor.getRequest().getRequestProcessor();
                        rp.setGlobalProcessor(null);
                        ObjectName rpName = rp.getRpName();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Unregister " + rpName));
                        }
                        Registry.getRegistry(null, null).unregisterComponent(rpName);
                        rp.setRpName(null);
                    }
                    catch (Exception e) {
                        log.warn((Object)"Error unregistering request", (Throwable)e);
                    }
                }
            }
        }
    }
}

