/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.coyote.Adapter;
import org.apache.coyote.Constants;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.RequestGroupInfo;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.http11.Http11Processor;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.net.JIoEndpoint;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.ServerSocketFactory;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.res.StringManager;
import org.jboss.logging.Logger;

public class Http11Protocol
implements ProtocolHandler,
MBeanRegistration {
    protected static Logger log = Logger.getLogger(Http11Protocol.class);
    protected static StringManager sm = StringManager.getManager("org.apache.coyote.http11");
    protected Http11ConnectionHandler cHandler = new Http11ConnectionHandler(this);
    protected JIoEndpoint endpoint = new JIoEndpoint();
    protected ObjectName tpOname = null;
    protected ObjectName rgOname = null;
    protected ServerSocketFactory socketFactory = null;
    protected SSLImplementation sslImplementation = null;
    protected HashMap<String, Object> attributes = new HashMap();
    protected Adapter adapter;
    protected int processorCache = -1;
    protected int socketBuffer = 9000;
    protected boolean secure;
    protected boolean SSLEnabled = false;
    protected String socketFactoryName = null;
    protected String sslImplementationName = null;
    protected int maxKeepAliveRequests = org.apache.tomcat.util.Constants.LOW_MEMORY ? 1 : 100;
    protected int keepAliveTimeout = -1;
    protected int timeout = 300000;
    protected int maxSavePostSize = 4096;
    protected int maxHttpHeaderSize = 8192;
    protected boolean disableUploadTimeout = true;
    protected String compression = "off";
    protected String noCompressionUserAgents = null;
    protected String compressableMimeTypes = "text/html,text/xml,text/plain";
    protected int compressionMinSize = 2048;
    protected String restrictedUserAgents = null;
    protected String server;
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public Http11Protocol() {
        this.setSoLinger(-1);
        this.setSoTimeout(60000);
        this.setTcpNoDelay(true);
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("http11protocol.setattribute", name, value));
        }
        this.attributes.put(name, value);
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public Iterator getAttributeNames() {
        return this.attributes.keySet().iterator();
    }

    public void setProperty(String name, String value) {
        this.setAttribute(name, value);
    }

    public String getProperty(String name) {
        return (String)this.getAttribute(name);
    }

    @Override
    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public Adapter getAdapter() {
        return this.adapter;
    }

    @Override
    public boolean hasIoEvents() {
        return false;
    }

    @Override
    public RequestGroupInfo getRequestGroupInfo() {
        return this.cHandler.global;
    }

    @Override
    public void init() throws Exception {
        this.endpoint.setName(this.getName());
        this.endpoint.setHandler(this.cHandler);
        try {
            if (this.isSSLEnabled()) {
                this.sslImplementation = SSLImplementation.getInstance(this.sslImplementationName);
                this.socketFactory = this.sslImplementation.getServerSocketFactory();
                this.endpoint.setServerSocketFactory(this.socketFactory);
            } else if (this.socketFactoryName != null) {
                this.socketFactory = (ServerSocketFactory)Class.forName(this.socketFactoryName).newInstance();
                this.endpoint.setServerSocketFactory(this.socketFactory);
            }
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("http11protocol.socketfactory.initerror"), (Throwable)ex);
            throw ex;
        }
        if (this.socketFactory != null) {
            for (String key : this.attributes.keySet()) {
                Object v = this.attributes.get(key);
                this.socketFactory.setAttribute(key, v);
            }
        }
        try {
            this.endpoint.init();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("http11protocol.endpoint.initerror"), (Throwable)ex);
            throw ex;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("http11protocol.init", this.getName()));
        }
    }

    @Override
    public void start() throws Exception {
        if (org.apache.tomcat.util.Constants.ENABLE_MODELER && this.domain != null) {
            try {
                this.tpOname = new ObjectName(this.domain + ":" + "type=ThreadPool,name=" + this.getName());
                Registry.getRegistry(null, null).registerComponent((Object)this.endpoint, this.tpOname, null);
            }
            catch (Exception e) {
                log.error((Object)"Can't register endpoint");
            }
            this.rgOname = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=" + this.getName());
            Registry.getRegistry(null, null).registerComponent((Object)this.cHandler.global, this.rgOname, null);
        }
        try {
            this.endpoint.start();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("http11protocol.endpoint.starterror"), (Throwable)ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("http11protocol.start", this.getName()));
        }
    }

    @Override
    public void pause() throws Exception {
        try {
            this.endpoint.pause();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("http11protocol.endpoint.pauseerror"), (Throwable)ex);
            throw ex;
        }
        RequestInfo[] states = this.cHandler.global.getRequestProcessors();
        int retry = 0;
        boolean done = false;
        block4: while (!done && retry < Constants.MAX_PAUSE_WAIT) {
            ++retry;
            done = true;
            for (int i = 0; i < states.length; ++i) {
                if (states[i].getStage() != 3) continue;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                done = false;
                continue block4;
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("http11protocol.pause", this.getName()));
        }
    }

    @Override
    public void resume() throws Exception {
        try {
            this.endpoint.resume();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("http11protocol.endpoint.resumeerror"), (Throwable)ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("http11protocol.resume", this.getName()));
        }
    }

    @Override
    public void destroy() throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("http11protocol.stop", this.getName()));
        }
        this.endpoint.destroy();
        if (org.apache.tomcat.util.Constants.ENABLE_MODELER) {
            if (this.tpOname != null) {
                Registry.getRegistry(null, null).unregisterComponent(this.tpOname);
            }
            if (this.rgOname != null) {
                Registry.getRegistry(null, null).unregisterComponent(this.rgOname);
            }
        }
    }

    public String getName() {
        String encodedAddr = "";
        if (this.getAddress() != null) {
            encodedAddr = "" + this.getAddress();
            if (encodedAddr.startsWith("/")) {
                encodedAddr = encodedAddr.substring(1);
            }
            encodedAddr = URLEncoder.encode(encodedAddr) + "-";
        }
        return "http-" + encodedAddr + this.endpoint.getPort();
    }

    public int getProcessorCache() {
        return this.processorCache;
    }

    public void setProcessorCache(int processorCache) {
        this.processorCache = processorCache;
    }

    public int getSocketBuffer() {
        return this.socketBuffer;
    }

    public void setSocketBuffer(int socketBuffer) {
        this.socketBuffer = socketBuffer;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean b) {
        this.secure = b;
    }

    public boolean isSSLEnabled() {
        return this.SSLEnabled;
    }

    public void setSSLEnabled(boolean SSLEnabled) {
        this.SSLEnabled = SSLEnabled;
    }

    public String getSocketFactory() {
        return this.socketFactoryName;
    }

    public void setSocketFactory(String valueS) {
        this.socketFactoryName = valueS;
    }

    public String getSSLImplementation() {
        return this.sslImplementationName;
    }

    public void setSSLImplementation(String valueS) {
        this.sslImplementationName = valueS;
        this.setSecure(true);
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.maxKeepAliveRequests = mkar;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int timeout) {
        this.keepAliveTimeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setMaxSavePostSize(int valueI) {
        this.maxSavePostSize = valueI;
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int valueI) {
        this.maxHttpHeaderSize = valueI;
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String valueS) {
        this.compression = valueS;
    }

    public String getNoCompressionUserAgents() {
        return this.noCompressionUserAgents;
    }

    public void setNoCompressionUserAgents(String valueS) {
        this.noCompressionUserAgents = valueS;
    }

    public String getCompressableMimeType() {
        return this.compressableMimeTypes;
    }

    public void setCompressableMimeType(String valueS) {
        this.compressableMimeTypes = valueS;
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public void setCompressionMinSize(int valueI) {
        this.compressionMinSize = valueI;
    }

    public String getRestrictedUserAgents() {
        return this.restrictedUserAgents;
    }

    public void setRestrictedUserAgents(String valueS) {
        this.restrictedUserAgents = valueS;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getServer() {
        return this.server;
    }

    public Executor getExecutor() {
        return this.endpoint.getExecutor();
    }

    public void setExecutor(Executor executor) {
        this.endpoint.setExecutor(executor);
    }

    public int getMaxThreads() {
        return this.endpoint.getMaxThreads();
    }

    public void setMaxThreads(int maxThreads) {
        this.endpoint.setMaxThreads(maxThreads);
    }

    public int getThreadPriority() {
        return this.endpoint.getThreadPriority();
    }

    public void setThreadPriority(int threadPriority) {
        this.endpoint.setThreadPriority(threadPriority);
    }

    public int getBacklog() {
        return this.endpoint.getBacklog();
    }

    public void setBacklog(int backlog) {
        this.endpoint.setBacklog(backlog);
    }

    public int getPort() {
        return this.endpoint.getPort();
    }

    public void setPort(int port) {
        this.endpoint.setPort(port);
    }

    public InetAddress getAddress() {
        return this.endpoint.getAddress();
    }

    public void setAddress(InetAddress ia) {
        this.endpoint.setAddress(ia);
    }

    public boolean getTcpNoDelay() {
        return this.endpoint.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.endpoint.setTcpNoDelay(tcpNoDelay);
    }

    public int getSoLinger() {
        return this.endpoint.getSoLinger();
    }

    public void setSoLinger(int soLinger) {
        this.endpoint.setSoLinger(soLinger);
    }

    public int getSoTimeout() {
        return this.endpoint.getSoTimeout();
    }

    public void setSoTimeout(int soTimeout) {
        this.endpoint.setSoTimeout(soTimeout);
    }

    public boolean getKeepAlive() {
        return this.maxKeepAliveRequests != 0 && this.maxKeepAliveRequests != 1;
    }

    public void setKeepAlive(boolean keepAlive) {
        if (!keepAlive) {
            this.setMaxKeepAliveRequests(1);
        }
    }

    public String getKeystore() {
        return (String)this.getAttribute("keystore");
    }

    public void setKeystore(String k) {
        this.setAttribute("keystore", k);
    }

    public String getKeypass() {
        return (String)this.getAttribute("keypass");
    }

    public void setKeypass(String k) {
        this.attributes.put("keypass", k);
    }

    public String getKeytype() {
        return (String)this.getAttribute("keystoreType");
    }

    public void setKeytype(String k) {
        this.setAttribute("keystoreType", k);
    }

    public String getClientauth() {
        return (String)this.getAttribute("clientauth");
    }

    public void setClientauth(String k) {
        this.setAttribute("clientauth", k);
    }

    public String getProtocols() {
        return (String)this.getAttribute("protocols");
    }

    public void setProtocols(String k) {
        this.setAttribute("protocols", k);
    }

    public String getAlgorithm() {
        return (String)this.getAttribute("algorithm");
    }

    public void setAlgorithm(String k) {
        this.setAttribute("algorithm", k);
    }

    public String getCiphers() {
        return (String)this.getAttribute("ciphers");
    }

    public void setCiphers(String ciphers) {
        this.setAttribute("ciphers", ciphers);
    }

    public String getKeyAlias() {
        return (String)this.getAttribute("keyAlias");
    }

    public void setKeyAlias(String keyAlias) {
        this.setAttribute("keyAlias", keyAlias);
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    protected static class Http11ConnectionHandler
    implements JIoEndpoint.Handler {
        protected Http11Protocol proto;
        protected AtomicLong registerCount = new AtomicLong(0L);
        protected RequestGroupInfo global = new RequestGroupInfo();
        protected ConcurrentHashMap<Socket, Http11Processor> connections = new ConcurrentHashMap();
        protected ConcurrentLinkedQueue<Http11Processor> recycledProcessors = new ConcurrentLinkedQueue<Http11Processor>(){
            protected AtomicInteger size = new AtomicInteger(0);

            @Override
            public boolean offer(Http11Processor processor) {
                boolean offer = Http11ConnectionHandler.this.proto.processorCache == -1 ? true : this.size.get() < Http11ConnectionHandler.this.proto.processorCache;
                boolean result = false;
                if (offer && (result = super.offer(processor))) {
                    this.size.incrementAndGet();
                }
                if (!result) {
                    Http11ConnectionHandler.this.unregister(processor);
                }
                return result;
            }

            @Override
            public Http11Processor poll() {
                Http11Processor result = (Http11Processor)super.poll();
                if (result != null) {
                    this.size.decrementAndGet();
                }
                return result;
            }

            @Override
            public void clear() {
                Http11Processor next = this.poll();
                while (next != null) {
                    Http11ConnectionHandler.this.unregister(next);
                    next = this.poll();
                }
                super.clear();
                this.size.set(0);
            }
        };

        Http11ConnectionHandler(Http11Protocol proto) {
            this.proto = proto;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JIoEndpoint.Handler.SocketState event(Socket socket, SocketStatus status) {
            Http11Processor result = this.connections.get(socket);
            JIoEndpoint.Handler.SocketState state = JIoEndpoint.Handler.SocketState.CLOSED;
            if (result != null) {
                result.startProcessing();
                try {
                    state = result.event(status);
                }
                catch (SocketException e) {
                    log.debug((Object)sm.getString("http11protocol.proto.socketexception.debug"), (Throwable)e);
                }
                catch (IOException e) {
                    log.debug((Object)sm.getString("http11protocol.proto.ioexception.debug"), (Throwable)e);
                }
                catch (Throwable e) {
                    log.error((Object)sm.getString("http11protocol.proto.error"), e);
                }
                finally {
                    if (state != JIoEndpoint.Handler.SocketState.LONG) {
                        this.connections.remove(socket);
                        this.recycledProcessors.offer(result);
                    } else if (this.proto.endpoint.isRunning()) {
                        this.proto.endpoint.getEventPoller().add(socket, result.getTimeout(), result.getResumeNotification(), false);
                    }
                    result.endProcessing();
                }
            }
            return state;
        }

        @Override
        public JIoEndpoint.Handler.SocketState process(Socket socket) {
            Http11Processor processor = this.recycledProcessors.poll();
            try {
                if (processor == null) {
                    processor = this.createProcessor();
                }
                if (this.proto.secure && this.proto.sslImplementation != null) {
                    processor.setSSLSupport(this.proto.sslImplementation.getSSLSupport(socket));
                } else {
                    processor.setSSLSupport(null);
                }
                JIoEndpoint.Handler.SocketState state = processor.process(socket);
                if (state == JIoEndpoint.Handler.SocketState.LONG) {
                    this.connections.put(socket, processor);
                    this.proto.endpoint.getEventPoller().add(socket, processor.getTimeout(), processor.getResumeNotification(), false);
                } else {
                    this.recycledProcessors.offer(processor);
                }
                return state;
            }
            catch (SocketException e) {
                log.debug((Object)sm.getString("http11protocol.proto.socketexception.debug"), (Throwable)e);
            }
            catch (IOException e) {
                log.debug((Object)sm.getString("http11protocol.proto.ioexception.debug"), (Throwable)e);
            }
            catch (Throwable e) {
                log.error((Object)sm.getString("http11protocol.proto.error"), e);
            }
            this.recycledProcessors.offer(processor);
            return JIoEndpoint.Handler.SocketState.CLOSED;
        }

        protected Http11Processor createProcessor() {
            Http11Processor processor = new Http11Processor(this.proto.maxHttpHeaderSize, this.proto.endpoint);
            processor.setAdapter(this.proto.adapter);
            processor.setMaxKeepAliveRequests(this.proto.maxKeepAliveRequests);
            processor.setKeepAliveTimeout(this.proto.keepAliveTimeout);
            processor.setTimeout(this.proto.timeout);
            processor.setDisableUploadTimeout(this.proto.disableUploadTimeout);
            processor.setCompressionMinSize(this.proto.compressionMinSize);
            processor.setCompression(this.proto.compression);
            processor.setNoCompressionUserAgents(this.proto.noCompressionUserAgents);
            processor.setCompressableMimeTypes(this.proto.compressableMimeTypes);
            processor.setRestrictedUserAgents(this.proto.restrictedUserAgents);
            processor.setSocketBuffer(this.proto.socketBuffer);
            processor.setMaxSavePostSize(this.proto.maxSavePostSize);
            processor.setServer(this.proto.server);
            this.register(processor);
            return processor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void register(Http11Processor processor) {
            RequestInfo rp = processor.getRequest().getRequestProcessor();
            rp.setGlobalProcessor(this.global);
            if (org.apache.tomcat.util.Constants.ENABLE_MODELER && this.proto.getDomain() != null) {
                Http11ConnectionHandler http11ConnectionHandler = this;
                synchronized (http11ConnectionHandler) {
                    try {
                        long count = this.registerCount.incrementAndGet();
                        ObjectName rpName = new ObjectName(this.proto.getDomain() + ":type=RequestProcessor,worker=" + this.proto.getName() + ",name=HttpRequest" + count);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Register " + rpName));
                        }
                        Registry.getRegistry(null, null).registerComponent((Object)rp, rpName, null);
                        rp.setRpName(rpName);
                    }
                    catch (Exception e) {
                        log.warn((Object)"Error registering request");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void unregister(Http11Processor processor) {
            RequestInfo rp = processor.getRequest().getRequestProcessor();
            rp.setGlobalProcessor(null);
            if (org.apache.tomcat.util.Constants.ENABLE_MODELER && this.proto.getDomain() != null) {
                Http11ConnectionHandler http11ConnectionHandler = this;
                synchronized (http11ConnectionHandler) {
                    try {
                        ObjectName rpName = rp.getRpName();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Unregister " + rpName));
                        }
                        Registry.getRegistry(null, null).unregisterComponent(rpName);
                        rp.setRpName(null);
                    }
                    catch (Exception e) {
                        log.warn((Object)"Error unregistering request", (Throwable)e);
                    }
                }
            }
        }
    }
}

