/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Random;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.Constants;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.jboss.logging.Logger;

public abstract class AuthenticatorBase
extends ValveBase
implements Authenticator,
Lifecycle {
    private static Logger log = Logger.getLogger(AuthenticatorBase.class);
    protected static final int SESSION_ID_BYTES = 18;
    protected boolean cache = true;
    protected boolean changeSessionIdOnAuthentication = Boolean.valueOf(System.getProperty("org.apache.catalina.authenticator.AuthenticatorBase.CHANGE_SESSIONID_ON_AUTH", "false"));
    protected Context context = null;
    protected static final String info = "org.apache.catalina.authenticator.AuthenticatorBase/1.0";
    protected boolean disableProxyCaching = true;
    protected boolean securePagesWithPragma = true;
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.authenticator");
    protected SingleSignOn sso = null;
    protected boolean started = false;
    private static final String DATE_ONE = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US).format(new Date(1L));

    public boolean getCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public boolean isChangeSessionIdOnAuthentication() {
        return this.changeSessionIdOnAuthentication;
    }

    public void setChangeSessionIdOnAuthentication(boolean changeSessionIdOnAuthentication) {
        this.changeSessionIdOnAuthentication = changeSessionIdOnAuthentication;
    }

    @Override
    public Container getContainer() {
        return this.context;
    }

    @Override
    public void setContainer(Container container) {
        if (!(container instanceof Context)) {
            throw new IllegalArgumentException(sm.getString("authenticator.notContext"));
        }
        super.setContainer(container);
        this.context = (Context)container;
    }

    @Override
    public String getInfo() {
        return info;
    }

    public boolean getDisableProxyCaching() {
        return this.disableProxyCaching;
    }

    public void setDisableProxyCaching(boolean nocache) {
        this.disableProxyCaching = nocache;
    }

    public boolean getSecurePagesWithPragma() {
        return this.securePagesWithPragma;
    }

    public void setSecurePagesWithPragma(boolean securePagesWithPragma) {
        this.securePagesWithPragma = securePagesWithPragma;
    }

    @Override
    public boolean authenticate(Request request, HttpServletResponse response) throws IOException, ServletException {
        return this.authenticate(request, response, this.context.getLoginConfig());
    }

    @Override
    public void login(Request request, String username, String password) throws ServletException {
        Realm realm;
        Principal principal;
        String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
        if (ssoId != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("SSO Id " + ssoId + " set; attempting " + "reauthentication"));
            }
            if (this.reauthenticateFromSSO(ssoId, request)) {
                return;
            }
        }
        if ((principal = (realm = this.context.getRealm()).authenticate(username, password)) != null) {
            this.register(request, request.getResponseFacade(), principal, "LOGIN", username, password);
        }
    }

    @Override
    public void logout(Request request) throws ServletException {
        this.unregister(request, request.getResponseFacade());
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        Session session;
        Principal principal;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Security checking request " + request.getMethod() + " " + request.getRequestURI()));
        }
        LoginConfig config = this.context.getLoginConfig();
        if (this.cache && (principal = request.getUserPrincipal()) == null && (session = request.getSessionInternal(false)) != null && (principal = session.getPrincipal()) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("We have cached auth type " + session.getAuthType() + " for principal " + session.getPrincipal()));
            }
            request.setAuthType(session.getAuthType());
            request.setUserPrincipal(principal);
        }
        String contextPath = this.context.getPath();
        String requestURI = request.getDecodedRequestURI();
        if (requestURI.startsWith(contextPath) && requestURI.endsWith("/j_security_check") && !this.authenticate(request, response, config)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(" Failed authenticate() test ??" + requestURI));
            }
            return;
        }
        Realm realm = this.context.getRealm();
        SecurityConstraint[] constraints = realm.findSecurityConstraints(request, this.context);
        if (constraints == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)" Not subject to any constraint");
            }
            this.getNext().invoke(request, response);
            return;
        }
        if (this.disableProxyCaching && !"POST".equalsIgnoreCase(request.getMethod())) {
            if (this.securePagesWithPragma) {
                response.setHeader("Pragma", "No-cache");
                response.setHeader("Cache-Control", "no-cache");
            } else {
                response.setHeader("Cache-Control", "private");
            }
            response.setHeader("Expires", DATE_ONE);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)" Calling hasUserDataPermission()");
        }
        if (!realm.hasUserDataPermission(request, response, constraints)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)" Failed hasUserDataPermission() test");
            }
            return;
        }
        boolean authRequired = true;
        for (int i = 0; i < constraints.length && authRequired; ++i) {
            String[] roles;
            if (!constraints[i].getAuthConstraint()) {
                authRequired = false;
                continue;
            }
            if (constraints[i].getAllRoles() || (roles = constraints[i].findAuthRoles()) != null && roles.length != 0) continue;
            authRequired = false;
        }
        if (authRequired) {
            if (log.isDebugEnabled()) {
                log.debug((Object)" Calling authenticate()");
            }
            if (!this.authenticate(request, response, config)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)" Failed authenticate() test");
                }
                return;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)" Calling accessControl()");
        }
        if (!realm.hasResourcePermission(request, response, constraints, this.context)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)" Failed accessControl() test");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)" Successfully passed all security constraints");
        }
        this.getNext().invoke(request, response);
    }

    protected void associate(String ssoId, Session session) {
        if (this.sso == null) {
            return;
        }
        this.sso.associate(ssoId, session);
    }

    protected abstract boolean authenticate(Request var1, HttpServletResponse var2, LoginConfig var3) throws IOException;

    protected synchronized String generateSessionId(Random random) {
        byte[] bytes = new byte[18];
        random.nextBytes(bytes);
        char[] id = ManagerBase.encode(bytes);
        return String.valueOf(id);
    }

    protected boolean reauthenticateFromSSO(String ssoId, Request request) {
        Realm realm;
        if (this.sso == null || ssoId == null) {
            return false;
        }
        boolean reauthenticated = false;
        Container parent = this.getContainer();
        if (parent != null && (realm = parent.getRealm()) != null) {
            reauthenticated = this.sso.reauthenticate(ssoId, realm, request);
        }
        if (reauthenticated) {
            this.associate(ssoId, request.getSessionInternal(true));
            if (log.isDebugEnabled()) {
                log.debug((Object)(" Reauthenticated cached principal '" + request.getUserPrincipal().getName() + "' with auth type '" + request.getAuthType() + "'"));
            }
        }
        return reauthenticated;
    }

    protected void register(Request request, HttpServletResponse response, Principal principal, String authType, String username, String password) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Authenticated '" + principal.getName() + "' with type '" + authType + "'"));
        }
        request.setAuthType(authType);
        request.setUserPrincipal(principal);
        Session session = request.getSessionInternal(false);
        if (session != null && this.changeSessionIdOnAuthentication) {
            Manager manager = request.getContext().getManager();
            manager.changeSessionId(session, request.getRandom());
            request.changeSessionId(session.getId());
        }
        if (this.cache && session != null) {
            session.setAuthType(authType);
            session.setPrincipal(principal);
            if (username != null) {
                session.setNote("org.apache.catalina.session.USERNAME", username);
            } else {
                session.removeNote("org.apache.catalina.session.USERNAME");
            }
            if (password != null) {
                session.setNote("org.apache.catalina.session.PASSWORD", password);
            } else {
                session.removeNote("org.apache.catalina.session.PASSWORD");
            }
        }
        if (this.sso == null) {
            return;
        }
        String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
        if (ssoId == null) {
            String ssoDomain;
            ssoId = this.generateSessionId(request.getRandom());
            Cookie cookie = new Cookie(Constants.SINGLE_SIGN_ON_COOKIE, ssoId);
            cookie.setMaxAge(-1);
            cookie.setPath("/");
            cookie.setSecure(request.isSecure());
            if (this.sso.isCookieHttpOnly()) {
                cookie.setHttpOnly(true);
            }
            if ((ssoDomain = this.sso.getCookieDomain()) != null) {
                cookie.setDomain(ssoDomain);
            }
            response.addCookie(cookie);
            this.sso.register(ssoId, principal, authType, username, password);
            request.setNote("org.apache.catalina.request.SSOID", ssoId);
        } else {
            this.sso.update(ssoId, principal, authType, username, password);
        }
        if (session == null) {
            session = request.getSessionInternal(true);
        }
        this.sso.associate(ssoId, session);
    }

    protected void unregister(Request request, HttpServletResponse response) {
        request.setAuthType(null);
        request.setUserPrincipal(null);
        Session session = request.getSessionInternal(false);
        if (this.cache && session != null) {
            session.setAuthType(null);
            session.setPrincipal(null);
            session.removeNote("org.apache.catalina.session.USERNAME");
            session.removeNote("org.apache.catalina.session.PASSWORD");
        }
        if (this.sso == null) {
            return;
        }
        String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
        if (ssoId != null) {
            request.removeNote("org.apache.catalina.request.SSOID");
            this.sso.deregister(ssoId);
        }
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    @Override
    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("authenticator.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        Container parent = this.context.getParent();
        while (this.sso == null && parent != null) {
            if (!(parent instanceof Pipeline)) {
                parent = parent.getParent();
                continue;
            }
            Valve[] valves = ((Pipeline)((Object)parent)).getValves();
            for (int i = 0; i < valves.length; ++i) {
                if (!(valves[i] instanceof SingleSignOn)) continue;
                this.sso = (SingleSignOn)valves[i];
                break;
            }
            if (this.sso != null) continue;
            parent = parent.getParent();
        }
        if (log.isDebugEnabled()) {
            if (this.sso != null) {
                log.debug((Object)("Found SingleSignOn Valve at " + this.sso));
            } else {
                log.debug((Object)"No SingleSignOn Valve is present");
            }
        }
    }

    @Override
    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("authenticator.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.sso = null;
    }
}

