/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.security.auth.Subject;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletResponse;
import javax.servlet.SessionTrackingMode;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Host;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.CoyoteInputStream;
import org.apache.catalina.connector.CoyoteReader;
import org.apache.catalina.connector.HttpEventImpl;
import org.apache.catalina.connector.InputBuffer;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ApplicationFilterChain;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.core.ApplicationFilterFactory;
import org.apache.catalina.core.StandardPart;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.Multipart;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.ParameterMap;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.util.StringParser;
import org.apache.coyote.ActionCode;
import org.apache.tomcat.util.Constants;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.buf.StringCache;
import org.apache.tomcat.util.http.Cookies;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.Parameters;
import org.apache.tomcat.util.http.ServerCookie;
import org.apache.tomcat.util.http.fileupload.FileItem;
import org.apache.tomcat.util.http.fileupload.FileUploadBase;
import org.apache.tomcat.util.http.fileupload.FileUploadException;
import org.apache.tomcat.util.http.fileupload.disk.DiskFileItemFactory;
import org.apache.tomcat.util.http.fileupload.servlet.ServletFileUpload;
import org.apache.tomcat.util.http.mapper.MappingData;

public class Request
implements HttpServletRequest {
    protected static final boolean SESSION_ID_CHECK = Boolean.valueOf(System.getProperty("org.apache.catalina.connector.Request.SESSION_ID_CHECK", "true"));
    protected static final boolean WRAPPED_RESPONSE_IN_LOGIN = Globals.STRICT_SERVLET_COMPLIANCE || Boolean.valueOf(System.getProperty("org.apache.catalina.connector.Request.WRAPPED_RESPONSE_IN_LOGIN", "false")) != false;
    protected static final boolean CHECK_ASYNC = Globals.STRICT_SERVLET_COMPLIANCE || Boolean.valueOf(System.getProperty("org.apache.catalina.connector.Request.CHECK_ASYNC", "true")) != false;
    protected static final boolean USE_PRINCIPAL_FROM_SESSION = Boolean.valueOf(System.getProperty("org.apache.catalina.connector.Request.USE_PRINCIPAL_FROM_SESSION", "false"));
    protected static final boolean LOCAL_RANDOM = Boolean.valueOf(System.getProperty("org.apache.catalina.connector.Request.LOCAL_RANDOM", Constants.LOW_MEMORY ? "false" : "true"));
    protected static final boolean SEED_WITH_NEXT_BYTES = Boolean.valueOf(System.getProperty("org.apache.catalina.connector.Request.SEED_WITH_NEXT_BYTES", "true"));
    protected org.apache.coyote.Request coyoteRequest;
    protected static final TimeZone GMT_ZONE;
    protected static StringManager sm;
    protected Cookie[] cookies = null;
    protected SimpleDateFormat[] formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
    protected static Locale defaultLocale;
    protected HashMap attributes = new HashMap();
    private HashMap readOnlyAttributes = new HashMap();
    protected ArrayList locales = new ArrayList();
    private transient HashMap notes = new HashMap();
    protected AsyncContextImpl asyncContext = null;
    protected String authType = null;
    protected long asyncTimeout = -1L;
    protected LinkedHashMap<AsyncListener, AsyncListenerRegistration> asyncListeners = new LinkedHashMap();
    protected HttpEventImpl event = null;
    protected boolean eventMode = false;
    protected Object dispatcherType = null;
    protected InputBuffer inputBuffer = new InputBuffer(this);
    protected CoyoteInputStream inputStream = new CoyoteInputStream(this.inputBuffer);
    protected CoyoteReader reader = new CoyoteReader(this.inputBuffer);
    protected boolean usingInputStream = false;
    protected boolean usingReader = false;
    protected ServletInputStream applicationInputStream = null;
    protected BufferedReader applicationReader = null;
    protected Principal userPrincipal = null;
    protected boolean sessionParsed = false;
    protected boolean parametersParsed = false;
    protected boolean cookiesParsed = false;
    protected boolean secure = false;
    protected transient Subject subject = null;
    protected static int CACHED_POST_LEN;
    protected byte[] postData = null;
    protected Map<String, Part> parts = null;
    protected ParameterMap parameterMap = new ParameterMap();
    protected Session session = null;
    protected Object requestDispatcherPath = null;
    protected boolean requestedSessionCookie = false;
    protected String requestedSessionId = null;
    protected boolean requestedSessionURL = false;
    protected boolean localesParsed = false;
    private StringParser parser = new StringParser();
    protected int localPort = -1;
    protected String remoteAddr = null;
    protected String remoteHost = null;
    protected int remotePort = -1;
    protected String localAddr = null;
    protected String localName = null;
    protected boolean canStartAsync = true;
    protected boolean sslAttributes = false;
    protected Random random = null;
    protected Connector connector;
    protected Context context = null;
    protected ArrayList<ApplicationFilterChain> filterChains = new ArrayList();
    protected int currentFilterChain = -1;
    protected static final String info = "org.apache.coyote.catalina.CoyoteRequest/1.0";
    protected MappingData mappingData = new MappingData();
    protected RequestFacade facade = null;
    protected Response response = null;
    protected B2CConverter URIConverter = null;
    protected Wrapper wrapper = null;

    public Request() {
        this.formats[0].setTimeZone(GMT_ZONE);
        this.formats[1].setTimeZone(GMT_ZONE);
        this.formats[2].setTimeZone(GMT_ZONE);
    }

    public void setCoyoteRequest(org.apache.coyote.Request coyoteRequest) {
        this.coyoteRequest = coyoteRequest;
        this.inputBuffer.setRequest(coyoteRequest);
    }

    public org.apache.coyote.Request getCoyoteRequest() {
        return this.coyoteRequest;
    }

    public void recycle() {
        this.context = null;
        this.wrapper = null;
        this.dispatcherType = null;
        this.requestDispatcherPath = null;
        this.eventMode = false;
        if (this.event != null) {
            this.event.clear();
            this.event = null;
        }
        this.sslAttributes = false;
        this.asyncContext = null;
        this.asyncTimeout = -1L;
        this.canStartAsync = true;
        this.asyncListeners.clear();
        this.authType = null;
        this.inputBuffer.recycle();
        this.usingInputStream = false;
        this.usingReader = false;
        this.applicationInputStream = null;
        this.applicationReader = null;
        this.userPrincipal = null;
        this.subject = null;
        this.sessionParsed = false;
        this.parametersParsed = false;
        this.cookiesParsed = false;
        this.locales.clear();
        this.localesParsed = false;
        this.secure = false;
        this.remoteAddr = null;
        this.remoteHost = null;
        this.remotePort = -1;
        this.localPort = -1;
        this.localAddr = null;
        this.localName = null;
        this.currentFilterChain = -1;
        this.filterChains.clear();
        this.attributes.clear();
        this.notes.clear();
        this.cookies = null;
        this.parts = null;
        if (this.session != null) {
            this.session.endAccess();
        }
        this.session = null;
        this.requestedSessionCookie = false;
        this.requestedSessionId = null;
        this.requestedSessionURL = false;
        if (Globals.IS_SECURITY_ENABLED || Connector.RECYCLE_FACADES) {
            this.parameterMap = new ParameterMap();
        } else {
            this.parameterMap.setLocked(false);
            this.parameterMap.clear();
        }
        this.mappingData.recycle();
        if (Globals.IS_SECURITY_ENABLED || Connector.RECYCLE_FACADES) {
            if (this.facade != null) {
                this.facade.clear();
                this.facade = null;
            }
            if (this.inputStream != null) {
                this.inputStream.clear();
                this.inputStream = null;
            }
            if (this.reader != null) {
                this.reader.clear();
                this.reader = null;
            }
        }
    }

    public void clearEncoders() {
        this.inputBuffer.clearEncoders();
    }

    public int read() throws IOException {
        return this.inputBuffer.realReadBytes(null, 0, 0);
    }

    public boolean isEof() throws IOException {
        return this.inputBuffer.isEof();
    }

    public boolean isReadable() {
        return this.inputBuffer.available() > 0;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
        if (LOCAL_RANDOM) {
            if (SEED_WITH_NEXT_BYTES) {
                byte[] seed = new byte[16];
                connector.getService().getRandom().nextBytes(seed);
                this.random = new SecureRandom(seed);
            } else {
                this.random = new SecureRandom(connector.getService().getRandom().generateSeed(16));
            }
        } else {
            this.random = connector.getService().getRandom();
        }
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Random getRandom() {
        return this.random;
    }

    public ApplicationFilterChain getFilterChain() {
        if (this.currentFilterChain >= 0 && this.currentFilterChain < this.filterChains.size()) {
            return this.filterChains.get(this.currentFilterChain);
        }
        return null;
    }

    public void setFilterChain(ApplicationFilterChain filterChain) {
        if (this.currentFilterChain >= 0 && this.currentFilterChain < this.filterChains.size()) {
            this.filterChains.set(this.currentFilterChain, filterChain);
        } else {
            this.filterChains.add(filterChain);
        }
    }

    public void nextFilterChain() {
        ++this.currentFilterChain;
    }

    public void releaseFilterChain() {
        --this.currentFilterChain;
    }

    public Host getHost() {
        return (Host)this.mappingData.host;
    }

    public void setHost(Host host) {
        this.mappingData.host = host;
    }

    public String getInfo() {
        return info;
    }

    public MappingData getMappingData() {
        return this.mappingData;
    }

    public HttpServletRequest getRequest() {
        if (this.facade == null) {
            this.facade = new RequestFacade(this);
        }
        return this.facade;
    }

    public HttpServletRequest getRequestFacade() {
        return this.getRequest();
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public HttpServletResponse getResponseFacade() {
        return this.getResponse().getResponse();
    }

    public InputStream getStream() {
        if (this.inputStream == null) {
            this.inputStream = new CoyoteInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    protected B2CConverter getURIConverter() {
        return this.URIConverter;
    }

    protected void setURIConverter(B2CConverter URIConverter) {
        this.URIConverter = URIConverter;
    }

    public Wrapper getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    public boolean getCanStartAsync() {
        return this.canStartAsync;
    }

    public void setCanStartAsync(boolean canStartAsync) {
        this.canStartAsync = canStartAsync;
    }

    public ServletInputStream createInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new CoyoteInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    public void finishRequest() throws IOException {
    }

    public Object getNote(String name) {
        return this.notes.get(name);
    }

    public Iterator getNoteNames() {
        return this.notes.keySet().iterator();
    }

    public void removeNote(String name) {
        this.notes.remove(name);
    }

    public void setNote(String name, Object value) {
        this.notes.put(name, value);
    }

    public void setContentLength(int length) {
    }

    public void setContentType(String type) {
    }

    public void setProtocol(String protocol) {
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public void setScheme(String scheme) {
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setServerName(String name) {
        this.coyoteRequest.serverName().setString(name);
    }

    public void setServerPort(int port) {
        this.coyoteRequest.setServerPort(port);
    }

    public Object getAttribute(String name) {
        if (name.equals("org.apache.catalina.core.DISPATCHER_TYPE")) {
            return this.dispatcherType == null ? ApplicationFilterFactory.REQUEST_INTEGER : this.dispatcherType;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_REQUEST_PATH")) {
            return this.requestDispatcherPath == null ? this.getRequestPathMB().toString() : this.requestDispatcherPath.toString();
        }
        Object attr = this.attributes.get(name);
        if (attr != null) {
            return attr;
        }
        attr = this.coyoteRequest.getAttribute(name);
        if (attr != null) {
            return attr;
        }
        if (!this.sslAttributes && Request.isSSLAttribute(name)) {
            this.sslAttributes = true;
            this.coyoteRequest.action(ActionCode.ACTION_REQ_SSL_ATTRIBUTE, this.coyoteRequest);
            attr = this.coyoteRequest.getAttribute("javax.servlet.request.X509Certificate");
            if (attr != null) {
                this.attributes.put("javax.servlet.request.X509Certificate", attr);
            }
            if ((attr = this.coyoteRequest.getAttribute("javax.servlet.request.cipher_suite")) != null) {
                this.attributes.put("javax.servlet.request.cipher_suite", attr);
            }
            if ((attr = this.coyoteRequest.getAttribute("javax.servlet.request.key_size")) != null) {
                this.attributes.put("javax.servlet.request.key_size", attr);
            }
            if ((attr = this.coyoteRequest.getAttribute("javax.servlet.request.ssl_session")) != null) {
                this.attributes.put("javax.servlet.request.ssl_session", attr);
            }
            attr = this.attributes.get(name);
        }
        return attr;
    }

    public X509Certificate[] getCertificateChain() {
        X509Certificate[] certs = (X509Certificate[])this.getAttribute("javax.servlet.request.X509Certificate");
        if (certs == null || certs.length < 1) {
            this.coyoteRequest.action(ActionCode.ACTION_REQ_SSL_CERTIFICATE, this.coyoteRequest);
            certs = (X509Certificate[])this.coyoteRequest.getAttribute("javax.servlet.request.X509Certificate");
            if (certs != null) {
                this.attributes.put("javax.servlet.request.X509Certificate", certs);
            }
        }
        return certs;
    }

    static boolean isSSLAttribute(String name) {
        return "javax.servlet.request.X509Certificate".equals(name) || "javax.servlet.request.cipher_suite".equals(name) || "javax.servlet.request.key_size".equals(name) || "javax.servlet.request.ssl_session".equals(name);
    }

    public Enumeration getAttributeNames() {
        if (this.isSecure()) {
            this.getAttribute("javax.servlet.request.X509Certificate");
        }
        return new Enumerator(this.attributes.keySet(), true);
    }

    public String getCharacterEncoding() {
        return this.coyoteRequest.getCharacterEncoding();
    }

    public int getContentLength() {
        return this.coyoteRequest.getContentLength();
    }

    public String getContentType() {
        return this.coyoteRequest.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.usingReader) {
            throw new IllegalStateException(sm.getString("coyoteRequest.getInputStream.ise"));
        }
        if (this.applicationInputStream != null) {
            return this.applicationInputStream;
        }
        this.usingInputStream = true;
        if (this.inputStream == null) {
            this.inputStream = new CoyoteInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    public void setInputStream(ServletInputStream inputStream) {
        this.applicationInputStream = inputStream;
    }

    public Locale getLocale() {
        if (!this.localesParsed) {
            this.parseLocales();
        }
        if (this.locales.size() > 0) {
            return (Locale)this.locales.get(0);
        }
        return defaultLocale;
    }

    public Enumeration getLocales() {
        if (!this.localesParsed) {
            this.parseLocales();
        }
        if (this.locales.size() > 0) {
            return new Enumerator(this.locales);
        }
        ArrayList<Locale> results = new ArrayList<Locale>();
        results.add(defaultLocale);
        return new Enumerator(results);
    }

    public String getParameter(String name) {
        if (!this.parametersParsed) {
            this.parseParameters();
        }
        return this.coyoteRequest.getParameters().getParameter(name);
    }

    public Map getParameterMap() {
        if (this.parameterMap.isLocked()) {
            return this.parameterMap;
        }
        Enumeration enumeration = this.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String name = enumeration.nextElement().toString();
            String[] values = this.getParameterValues(name);
            this.parameterMap.put(name, values);
        }
        this.parameterMap.setLocked(true);
        return this.parameterMap;
    }

    public Enumeration getParameterNames() {
        if (!this.parametersParsed) {
            this.parseParameters();
        }
        return this.coyoteRequest.getParameters().getParameterNames();
    }

    public String[] getParameterValues(String name) {
        if (!this.parametersParsed) {
            this.parseParameters();
        }
        return this.coyoteRequest.getParameters().getParameterValues(name);
    }

    public String getProtocol() {
        return this.coyoteRequest.protocol().toString();
    }

    public BufferedReader getReader() throws IOException {
        if (this.usingInputStream) {
            throw new IllegalStateException(sm.getString("coyoteRequest.getReader.ise"));
        }
        if (this.applicationReader != null) {
            return this.applicationReader;
        }
        this.usingReader = true;
        this.inputBuffer.checkConverter();
        if (this.reader == null) {
            this.reader = new CoyoteReader(this.inputBuffer);
        }
        return this.reader;
    }

    public void setReader(BufferedReader reader) {
        this.applicationReader = reader;
    }

    public String getRealPath(String path) {
        if (this.context == null) {
            return null;
        }
        ServletContext servletContext = this.context.getServletContext();
        if (servletContext == null) {
            return null;
        }
        try {
            return servletContext.getRealPath(path);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getRemoteAddr() {
        if (this.remoteAddr == null) {
            this.coyoteRequest.action(ActionCode.ACTION_REQ_HOST_ADDR_ATTRIBUTE, this.coyoteRequest);
            this.remoteAddr = this.coyoteRequest.remoteAddr().toString();
        }
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        if (this.remoteHost == null) {
            if (!this.connector.getEnableLookups()) {
                this.remoteHost = this.getRemoteAddr();
            } else {
                this.coyoteRequest.action(ActionCode.ACTION_REQ_HOST_ATTRIBUTE, this.coyoteRequest);
                this.remoteHost = this.coyoteRequest.remoteHost().toString();
            }
        }
        return this.remoteHost;
    }

    public int getRemotePort() {
        if (this.remotePort == -1) {
            this.coyoteRequest.action(ActionCode.ACTION_REQ_REMOTEPORT_ATTRIBUTE, this.coyoteRequest);
            this.remotePort = this.coyoteRequest.getRemotePort();
        }
        return this.remotePort;
    }

    public String getLocalName() {
        if (this.localName == null) {
            this.coyoteRequest.action(ActionCode.ACTION_REQ_LOCAL_NAME_ATTRIBUTE, this.coyoteRequest);
            this.localName = this.coyoteRequest.localName().toString();
        }
        return this.localName;
    }

    public String getLocalAddr() {
        if (this.localAddr == null) {
            this.coyoteRequest.action(ActionCode.ACTION_REQ_LOCAL_ADDR_ATTRIBUTE, this.coyoteRequest);
            this.localAddr = this.coyoteRequest.localAddr().toString();
        }
        return this.localAddr;
    }

    public int getLocalPort() {
        if (this.localPort == -1) {
            this.coyoteRequest.action(ActionCode.ACTION_REQ_LOCALPORT_ATTRIBUTE, this.coyoteRequest);
            this.localPort = this.coyoteRequest.getLocalPort();
        }
        return this.localPort;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (this.context == null) {
            return null;
        }
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            return this.context.getServletContext().getRequestDispatcher(path);
        }
        String servletPath = (String)this.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = this.getServletPath();
        }
        String pathInfo = this.getPathInfo();
        String requestPath = null;
        requestPath = pathInfo == null ? servletPath : servletPath + pathInfo;
        int pos = requestPath.lastIndexOf(47);
        String relative = null;
        relative = pos >= 0 ? requestPath.substring(0, pos + 1) + path : requestPath + path;
        return this.context.getServletContext().getRequestDispatcher(relative);
    }

    public String getScheme() {
        return this.coyoteRequest.scheme().toString();
    }

    public String getServerName() {
        return this.coyoteRequest.serverName().toString();
    }

    public int getServerPort() {
        return this.coyoteRequest.getServerPort();
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void removeAttribute(String name) {
        Object value = null;
        boolean found = false;
        if (this.readOnlyAttributes.containsKey(name)) {
            return;
        }
        if (name.startsWith("org.apache.tomcat.")) {
            this.coyoteRequest.getAttributes().remove(name);
        }
        if (!(found = this.attributes.containsKey(name))) {
            return;
        }
        value = this.attributes.get(name);
        this.attributes.remove(name);
        if (this.context == null) {
            return;
        }
        Object[] listeners = this.context.getApplicationEventListeners();
        if (listeners == null || listeners.length == 0) {
            return;
        }
        ServletRequestAttributeEvent event = new ServletRequestAttributeEvent(this.context.getServletContext(), (ServletRequest)this.getRequest(), name, value);
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof ServletRequestAttributeListener)) continue;
            ServletRequestAttributeListener listener = (ServletRequestAttributeListener)listeners[i];
            try {
                listener.attributeRemoved(event);
                continue;
            }
            catch (Throwable t) {
                this.context.getLogger().error((Object)sm.getString("coyoteRequest.attributeEvent"), t);
                this.attributes.put("javax.servlet.error.exception", t);
            }
        }
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException(sm.getString("coyoteRequest.setAttribute.namenull"));
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_TYPE")) {
            this.dispatcherType = value;
            return;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_REQUEST_PATH")) {
            this.requestDispatcherPath = value;
            return;
        }
        Object oldValue = null;
        boolean replaced = false;
        if (this.readOnlyAttributes.containsKey(name)) {
            return;
        }
        oldValue = this.attributes.put(name, value);
        if (oldValue != null) {
            replaced = true;
        }
        if (name.startsWith("org.apache.tomcat.")) {
            this.coyoteRequest.setAttribute(name, value);
        }
        if (this.context == null) {
            return;
        }
        Object[] listeners = this.context.getApplicationEventListeners();
        if (listeners == null || listeners.length == 0) {
            return;
        }
        ServletRequestAttributeEvent event = null;
        event = replaced ? new ServletRequestAttributeEvent(this.context.getServletContext(), (ServletRequest)this.getRequest(), name, oldValue) : new ServletRequestAttributeEvent(this.context.getServletContext(), (ServletRequest)this.getRequest(), name, value);
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof ServletRequestAttributeListener)) continue;
            ServletRequestAttributeListener listener = (ServletRequestAttributeListener)listeners[i];
            try {
                if (replaced) {
                    listener.attributeReplaced(event);
                    continue;
                }
                listener.attributeAdded(event);
                continue;
            }
            catch (Throwable t) {
                this.context.getLogger().error((Object)sm.getString("coyoteRequest.attributeEvent"), t);
                this.attributes.put("javax.servlet.error.exception", t);
            }
        }
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        if (this.usingReader) {
            return;
        }
        byte[] buffer = new byte[]{97};
        String dummy = new String(buffer, enc);
        this.coyoteRequest.setCharacterEncoding(enc);
    }

    public void addCookie(Cookie cookie) {
        if (!this.cookiesParsed) {
            this.parseCookies();
        }
        int size = 0;
        if (this.cookies != null) {
            size = this.cookies.length;
        }
        Cookie[] newCookies = new Cookie[size + 1];
        for (int i = 0; i < size; ++i) {
            newCookies[i] = this.cookies[i];
        }
        newCookies[size] = cookie;
        this.cookies = newCookies;
    }

    public void addHeader(String name, String value) {
    }

    public void addLocale(Locale locale) {
        this.locales.add(locale);
    }

    public void addParameter(String name, String[] values) {
        this.coyoteRequest.getParameters().addParameterValues(name, values);
    }

    public void changeSessionId(String newSessionId) {
        if (this.requestedSessionId != null && this.requestedSessionId.length() > 0) {
            this.requestedSessionId = newSessionId;
        }
        if (this.context != null && !this.context.getServletContext().getEffectiveSessionTrackingModes().contains(SessionTrackingMode.COOKIE)) {
            return;
        }
        if (this.response != null) {
            Cookie cookie = new Cookie(this.context.getSessionCookie().getName(), newSessionId);
            this.configureSessionCookie(cookie);
            this.response.addCookieInternal(cookie);
        }
    }

    public void clearCookies() {
        this.cookiesParsed = true;
        this.cookies = null;
    }

    public void clearHeaders() {
    }

    public void clearLocales() {
        this.locales.clear();
    }

    public void clearParameters() {
        this.parametersParsed = false;
    }

    public void setAuthType(String type) {
        this.authType = type;
    }

    public void setContextPath(String path) {
        if (path == null) {
            this.mappingData.contextPath.setString("");
        } else {
            this.mappingData.contextPath.setString(path);
        }
    }

    public void setMethod(String method) {
    }

    public void setQueryString(String query) {
    }

    public void setPathInfo(String path) {
        this.mappingData.pathInfo.setString(path);
    }

    public void setRequestedSessionCookie(boolean flag) {
        this.requestedSessionCookie = flag;
    }

    public void setRequestedSessionId(String id) {
        this.requestedSessionId = id;
    }

    public void setRequestedSessionURL(boolean flag) {
        this.requestedSessionURL = flag;
    }

    public void setRequestURI(String uri) {
    }

    public void setDecodedRequestURI(String uri) {
    }

    public String getDecodedRequestURI() {
        return this.coyoteRequest.decodedURI().toString();
    }

    public MessageBytes getDecodedRequestURIMB() {
        return this.coyoteRequest.decodedURI();
    }

    public void setServletPath(String path) {
        if (path != null) {
            this.mappingData.wrapperPath.setString(path);
        }
    }

    public void setUserPrincipal(Principal principal) {
        if (Globals.IS_SECURITY_ENABLED) {
            HttpSession session = this.getSession(false);
            if (this.subject != null && !this.subject.getPrincipals().contains(principal)) {
                this.subject.getPrincipals().add(principal);
            } else if (session != null && session.getAttribute("javax.security.auth.subject") == null) {
                this.subject = new Subject();
                this.subject.getPrincipals().add(principal);
            }
            if (session != null) {
                session.setAttribute("javax.security.auth.subject", (Object)this.subject);
            }
        }
        this.userPrincipal = principal;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getContextPath() {
        return this.mappingData.contextPath.toString();
    }

    public MessageBytes getContextPathMB() {
        return this.mappingData.contextPath;
    }

    public Cookie[] getCookies() {
        if (!this.cookiesParsed) {
            this.parseCookies();
        }
        return this.cookies;
    }

    public void setCookies(Cookie[] cookies) {
        this.cookies = cookies;
    }

    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        long result = FastHttpDateFormat.parseDate(value, this.formats);
        if (result != -1L) {
            return result;
        }
        throw new IllegalArgumentException(value);
    }

    public String getHeader(String name) {
        return this.coyoteRequest.getHeader(name);
    }

    public Enumeration getHeaders(String name) {
        return this.coyoteRequest.getMimeHeaders().values(name);
    }

    public Enumeration getHeaderNames() {
        return this.coyoteRequest.getMimeHeaders().names();
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public String getMethod() {
        return this.coyoteRequest.method().toString();
    }

    public String getPathInfo() {
        return this.mappingData.pathInfo.toString();
    }

    public MessageBytes getPathInfoMB() {
        return this.mappingData.pathInfo;
    }

    public String getPathTranslated() {
        if (this.context == null) {
            return null;
        }
        if (this.getPathInfo() == null) {
            return null;
        }
        return this.context.getServletContext().getRealPath(this.getPathInfo());
    }

    public String getQueryString() {
        return this.coyoteRequest.queryString().toString();
    }

    public String getRemoteUser() {
        if (this.userPrincipal != null) {
            return this.userPrincipal.getName();
        }
        return null;
    }

    public MessageBytes getRequestPathMB() {
        return this.mappingData.requestPath;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public String getRequestURI() {
        return this.coyoteRequest.requestURI().toString();
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer();
        String scheme = this.getScheme();
        int port = this.getServerPort();
        if (port < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(this.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(this.getRequestURI());
        return url;
    }

    public ServletContext getServletContext() {
        if (this.context == null) {
            return null;
        }
        return this.context.getServletContext();
    }

    public ServletContext getServletContext0() {
        return this.getServletContext();
    }

    public String getServletPath() {
        return this.mappingData.wrapperPath.toString();
    }

    public MessageBytes getServletPathMB() {
        return this.mappingData.wrapperPath;
    }

    public HttpSession getSession() {
        Session session = this.doGetSession(true);
        if (session != null) {
            return session.getSession();
        }
        return null;
    }

    public HttpSession getSession(boolean create) {
        Session session = this.doGetSession(create);
        if (session != null) {
            return session.getSession();
        }
        return null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        if (this.requestedSessionId != null) {
            return this.requestedSessionCookie;
        }
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        if (this.requestedSessionId != null) {
            return this.requestedSessionURL;
        }
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        if (this.requestedSessionId == null) {
            return false;
        }
        if (this.context == null) {
            return false;
        }
        Manager manager = this.context.getManager();
        if (manager == null) {
            return false;
        }
        Session session = null;
        try {
            session = manager.findSession(this.requestedSessionId);
        }
        catch (IOException e) {
            session = null;
        }
        return session != null && session.isValid();
    }

    public boolean isUserInRole(String role) {
        String realRole;
        Principal principal = this.doGetUserPrincipal();
        if (principal == null) {
            return false;
        }
        if (this.context == null) {
            return false;
        }
        Realm realm = this.context.getRealm();
        if (realm == null) {
            return false;
        }
        if (this.wrapper != null && (realRole = this.wrapper.findSecurityReference(role)) != null && realm.hasRole(principal, realRole)) {
            return true;
        }
        return realm.hasRole(principal, role);
    }

    public Principal getPrincipal() {
        return this.userPrincipal;
    }

    public Principal getUserPrincipal() {
        Principal principal = this.doGetUserPrincipal();
        if (principal instanceof GenericPrincipal) {
            return ((GenericPrincipal)principal).getUserPrincipal();
        }
        return principal;
    }

    protected Principal doGetUserPrincipal() {
        Session session;
        Principal principal;
        if (USE_PRINCIPAL_FROM_SESSION && this.userPrincipal == null && (principal = (session = this.doGetSession(false)).getPrincipal()) != null) {
            return principal;
        }
        return this.userPrincipal;
    }

    public Session getSessionInternal() {
        return this.doGetSession(true);
    }

    public Session getSessionInternal(boolean create) {
        return this.doGetSession(create);
    }

    public HttpEventImpl getEvent() {
        if (this.event == null) {
            this.event = new HttpEventImpl(this, this.response);
        }
        return this.event;
    }

    public boolean isEventMode() {
        return this.eventMode;
    }

    public void setEventMode(boolean eventMode) {
        this.eventMode = eventMode;
    }

    public boolean ready() {
        return this.inputBuffer.getAvailable() > 0;
    }

    public void setTimeout(int timeout) {
        this.coyoteRequest.action(ActionCode.ACTION_EVENT_TIMEOUT, timeout);
    }

    public void setTimeout0(int timeout) {
        this.setTimeout(timeout);
    }

    public void resume() {
        this.coyoteRequest.action(ActionCode.ACTION_EVENT_RESUME, null);
    }

    public void suspend() {
        this.coyoteRequest.action(ActionCode.ACTION_EVENT_SUSPEND, null);
    }

    protected Session doGetSession(boolean create) {
        if (this.context == null) {
            return null;
        }
        if (this.session != null && !this.session.isValid()) {
            this.session = null;
        }
        if (this.session != null) {
            return this.session;
        }
        Manager manager = this.context.getManager();
        if (manager == null) {
            return null;
        }
        if (this.requestedSessionId != null) {
            try {
                this.session = manager.findSession(this.requestedSessionId);
            }
            catch (IOException e) {
                this.session = null;
            }
            if (this.session != null && !this.session.isValid()) {
                this.session = null;
            }
            if (this.session != null) {
                this.session.access();
                return this.session;
            }
        }
        if (!create) {
            return null;
        }
        if (this.response != null && this.context.getCookies() && this.response.getResponse().isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteRequest.sessionCreateCommitted"));
        }
        String sessionId = this.requestedSessionId;
        if (sessionId != null) {
            if (SESSION_ID_CHECK) {
                boolean found = false;
                try {
                    if (!found) {
                        Container[] children = this.getHost().findChildren();
                        for (int i = 0; i < children.length && !found; ++i) {
                            if (children[i].getManager() == null || children[i].getManager().findSession(sessionId) == null) continue;
                            found = true;
                        }
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (!found) {
                    sessionId = null;
                }
            } else if (!this.isRequestedSessionIdFromCookie()) {
                sessionId = null;
            }
        }
        this.session = manager.createSession(sessionId, this.random);
        if (!(this.session == null || !this.context.getCookies() || this.isRequestedSessionIdFromCookie() && this.session.getIdInternal().equals(this.getRequestedSessionId()))) {
            Cookie cookie = new Cookie(this.context.getSessionCookie().getName(), this.session.getIdInternal());
            this.configureSessionCookie(cookie);
            this.response.addCookieInternal(cookie);
        }
        if (this.session != null) {
            this.session.access();
            return this.session;
        }
        return null;
    }

    protected void configureSessionCookie(Cookie cookie) {
        cookie.setMaxAge(this.context.getSessionCookie().getMaxAge());
        if (this.context.getSessionCookie().getPath() != null) {
            cookie.setPath(this.context.getSessionCookie().getPath());
        } else {
            String contextPath = this.context.getEncodedPath();
            if ("".equals(contextPath)) {
                contextPath = "/";
            }
            cookie.setPath(contextPath);
        }
        if (this.context.getSessionCookie().getComment() != null) {
            cookie.setComment(this.context.getSessionCookie().getComment());
        }
        if (this.context.getSessionCookie().getDomain() != null) {
            cookie.setDomain(this.context.getSessionCookie().getDomain());
        }
        if (this.context.getSessionCookie().isHttpOnly()) {
            cookie.setHttpOnly(true);
        }
        if (this.context.getSessionCookie().isSecure()) {
            cookie.setSecure(true);
        } else if (this.isSecure()) {
            cookie.setSecure(true);
        }
    }

    protected String unescape(String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(92) == -1) {
            return s;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '\\') {
                buf.append(c);
                continue;
            }
            if (++i >= s.length()) {
                throw new IllegalArgumentException();
            }
            c = s.charAt(i);
            buf.append(c);
        }
        return buf.toString();
    }

    protected void parseCookies() {
        this.cookiesParsed = true;
        Cookies serverCookies = this.coyoteRequest.getCookies();
        int count = serverCookies.getCookieCount();
        if (count <= 0) {
            return;
        }
        this.cookies = new Cookie[count];
        int idx = 0;
        for (int i = 0; i < count; ++i) {
            ServerCookie scookie = serverCookies.getCookie(i);
            try {
                Cookie cookie = new Cookie(scookie.getName().toString(), null);
                int version = scookie.getVersion();
                cookie.setVersion(version);
                cookie.setValue(this.unescape(scookie.getValue().toString()));
                cookie.setPath(this.unescape(scookie.getPath().toString()));
                String domain = scookie.getDomain().toString();
                if (domain != null) {
                    cookie.setDomain(this.unescape(domain));
                }
                String comment = scookie.getComment().toString();
                cookie.setComment(version == 1 ? this.unescape(comment) : null);
                this.cookies[idx++] = cookie;
                continue;
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (idx < count) {
            Cookie[] ncookies = new Cookie[idx];
            System.arraycopy(this.cookies, 0, ncookies, 0, idx);
            this.cookies = ncookies;
        }
    }

    protected void parseParameters() {
        int semicolon;
        this.parametersParsed = true;
        if (this.context == null) {
            return;
        }
        Parameters parameters = this.coyoteRequest.getParameters();
        String enc = this.getCharacterEncoding();
        boolean useBodyEncodingForURI = this.connector.getUseBodyEncodingForURI();
        if (enc != null) {
            parameters.setEncoding(enc);
            if (useBodyEncodingForURI) {
                parameters.setQueryStringEncoding(enc);
            }
        } else {
            parameters.setEncoding("ISO-8859-1");
            if (useBodyEncodingForURI) {
                parameters.setQueryStringEncoding("ISO-8859-1");
            }
        }
        parameters.handleQueryParameters();
        if (this.usingInputStream || this.usingReader) {
            return;
        }
        if (!this.getMethod().equalsIgnoreCase("POST")) {
            return;
        }
        String contentType = this.getContentType();
        if (contentType == null) {
            contentType = "";
        }
        if (!"application/x-www-form-urlencoded".equals(contentType = (semicolon = contentType.indexOf(59)) >= 0 ? contentType.substring(0, semicolon).trim() : contentType.trim())) {
            block28: {
                if (this.parts == null && "multipart/form-data".equals(contentType)) {
                    try {
                        this.parseMultipart();
                    }
                    catch (Exception e) {
                        if (!this.context.getLogger().isDebugEnabled()) break block28;
                        this.context.getLogger().debug((Object)sm.getString("coyoteRequest.parseMultipart"), (Throwable)e);
                    }
                }
            }
            return;
        }
        int len = this.getContentLength();
        if (len > 0) {
            int maxPostSize = this.connector.getMaxPostSize();
            if (maxPostSize > 0 && len > maxPostSize) {
                if (this.context.getLogger().isDebugEnabled()) {
                    this.context.getLogger().debug((Object)sm.getString("coyoteRequest.postTooLarge"));
                }
                return;
            }
            byte[] formData = null;
            if (len < CACHED_POST_LEN) {
                if (this.postData == null) {
                    this.postData = new byte[CACHED_POST_LEN];
                }
                formData = this.postData;
            } else {
                formData = new byte[len];
            }
            try {
                if (this.readPostBody(formData, len) != len) {
                    return;
                }
            }
            catch (IOException e) {
                if (this.context.getLogger().isDebugEnabled()) {
                    this.context.getLogger().debug((Object)sm.getString("coyoteRequest.parseParameters"), (Throwable)e);
                }
                return;
            }
            parameters.processParameters(formData, 0, len);
        } else if ("chunked".equalsIgnoreCase(this.coyoteRequest.getHeader("transfer-encoding"))) {
            byte[] formData = null;
            try {
                formData = this.readChunkedPostBody();
            }
            catch (IOException e) {
                if (this.context.getLogger().isDebugEnabled()) {
                    this.context.getLogger().debug((Object)sm.getString("coyoteRequest.parseParameters"), (Throwable)e);
                }
                return;
            }
            if (formData != null) {
                parameters.processParameters(formData, 0, formData.length);
            }
        }
    }

    protected byte[] readChunkedPostBody() throws IOException {
        ByteChunk body = new ByteChunk();
        byte[] buffer = new byte[CACHED_POST_LEN];
        int len = 0;
        while (len > -1) {
            len = this.getStream().read(buffer, 0, CACHED_POST_LEN);
            if (this.connector.getMaxPostSize() > 0 && body.getLength() + len > this.connector.getMaxPostSize()) {
                throw new IllegalArgumentException(sm.getString("coyoteRequest.postTooLarge"));
            }
            if (len <= 0) continue;
            body.append(buffer, 0, len);
        }
        if (body.getLength() == 0) {
            return null;
        }
        if (body.getLength() < body.getBuffer().length) {
            int length = body.getLength();
            byte[] result = new byte[length];
            System.arraycopy(body.getBuffer(), 0, result, 0, length);
            return result;
        }
        return body.getBuffer();
    }

    protected void parseMultipart() throws IOException, ServletException {
        int semicolon;
        this.parts = Collections.emptyMap();
        if (this.context == null) {
            return;
        }
        Multipart config = this.wrapper.getMultipartConfig();
        if (config == null) {
            return;
        }
        if (this.usingInputStream || this.usingReader) {
            return;
        }
        if (!this.getMethod().equalsIgnoreCase("POST")) {
            return;
        }
        String contentType = this.getContentType();
        if (contentType == null) {
            contentType = "";
        }
        if (!"multipart/form-data".equals(contentType = (semicolon = contentType.indexOf(59)) >= 0 ? contentType.substring(0, semicolon).trim() : contentType.trim())) {
            throw new ServletException(sm.getString("coyoteRequest.notMultipart"));
        }
        DiskFileItemFactory factory = new DiskFileItemFactory();
        if (config.getLocation() != null) {
            factory.setRepository(new File(config.getLocation()));
        }
        if (config.getFileSizeThreshold() > 0) {
            factory.setSizeThreshold(config.getFileSizeThreshold());
        }
        ServletFileUpload upload = new ServletFileUpload();
        upload.setFileItemFactory(factory);
        upload.setFileSizeMax(config.getMaxFileSize());
        upload.setSizeMax(config.getMaxRequestSize());
        this.parts = new HashMap<String, Part>();
        try {
            for (FileItem fileItem : upload.parseRequest(this.getRequest())) {
                if (fileItem.getName() == null) {
                    this.coyoteRequest.getParameters().addParameterValues(fileItem.getFieldName(), new String[]{fileItem.getString()});
                }
                this.parts.put(fileItem.getFieldName(), new StandardPart(fileItem, config));
            }
        }
        catch (FileUploadBase.FileSizeLimitExceededException e) {
            throw new IllegalStateException(sm.getString("coyoteRequest.parseMultipart"), e);
        }
        catch (FileUploadBase.SizeLimitExceededException e) {
            throw new IllegalStateException(sm.getString("coyoteRequest.parseMultipart"), e);
        }
        catch (FileUploadException e) {
            throw new IOException(sm.getString("coyoteRequest.parseMultipart"), e);
        }
    }

    protected int readPostBody(byte[] body, int len) throws IOException {
        int inputLen;
        int offset = 0;
        do {
            if ((inputLen = this.getStream().read(body, offset, len - offset)) > 0) continue;
            return offset;
        } while (len - (offset += inputLen) > 0);
        return len;
    }

    protected void parseLocales() {
        this.localesParsed = true;
        Enumeration values = this.getHeaders("accept-language");
        while (values.hasMoreElements()) {
            String value = values.nextElement().toString();
            this.parseLocalesHeader(value);
        }
    }

    protected void parseLocalesHeader(String value) {
        int start;
        TreeMap<Double, ArrayList<Locale>> locales = new TreeMap<Double, ArrayList<Locale>>();
        int white = value.indexOf(32);
        if (white < 0) {
            white = value.indexOf(9);
        }
        if (white >= 0) {
            StringBuilder sb = new StringBuilder();
            int len = value.length();
            for (int i = 0; i < len; ++i) {
                char ch = value.charAt(i);
                if (ch == ' ' || ch == '\t') continue;
                sb.append(ch);
            }
            value = sb.toString();
        }
        this.parser.setString(value);
        int length = this.parser.getLength();
        while ((start = this.parser.getIndex()) < length) {
            int end = this.parser.findChar(',');
            String entry = this.parser.extract(start, end).trim();
            this.parser.advance();
            double quality = 1.0;
            int semi = entry.indexOf(";q=");
            if (semi >= 0) {
                try {
                    String strQuality = entry.substring(semi + 3);
                    quality = strQuality.length() <= 5 ? Double.parseDouble(strQuality) : 0.0;
                }
                catch (NumberFormatException e) {
                    quality = 0.0;
                }
                entry = entry.substring(0, semi);
            }
            if (quality < 5.0E-5 || "*".equals(entry)) continue;
            String language = null;
            String country = null;
            String variant = null;
            int dash = entry.indexOf(45);
            if (dash < 0) {
                language = entry;
                country = "";
                variant = "";
            } else {
                language = entry.substring(0, dash);
                country = entry.substring(dash + 1);
                int vDash = country.indexOf(45);
                if (vDash > 0) {
                    String cTemp = country.substring(0, vDash);
                    variant = country.substring(vDash + 1);
                    country = cTemp;
                } else {
                    variant = "";
                }
            }
            if (!Request.isAlpha(language) || !Request.isAlpha(country) || !Request.isAlpha(variant)) continue;
            Locale locale = new Locale(language, country, variant);
            Double key = new Double(-quality);
            ArrayList<Locale> values = (ArrayList<Locale>)locales.get(key);
            if (values == null) {
                values = new ArrayList<Locale>();
                locales.put(key, values);
            }
            values.add(locale);
        }
        for (ArrayList list : locales.values()) {
            for (Locale locale : list) {
                this.addLocale(locale);
            }
        }
    }

    protected static final boolean isAlpha(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
            return false;
        }
        return true;
    }

    public AsyncContext getAsyncContext() {
        return this.asyncContext;
    }

    public boolean isAsyncStarted() {
        return this.asyncContext != null && !this.canStartAsync && this.eventMode;
    }

    public boolean isAsyncSupported() {
        int filterChainCount = this.currentFilterChain + 1;
        for (int i = 0; i < filterChainCount; ++i) {
            int pos;
            ApplicationFilterChain filterChain = this.filterChains.get(i);
            int n = filterChain.getFilterCount();
            int lastFilter = pos = filterChain.getPointer();
            if (pos == n + 1) {
                lastFilter = n;
            }
            for (int j = 0; j < lastFilter; ++j) {
                if (filterChain.getFilters()[j].getFilterDef().getAsyncSupported()) continue;
                return false;
            }
            if (pos != n + 1 || filterChain.getWrapper().getAsyncSupported()) continue;
            return false;
        }
        return true;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return this.startAsync((ServletRequest)this.getRequest(), (ServletResponse)this.getResponse().getResponse());
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        if (CHECK_ASYNC && !this.isAsyncSupported()) {
            throw new IllegalStateException(sm.getString("coyoteRequest.noAsync"));
        }
        if (this.response.isClosed() || this.context == null) {
            throw new IllegalStateException(sm.getString("coyoteRequest.closed"));
        }
        if (!this.canStartAsync) {
            throw new IllegalStateException(sm.getString("coyoteRequest.cannotStartAsync"));
        }
        LinkedHashMap<AsyncListener, AsyncListenerRegistration> localAsyncListeners = this.asyncListeners;
        this.asyncListeners = new LinkedHashMap();
        for (AsyncListenerRegistration registration : localAsyncListeners.values()) {
            AsyncListener asyncListener = registration.getListener();
            AsyncEvent asyncEvent = new AsyncEvent((AsyncContext)this.asyncContext, registration.getRequest(), registration.getResponse());
            try {
                asyncListener.onStartAsync(asyncEvent);
            }
            catch (IOException e) {
                throw new IllegalStateException(sm.getString("coyoteRequest.onStartAsyncError", asyncListener.getClass().getName()), e);
            }
        }
        this.canStartAsync = false;
        if (this.asyncContext == null) {
            this.asyncContext = new AsyncContextImpl();
            this.eventMode = true;
        } else {
            this.asyncContext.reset();
        }
        this.asyncContext.setRequestAndResponse(servletRequest, servletResponse);
        return this.asyncContext;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        if (this.context != null && this.context.getAuthenticator() != null) {
            return this.context.getAuthenticator().authenticate(this, response);
        }
        throw new ServletException(sm.getString("coyoteRequest.noAuthenticator"));
    }

    public void login(String username, String password) throws ServletException {
        if (this.userPrincipal != null) {
            throw new ServletException(sm.getString("coyoteRequest.authFailed"));
        }
        if (this.context == null || this.context.getAuthenticator() == null) {
            throw new ServletException(sm.getString("coyoteRequest.noAuthenticator"));
        }
        this.context.getAuthenticator().login(this, username, password);
        if (this.userPrincipal == null) {
            throw new ServletException(sm.getString("coyoteRequest.authFailed"));
        }
    }

    public void logout() throws ServletException {
        Principal principal = this.userPrincipal;
        if (this.context != null && this.context.getAuthenticator() != null) {
            this.context.getAuthenticator().logout(this);
        } else {
            this.userPrincipal = null;
            this.authType = null;
        }
        if (principal instanceof GenericPrincipal) {
            GenericPrincipal gp = (GenericPrincipal)principal;
            try {
                gp.logout();
            }
            catch (Exception e) {
                throw new ServletException(sm.getString("coyoteRequest.logoutfail"), (Throwable)e);
            }
        }
    }

    public DispatcherType getDispatcherType() {
        if (this.dispatcherType == null) {
            return DispatcherType.REQUEST;
        }
        if (this.dispatcherType == ApplicationFilterFactory.REQUEST_INTEGER) {
            return DispatcherType.REQUEST;
        }
        if (this.dispatcherType == ApplicationFilterFactory.ASYNC_INTEGER) {
            return DispatcherType.ASYNC;
        }
        if (this.dispatcherType == ApplicationFilterFactory.ERROR_INTEGER) {
            return DispatcherType.ERROR;
        }
        if (this.dispatcherType == ApplicationFilterFactory.FORWARD_INTEGER) {
            return DispatcherType.FORWARD;
        }
        if (this.dispatcherType == ApplicationFilterFactory.INCLUDE_INTEGER) {
            return DispatcherType.INCLUDE;
        }
        throw new IllegalStateException();
    }

    public Part getPart(String name) throws IOException, ServletException {
        if (this.parts == null) {
            this.parseMultipart();
        }
        return this.parts.get(name);
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        if (this.parts == null) {
            this.parseMultipart();
        }
        return this.parts.values();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(sm.getString("coyoteRequest.servletStack", Thread.currentThread().getName()));
        if (this.eventMode) {
            buf.append(" [event]");
        }
        if (this.asyncContext != null) {
            buf.append(" [async]");
        }
        buf.append("\r\n");
        int filterChainCount = this.currentFilterChain + 1;
        for (int i = 0; i < filterChainCount; ++i) {
            ApplicationFilterChain filterChain = this.filterChains.get(i);
            ApplicationFilterConfig[] filterConfigs = filterChain.getFilters();
            int n = filterChain.getFilterCount();
            int pos = filterChain.getPointer();
            for (int j = 0; j < n; ++j) {
                FilterDef filterDef = filterConfigs[j].getFilterDef();
                if (pos == j) {
                    buf.append("-> ");
                } else {
                    buf.append("   ");
                }
                buf.append("[F] ").append(filterDef.getFilterName()).append(" [").append(filterDef.getFilterClass()).append("] ").append(filterDef.getAsyncSupported() ? "[A]" : "").append("\r\n");
            }
            if (pos == n) {
                buf.append("-> ");
            } else {
                buf.append("   ");
            }
            Wrapper wrapper = filterChain.getWrapper();
            buf.append("[S] ").append(wrapper.getName()).append(" [").append(wrapper.getServletClass()).append("] ").append(wrapper.getAsyncSupported() ? "[A]" : "").append("\r\n");
        }
        return buf.toString();
    }

    static {
        new StringCache.ByteEntry();
        new StringCache.CharEntry();
        GMT_ZONE = TimeZone.getTimeZone("GMT");
        sm = StringManager.getManager("org.apache.catalina.connector");
        defaultLocale = Locale.getDefault();
        CACHED_POST_LEN = 8192;
    }

    public class AsyncListenerRegistration {
        protected ServletRequest request;
        protected ServletResponse response;
        protected AsyncListener listener;

        protected AsyncListenerRegistration(AsyncListener listener, ServletRequest request2, ServletResponse response) {
            this.listener = listener;
            this.request = request2;
            this.response = response;
        }

        public ServletRequest getRequest() {
            return this.request;
        }

        public ServletResponse getResponse() {
            return this.response;
        }

        public AsyncListener getListener() {
            return this.listener;
        }
    }

    public class AsyncContextImpl
    implements AsyncContext {
        protected ServletRequest servletRequest = null;
        protected ServletResponse servletResponse = null;
        protected ServletContext servletContext = null;
        protected String path = null;
        protected Runnable runnable = null;
        protected boolean useAttributes = false;
        protected boolean original = true;
        protected boolean ready = true;

        public void complete() {
            Request.this.setEventMode(false);
            Request.this.resume();
        }

        public void dispatch() {
            this.servletContext = null;
            if (this.servletRequest == Request.this.getRequestFacade()) {
                this.path = Request.this.getRequestPathMB().toString();
            } else if (this.servletRequest instanceof HttpServletRequest) {
                String requestURI = ((HttpServletRequest)this.servletRequest).getRequestURI();
                this.servletContext = Request.this.getServletContext0().getContext(requestURI);
                if (this.servletContext != null) {
                    this.path = requestURI.substring(this.servletContext.getContextPath().length());
                } else {
                    throw new IllegalStateException(sm.getString("coyoteRequest.dispatchNoServletContext", requestURI));
                }
            }
            Request.this.resume();
        }

        public void dispatch(String path) {
            this.servletContext = null;
            this.path = path;
            this.useAttributes = true;
            Request.this.resume();
        }

        public void dispatch(ServletContext servletContext, String path) {
            this.servletContext = servletContext;
            this.path = path;
            this.useAttributes = true;
            Request.this.resume();
        }

        public ServletRequest getRequest() {
            if (this.servletRequest != null) {
                return this.servletRequest;
            }
            return Request.this.getRequestFacade();
        }

        public ServletResponse getResponse() {
            if (this.servletResponse != null) {
                return this.servletResponse;
            }
            return Request.this.getResponseFacade();
        }

        public boolean hasOriginalRequestAndResponse() {
            return this.servletRequest == Request.this.getRequestFacade() && this.servletResponse == Request.this.getResponseFacade();
        }

        public void start(Runnable runnable) {
            this.runnable = runnable;
            Request.this.resume();
        }

        public boolean isReady() {
            return this.ready;
        }

        public void done() {
            this.ready = false;
        }

        public void setRequestAndResponse(ServletRequest servletRequest, ServletResponse servletResponse) {
            this.servletRequest = servletRequest;
            this.servletResponse = servletResponse;
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }

        public String getPath() {
            return this.path;
        }

        public boolean getUseAttributes() {
            return this.useAttributes;
        }

        public Runnable getRunnable() {
            return this.runnable;
        }

        public void reset() {
            this.servletContext = null;
            this.path = null;
            this.runnable = null;
            this.useAttributes = false;
            this.ready = true;
        }

        public Map<AsyncListener, AsyncListenerRegistration> getAsyncListeners() {
            return Request.this.asyncListeners;
        }

        public void addListener(AsyncListener listener, ServletRequest servletRequest, ServletResponse servletResponse) {
            Request.this.asyncListeners.put(listener, new AsyncListenerRegistration(listener, servletRequest, servletResponse));
        }

        public void addListener(AsyncListener listener) {
            this.addListener(listener, this.getRequest(), (ServletResponse)Request.this.response.getResponse());
        }

        public long getTimeout() {
            return Request.this.asyncTimeout;
        }

        public void setTimeout(long timeout) {
            int realTimeout;
            Request.this.asyncTimeout = timeout;
            int n = realTimeout = Request.this.asyncTimeout > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)Request.this.asyncTimeout;
            if (realTimeout <= 0) {
                realTimeout = Integer.MAX_VALUE;
            }
            Request.this.setTimeout0(realTimeout);
        }

        public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
            AsyncListener listenerInstance = null;
            try {
                listenerInstance = (AsyncListener)Request.this.context.getInstanceManager().newInstance(clazz);
            }
            catch (Exception e) {
                throw new ServletException(sm.getString("coyoteRequest.createListener", clazz.getName()), (Throwable)e);
            }
            return (T)listenerInstance;
        }
    }
}

