/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.el.util;

import java.text.MessageFormat;
import java.util.ResourceBundle;

/**
 * @author Jacob Hookom [jacob@hookom.net]
 * @version $Id: MessageFactory.java 1882 2011-12-06 15:27:15Z remy.maucherat@jboss.com $
 */
public final class MessageFactory {

    protected static final ResourceBundle bundle =
            ResourceBundle.getBundle("org.apache.el.Messages");

    public MessageFactory() {
        super();
    }

    public static String get(final String key) {
        return bundle.getString(key);
    }

    public static String get(final String key, final Object... args) {
        String value = get(key);
        if (value == null) {
            value = key;
        }

        MessageFormat mf = new MessageFormat(value);
        return mf.format(args, new StringBuffer(), null).toString();
    }
}
