/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tomcat.util.Constants;

public abstract class AbstractEndpoint {
    protected static final int DEFAULT_SO_TIMEOUT = 60000;
    protected volatile boolean running = false;
    protected volatile boolean paused = false;
    protected boolean initialized = false;
    protected AtomicInteger counter = new AtomicInteger();
    protected boolean reuseAddress = false;
    protected int curThreadsBusy = 0;
    protected int curThreads = 0;
    protected int sequence = 0;
    protected int acceptorThreadCount = 0;
    protected Executor executor = null;
    protected int maxThreads = Constants.LOW_MEMORY ? 32 : 32 * Runtime.getRuntime().availableProcessors();
    protected int maxConnections = 1024;
    protected int threadPriority = 5;
    protected int sendfileSize = -1;
    protected int port;
    protected InetAddress address;
    protected ThreadFactory threadFactory;
    protected int backlog = 511;
    protected boolean tcpNoDelay = false;
    protected int soLinger = 100;
    protected int soTimeout = -1;
    protected boolean deferAccept = true;
    protected int keepAliveTimeout = -1;
    protected boolean daemon = true;
    protected String name = "TP";
    protected boolean useSendfile = true;
    protected boolean reverseConnection = false;
    protected boolean SSLEnabled = false;
    protected String SSLProtocol = "all";
    protected String SSLPassword = null;
    protected String SSLCipherSuite = "ALL";
    protected String SSLCertificateFile = null;
    protected String SSLCertificateChainFile = null;
    protected String SSLCACertificatePath = null;
    protected String SSLCACertificateFile = null;
    protected String SSLCARevocationPath = null;
    protected String SSLCARevocationFile = null;
    protected String SSLVerifyClient = "none";
    protected int SSLVerifyDepth = 10;
    protected boolean SSLInsecureRenegotiation = false;
    protected String SSLCertificateKeyFile = null;

    public abstract void init() throws Exception;

    public abstract void start() throws Exception;

    public void pause() {
        if (this.running && !this.paused) {
            this.paused = true;
            this.unlockAccept();
        }
    }

    public void resume() {
        if (this.running) {
            this.paused = false;
        }
    }

    public abstract void stop();

    public abstract void destroy() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockAccept() {
        Socket s = null;
        try {
            if (this.address == null) {
                s = new Socket("localhost", this.port);
            } else {
                s = new Socket(this.address, this.port);
                s.setSoLinger(true, 0);
            }
            if (this.deferAccept) {
                s.getOutputStream().write(" ".getBytes());
                s.getOutputStream().flush();
            }
        }
        catch (Exception e) {
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception e) {}
            }
        }
    }

    protected Thread newThread(Runnable target, String name, boolean daemon) {
        Thread thread = this.threadFactory != null ? this.threadFactory.newThread(target) : new Thread(target);
        thread.setName(this.getName() + "-" + name);
        thread.setPriority(this.threadPriority);
        thread.setDaemon(daemon);
        return thread;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public int getCurThreadsBusy() {
        return this.curThreadsBusy;
    }

    public void setCurThreadsBusy(int curThreadsBusy) {
        this.curThreadsBusy = curThreadsBusy;
    }

    public int getCurThreads() {
        return this.curThreads;
    }

    public void setCurThreads(int curThreads) {
        this.curThreads = curThreads;
    }

    public int getSequence() {
        return this.sequence++;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public int getSendfileSize() {
        return this.sendfileSize;
    }

    public void setSendfileSize(int sendfileSize) {
        this.sendfileSize = sendfileSize;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        if (backlog > 0) {
            this.backlog = backlog;
        }
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public void setSoLinger(int soLinger) {
        this.soLinger = soLinger;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public boolean getDeferAccept() {
        return this.deferAccept;
    }

    public void setDeferAccept(boolean deferAccept) {
        this.deferAccept = deferAccept;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public boolean getDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean getUseSendfile() {
        return this.useSendfile;
    }

    public void setUseSendfile(boolean useSendfile) {
        this.useSendfile = useSendfile;
    }

    public boolean isReverseConnection() {
        return this.reverseConnection;
    }

    public void setReverseConnection(boolean reverseConnection) {
        this.reverseConnection = reverseConnection;
    }

    public boolean getSSLEnabled() {
        return this.SSLEnabled;
    }

    public void setSSLEnabled(boolean sSLEnabled) {
        this.SSLEnabled = sSLEnabled;
    }

    public String getSSLProtocol() {
        return this.SSLProtocol;
    }

    public void setSSLProtocol(String sSLProtocol) {
        this.SSLProtocol = sSLProtocol;
    }

    public String getSSLPassword() {
        return this.SSLPassword;
    }

    public void setSSLPassword(String sSLPassword) {
        this.SSLPassword = sSLPassword;
    }

    public String getSSLCipherSuite() {
        return this.SSLCipherSuite;
    }

    public void setSSLCipherSuite(String sSLCipherSuite) {
        this.SSLCipherSuite = sSLCipherSuite;
    }

    public String getSSLCertificateFile() {
        return this.SSLCertificateFile;
    }

    public void setSSLCertificateFile(String sSLCertificateFile) {
        this.SSLCertificateFile = sSLCertificateFile;
    }

    public String getSSLCertificateChainFile() {
        return this.SSLCertificateChainFile;
    }

    public void setSSLCertificateChainFile(String sSLCertificateChainFile) {
        this.SSLCertificateChainFile = sSLCertificateChainFile;
    }

    public String getSSLCACertificatePath() {
        return this.SSLCACertificatePath;
    }

    public void setSSLCACertificatePath(String sSLCACertificatePath) {
        this.SSLCACertificatePath = sSLCACertificatePath;
    }

    public String getSSLCACertificateFile() {
        return this.SSLCACertificateFile;
    }

    public void setSSLCACertificateFile(String sSLCACertificateFile) {
        this.SSLCACertificateFile = sSLCACertificateFile;
    }

    public String getSSLCARevocationPath() {
        return this.SSLCARevocationPath;
    }

    public void setSSLCARevocationPath(String sSLCARevocationPath) {
        this.SSLCARevocationPath = sSLCARevocationPath;
    }

    public String getSSLCARevocationFile() {
        return this.SSLCARevocationFile;
    }

    public void setSSLCARevocationFile(String sSLCARevocationFile) {
        this.SSLCARevocationFile = sSLCARevocationFile;
    }

    public String getSSLVerifyClient() {
        return this.SSLVerifyClient;
    }

    public void setSSLVerifyClient(String sSLVerifyClient) {
        this.SSLVerifyClient = sSLVerifyClient;
    }

    public int getSSLVerifyDepth() {
        return this.SSLVerifyDepth;
    }

    public void setSSLVerifyDepth(int sSLVerifyDepth) {
        this.SSLVerifyDepth = sSLVerifyDepth;
    }

    public boolean getSSLInsecureRenegotiation() {
        return this.SSLInsecureRenegotiation;
    }

    public void setSSLInsecureRenegotiation(boolean sSLInsecureRenegotiation) {
        this.SSLInsecureRenegotiation = sSLInsecureRenegotiation;
    }

    public String getSSLCertificateKeyFile() {
        return this.SSLCertificateKeyFile;
    }

    public void setSSLCertificateKeyFile(String sSLCertificateKeyFile) {
        this.SSLCertificateKeyFile = sSLCertificateKeyFile;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public int getAcceptorThreadCount() {
        return this.acceptorThreadCount;
    }

    public void setAcceptorThreadCount(int acceptorThreadCount) {
        this.acceptorThreadCount = acceptorThreadCount;
    }
}

