/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSession;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.jsse.SecureNioChannel;
import org.jboss.web.CoyoteLogger;

class NioJSSESupport
implements SSLSupport {
    protected SecureNioChannel channel;
    protected SSLSession session;

    NioJSSESupport(SecureNioChannel channel) {
        this.channel = channel;
        this.session = channel.getSSLSession();
    }

    NioJSSESupport(SSLSession session) {
        this.session = session;
    }

    @Override
    public String getCipherSuite() throws IOException {
        return this.session == null ? null : this.session.getCipherSuite();
    }

    @Override
    public Object[] getPeerCertificateChain() throws IOException {
        return this.getPeerCertificateChain(false);
    }

    @Override
    public Object[] getPeerCertificateChain(boolean force) throws IOException {
        if (this.session == null) {
            return null;
        }
        javax.security.cert.X509Certificate[] jsseCerts = null;
        try {
            jsseCerts = this.session.getPeerCertificateChain();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (jsseCerts == null) {
            jsseCerts = new javax.security.cert.X509Certificate[]{};
        }
        if (jsseCerts.length <= 0 && force) {
            this.session.invalidate();
            this.handShake();
            this.session = this.channel.getSSLSession();
        }
        return this.getX509Certificates(this.session);
    }

    protected X509Certificate[] getX509Certificates(SSLSession session) throws IOException {
        Certificate[] certs = null;
        try {
            certs = session.getPeerCertificates();
        }
        catch (Throwable t) {
            CoyoteLogger.UTIL_LOGGER.debug("Error getting client certs", t);
            return null;
        }
        if (certs == null) {
            return null;
        }
        X509Certificate[] x509Certs = new X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            if (certs[i] instanceof X509Certificate) {
                x509Certs[i] = (X509Certificate)certs[i];
            } else {
                try {
                    byte[] buffer = certs[i].getEncoded();
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
                    x509Certs[i] = (X509Certificate)cf.generateCertificate(stream);
                }
                catch (Exception ex) {
                    CoyoteLogger.UTIL_LOGGER.errorTranslatingCertificate(certs[i], ex);
                    return null;
                }
            }
            if (!CoyoteLogger.UTIL_LOGGER.isTraceEnabled()) continue;
            CoyoteLogger.UTIL_LOGGER.trace("Cert #" + i + " = " + x509Certs[i]);
        }
        if (x509Certs.length < 1) {
            return null;
        }
        return x509Certs;
    }

    @Override
    public Integer getKeySize() throws IOException {
        SSLSupport.CipherData[] c_aux = ciphers;
        if (this.session == null) {
            return null;
        }
        Integer keySize = (Integer)this.session.getValue("javax.servlet.request.key_size");
        if (keySize == null) {
            int size = 0;
            String cipherSuite = this.session.getCipherSuite();
            for (int i = 0; i < c_aux.length; ++i) {
                if (cipherSuite.indexOf(c_aux[i].phrase) < 0) continue;
                size = c_aux[i].keySize;
                break;
            }
            keySize = new Integer(size);
            this.session.putValue("javax.servlet.request.key_size", keySize);
        }
        return keySize;
    }

    @Override
    public String getSessionId() throws IOException {
        if (this.session == null) {
            return null;
        }
        byte[] ssl_session = this.session.getId();
        if (ssl_session == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder("");
        for (int x = 0; x < ssl_session.length; ++x) {
            String digit = Integer.toHexString(ssl_session[x]);
            if (digit.length() < 2) {
                buf.append('0');
            }
            if (digit.length() > 2) {
                digit = digit.substring(digit.length() - 2);
            }
            buf.append(digit);
        }
        return buf.toString();
    }

    protected void handShake() throws IOException {
        if (this.channel != null && this.channel.handshakeComplete) {
            return;
        }
        if (this.channel != null) {
            this.channel.handshake();
        }
    }
}

