/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.TreeMap;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.naming.directory.DirContext;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.SessionTrackingMode;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.ThreadBindingListener;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContextValve;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.JspPropertyGroup;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.deploy.SessionCookie;
import org.apache.catalina.deploy.jsp.TagLibraryInfo;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.util.CharsetMapper;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.URLEncoder;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.apache.naming.resources.FileDirContext;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.naming.resources.WARDirContext;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.Constants;
import org.apache.tomcat.util.http.mapper.Mapper;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.web.CatalinaLogger;
import org.jboss.web.CatalinaMessages;

public class StandardContext
extends ContainerBase
implements Context,
NotificationEmitter {
    protected static final String info = "org.apache.catalina.core.StandardContext/1.0";
    protected static URLEncoder urlEncoder = new URLEncoder();
    protected String altDDName = null;
    protected InstanceManager instanceManager = null;
    protected String hostName;
    protected String[] applicationListeners = new String[0];
    protected HashSet<String> restrictedApplicationListeners = new HashSet();
    protected EventListener[] applicationListenerInstances = new EventListener[0];
    protected Object[] applicationEventListenersInstances = null;
    protected Object[] applicationLifecycleListenersInstances = null;
    protected Object[] applicationSessionLifecycleListenersInstances = null;
    protected Object[] listenersInstances = null;
    protected ApplicationParameter[] applicationParameters = new ApplicationParameter[0];
    protected Authenticator authenticator = null;
    protected boolean available = false;
    protected boolean starting = false;
    protected NotificationBroadcasterSupport broadcaster = null;
    protected CharsetMapper charsetMapper = null;
    protected String charsetMapperClass = "org.apache.catalina.util.CharsetMapper";
    protected boolean configured = false;
    protected SecurityConstraint[] constraints = new SecurityConstraint[0];
    protected ApplicationContext context = null;
    protected String configClass = null;
    protected Set<SessionTrackingMode> defaultSessionTrackingModes = EnumSet.of(SessionTrackingMode.URL, SessionTrackingMode.COOKIE);
    protected Set<SessionTrackingMode> sessionTrackingModes = null;
    protected boolean crossContext = Boolean.valueOf(System.getProperty("org.apache.catalina.core.StandardContext.CROSS_CONTEXT", "false"));
    protected String encodedPath = null;
    protected String displayName = null;
    protected boolean distributable = false;
    protected String docBase = null;
    protected HashMap<String, ErrorPage> exceptionPages = new HashMap();
    protected HashMap<String, ApplicationFilterConfig> filterConfigs = new HashMap();
    protected HashMap<String, FilterDef> filterDefs = new HashMap();
    protected FilterMap[] filterMaps = new FilterMap[0];
    protected int filterMapInsertPoint = 0;
    protected boolean ignoreAnnotations = false;
    protected String[] instanceListeners = new String[0];
    protected LinkedHashMap<String, JspPropertyGroup> jspPropertyGroups = new LinkedHashMap();
    protected HashMap<String, TagLibraryInfo> jspTagLibraries = new HashMap();
    protected String logicalName = null;
    protected LoginConfig loginConfig = null;
    protected Mapper mapper = new Mapper();
    protected HashMap<String, String> mimeMappings = new HashMap();
    protected ErrorPage okErrorPage = null;
    protected HashMap<String, String> parameters = new HashMap();
    protected boolean paused = false;
    protected String publicId = null;
    protected String version = null;
    protected int versionMinor = 0;
    protected int versionMajor = 0;
    protected boolean override = false;
    protected boolean privileged = false;
    protected boolean replaceWelcomeFiles = false;
    protected HashMap<String, String> roleMappings = new HashMap();
    protected String[] securityRoles = new String[0];
    protected HashMap<String, String> servletMappings = new HashMap();
    protected int sessionTimeout = 30;
    protected long sequenceNumber = 0L;
    protected SessionCookie sessionCookie = new SessionCookie();
    protected HashMap<Integer, ErrorPage> statusPages = new HashMap();
    protected HashMap<String, String> taglibs = new HashMap();
    protected long unloadDelay = 2000L;
    protected String[] welcomeFiles = new String[0];
    protected String[] wrapperLifecycles = new String[0];
    protected String[] wrapperListeners = new String[0];
    protected String workDir = null;
    protected String wrapperClassName = StandardWrapper.class.getName();
    protected Class<?> wrapperClass = null;
    protected boolean filesystemBased = false;
    protected boolean cachingAllowed = true;
    protected boolean caseSensitive = true;
    protected boolean allowLinking = false;
    protected int cacheMaxSize = Constants.LOW_MEMORY ? 128 : 10240;
    protected int cacheObjectMaxSize = Constants.LOW_MEMORY ? 8 : 256;
    protected int cacheTTL = 5000;
    protected DirContext webappResources = null;
    protected long startupTime;
    protected long startTime;
    protected long tldScanTime;
    protected String engineName = null;
    protected String j2EEApplication = "none";
    protected String j2EEServer = "none";
    protected static final ThreadBindingListener DEFAULT_NAMING_LISTENER;
    protected ThreadBindingListener threadBindingListener = DEFAULT_NAMING_LISTENER;
    protected MBeanNotificationInfo[] notificationInfo;
    protected String server = null;
    protected String[] javaVMs = null;

    public StandardContext() {
        this.pipeline.setBasic(new StandardContextValve());
        this.broadcaster = new NotificationBroadcasterSupport();
    }

    @Override
    public InstanceManager getInstanceManager() {
        return this.instanceManager;
    }

    @Override
    public void setInstanceManager(InstanceManager instanceManager) {
        this.instanceManager = instanceManager;
    }

    @Override
    public String getEncodedPath() {
        return this.encodedPath;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.encodedPath = urlEncoder.encode(name);
    }

    public boolean isCachingAllowed() {
        return this.cachingAllowed;
    }

    public void setCachingAllowed(boolean cachingAllowed) {
        this.cachingAllowed = cachingAllowed;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setAllowLinking(boolean allowLinking) {
        this.allowLinking = allowLinking;
    }

    public boolean isAllowLinking() {
        return this.allowLinking;
    }

    public void setCacheTTL(int cacheTTL) {
        this.cacheTTL = cacheTTL;
    }

    public int getCacheTTL() {
        return this.cacheTTL;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public void setCacheMaxSize(int cacheMaxSize) {
        this.cacheMaxSize = cacheMaxSize;
    }

    public int getCacheObjectMaxSize() {
        return this.cacheObjectMaxSize;
    }

    public void setCacheObjectMaxSize(int cacheObjectMaxSize) {
        this.cacheObjectMaxSize = cacheObjectMaxSize;
    }

    public boolean isFilesystemBased() {
        return this.filesystemBased;
    }

    public void setFilesystemBased(boolean filesystemBased) {
        this.filesystemBased = filesystemBased;
    }

    @Override
    public Object[] getApplicationEventListeners() {
        return this.applicationEventListenersInstances != null ? this.applicationEventListenersInstances : this.listenersInstances;
    }

    @Override
    public void setApplicationEventListeners(Object[] listeners) {
        this.applicationEventListenersInstances = listeners;
    }

    @Override
    public Object[] getApplicationSessionLifecycleListeners() {
        return this.applicationSessionLifecycleListenersInstances != null ? this.applicationSessionLifecycleListenersInstances : this.listenersInstances;
    }

    @Override
    public void setApplicationSessionLifecycleListeners(Object[] listeners) {
        this.applicationSessionLifecycleListenersInstances = listeners;
    }

    @Override
    public Object[] getApplicationLifecycleListeners() {
        return this.applicationLifecycleListenersInstances;
    }

    @Override
    public void setApplicationLifecycleListeners(Object[] listeners) {
        this.applicationLifecycleListenersInstances = listeners;
    }

    @Override
    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    @Override
    public void setAuthenticator(Authenticator authenticator) {
        Authenticator oldAuthenticator = this.authenticator;
        this.authenticator = authenticator;
        this.support.firePropertyChange("authenticator", oldAuthenticator, this.authenticator);
    }

    @Override
    public boolean getAvailable() {
        return this.available;
    }

    @Override
    public void setAvailable(boolean available) {
        boolean oldAvailable = this.available;
        this.available = available;
        this.support.firePropertyChange("available", oldAvailable, this.available);
    }

    @Override
    public boolean isStarting() {
        return this.starting;
    }

    @Override
    public void setStarting(boolean starting) {
        this.starting = starting;
    }

    @Override
    public CharsetMapper getCharsetMapper() {
        if (this.charsetMapper == null) {
            try {
                Class<?> clazz = Class.forName(this.charsetMapperClass);
                this.charsetMapper = (CharsetMapper)clazz.newInstance();
            }
            catch (Throwable t) {
                this.charsetMapper = new CharsetMapper();
            }
        }
        return this.charsetMapper;
    }

    @Override
    public void setCharsetMapper(CharsetMapper mapper) {
        CharsetMapper oldCharsetMapper = this.charsetMapper;
        this.charsetMapper = mapper;
        if (mapper != null) {
            this.charsetMapperClass = mapper.getClass().getName();
        }
        this.support.firePropertyChange("charsetMapper", oldCharsetMapper, this.charsetMapper);
    }

    public String getConfigClass() {
        return this.configClass;
    }

    public void setConfigClass(String configClass) {
        this.configClass = configClass;
    }

    @Override
    public boolean getConfigured() {
        return this.configured;
    }

    @Override
    public void setConfigured(boolean configured) {
        boolean oldConfigured = this.configured;
        this.configured = configured;
        this.support.firePropertyChange("configured", oldConfigured, this.configured);
    }

    @Override
    public boolean getCookies() {
        return this.getSessionTrackingModes().contains(SessionTrackingMode.COOKIE);
    }

    @Override
    public void setCookies(boolean cookies) {
        boolean oldCookies = this.defaultSessionTrackingModes.contains(SessionTrackingMode.COOKIE);
        if (oldCookies && !cookies) {
            this.defaultSessionTrackingModes.remove(SessionTrackingMode.COOKIE);
        }
        if (!oldCookies && cookies) {
            this.defaultSessionTrackingModes.add(SessionTrackingMode.COOKIE);
        }
        if (oldCookies != cookies) {
            this.support.firePropertyChange("cookies", oldCookies, cookies);
        }
    }

    @Override
    public boolean getCrossContext() {
        return this.crossContext;
    }

    @Override
    public void setCrossContext(boolean crossContext) {
        boolean oldCrossContext = this.crossContext;
        this.crossContext = crossContext;
        this.support.firePropertyChange("crossContext", oldCrossContext, this.crossContext);
    }

    public long getStartupTime() {
        return this.startupTime;
    }

    public void setStartupTime(long startupTime) {
        this.startupTime = startupTime;
    }

    public long getTldScanTime() {
        return this.tldScanTime;
    }

    public void setTldScanTime(long tldScanTime) {
        this.tldScanTime = tldScanTime;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getAltDDName() {
        return this.altDDName;
    }

    @Override
    public void setAltDDName(String altDDName) {
        this.altDDName = altDDName;
        if (this.context != null) {
            this.context.setAttribute("org.apache.catalina.deploy.alt_dd", altDDName);
        }
    }

    @Override
    public void setDisplayName(String displayName) {
        String oldDisplayName = this.displayName;
        this.displayName = displayName;
        this.support.firePropertyChange("displayName", oldDisplayName, this.displayName);
    }

    @Override
    public boolean getDistributable() {
        return this.distributable;
    }

    @Override
    public void setDistributable(boolean distributable) {
        boolean oldDistributable = this.distributable;
        this.distributable = distributable;
        this.support.firePropertyChange("distributable", oldDistributable, this.distributable);
        if (this.getManager() != null) {
            this.getManager().setDistributable(distributable);
        }
    }

    @Override
    public String getDocBase() {
        return this.docBase;
    }

    @Override
    public void setDocBase(String docBase) {
        this.docBase = docBase;
    }

    @Override
    public String getInfo() {
        return info;
    }

    public String getEngineName() {
        if (this.engineName != null) {
            return this.engineName;
        }
        return this.domain;
    }

    public void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    public String getJ2EEApplication() {
        return this.j2EEApplication;
    }

    public void setJ2EEApplication(String j2EEApplication) {
        this.j2EEApplication = j2EEApplication;
    }

    public String getJ2EEServer() {
        return this.j2EEServer;
    }

    public void setJ2EEServer(String j2EEServer) {
        this.j2EEServer = j2EEServer;
    }

    @Override
    public void setLoader(Loader loader) {
        super.setLoader(loader);
    }

    @Override
    public boolean getIgnoreAnnotations() {
        return this.ignoreAnnotations;
    }

    @Override
    public void setIgnoreAnnotations(boolean ignoreAnnotations) {
        boolean oldIgnoreAnnotations = this.ignoreAnnotations;
        this.ignoreAnnotations = ignoreAnnotations;
        this.support.firePropertyChange("ignoreAnnotations", oldIgnoreAnnotations, this.ignoreAnnotations);
    }

    @Override
    public void setSessionCookie(SessionCookie sessionCookie) {
        SessionCookie oldSessionCookie = this.sessionCookie;
        this.sessionCookie = sessionCookie;
        this.support.firePropertyChange("sessionCookie", oldSessionCookie, sessionCookie);
    }

    @Override
    public SessionCookie getSessionCookie() {
        return this.sessionCookie;
    }

    @Override
    public String getLogicalName() {
        return this.logicalName;
    }

    @Override
    public void setLogicalName(String logicalName) {
        String oldLogicalName = this.logicalName;
        this.logicalName = logicalName;
        this.support.firePropertyChange("logicalName", oldLogicalName, logicalName);
    }

    @Override
    public LoginConfig getLoginConfig() {
        return this.loginConfig;
    }

    @Override
    public void setLoginConfig(LoginConfig config) {
        String errorPage;
        if (config == null) {
            throw CatalinaMessages.MESSAGES.nullLoginConfig();
        }
        String loginPage = config.getLoginPage();
        if (loginPage != null && !loginPage.startsWith("/")) {
            if (this.isServlet22()) {
                CatalinaLogger.CORE_LOGGER.loginPageStartsWithSlash(loginPage);
                config.setLoginPage("/" + loginPage);
            } else {
                throw CatalinaMessages.MESSAGES.loginPageMustStartWithSlash(loginPage);
            }
        }
        if ((errorPage = config.getErrorPage()) != null && !errorPage.startsWith("/")) {
            if (this.isServlet22()) {
                CatalinaLogger.CORE_LOGGER.errorPageStartsWithSlash(errorPage);
                config.setErrorPage("/" + errorPage);
            } else {
                throw CatalinaMessages.MESSAGES.errorPageMustStartWithSlash(errorPage);
            }
        }
        LoginConfig oldLoginConfig = this.loginConfig;
        this.loginConfig = config;
        this.support.firePropertyChange("loginConfig", oldLoginConfig, this.loginConfig);
    }

    @Override
    public Mapper getMapper() {
        return this.mapper;
    }

    @Override
    public String getPath() {
        return this.getName();
    }

    @Override
    public void setPath(String path) {
        this.setName(path);
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public void setPublicId(String publicId) {
        String oldPublicId = this.publicId;
        this.publicId = publicId;
        this.support.firePropertyChange("publicId", oldPublicId, publicId);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public int getVersionMajor() {
        int pos;
        if (this.version != null && (pos = this.version.indexOf(46)) != -1) {
            this.versionMajor = Integer.parseInt(this.version.substring(0, pos));
        }
        return this.versionMajor;
    }

    @Override
    public int getVersionMinor() {
        int pos;
        if (this.version != null && (pos = this.version.indexOf(46)) < this.version.length()) {
            this.versionMinor = Integer.parseInt(this.version.substring(pos + 1));
        }
        return this.versionMinor;
    }

    @Override
    public void setVersion(String version) {
        String oldVersion = this.version;
        this.version = version;
        this.getVersionMajor();
        this.getVersionMinor();
        this.support.firePropertyChange("version", oldVersion, version);
    }

    @Override
    public boolean getOverride() {
        return this.override;
    }

    @Override
    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        if (this.getPrivileged()) {
            return this.getClass().getClassLoader();
        }
        if (this.parent != null) {
            return this.parent.getParentClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    @Override
    public boolean getPrivileged() {
        return this.privileged;
    }

    @Override
    public void setPrivileged(boolean privileged) {
        boolean oldPrivileged = this.privileged;
        this.privileged = privileged;
        this.support.firePropertyChange("privileged", oldPrivileged, this.privileged);
    }

    @Override
    public void setOverride(boolean override) {
        boolean oldOverride = this.override;
        this.override = override;
        this.support.firePropertyChange("override", oldOverride, this.override);
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.defaultSessionTrackingModes;
    }

    public Set<SessionTrackingMode> getSessionTrackingModes() {
        if (this.sessionTrackingModes == null) {
            return this.defaultSessionTrackingModes;
        }
        return this.sessionTrackingModes;
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        this.sessionTrackingModes = sessionTrackingModes;
    }

    @Override
    public void addSessionTrackingMode(String trackingMode) {
        SessionTrackingMode mode = SessionTrackingMode.valueOf((String)trackingMode);
        if (mode == null) {
            throw new IllegalArgumentException();
        }
        if (this.sessionTrackingModes == null) {
            this.sessionTrackingModes = new HashSet<SessionTrackingMode>();
        }
        this.sessionTrackingModes.add(mode);
    }

    public boolean isReplaceWelcomeFiles() {
        return this.replaceWelcomeFiles;
    }

    public void setReplaceWelcomeFiles(boolean replaceWelcomeFiles) {
        boolean oldReplaceWelcomeFiles = this.replaceWelcomeFiles;
        this.replaceWelcomeFiles = replaceWelcomeFiles;
        this.support.firePropertyChange("replaceWelcomeFiles", oldReplaceWelcomeFiles, this.replaceWelcomeFiles);
    }

    @Override
    public ServletContext getServletContext() {
        if (this.context == null) {
            this.context = new ApplicationContext(this.getBasePath(), this);
            if (this.altDDName != null) {
                this.context.setAttribute("org.apache.catalina.deploy.alt_dd", this.altDDName);
            }
        }
        return this.context.getFacade();
    }

    @Override
    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    @Override
    public void setSessionTimeout(int timeout) {
        int oldSessionTimeout = this.sessionTimeout;
        this.sessionTimeout = timeout == 0 ? -1 : timeout;
        this.support.firePropertyChange("sessionTimeout", oldSessionTimeout, this.sessionTimeout);
    }

    public long getUnloadDelay() {
        return this.unloadDelay;
    }

    public void setUnloadDelay(long unloadDelay) {
        long oldUnloadDelay = this.unloadDelay;
        this.unloadDelay = unloadDelay;
        this.support.firePropertyChange("unloadDelay", oldUnloadDelay, this.unloadDelay);
    }

    @Override
    public String getWrapperClass() {
        return this.wrapperClassName;
    }

    @Override
    public void setWrapperClass(String wrapperClassName) {
        this.wrapperClassName = wrapperClassName;
        try {
            this.wrapperClass = Class.forName(wrapperClassName);
            if (!StandardWrapper.class.isAssignableFrom(this.wrapperClass)) {
                throw CatalinaMessages.MESSAGES.invalidWrapperClass(wrapperClassName);
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException(cnfe.getMessage());
        }
    }

    @Override
    public void setResources(DirContext resources) {
        if (this.started) {
            throw CatalinaMessages.MESSAGES.cannotSetResourcesAfterStart();
        }
        DirContext oldResources = this.webappResources;
        if (oldResources == resources) {
            return;
        }
        if (resources instanceof BaseDirContext) {
            ((BaseDirContext)resources).setCached(this.isCachingAllowed());
            ((BaseDirContext)resources).setCacheTTL(this.getCacheTTL());
            ((BaseDirContext)resources).setCacheMaxSize(this.getCacheMaxSize());
            ((BaseDirContext)resources).setCacheObjectMaxSize(this.getCacheObjectMaxSize());
        }
        if (resources instanceof FileDirContext) {
            this.filesystemBased = true;
            ((FileDirContext)resources).setCaseSensitive(this.isCaseSensitive());
            ((FileDirContext)resources).setAllowLinking(this.isAllowLinking());
        }
        this.webappResources = resources;
        this.resources = null;
        this.support.firePropertyChange("resources", oldResources, this.webappResources);
    }

    @Override
    public ThreadBindingListener getThreadBindingListener() {
        return this.threadBindingListener;
    }

    @Override
    public void setThreadBindingListener(ThreadBindingListener threadBindingListener) {
        this.threadBindingListener = threadBindingListener;
    }

    public String getCharsetMapperClass() {
        return this.charsetMapperClass;
    }

    public void setCharsetMapperClass(String mapper) {
        String oldCharsetMapperClass = this.charsetMapperClass;
        this.charsetMapperClass = mapper;
        this.support.firePropertyChange("charsetMapperClass", oldCharsetMapperClass, this.charsetMapperClass);
    }

    public String getWorkPath() {
        if (this.getWorkDir() == null) {
            return null;
        }
        File workDir = new File(this.getWorkDir());
        if (!workDir.isAbsolute()) {
            File catalinaHome = this.workBase();
            String catalinaHomePath = null;
            try {
                catalinaHomePath = catalinaHome.getCanonicalPath();
                workDir = new File(catalinaHomePath, this.getWorkDir());
            }
            catch (IOException e) {
                CatalinaLogger.CORE_LOGGER.failedObtainingWorkDirectory(this.getPath(), e);
            }
        }
        return workDir.getAbsolutePath();
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
        if (this.started) {
            this.postWorkDirectory();
        }
    }

    @Override
    public void addApplicationListener(String listener) {
        this.addApplicationListener(listener, false);
    }

    protected void addApplicationListener(String listener, boolean restricted) {
        String[] results = new String[this.applicationListeners.length + 1];
        for (int i = 0; i < this.applicationListeners.length; ++i) {
            if (listener.equals(this.applicationListeners[i])) {
                CatalinaLogger.CORE_LOGGER.duplicateListener(listener);
                if (!restricted && this.restrictedApplicationListeners.contains(listener)) {
                    this.restrictedApplicationListeners.remove(listener);
                }
                return;
            }
            results[i] = this.applicationListeners[i];
        }
        results[this.applicationListeners.length] = listener;
        if (restricted && !this.restrictedApplicationListeners.contains(listener)) {
            boolean found = false;
            for (String check : this.applicationListeners) {
                if (!check.equals(listener)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.restrictedApplicationListeners.add(listener);
            }
        }
        this.applicationListeners = results;
        this.fireContainerEvent("addApplicationListener", listener);
    }

    @Override
    public <T extends EventListener> void addApplicationListenerInstance(T listener) {
        EventListener[] results = new EventListener[this.applicationListenerInstances.length + 1];
        for (int i = 0; i < this.applicationListenerInstances.length; ++i) {
            if (listener.equals(this.applicationListenerInstances[i])) {
                CatalinaLogger.CORE_LOGGER.duplicateListener(listener.getClass().getName());
                return;
            }
            results[i] = this.applicationListenerInstances[i];
        }
        results[this.applicationListenerInstances.length] = listener;
        this.applicationListenerInstances = results;
        this.fireContainerEvent("addApplicationListenerInstance", listener);
    }

    @Override
    public void addApplicationParameter(ApplicationParameter parameter) {
        String newName = parameter.getName();
        for (int i = 0; i < this.applicationParameters.length; ++i) {
            if (!newName.equals(this.applicationParameters[i].getName()) || this.applicationParameters[i].getOverride()) continue;
            return;
        }
        ApplicationParameter[] results = new ApplicationParameter[this.applicationParameters.length + 1];
        System.arraycopy(this.applicationParameters, 0, results, 0, this.applicationParameters.length);
        results[this.applicationParameters.length] = parameter;
        this.applicationParameters = results;
        this.fireContainerEvent("addApplicationParameter", parameter);
    }

    @Override
    public void addChild(Container child) {
        String jspFile;
        Wrapper oldJspServlet = null;
        if (!(child instanceof Wrapper)) {
            throw CatalinaMessages.MESSAGES.contextChildMustBeWrapper();
        }
        Wrapper wrapper = (Wrapper)child;
        boolean isJspServlet = "jsp".equals(child.getName());
        if (isJspServlet && (oldJspServlet = (Wrapper)this.findChild("jsp")) != null) {
            this.removeChild(oldJspServlet);
        }
        if ((jspFile = wrapper.getJspFile()) != null && !jspFile.startsWith("/")) {
            if (this.isServlet22()) {
                CatalinaLogger.CORE_LOGGER.jspFileStartsWithSlash(jspFile);
                wrapper.setJspFile("/" + jspFile);
            } else {
                throw CatalinaMessages.MESSAGES.jspFileMustStartWithSlash(jspFile);
            }
        }
        super.addChild(child);
        if (isJspServlet && oldJspServlet != null) {
            String[] jspMappings = oldJspServlet.findMappings();
            for (int i = 0; jspMappings != null && i < jspMappings.length; ++i) {
                this.addServletMapping(jspMappings[i], child.getName());
            }
        }
    }

    @Override
    public void addConstraint(SecurityConstraint constraint) {
        SecurityCollection[] collections = constraint.findCollections();
        for (int i = 0; i < collections.length; ++i) {
            String[] patterns = collections[i].findPatterns();
            for (int j = 0; j < patterns.length; ++j) {
                patterns[j] = this.adjustURLPattern(patterns[j]);
                if (this.validateURLPattern(patterns[j])) continue;
                throw CatalinaMessages.MESSAGES.invalidSecurityConstraintUrlPattern(patterns[j]);
            }
        }
        SecurityConstraint[] results = new SecurityConstraint[this.constraints.length + 1];
        for (int i = 0; i < this.constraints.length; ++i) {
            results[i] = this.constraints[i];
        }
        results[this.constraints.length] = constraint;
        this.constraints = results;
    }

    @Override
    public void addErrorPage(ErrorPage errorPage) {
        String exceptionType;
        if (errorPage == null) {
            throw CatalinaMessages.MESSAGES.nullErrorPage();
        }
        String location = errorPage.getLocation();
        if (location != null && !location.startsWith("/")) {
            if (this.isServlet22()) {
                CatalinaLogger.CORE_LOGGER.errorPageStartsWithSlash(location);
                errorPage.setLocation("/" + location);
            } else {
                throw CatalinaMessages.MESSAGES.errorPageMustStartWithSlash(location);
            }
        }
        if ((exceptionType = errorPage.getExceptionType()) != null) {
            this.exceptionPages.put(exceptionType, errorPage);
        } else {
            if (errorPage.getErrorCode() == 200) {
                this.okErrorPage = errorPage;
            }
            this.statusPages.put(errorPage.getErrorCode(), errorPage);
        }
        this.fireContainerEvent("addErrorPage", errorPage);
    }

    public void addApplicationFilterConfig(ApplicationFilterConfig filterConfig) {
        this.filterConfigs.put(filterConfig.getFilterName(), filterConfig);
        this.fireContainerEvent("addApplicationFilterConfig", filterConfig);
    }

    @Override
    public void addFilterDef(FilterDef filterDef) {
        this.filterDefs.put(filterDef.getFilterName(), filterDef);
        this.fireContainerEvent("addFilterDef", filterDef);
    }

    @Override
    public void addFilterMap(FilterMap filterMap) {
        this.validateFilterMap(filterMap);
        FilterMap[] results = new FilterMap[this.filterMaps.length + 1];
        System.arraycopy(this.filterMaps, 0, results, 0, this.filterMaps.length);
        results[this.filterMaps.length] = filterMap;
        this.filterMaps = results;
        this.fireContainerEvent("addFilterMap", filterMap);
    }

    @Override
    public void addFilterMapBefore(FilterMap filterMap) {
        this.validateFilterMap(filterMap);
        FilterMap[] results = new FilterMap[this.filterMaps.length + 1];
        System.arraycopy(this.filterMaps, 0, results, 0, this.filterMapInsertPoint);
        System.arraycopy(this.filterMaps, this.filterMapInsertPoint, results, this.filterMapInsertPoint + 1, this.filterMaps.length - this.filterMapInsertPoint);
        results[this.filterMapInsertPoint] = filterMap;
        ++this.filterMapInsertPoint;
        this.filterMaps = results;
        this.fireContainerEvent("addFilterMap", filterMap);
    }

    protected void validateFilterMap(FilterMap filterMap) {
        String filterName = filterMap.getFilterName();
        String[] servletNames = filterMap.getServletNames();
        String[] urlPatterns = filterMap.getURLPatterns();
        if (this.findFilterDef(filterName) == null) {
            throw CatalinaMessages.MESSAGES.unknownFilterNameInMapping(filterName);
        }
        if (!filterMap.getMatchAllServletNames() && !filterMap.getMatchAllUrlPatterns() && servletNames.length == 0 && urlPatterns.length == 0) {
            throw CatalinaMessages.MESSAGES.missingFilterMapping();
        }
        for (int i = 0; i < urlPatterns.length; ++i) {
            if (this.validateURLPattern(urlPatterns[i])) continue;
            throw CatalinaMessages.MESSAGES.invalidFilterMappingUrlPattern(urlPatterns[i]);
        }
    }

    @Override
    public void addInstanceListener(String listener) {
        String[] results = new String[this.instanceListeners.length + 1];
        for (int i = 0; i < this.instanceListeners.length; ++i) {
            results[i] = this.instanceListeners[i];
        }
        results[this.instanceListeners.length] = listener;
        this.instanceListeners = results;
        this.fireContainerEvent("addInstanceListener", listener);
    }

    @Override
    public void addJspMapping(String pattern) {
        String servletName = this.findServletMapping("*.jsp");
        if (servletName == null) {
            servletName = "jsp";
        }
        if (this.findChild(servletName) != null) {
            this.addServletMapping(pattern, servletName, true);
        } else {
            CatalinaLogger.CORE_LOGGER.missingJspServlet();
        }
    }

    @Override
    public void addJspPropertyGroup(JspPropertyGroup propertyGroup) {
        Collection urlPatterns = propertyGroup.getUrlPatterns();
        for (int i = 0; i < ((ArrayList)urlPatterns).size(); ++i) {
            this.addJspMapping((String)((ArrayList)urlPatterns).get(i));
            this.jspPropertyGroups.put((String)((ArrayList)urlPatterns).get(i), propertyGroup);
        }
    }

    @Override
    public void addJspTagLibrary(TagLibraryInfo tagLibraryInfo) {
        String[] listeners = tagLibraryInfo.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            this.addApplicationListener(listeners[i], true);
        }
        this.jspTagLibraries.put(tagLibraryInfo.getUri(), tagLibraryInfo);
    }

    @Override
    public void addJspTagLibrary(String uri, TagLibraryInfo tagLibraryInfo) {
        this.jspTagLibraries.put(uri, tagLibraryInfo);
    }

    @Override
    public void addLocaleEncodingMappingParameter(String locale, String encoding) {
        this.getCharsetMapper().addCharsetMappingFromDeploymentDescriptor(locale, encoding);
    }

    @Override
    public void addMimeMapping(String extension, String mimeType) {
        this.mimeMappings.put(extension, mimeType);
        this.fireContainerEvent("addMimeMapping", extension);
    }

    @Override
    public void addParameter(String name, String value) {
        if (name == null || value == null) {
            throw CatalinaMessages.MESSAGES.missingParameterNameOrValue();
        }
        if (this.parameters.get(name) != null) {
            throw CatalinaMessages.MESSAGES.duplicateContextParameters(name);
        }
        this.parameters.put(name, value);
        this.fireContainerEvent("addParameter", name);
    }

    @Override
    public void addRoleMapping(String role, String link) {
        this.roleMappings.put(role, link);
        this.fireContainerEvent("addRoleMapping", role);
    }

    @Override
    public void addSecurityRole(String role) {
        String[] results = new String[this.securityRoles.length + 1];
        for (int i = 0; i < this.securityRoles.length; ++i) {
            results[i] = this.securityRoles[i];
        }
        results[this.securityRoles.length] = role;
        this.securityRoles = results;
        this.fireContainerEvent("addSecurityRole", role);
    }

    @Override
    public void addServletMapping(String pattern, String name) {
        this.addServletMapping(pattern, name, false);
    }

    public void addServletMapping(String pattern, String name, boolean jspWildCard) {
        Wrapper wrapper = (Wrapper)this.findChild(name);
        if (this.findChild(name) == null) {
            throw CatalinaMessages.MESSAGES.unknownServletNameInMapping(name);
        }
        if (!this.validateURLPattern(pattern = this.adjustURLPattern(RequestUtil.URLDecode(pattern)))) {
            throw CatalinaMessages.MESSAGES.invalidServletMappingUrlPattern(pattern);
        }
        String name2 = this.servletMappings.get(pattern);
        if (name2 != null) {
            Wrapper wrapper2 = (Wrapper)this.findChild(name2);
            wrapper2.removeMapping(pattern);
            this.mapper.removeWrapper(pattern);
        }
        this.servletMappings.put(pattern, name);
        wrapper.addMapping(pattern);
        if (wrapper.getEnabled()) {
            this.mapper.addWrapper(pattern, wrapper, jspWildCard);
        }
        this.fireContainerEvent("addServletMapping", pattern);
    }

    @Override
    public void addTaglib(String uri, String location) {
        this.taglibs.put(uri, location);
        this.fireContainerEvent("addTaglib", uri);
    }

    @Override
    public void addWelcomeFile(String name) {
        if (this.replaceWelcomeFiles) {
            this.welcomeFiles = new String[0];
            this.setReplaceWelcomeFiles(false);
        }
        String[] results = new String[this.welcomeFiles.length + 1];
        for (int i = 0; i < this.welcomeFiles.length; ++i) {
            results[i] = this.welcomeFiles[i];
        }
        results[this.welcomeFiles.length] = name;
        this.welcomeFiles = results;
        if (this.started) {
            this.postContextAttributes();
        }
        this.fireContainerEvent("addWelcomeFile", name);
    }

    @Override
    public void addWrapperLifecycle(String listener) {
        String[] results = new String[this.wrapperLifecycles.length + 1];
        for (int i = 0; i < this.wrapperLifecycles.length; ++i) {
            results[i] = this.wrapperLifecycles[i];
        }
        results[this.wrapperLifecycles.length] = listener;
        this.wrapperLifecycles = results;
        this.fireContainerEvent("addWrapperLifecycle", listener);
    }

    @Override
    public void addWrapperListener(String listener) {
        String[] results = new String[this.wrapperListeners.length + 1];
        for (int i = 0; i < this.wrapperListeners.length; ++i) {
            results[i] = this.wrapperListeners[i];
        }
        results[this.wrapperListeners.length] = listener;
        this.wrapperListeners = results;
        this.fireContainerEvent("addWrapperListener", listener);
    }

    @Override
    public Wrapper createWrapper() {
        Object listener;
        Class<?> clazz;
        int i;
        Wrapper wrapper = null;
        if (this.wrapperClass != null) {
            try {
                wrapper = (Wrapper)this.wrapperClass.newInstance();
            }
            catch (Throwable t) {
                throw CatalinaMessages.MESSAGES.errorCreatingWrapper(t);
            }
        } else {
            wrapper = new StandardWrapper();
        }
        for (i = 0; i < this.instanceListeners.length; ++i) {
            try {
                clazz = Class.forName(this.instanceListeners[i]);
                listener = (InstanceListener)clazz.newInstance();
                wrapper.addInstanceListener((InstanceListener)listener);
                continue;
            }
            catch (Throwable t) {
                throw CatalinaMessages.MESSAGES.errorCreatingWrapper(t);
            }
        }
        for (i = 0; i < this.wrapperLifecycles.length; ++i) {
            try {
                clazz = Class.forName(this.wrapperLifecycles[i]);
                listener = (LifecycleListener)clazz.newInstance();
                if (!(wrapper instanceof Lifecycle)) continue;
                ((Lifecycle)((Object)wrapper)).addLifecycleListener((LifecycleListener)listener);
                continue;
            }
            catch (Throwable t) {
                throw CatalinaMessages.MESSAGES.errorCreatingWrapper(t);
            }
        }
        for (i = 0; i < this.wrapperListeners.length; ++i) {
            try {
                clazz = Class.forName(this.wrapperListeners[i]);
                listener = (ContainerListener)clazz.newInstance();
                wrapper.addContainerListener((ContainerListener)listener);
                continue;
            }
            catch (Throwable t) {
                throw CatalinaMessages.MESSAGES.errorCreatingWrapper(t);
            }
        }
        return wrapper;
    }

    public ApplicationFilterConfig findApplicationFilterConfig(String name) {
        return this.filterConfigs.get(name);
    }

    public ApplicationFilterConfig[] findApplicationFilterConfigs() {
        return this.filterConfigs.values().toArray(new ApplicationFilterConfig[0]);
    }

    @Override
    public String[] findApplicationListeners() {
        return this.applicationListeners;
    }

    @Override
    public ApplicationParameter[] findApplicationParameters() {
        return this.applicationParameters;
    }

    @Override
    public SecurityConstraint[] findConstraints() {
        return this.constraints;
    }

    @Override
    public ErrorPage findErrorPage(int errorCode) {
        if (errorCode == 200) {
            return this.okErrorPage;
        }
        return this.statusPages.get(errorCode);
    }

    @Override
    public ErrorPage findErrorPage(String exceptionType) {
        return this.exceptionPages.get(exceptionType);
    }

    @Override
    public ErrorPage[] findErrorPages() {
        int i;
        ErrorPage[] results1 = new ErrorPage[this.exceptionPages.size()];
        results1 = this.exceptionPages.values().toArray(results1);
        ErrorPage[] results2 = new ErrorPage[this.statusPages.size()];
        results2 = this.statusPages.values().toArray(results2);
        ErrorPage[] results = new ErrorPage[results1.length + results2.length];
        for (i = 0; i < results1.length; ++i) {
            results[i] = results1[i];
        }
        for (i = results1.length; i < results.length; ++i) {
            results[i] = results2[i - results1.length];
        }
        return results;
    }

    @Override
    public FilterDef findFilterDef(String filterName) {
        return this.filterDefs.get(filterName);
    }

    @Override
    public FilterDef[] findFilterDefs() {
        FilterDef[] results = new FilterDef[this.filterDefs.size()];
        return this.filterDefs.values().toArray(results);
    }

    @Override
    public FilterMap[] findFilterMaps() {
        return this.filterMaps;
    }

    @Override
    public String[] findInstanceListeners() {
        return this.instanceListeners;
    }

    @Override
    public JspPropertyGroup[] findJspPropertyGroups() {
        JspPropertyGroup[] results = new JspPropertyGroup[this.jspPropertyGroups.size()];
        return this.jspPropertyGroups.values().toArray(results);
    }

    public Context findMappingObject() {
        return (Context)this.getMappingObject();
    }

    @Override
    public String findMimeMapping(String extension) {
        return this.mimeMappings.get(extension);
    }

    @Override
    public String[] findMimeMappings() {
        String[] results = new String[this.mimeMappings.size()];
        return this.mimeMappings.keySet().toArray(results);
    }

    @Override
    public String findParameter(String name) {
        return this.parameters.get(name);
    }

    @Override
    public String[] findParameters() {
        String[] results = new String[this.parameters.size()];
        return this.parameters.keySet().toArray(results);
    }

    @Override
    public String findRoleMapping(String role) {
        String realRole = this.roleMappings.get(role);
        if (realRole != null) {
            return realRole;
        }
        return role;
    }

    @Override
    public boolean findSecurityRole(String role) {
        for (int i = 0; i < this.securityRoles.length; ++i) {
            if (!role.equals(this.securityRoles[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] findSecurityRoles() {
        return this.securityRoles;
    }

    @Override
    public String findServletMapping(String pattern) {
        return this.servletMappings.get(pattern);
    }

    @Override
    public String[] findServletMappings() {
        String[] results = new String[this.servletMappings.size()];
        return this.servletMappings.keySet().toArray(results);
    }

    @Override
    public int[] findStatusPages() {
        int[] results = new int[this.statusPages.size()];
        Iterator<Integer> elements = this.statusPages.keySet().iterator();
        int i = 0;
        while (elements.hasNext()) {
            results[i++] = elements.next();
        }
        return results;
    }

    @Override
    public String findTaglib(String uri) {
        return this.taglibs.get(uri);
    }

    @Override
    public String[] findTaglibs() {
        String[] results = new String[this.taglibs.size()];
        return this.taglibs.keySet().toArray(results);
    }

    @Override
    public boolean findWelcomeFile(String name) {
        for (int i = 0; i < this.welcomeFiles.length; ++i) {
            if (!name.equals(this.welcomeFiles[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] findWelcomeFiles() {
        return this.welcomeFiles;
    }

    @Override
    public String[] findWrapperLifecycles() {
        return this.wrapperLifecycles;
    }

    @Override
    public String[] findWrapperListeners() {
        return this.wrapperListeners;
    }

    @Override
    public synchronized void reload() {
        if (!this.started) {
            return;
        }
        this.setPaused(true);
        try {
            this.stop();
        }
        catch (LifecycleException e) {
            CatalinaLogger.CORE_LOGGER.errorStoppingContext(this.getName(), e);
        }
        try {
            this.start();
        }
        catch (LifecycleException e) {
            CatalinaLogger.CORE_LOGGER.errorStartingContext(this.getName(), e);
        }
        this.setPaused(false);
    }

    @Override
    public void removeApplicationListener(String listener) {
        int n = -1;
        for (int i = 0; i < this.applicationListeners.length; ++i) {
            if (!this.applicationListeners[i].equals(listener)) continue;
            n = i;
            break;
        }
        if (n < 0) {
            return;
        }
        int j = 0;
        String[] results = new String[this.applicationListeners.length - 1];
        for (int i = 0; i < this.applicationListeners.length; ++i) {
            if (i == n) continue;
            results[j++] = this.applicationListeners[i];
        }
        this.applicationListeners = results;
        this.fireContainerEvent("removeApplicationListener", listener);
    }

    @Override
    public void removeApplicationParameter(String name) {
        int n = -1;
        for (int i = 0; i < this.applicationParameters.length; ++i) {
            if (!name.equals(this.applicationParameters[i].getName())) continue;
            n = i;
            break;
        }
        if (n < 0) {
            return;
        }
        int j = 0;
        ApplicationParameter[] results = new ApplicationParameter[this.applicationParameters.length - 1];
        for (int i = 0; i < this.applicationParameters.length; ++i) {
            if (i == n) continue;
            results[j++] = this.applicationParameters[i];
        }
        this.applicationParameters = results;
        this.fireContainerEvent("removeApplicationParameter", name);
    }

    @Override
    public void removeChild(Container child) {
        if (!(child instanceof Wrapper)) {
            throw CatalinaMessages.MESSAGES.contextChildMustBeWrapper();
        }
        super.removeChild(child);
    }

    @Override
    public void removeConstraint(SecurityConstraint constraint) {
        int n = -1;
        for (int i = 0; i < this.constraints.length; ++i) {
            if (!this.constraints[i].equals(constraint)) continue;
            n = i;
            break;
        }
        if (n < 0) {
            return;
        }
        int j = 0;
        SecurityConstraint[] results = new SecurityConstraint[this.constraints.length - 1];
        for (int i = 0; i < this.constraints.length; ++i) {
            if (i == n) continue;
            results[j++] = this.constraints[i];
        }
        this.constraints = results;
        this.fireContainerEvent("removeConstraint", constraint);
    }

    @Override
    public void removeErrorPage(ErrorPage errorPage) {
        String exceptionType = errorPage.getExceptionType();
        if (exceptionType != null) {
            this.exceptionPages.remove(exceptionType);
        } else {
            if (errorPage.getErrorCode() == 200) {
                this.okErrorPage = null;
            }
            this.statusPages.remove(errorPage.getErrorCode());
        }
        this.fireContainerEvent("removeErrorPage", errorPage);
    }

    @Override
    public void removeFilterDef(FilterDef filterDef) {
        this.filterDefs.remove(filterDef.getFilterName());
        this.fireContainerEvent("removeFilterDef", filterDef);
    }

    @Override
    public void removeFilterMap(FilterMap filterMap) {
        int n = -1;
        for (int i = 0; i < this.filterMaps.length; ++i) {
            if (this.filterMaps[i] != filterMap) continue;
            n = i;
            break;
        }
        if (n < 0) {
            return;
        }
        FilterMap[] results = new FilterMap[this.filterMaps.length - 1];
        System.arraycopy(this.filterMaps, 0, results, 0, n);
        System.arraycopy(this.filterMaps, n + 1, results, n, this.filterMaps.length - 1 - n);
        if (n < this.filterMapInsertPoint) {
            --this.filterMapInsertPoint;
        }
        this.filterMaps = results;
        this.fireContainerEvent("removeFilterMap", filterMap);
    }

    @Override
    public void removeInstanceListener(String listener) {
        int n = -1;
        for (int i = 0; i < this.instanceListeners.length; ++i) {
            if (!this.instanceListeners[i].equals(listener)) continue;
            n = i;
            break;
        }
        if (n < 0) {
            return;
        }
        int j = 0;
        String[] results = new String[this.instanceListeners.length - 1];
        for (int i = 0; i < this.instanceListeners.length; ++i) {
            if (i == n) continue;
            results[j++] = this.instanceListeners[i];
        }
        this.instanceListeners = results;
        this.fireContainerEvent("removeInstanceListener", listener);
    }

    @Override
    public void removeMimeMapping(String extension) {
        this.mimeMappings.remove(extension);
        this.fireContainerEvent("removeMimeMapping", extension);
    }

    @Override
    public void removeParameter(String name) {
        this.parameters.remove(name);
        this.fireContainerEvent("removeParameter", name);
    }

    @Override
    public void removeRoleMapping(String role) {
        this.roleMappings.remove(role);
        this.fireContainerEvent("removeRoleMapping", role);
    }

    @Override
    public void removeSecurityRole(String role) {
        int n = -1;
        for (int i = 0; i < this.securityRoles.length; ++i) {
            if (!role.equals(this.securityRoles[i])) continue;
            n = i;
            break;
        }
        if (n < 0) {
            return;
        }
        int j = 0;
        String[] results = new String[this.securityRoles.length - 1];
        for (int i = 0; i < this.securityRoles.length; ++i) {
            if (i == n) continue;
            results[j++] = this.securityRoles[i];
        }
        this.securityRoles = results;
        this.fireContainerEvent("removeSecurityRole", role);
    }

    @Override
    public void removeServletMapping(String pattern) {
        String name = this.servletMappings.remove(pattern);
        Wrapper wrapper = (Wrapper)this.findChild(name);
        if (wrapper != null) {
            wrapper.removeMapping(pattern);
        }
        this.mapper.removeWrapper(pattern);
        this.fireContainerEvent("removeServletMapping", pattern);
    }

    @Override
    public void removeTaglib(String uri) {
        this.taglibs.remove(uri);
        this.fireContainerEvent("removeTaglib", uri);
    }

    @Override
    public void removeWelcomeFile(String name) {
        int n = -1;
        for (int i = 0; i < this.welcomeFiles.length; ++i) {
            if (!this.welcomeFiles[i].equals(name)) continue;
            n = i;
            break;
        }
        if (n < 0) {
            return;
        }
        int j = 0;
        String[] results = new String[this.welcomeFiles.length - 1];
        for (int i = 0; i < this.welcomeFiles.length; ++i) {
            if (i == n) continue;
            results[j++] = this.welcomeFiles[i];
        }
        this.welcomeFiles = results;
        if (this.started) {
            this.postContextAttributes();
        }
        this.fireContainerEvent("removeWelcomeFile", name);
    }

    @Override
    public void removeWrapperLifecycle(String listener) {
        int n = -1;
        for (int i = 0; i < this.wrapperLifecycles.length; ++i) {
            if (!this.wrapperLifecycles[i].equals(listener)) continue;
            n = i;
            break;
        }
        if (n < 0) {
            return;
        }
        int j = 0;
        String[] results = new String[this.wrapperLifecycles.length - 1];
        for (int i = 0; i < this.wrapperLifecycles.length; ++i) {
            if (i == n) continue;
            results[j++] = this.wrapperLifecycles[i];
        }
        this.wrapperLifecycles = results;
        this.fireContainerEvent("removeWrapperLifecycle", listener);
    }

    @Override
    public void removeWrapperListener(String listener) {
        int n = -1;
        for (int i = 0; i < this.wrapperListeners.length; ++i) {
            if (!this.wrapperListeners[i].equals(listener)) continue;
            n = i;
            break;
        }
        if (n < 0) {
            return;
        }
        int j = 0;
        String[] results = new String[this.wrapperListeners.length - 1];
        for (int i = 0; i < this.wrapperListeners.length; ++i) {
            if (i == n) continue;
            results[j++] = this.wrapperListeners[i];
        }
        this.wrapperListeners = results;
        this.fireContainerEvent("removeWrapperListener", listener);
    }

    public long getProcessingTime() {
        long result = 0L;
        Container[] children = this.findChildren();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                result += ((StandardWrapper)children[i]).getProcessingTime();
            }
        }
        return result;
    }

    protected boolean filterStart() {
        boolean ok = true;
        for (ApplicationFilterConfig filterConfig : this.filterConfigs.values()) {
            try {
                filterConfig.getFilter();
            }
            catch (Throwable t) {
                this.getLogger().error((Object)CatalinaMessages.MESSAGES.errorStartingFilter(filterConfig.getFilterName()), t);
                ok = false;
            }
        }
        for (String name : this.filterDefs.keySet()) {
            ApplicationFilterConfig filterConfig = this.filterConfigs.get(name);
            if (filterConfig != null) continue;
            CatalinaLogger.CORE_LOGGER.startingFilter(name);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(" Starting filter '" + name + "'"));
            }
            try {
                filterConfig = new ApplicationFilterConfig(this, this.filterDefs.get(name));
                filterConfig.getFilter();
                this.filterConfigs.put(name, filterConfig);
            }
            catch (Throwable t) {
                this.getLogger().error((Object)CatalinaMessages.MESSAGES.errorStartingFilter(name), t);
                ok = false;
            }
        }
        return ok;
    }

    protected boolean filterStop() {
        for (String name : this.filterConfigs.keySet()) {
            CatalinaLogger.CORE_LOGGER.stoppingFilter(name);
            ApplicationFilterConfig filterConfig = this.filterConfigs.get(name);
            filterConfig.release();
        }
        this.filterConfigs.clear();
        return true;
    }

    public FilterConfig findFilterConfig(String name) {
        return this.filterConfigs.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contextListenerStart() {
        int i;
        String[] listeners = this.findApplicationListeners();
        EventListener[] listenerInstances = this.applicationListenerInstances;
        EventListener[] results = new EventListener[listeners.length + listenerInstances.length];
        boolean ok = true;
        for (i = 0; i < listeners.length; ++i) {
            try {
                results[i] = (EventListener)this.instanceManager.newInstance(listeners[i]);
                continue;
            }
            catch (Throwable t) {
                this.getLogger().error((Object)CatalinaMessages.MESSAGES.errorInstatiatingApplicationListener(listeners[i]), t);
                ok = false;
            }
        }
        for (i = 0; i < listenerInstances.length; ++i) {
            results[i + listeners.length] = listenerInstances[i];
        }
        this.applicationListenerInstances = new EventListener[0];
        if (!ok) {
            this.getLogger().error((Object)CatalinaMessages.MESSAGES.skippingApplicationListener());
            return false;
        }
        ArrayList<EventListener> otherListeners = new ArrayList<EventListener>();
        ArrayList<EventListener> contextLifecycleListeners = new ArrayList<EventListener>();
        for (int i2 = 0; i2 < results.length; ++i2) {
            if (results[i2] instanceof ServletContextListener) {
                contextLifecycleListeners.add(results[i2]);
            }
            otherListeners.add(results[i2]);
        }
        this.listenersInstances = otherListeners.toArray();
        this.setApplicationLifecycleListeners(contextLifecycleListeners.toArray());
        Object[] instances = this.getApplicationLifecycleListeners();
        if (instances == null || instances.length == 0) {
            return ok;
        }
        ServletContextEvent event = new ServletContextEvent(this.getServletContext());
        for (int i3 = 0; i3 < instances.length; ++i3) {
            if (instances[i3] == null || !(instances[i3] instanceof ServletContextListener)) continue;
            ServletContextListener listener = (ServletContextListener)instances[i3];
            try {
                this.context.setRestricted(this.isRestricted(listener));
                this.fireContainerEvent("beforeContextInitialized", listener);
                listener.contextInitialized(event);
                this.fireContainerEvent("afterContextInitialized", listener);
                continue;
            }
            catch (Throwable t) {
                this.fireContainerEvent("afterContextInitialized", listener);
                this.getLogger().error((Object)CatalinaMessages.MESSAGES.errorSendingContextInitializedEvent(instances[i3].getClass().getName()), t);
                ok = false;
                continue;
            }
            finally {
                this.context.setRestricted(false);
            }
        }
        return ok;
    }

    public boolean listenerStart() {
        int i;
        Object[] listeners = this.listenersInstances;
        EventListener[] listenerInstances = this.applicationListenerInstances;
        EventListener[] results = new EventListener[listeners.length + listenerInstances.length];
        boolean ok = true;
        for (i = 0; i < listeners.length; ++i) {
            try {
                results[i] = (EventListener)listeners[i];
                continue;
            }
            catch (Throwable t) {
                this.getLogger().error((Object)CatalinaMessages.MESSAGES.errorInstatiatingApplicationListener(listeners[i].getClass().getName()), t);
                ok = false;
            }
        }
        for (i = 0; i < listenerInstances.length; ++i) {
            results[i + listeners.length] = listenerInstances[i];
        }
        if (!ok) {
            this.getLogger().error((Object)CatalinaMessages.MESSAGES.skippingApplicationListener());
            return false;
        }
        this.listenersInstances = results;
        ArrayList<EventListener> eventListeners = new ArrayList<EventListener>();
        ArrayList<EventListener> sessionLifecycleListeners = new ArrayList<EventListener>();
        for (int i2 = 0; i2 < results.length; ++i2) {
            if (results[i2] instanceof ServletContextAttributeListener || results[i2] instanceof ServletRequestAttributeListener || results[i2] instanceof ServletRequestListener || results[i2] instanceof HttpSessionAttributeListener) {
                eventListeners.add(results[i2]);
            }
            if (!(results[i2] instanceof HttpSessionListener)) continue;
            sessionLifecycleListeners.add(results[i2]);
        }
        this.setApplicationEventListeners(eventListeners.toArray());
        this.setApplicationSessionLifecycleListeners(sessionLifecycleListeners.toArray());
        return ok;
    }

    public boolean listenerStop() {
        boolean ok = true;
        Object[] listeners = this.getApplicationLifecycleListeners();
        if (listeners != null && listeners.length > 0) {
            ServletContextEvent event = new ServletContextEvent(this.getServletContext());
            for (int i = listeners.length - 1; i >= 0; --i) {
                if (listeners[i] == null || !(listeners[i] instanceof ServletContextListener)) continue;
                ServletContextListener listener = (ServletContextListener)listeners[i];
                try {
                    this.fireContainerEvent("beforeContextDestroyed", listener);
                    listener.contextDestroyed(event);
                    this.fireContainerEvent("afterContextDestroyed", listener);
                    continue;
                }
                catch (Throwable t) {
                    this.fireContainerEvent("afterContextDestroyed", listener);
                    this.getLogger().error((Object)CatalinaMessages.MESSAGES.errorSendingContextDestroyedEvent(listeners[i].getClass().getName()), t);
                    ok = false;
                }
            }
        }
        if ((listeners = this.listenersInstances) != null && listeners.length > 0) {
            for (int i = listeners.length - 1; i >= 0; --i) {
                if (listeners[i] == null) continue;
                try {
                    this.getInstanceManager().destroyInstance(listeners[i]);
                    continue;
                }
                catch (Throwable t) {
                    this.getLogger().error((Object)CatalinaMessages.MESSAGES.errorDestroyingApplicationListener(listeners[i].getClass().getName()), t);
                    ok = false;
                }
            }
        }
        this.setApplicationEventListeners(null);
        this.setApplicationLifecycleListeners(null);
        this.setApplicationSessionLifecycleListeners(null);
        this.listenersInstances = null;
        return ok;
    }

    public boolean resourcesStart() {
        boolean ok = true;
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        if (this.getParent() != null) {
            env.put("host", this.getParent().getName());
        }
        env.put("context", this.getName());
        try {
            ProxyDirContext proxyDirContext = new ProxyDirContext(env, this.webappResources);
            if (this.webappResources instanceof FileDirContext) {
                this.filesystemBased = true;
                ((FileDirContext)this.webappResources).setCaseSensitive(this.isCaseSensitive());
                ((FileDirContext)this.webappResources).setAllowLinking(this.isAllowLinking());
            }
            if (this.webappResources instanceof BaseDirContext) {
                ((BaseDirContext)this.webappResources).setDocBase(this.getBasePath());
                ((BaseDirContext)this.webappResources).setCached(this.isCachingAllowed());
                ((BaseDirContext)this.webappResources).setCacheTTL(this.getCacheTTL());
                ((BaseDirContext)this.webappResources).setCacheMaxSize(this.getCacheMaxSize());
                ((BaseDirContext)this.webappResources).allocate();
            }
            if (Constants.ENABLE_MODELER && this.isCachingAllowed()) {
                ObjectName resourcesName = new ObjectName(this.getDomain() + ":type=Cache,host=" + this.getHostname() + ",path=" + ("".equals(this.getPath()) ? "/" : this.getPath()));
                Registry.getRegistry(null, null).registerComponent((Object)proxyDirContext.getCache(), resourcesName, null);
            }
            this.resources = proxyDirContext;
        }
        catch (Throwable t) {
            CatalinaLogger.CORE_LOGGER.errorStartingResources(t);
            ok = false;
        }
        return ok;
    }

    public boolean resourcesStop() {
        boolean ok = true;
        try {
            if (this.resources != null) {
                if (this.resources instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.resources)).stop();
                }
                if (this.webappResources instanceof BaseDirContext) {
                    ((BaseDirContext)this.webappResources).release();
                }
                if (Constants.ENABLE_MODELER && this.isCachingAllowed()) {
                    ObjectName resourcesName = new ObjectName(this.getDomain() + ":type=Cache,host=" + this.getHostname() + ",path=" + ("".equals(this.getPath()) ? "/" : this.getPath()));
                    Registry.getRegistry(null, null).unregisterComponent(resourcesName);
                }
            }
        }
        catch (Throwable t) {
            CatalinaLogger.CORE_LOGGER.errorStoppingResources(t);
            ok = false;
        }
        this.resources = null;
        return ok;
    }

    public void loadOnStartup(Container[] children) {
        TreeMap<Integer, ArrayList<Wrapper>> map = new TreeMap<Integer, ArrayList<Wrapper>>();
        for (int i = 0; i < children.length; ++i) {
            Wrapper wrapper = (Wrapper)children[i];
            int loadOnStartup = wrapper.getLoadOnStartup();
            if (loadOnStartup < 0) continue;
            Integer key = loadOnStartup;
            ArrayList<Wrapper> list = (ArrayList<Wrapper>)map.get(key);
            if (list == null) {
                list = new ArrayList<Wrapper>();
                map.put(key, list);
            }
            list.add(wrapper);
        }
        for (ArrayList list : map.values()) {
            for (Wrapper wrapper : list) {
                try {
                    wrapper.load();
                }
                catch (ServletException e) {
                    this.getLogger().error((Object)CatalinaMessages.MESSAGES.errorLoadingServlet(wrapper.getName()), StandardWrapper.getRootCause(e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() throws LifecycleException {
        if (this.started) {
            CatalinaLogger.CORE_LOGGER.containerAlreadyStarted(this.logName());
            return;
        }
        if (!this.initialized) {
            try {
                this.init();
            }
            catch (Exception ex) {
                throw new LifecycleException(CatalinaMessages.MESSAGES.errorInitializingContext(), ex);
            }
        }
        if (Constants.ENABLE_MODELER) {
            this.preRegisterJMX();
            if (this.oname != null && Registry.getRegistry(null, null).getMBeanServer().isRegistered(this.oname)) {
                Registry.getRegistry(null, null).unregisterComponent(this.oname);
            }
        }
        this.lifecycle.fireLifecycleEvent("before_start", null);
        this.setAvailable(false);
        this.setStarting(true);
        this.setConfigured(false);
        boolean ok = true;
        if (this.webappResources == null) {
            try {
                if (this.docBase != null && this.docBase.endsWith(".war") && !new File(this.getBasePath()).isDirectory()) {
                    this.setResources(new WARDirContext());
                } else {
                    this.setResources(new FileDirContext());
                }
            }
            catch (IllegalArgumentException e) {
                CatalinaLogger.CORE_LOGGER.errorInitializingResources(e);
                ok = false;
            }
        }
        if (ok && !this.resourcesStart()) {
            ok = false;
        }
        this.getCharsetMapper();
        this.postWorkDirectory();
        ClassLoader oldCCL = this.bindThread();
        try {
            if (ok) {
                this.started = true;
                if (this.loader != null && this.loader instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.loader)).start();
                }
                if (this.loader != null && this.loader.getClassLoader() != null) {
                    DirContextURLStreamHandler.bind(this.loader.getClassLoader(), this.getResources());
                }
                this.unbindThread(oldCCL);
                oldCCL = this.bindThread();
                this.logger = null;
                this.getLogger();
                if (this.logger != null && this.logger instanceof Lifecycle) {
                    ((Lifecycle)this.logger).start();
                }
                if (this.cluster != null && this.cluster instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.cluster)).start();
                }
                if (this.realm != null && this.realm instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.realm)).start();
                }
                if (this.resources != null && this.resources instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.resources)).start();
                }
                Container[] children = this.findChildren();
                for (int i = 0; i < children.length; ++i) {
                    if (!(children[i] instanceof Lifecycle)) continue;
                    ((Lifecycle)((Object)children[i])).start();
                }
                if (this.pipeline instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.pipeline)).start();
                }
                this.lifecycle.fireLifecycleEvent("start", null);
                Manager contextManager = null;
                if (this.manager == null) {
                    contextManager = this.getCluster() != null && this.distributable ? this.getCluster().createManager(this.getName()) : new StandardManager();
                }
                if (contextManager != null) {
                    this.setManager(contextManager);
                }
                if (this.manager != null) {
                    this.manager.setMaxInactiveInterval(this.sessionTimeout * 60);
                }
                if (this.manager != null && this.getCluster() != null && this.distributable) {
                    this.getCluster().registerManager(this.manager);
                }
            }
        }
        catch (Throwable t) {
            ok = false;
            CatalinaLogger.CORE_LOGGER.errorStartingContext(this.getName(), t);
        }
        finally {
            this.unbindThread(oldCCL);
        }
        if (!this.getConfigured()) {
            ok = false;
        }
        oldCCL = this.bindThread();
        try {
            if (ok) {
                this.postContextAttributes();
            }
            if (ok) {
                this.lifecycle.fireLifecycleEvent("after_start", null);
            }
            if (ok && !this.contextListenerStart()) {
                ok = false;
            }
            if (ok && this.manager != null && this.manager instanceof Lifecycle) {
                ok = false;
                ((Lifecycle)((Object)this.getManager())).start();
                ok = true;
            }
            if (ok && !this.filterStart()) {
                ok = false;
            }
            if (ok) {
                this.loadOnStartup(this.findChildren());
            }
            if (ok && !this.listenerStart()) {
                ok = false;
            }
            if (ok) {
                this.lifecycle.fireLifecycleEvent("complete-config", null);
            }
            if (!this.getConfigured()) {
                ok = false;
            }
            if (ok) {
                super.threadStart();
            }
        }
        catch (Throwable t) {
            ok = false;
            CatalinaLogger.CORE_LOGGER.errorStartingContext(this.getName(), t);
        }
        finally {
            this.unbindThread(oldCCL);
        }
        this.mapper.setContext(this.getPath(), this.welcomeFiles, this.resources);
        if (ok) {
            this.setAvailable(true);
        } else {
            CatalinaLogger.CORE_LOGGER.errorStartingContextWillStop(this.getName());
            try {
                this.stop();
            }
            catch (Throwable t) {
                CatalinaLogger.CORE_LOGGER.errorStartingContextCleanup(this.getName(), t);
            }
            this.setAvailable(false);
        }
        this.setStarting(false);
        if (Constants.ENABLE_MODELER) {
            this.registerJMX();
        }
        this.startTime = System.currentTimeMillis();
        if (ok && this.getObjectName() != null) {
            Notification notification = new Notification("j2ee.state.running", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        if (!ok && this.started) {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() throws LifecycleException {
        if (!this.started) {
            CatalinaLogger.CORE_LOGGER.containerNotStarted(this.logName());
            return;
        }
        this.lifecycle.fireLifecycleEvent("before_stop", null);
        if (this.getObjectName() != null) {
            Notification notification = new Notification("j2ee.state.stopping", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        this.setAvailable(false);
        ClassLoader oldCCL = this.bindThread();
        try {
            Container[] children = this.findChildren();
            for (int i = 0; i < children.length; ++i) {
                if (!(children[i] instanceof Lifecycle)) continue;
                ((Lifecycle)((Object)children[i])).stop();
            }
            this.filterStop();
            super.threadStop();
            if (this.manager != null && this.manager instanceof Lifecycle) {
                ((Lifecycle)((Object)this.manager)).stop();
            }
            this.listenerStop();
            this.setCharsetMapper(null);
            this.lifecycle.fireLifecycleEvent("stop", null);
            this.started = false;
            if (this.pipeline instanceof Lifecycle) {
                ((Lifecycle)((Object)this.pipeline)).stop();
            }
            if (this.context != null) {
                this.context.clearAttributes();
            }
            this.resourcesStop();
            if (this.realm != null && this.realm instanceof Lifecycle) {
                ((Lifecycle)((Object)this.realm)).stop();
            }
            if (this.cluster != null && this.cluster instanceof Lifecycle) {
                ((Lifecycle)((Object)this.cluster)).stop();
            }
            if (this.logger != null && this.logger instanceof Lifecycle) {
                ((Lifecycle)this.logger).stop();
            }
            if (this.loader != null && this.loader.getClassLoader() != null) {
                DirContextURLStreamHandler.unbind(this.loader.getClassLoader());
            }
            if (this.loader != null && this.loader instanceof Lifecycle) {
                ((Lifecycle)((Object)this.loader)).stop();
            }
        }
        finally {
            this.unbindThread(oldCCL);
        }
        if (this.getObjectName() != null) {
            Notification notification = new Notification("j2ee.state.stopped", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        this.context = null;
        try {
            this.resetContext();
        }
        catch (Exception ex) {
            CatalinaLogger.CORE_LOGGER.errorResettingContext(this.getName(), ex);
        }
        this.lifecycle.fireLifecycleEvent("after_stop", null);
    }

    @Override
    public synchronized void destroy() throws Exception {
        if (this.oname != null) {
            Notification notification = new Notification("j2ee.object.deleted", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        super.destroy();
        this.lifecycle.fireLifecycleEvent("destroy", null);
        this.instanceListeners = new String[0];
    }

    protected void resetContext() throws Exception, MBeanRegistrationException {
        this.children = new HashMap();
        this.startupTime = 0L;
        this.startTime = 0L;
        this.tldScanTime = 0L;
        this.distributable = false;
        this.applicationListeners = new String[0];
        this.applicationEventListenersInstances = null;
        this.applicationLifecycleListenersInstances = null;
        this.applicationSessionLifecycleListenersInstances = null;
        this.listenersInstances = null;
        this.instanceManager = null;
        this.authenticator = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getParent() != null) {
            sb.append(this.getParent().toString());
            sb.append(".");
        }
        sb.append("StandardContext[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    protected String adjustURLPattern(String urlPattern) {
        if (urlPattern == null) {
            return urlPattern;
        }
        if (urlPattern.startsWith("/") || urlPattern.startsWith("*.")) {
            return urlPattern;
        }
        if (!this.isServlet22()) {
            return urlPattern;
        }
        CatalinaLogger.CORE_LOGGER.urlPatternStartsWithSlash(urlPattern);
        return "/" + urlPattern;
    }

    protected boolean isRestricted(Object listener) {
        return this.restrictedApplicationListeners.contains(listener.getClass().getName());
    }

    protected boolean isServlet22() {
        if (this.publicId == null) {
            return false;
        }
        return this.publicId.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN");
    }

    protected File engineBase() {
        String base = System.getProperty("catalina.base");
        if (base == null) {
            StandardEngine eng = (StandardEngine)this.getParent().getParent();
            base = eng.getBaseDir();
        }
        return new File(base);
    }

    protected File workBase() {
        String base = System.getProperty("catalina.work");
        if (base == null) {
            return this.engineBase();
        }
        return new File(base);
    }

    protected ClassLoader bindThread() {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        if (this.getLoader() != null && this.getLoader().getClassLoader() != null) {
            Thread.currentThread().setContextClassLoader(this.getLoader().getClassLoader());
        }
        this.threadBindingListener.bind();
        this.lifecycle.fireLifecycleEvent("bind-thread", null);
        return oldContextClassLoader;
    }

    protected void unbindThread(ClassLoader oldContextClassLoader) {
        this.lifecycle.fireLifecycleEvent("unbind-thread", null);
        this.threadBindingListener.unbind();
        Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        oldContextClassLoader = null;
    }

    protected String getBasePath() {
        Container container;
        String docBase = null;
        for (container = this; container != null && !(container instanceof Host); container = container.getParent()) {
        }
        File file = new File(this.getDocBase());
        if (!file.isAbsolute()) {
            if (container == null) {
                docBase = new File(this.engineBase(), this.getDocBase()).getPath();
            } else {
                String appBase = ((Host)container).getAppBase();
                file = new File(appBase);
                if (!file.isAbsolute()) {
                    file = new File(this.engineBase(), appBase);
                }
                docBase = new File(file, this.getDocBase()).getPath();
            }
        } else {
            docBase = file.getPath();
        }
        return docBase;
    }

    protected String getAppBase() {
        Container container;
        String appBase = null;
        for (container = this; container != null && !(container instanceof Host); container = container.getParent()) {
        }
        if (container != null) {
            appBase = ((Host)container).getAppBase();
        }
        return appBase;
    }

    public File getConfigBase() {
        File configBase = new File(System.getProperty("catalina.base"), "conf");
        if (!configBase.exists()) {
            return null;
        }
        StandardContext host = null;
        Container engine = null;
        for (Container container = this; container != null; container = container.getParent()) {
            if (container instanceof Host) {
                host = container;
            }
            if (!(container instanceof Engine)) continue;
            engine = container;
        }
        if (engine != null) {
            configBase = new File(configBase, engine.getName());
        }
        if (host != null) {
            configBase = new File(configBase, host.getName());
        }
        return configBase;
    }

    protected String getDefaultConfigFile() {
        String basename = null;
        String path = this.getPath();
        basename = path.equals("") ? "ROOT" : path.substring(1).replace('/', '#');
        return basename + ".xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean copy(File src, File dest) {
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            int len;
            is = new FileInputStream(src);
            os = new FileOutputStream(dest);
            byte[] buf = new byte[4096];
            while ((len = is.read(buf)) >= 0) {
                os.write(buf, 0, len);
            }
            is.close();
            os.close();
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {}
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception e) {}
        }
        return true;
    }

    public boolean getPaused() {
        return this.paused;
    }

    protected void postContextAttributes() {
        ServletContext context = this.getServletContext();
        context.setAttribute("org.apache.catalina.SERVLET_VERSION", (Object)this.version);
        context.setAttribute("org.apache.catalina.resources", (Object)this.getResources());
        context.setAttribute("org.apache.catalina.WELCOME_FILES", (Object)this.welcomeFiles);
        context.setAttribute("org.apache.catalina.JSP_PROPERTY_GROUPS", this.jspPropertyGroups);
        context.setAttribute("org.apache.catalina.JSP_TAG_LIBRARIES", this.jspTagLibraries);
        context.setAttribute(InstanceManager.class.getName(), (Object)this.instanceManager);
    }

    public String getHostname() {
        Container parentHost = this.getParent();
        if (parentHost != null) {
            this.hostName = parentHost.getName();
        }
        if (this.hostName == null || this.hostName.length() < 1) {
            this.hostName = "_";
        }
        return this.hostName;
    }

    protected void postWorkDirectory() {
        String workDir = this.getWorkDir();
        if (workDir == null || workDir.length() == 0) {
            String temp;
            String hostName = null;
            String engineName = null;
            String hostWorkDir = null;
            Container parentHost = this.getParent();
            if (parentHost != null) {
                Container parentEngine;
                hostName = parentHost.getName();
                if (parentHost instanceof StandardHost) {
                    hostWorkDir = ((StandardHost)parentHost).getWorkDir();
                }
                if ((parentEngine = parentHost.getParent()) != null) {
                    engineName = parentEngine.getName();
                }
            }
            if (hostName == null || hostName.length() < 1) {
                hostName = "_";
            }
            if (engineName == null || engineName.length() < 1) {
                engineName = "_";
            }
            if ((temp = this.getPath()).startsWith("/")) {
                temp = temp.substring(1);
            }
            temp = temp.replace('/', '_');
            if ((temp = temp.replace('\\', '_')).length() < 1) {
                temp = "_";
            }
            workDir = hostWorkDir != null ? hostWorkDir + File.separator + temp : "work" + File.separator + engineName + File.separator + hostName + File.separator + temp;
            this.workDir = workDir;
        }
        File dir = new File(this.getWorkPath());
        dir.mkdirs();
        this.getServletContext();
        this.context.setAttribute("javax.servlet.context.tempdir", dir);
        this.context.setAttributeReadOnly("javax.servlet.context.tempdir");
    }

    protected void setPaused(boolean paused) {
        this.paused = paused;
    }

    protected boolean validateURLPattern(String urlPattern) {
        if (urlPattern == null) {
            return false;
        }
        if (urlPattern.indexOf(10) >= 0 || urlPattern.indexOf(13) >= 0) {
            return false;
        }
        if (urlPattern.equals("")) {
            return true;
        }
        if (urlPattern.startsWith("*.")) {
            if (urlPattern.indexOf(47) < 0) {
                this.checkUnusualURLPattern(urlPattern);
                return true;
            }
            return false;
        }
        if (urlPattern.startsWith("/") && urlPattern.indexOf("*.") < 0) {
            this.checkUnusualURLPattern(urlPattern);
            return true;
        }
        return false;
    }

    protected void checkUnusualURLPattern(String urlPattern) {
        if (CatalinaLogger.CORE_LOGGER.isInfoEnabled() && urlPattern.endsWith("*") && (urlPattern.length() < 2 || urlPattern.charAt(urlPattern.length() - 2) != '/')) {
            CatalinaLogger.CORE_LOGGER.suspiciousUrlPattern(this.getName(), urlPattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDeploymentDescriptor() {
        InputStream stream = null;
        ServletContext servletContext = this.getServletContext();
        if (servletContext != null) {
            stream = servletContext.getResourceAsStream("/WEB-INF/web.xml");
        }
        if (stream == null) {
            return "";
        }
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            br = new BufferedReader(new InputStreamReader(stream));
            String strRead = "";
            while (strRead != null) {
                sb.append(strRead);
                strRead = br.readLine();
            }
        }
        catch (IOException e) {
            String string = "";
            return string;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
        return sb.toString();
    }

    public String[] getServlets() {
        String[] result = null;
        Container[] children = this.findChildren();
        if (children != null) {
            result = new String[children.length];
            for (int i = 0; i < children.length; ++i) {
                result[i] = ((StandardWrapper)children[i]).getObjectName();
            }
        }
        return result;
    }

    @Override
    public ObjectName createObjectName(String hostDomain, ObjectName parentName) throws MalformedObjectNameException {
        StandardHost hst = (StandardHost)this.getParent();
        String pathName = this.getName();
        String hostName = this.getParent().getName();
        String name = "//" + (hostName == null ? "DEFAULT" : hostName) + ("".equals(pathName) ? "/" : pathName);
        String suffix = ",J2EEApplication=" + this.getJ2EEApplication() + ",J2EEServer=" + this.getJ2EEServer();
        String onameStr = "j2eeType=WebModule,name=" + name + suffix;
        if (this.getDomain() == null) {
            this.domain = hst.getDomain();
        }
        ObjectName oname = new ObjectName(this.getDomain() + ":" + onameStr);
        return oname;
    }

    protected void preRegisterJMX() {
        try {
            StandardHost host = (StandardHost)this.getParent();
            if (this.oname == null || this.oname.getKeyProperty("j2eeType") == null) {
                this.controller = this.oname = this.createObjectName(host.getDomain(), host.getJmxName());
            }
        }
        catch (Exception ex) {
            CatalinaLogger.CORE_LOGGER.contextObjectNameCreationFailed(this.getName(), ex);
        }
    }

    protected void registerJMX() {
        try {
            if (!Registry.getRegistry(null, null).getMBeanServer().isRegistered(this.oname)) {
                this.controller = this.oname;
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
                if (this.getObjectName() != null) {
                    Notification notification = new Notification("j2ee.object.created", this.getObjectName(), this.sequenceNumber++);
                    this.broadcaster.sendNotification(notification);
                }
            }
            Container[] children = this.findChildren();
            for (int i = 0; children != null && i < children.length; ++i) {
                ((StandardWrapper)children[i]).registerJMX(this);
            }
        }
        catch (Exception ex) {
            CatalinaLogger.CORE_LOGGER.contextJmxRegistrationFailed(this.getName(), ex);
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (this.oname != null) {
            return name;
        }
        ObjectName result = super.preRegister(server, name);
        return name;
    }

    @Override
    public void preDeregister() throws Exception {
        if (this.started) {
            try {
                this.stop();
            }
            catch (Exception ex) {
                CatalinaLogger.CORE_LOGGER.errorStoppingContext(this.getName(), ex);
            }
        }
    }

    @Override
    public synchronized void init() throws Exception {
        super.init();
        this.lifecycle.fireLifecycleEvent("init", null);
        if (this.getObjectName() != null) {
            Notification notification = new Notification("j2ee.state.starting", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public ObjectName getParentName() throws MalformedObjectNameException {
        String path = this.oname.getKeyProperty("name");
        if (path == null) {
            CatalinaLogger.CORE_LOGGER.cannotFindContextJmxParentName(this.getName());
            return null;
        }
        if (!path.startsWith("//")) {
            CatalinaLogger.CORE_LOGGER.cannotFindContextJmxParentName(this.getName());
            return null;
        }
        path = path.substring(2);
        int delim = path.indexOf("/");
        this.hostName = "localhost";
        if (delim > 0) {
            this.hostName = path.substring(0, delim);
            if ((path = path.substring(delim)).equals("/")) {
                this.setName("");
            } else {
                this.setName(path);
            }
        } else {
            this.setName(path);
        }
        String parentDomain = this.getEngineName();
        if (parentDomain == null) {
            parentDomain = this.domain;
        }
        ObjectName parentName = new ObjectName(parentDomain + ":" + "type=Host,host=" + this.hostName);
        return parentName;
    }

    public void create() throws Exception {
        this.init();
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object object) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener, filter, object);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.notificationInfo == null) {
            this.notificationInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"j2ee.object.created"}, Notification.class.getName(), "web application is created"), new MBeanNotificationInfo(new String[]{"j2ee.state.starting"}, Notification.class.getName(), "change web application is starting"), new MBeanNotificationInfo(new String[]{"j2ee.state.running"}, Notification.class.getName(), "web application is running"), new MBeanNotificationInfo(new String[]{"j2ee.state.stopping"}, Notification.class.getName(), "web application start to stopped"), new MBeanNotificationInfo(new String[]{"j2ee.object.stopped"}, Notification.class.getName(), "web application is stopped"), new MBeanNotificationInfo(new String[]{"j2ee.object.deleted"}, Notification.class.getName(), "web application is deleted")};
        }
        return this.notificationInfo;
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object object) throws IllegalArgumentException {
        this.broadcaster.addNotificationListener(listener, filter, object);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener);
    }

    public DirContext getStaticResources() {
        return this.getResources();
    }

    public DirContext findStaticResources() {
        return this.getResources();
    }

    public String[] getWelcomeFiles() {
        return this.findWelcomeFiles();
    }

    public boolean isStateManageable() {
        return true;
    }

    public void startRecursive() throws LifecycleException {
        this.start();
    }

    public int getState() {
        if (this.started) {
            return 1;
        }
        if (this.initialized) {
            return 0;
        }
        if (!this.available) {
            return 4;
        }
        return 3;
    }

    public String getServer() {
        return this.server;
    }

    public String setServer(String server) {
        this.server = server;
        return this.server;
    }

    public String[] getJavaVMs() {
        return this.javaVMs;
    }

    public String[] setJavaVMs(String[] javaVMs) {
        this.javaVMs = javaVMs;
        return javaVMs;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean isEventProvider() {
        return false;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    static {
        urlEncoder.addSafeCharacter('~');
        urlEncoder.addSafeCharacter('-');
        urlEncoder.addSafeCharacter('_');
        urlEncoder.addSafeCharacter('.');
        urlEncoder.addSafeCharacter('*');
        urlEncoder.addSafeCharacter('/');
        DEFAULT_NAMING_LISTENER = new ThreadBindingListener(){

            @Override
            public void bind() {
            }

            @Override
            public void unbind() {
            }
        };
    }
}

