/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.Executor;
import org.apache.tomcat.util.Constants;
import org.apache.tomcat.util.net.ServerSocketFactory;
import org.apache.tomcat.util.net.SocketStatus;
import org.jboss.web.CoyoteLogger;

public class JIoEndpoint {
    protected WorkerStack workers = null;
    protected volatile boolean running = false;
    protected volatile boolean paused = false;
    protected boolean initialized = false;
    protected int curThreadsBusy = 0;
    protected int curThreads = 0;
    protected int sequence = 0;
    protected ServerSocket serverSocket = null;
    protected int acceptorThreadCount = 0;
    protected Executor executor = null;
    protected int maxThreads = Constants.LOW_MEMORY ? 64 : (org.apache.tomcat.util.net.Constants.MAX_THREADS == -1 ? 512 * Runtime.getRuntime().availableProcessors() : org.apache.tomcat.util.net.Constants.MAX_THREADS);
    protected int threadPriority = 5;
    protected int pollerSize = Constants.LOW_MEMORY ? 128 : 32768;
    protected int keepAliveTimeout = -1;
    protected int port;
    protected InetAddress address;
    protected Handler handler = null;
    protected int backlog = 100;
    protected boolean tcpNoDelay = false;
    protected int soLinger = 100;
    protected int soTimeout = -1;
    protected boolean daemon = true;
    protected String name = "TP";
    protected ServerSocketFactory serverSocketFactory = null;
    protected Poller eventPoller = null;

    public void setAcceptorThreadCount(int acceptorThreadCount) {
        this.acceptorThreadCount = acceptorThreadCount;
    }

    public int getAcceptorThreadCount() {
        return this.acceptorThreadCount;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public void setPollerSize(int pollerSize) {
        this.pollerSize = pollerSize;
    }

    public int getPollerSize() {
        return this.pollerSize;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void setBacklog(int backlog) {
        if (backlog > 0) {
            this.backlog = backlog;
        }
    }

    public int getBacklog() {
        return this.backlog;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public void setSoLinger(int soLinger) {
        this.soLinger = soLinger;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public void setDaemon(boolean b) {
        this.daemon = b;
    }

    public boolean getDaemon() {
        return this.daemon;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setServerSocketFactory(ServerSocketFactory factory) {
        this.serverSocketFactory = factory;
    }

    public ServerSocketFactory getServerSocketFactory() {
        return this.serverSocketFactory;
    }

    public Poller getEventPoller() {
        return this.eventPoller;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public int getCurrentThreadCount() {
        return this.curThreads;
    }

    public int getCurrentThreadsBusy() {
        return this.workers != null ? this.curThreads - this.workers.size() : 0;
    }

    public void init() throws Exception {
        if (this.initialized) {
            return;
        }
        if (this.acceptorThreadCount == 0) {
            this.acceptorThreadCount = 1;
        }
        if (this.serverSocketFactory == null) {
            this.serverSocketFactory = ServerSocketFactory.getDefault();
        }
        if (this.serverSocket == null) {
            try {
                this.serverSocket = this.address == null ? this.serverSocketFactory.createSocket(this.port, this.backlog) : this.serverSocketFactory.createSocket(this.port, this.backlog, this.address);
            }
            catch (BindException be) {
                if (this.address == null) {
                    throw new BindException(be.getMessage() + "<null>:" + this.port);
                }
                throw new BindException(be.getMessage() + " " + this.address.toString() + ":" + this.port);
            }
        }
        this.initialized = true;
    }

    public void start() throws Exception {
        if (!this.initialized) {
            this.init();
        }
        if (!this.running) {
            this.running = true;
            this.paused = false;
            if (this.executor == null) {
                this.workers = new WorkerStack(this.maxThreads);
            }
            this.eventPoller = new Poller();
            this.eventPoller.init();
            Thread pollerThread = new Thread((Runnable)this.eventPoller, this.getName() + "-Poller");
            pollerThread.setPriority(this.threadPriority);
            pollerThread.setDaemon(true);
            pollerThread.start();
            for (int i = 0; i < this.acceptorThreadCount; ++i) {
                Thread acceptorThread = new Thread((Runnable)new Acceptor(), this.getName() + "-Acceptor-" + i);
                acceptorThread.setPriority(this.threadPriority);
                acceptorThread.setDaemon(this.daemon);
                acceptorThread.start();
            }
        }
    }

    public void pause() {
        if (this.running && !this.paused) {
            this.paused = true;
            this.unlockAccept();
        }
    }

    public void resume() {
        if (this.running) {
            this.paused = false;
        }
    }

    public void stop() {
        if (this.running) {
            this.running = false;
            this.unlockAccept();
            this.eventPoller.destroy();
            this.eventPoller = null;
        }
    }

    public void destroy() throws Exception {
        if (this.running) {
            this.stop();
        }
        if (this.serverSocket != null) {
            try {
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (Exception e) {
                CoyoteLogger.UTIL_LOGGER.errorClosingSocket(e);
            }
            this.serverSocket = null;
        }
        this.initialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockAccept() {
        Socket s = null;
        try {
            if (this.address == null) {
                s = new Socket("localhost", this.port);
            } else {
                s = new Socket(this.address, this.port);
                s.setSoLinger(true, 0);
            }
        }
        catch (Exception e) {
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception e) {}
            }
        }
    }

    protected boolean setSocketOptions(Socket socket) {
        int step = 1;
        try {
            if (this.soLinger >= 0) {
                socket.setSoLinger(true, this.soLinger);
            }
            if (this.tcpNoDelay) {
                socket.setTcpNoDelay(this.tcpNoDelay);
            }
            if (this.soTimeout > 0) {
                socket.setSoTimeout(this.soTimeout);
            }
            step = 2;
            this.serverSocketFactory.handshake(socket);
        }
        catch (Throwable t) {
            if (step == 2) {
                CoyoteLogger.UTIL_LOGGER.handshakeFailed(t);
            } else {
                CoyoteLogger.UTIL_LOGGER.unexpectedError(t);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Worker createWorkerThread() {
        WorkerStack workerStack = this.workers;
        synchronized (workerStack) {
            if (this.workers.size() > 0) {
                ++this.curThreadsBusy;
                return this.workers.pop();
            }
            if (this.maxThreads > 0 && this.curThreads < this.maxThreads) {
                ++this.curThreadsBusy;
                if (this.curThreadsBusy == this.maxThreads) {
                    CoyoteLogger.UTIL_LOGGER.maxThreadsReached(this.maxThreads, this.address, this.port);
                }
                return this.newWorkerThread();
            }
            if (this.maxThreads < 0) {
                ++this.curThreadsBusy;
                return this.newWorkerThread();
            }
            return null;
        }
    }

    protected Worker newWorkerThread() {
        Worker workerThread = new Worker();
        workerThread.start();
        return workerThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Worker getWorkerThread() {
        Worker workerThread = this.createWorkerThread();
        if (org.apache.tomcat.util.net.Constants.WAIT_FOR_THREAD || Constants.LOW_MEMORY) {
            while (workerThread == null) {
                try {
                    WorkerStack workerStack = this.workers;
                    synchronized (workerStack) {
                        this.workers.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                workerThread = this.createWorkerThread();
            }
        }
        return workerThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycleWorkerThread(Worker workerThread) {
        WorkerStack workerStack = this.workers;
        synchronized (workerStack) {
            this.workers.push(workerThread);
            --this.curThreadsBusy;
            this.workers.notify();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean processSocket(Socket socket) {
        try {
            if (this.executor == null) {
                Worker worker = this.getWorkerThread();
                if (worker == null) return false;
                worker.assign(socket);
                return true;
            } else {
                this.executor.execute(new SocketProcessor(socket));
            }
            return true;
        }
        catch (Throwable t) {
            CoyoteLogger.UTIL_LOGGER.errorProcessingSocket(t);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean processSocket(Socket socket, SocketStatus status) {
        try {
            if (this.executor == null) {
                Worker worker = this.getWorkerThread();
                if (worker == null) return false;
                worker.assign(socket, status);
                return true;
            } else {
                this.executor.execute(new SocketEventProcessor(socket, status));
            }
            return true;
        }
        catch (Throwable t) {
            CoyoteLogger.UTIL_LOGGER.errorProcessingSocket(t);
            return false;
        }
    }

    public class WorkerStack {
        protected Worker[] workers = null;
        protected int end = 0;

        public WorkerStack(int size) {
            this.workers = new Worker[size];
        }

        public void push(Worker worker) {
            this.workers[this.end++] = worker;
        }

        public Worker pop() {
            if (this.end > 0) {
                return this.workers[--this.end];
            }
            return null;
        }

        public Worker peek() {
            return this.workers[this.end];
        }

        public boolean isEmpty() {
            return this.end == 0;
        }

        public int size() {
            return this.end;
        }
    }

    protected class Worker
    implements Runnable {
        protected Thread thread = null;
        protected boolean available = false;
        protected Socket socket = null;
        protected SocketStatus status = null;

        protected Worker() {
        }

        protected synchronized void assign(Socket socket) {
            while (this.available) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.socket = socket;
            this.status = null;
            this.available = true;
            this.notifyAll();
        }

        protected synchronized void assign(Socket socket, SocketStatus status) {
            while (this.available) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.socket = socket;
            this.status = status;
            this.available = true;
            this.notifyAll();
        }

        private synchronized Socket await() {
            while (!this.available) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            Socket socket = this.socket;
            this.available = false;
            this.notifyAll();
            return socket;
        }

        @Override
        public void run() {
            while (JIoEndpoint.this.running) {
                Socket socket = this.await();
                if (socket == null) continue;
                if (this.status != null) {
                    Handler.SocketState socketState = JIoEndpoint.this.handler.event(socket, this.status);
                    if (socketState == Handler.SocketState.CLOSED) {
                        try {
                            socket.close();
                        }
                        catch (IOException e) {}
                    } else if (socketState == Handler.SocketState.OPEN && JIoEndpoint.this.handler.process(socket) == Handler.SocketState.CLOSED) {
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {}
                    }
                } else if (!(this.status != null || JIoEndpoint.this.setSocketOptions(socket) && JIoEndpoint.this.handler.process(socket) != Handler.SocketState.CLOSED)) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                JIoEndpoint.this.recycleWorkerThread(this);
            }
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setName(JIoEndpoint.this.getName() + "-" + ++JIoEndpoint.this.curThreads);
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    public class Poller
    implements Runnable {
        protected SocketList addList = null;
        protected SocketList localAddList = null;
        protected SocketTimeouts timeouts = null;
        protected long lastMaintain = System.currentTimeMillis();
        protected int connectionCount = 0;

        public int getConnectionCount() {
            return this.connectionCount;
        }

        protected void init() {
            this.timeouts = new SocketTimeouts(JIoEndpoint.this.pollerSize);
            this.connectionCount = 0;
            this.addList = new SocketList(JIoEndpoint.this.pollerSize);
            this.localAddList = new SocketList(JIoEndpoint.this.pollerSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void destroy() {
            try {
                Poller poller = this;
                synchronized (poller) {
                    this.wait(2L);
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            SocketInfo info = this.addList.get();
            while (info != null) {
                if (!JIoEndpoint.this.processSocket(info.socket, SocketStatus.STOP)) {
                    try {
                        info.socket.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                info = this.addList.get();
            }
            this.addList.clear();
            long future = System.currentTimeMillis() + Integer.MAX_VALUE;
            Socket socket = this.timeouts.check(future);
            while (socket != null) {
                if (!JIoEndpoint.this.processSocket(socket, SocketStatus.TIMEOUT)) {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                socket = this.timeouts.check(future);
            }
            this.connectionCount = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Socket socket, int timeout, boolean resume, boolean wakeup) {
            if (timeout < 0) {
                timeout = JIoEndpoint.this.keepAliveTimeout;
            }
            if (timeout < 0) {
                timeout = JIoEndpoint.this.soTimeout;
            }
            if (timeout <= 0) {
                timeout = Integer.MAX_VALUE;
            }
            boolean ok = false;
            Poller poller = this;
            synchronized (poller) {
                if (this.addList.add(socket, timeout, (resume ? 4 : 0) | (wakeup ? 8 : 0))) {
                    ok = true;
                    this.notify();
                }
            }
            if (!ok && !JIoEndpoint.this.processSocket(socket, SocketStatus.ERROR)) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }

        protected void maintain() {
            long date = System.currentTimeMillis();
            if (date - this.lastMaintain < 5000L) {
                return;
            }
            this.lastMaintain = date;
            Socket socket = this.timeouts.check(date);
            while (socket != null) {
                if (!JIoEndpoint.this.processSocket(socket, SocketStatus.TIMEOUT)) {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                socket = this.timeouts.check(date);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int maintain = 0;
            while (JIoEndpoint.this.running) {
                while (JIoEndpoint.this.paused) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
                while (this.connectionCount < 1 && this.addList.size() < 1) {
                    try {
                        if (JIoEndpoint.this.soTimeout > 0 && JIoEndpoint.this.running) {
                            this.maintain();
                        }
                        Poller e = this;
                        synchronized (e) {
                            this.wait(10000L);
                        }
                    }
                    catch (InterruptedException e) {
                    }
                    catch (Throwable t) {
                        CoyoteLogger.UTIL_LOGGER.errorProcessingSocketTimeout(t);
                    }
                }
                try {
                    if (this.addList.size() > 0) {
                        Poller t = this;
                        synchronized (t) {
                            this.addList.duplicate(this.localAddList);
                            this.addList.clear();
                        }
                        SocketInfo info = this.localAddList.get();
                        while (info != null) {
                            if (info.wakeup()) {
                                if (this.timeouts.remove(info.socket)) {
                                    if (info.resume()) {
                                        if (!JIoEndpoint.this.processSocket(info.socket, SocketStatus.OPEN_CALLBACK)) {
                                            try {
                                                info.socket.close();
                                            }
                                            catch (IOException e) {}
                                        }
                                    } else {
                                        this.timeouts.add(info.socket, System.currentTimeMillis() + (long)info.timeout);
                                    }
                                }
                            } else if (info.resume()) {
                                this.timeouts.remove(info.socket);
                                if (!JIoEndpoint.this.processSocket(info.socket, SocketStatus.OPEN_CALLBACK)) {
                                    try {
                                        info.socket.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                            } else {
                                this.timeouts.add(info.socket, System.currentTimeMillis() + (long)info.timeout);
                            }
                            info = this.localAddList.get();
                        }
                    }
                    try {
                        Thread.sleep(2L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (JIoEndpoint.this.soTimeout <= 0 || maintain++ <= 1000 || !JIoEndpoint.this.running) continue;
                    maintain = 0;
                    this.maintain();
                }
                catch (Throwable t) {
                    if (maintain == 0) {
                        CoyoteLogger.UTIL_LOGGER.errorProcessingSocketTimeout(t);
                        continue;
                    }
                    CoyoteLogger.UTIL_LOGGER.errorPollingSocketWithException(t);
                }
            }
            Poller poller = this;
            synchronized (poller) {
                this.notifyAll();
            }
        }
    }

    protected class SocketEventProcessor
    implements Runnable {
        protected Socket socket = null;
        protected SocketStatus status = null;

        public SocketEventProcessor(Socket socket, SocketStatus status) {
            this.socket = socket;
            this.status = status;
        }

        @Override
        public void run() {
            Handler.SocketState socketState = JIoEndpoint.this.handler.event(this.socket, this.status);
            if (socketState == Handler.SocketState.CLOSED) {
                try {
                    this.socket.close();
                }
                catch (IOException e) {}
            } else if (socketState == Handler.SocketState.OPEN && JIoEndpoint.this.handler.process(this.socket) == Handler.SocketState.CLOSED) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.socket = null;
        }
    }

    protected class SocketProcessor
    implements Runnable {
        protected Socket socket = null;

        public SocketProcessor(Socket socket) {
            this.socket = socket;
        }

        @Override
        public void run() {
            if (!JIoEndpoint.this.setSocketOptions(this.socket) || JIoEndpoint.this.handler.process(this.socket) == Handler.SocketState.CLOSED) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.socket = null;
        }
    }

    public class SocketList {
        protected int size = 0;
        protected int pos = 0;
        protected Socket[] sockets;
        protected int[] timeouts;
        protected int[] flags;
        protected SocketInfo info = new SocketInfo();

        public SocketList(int size) {
            this.sockets = new Socket[size];
            this.timeouts = new int[size];
            this.flags = new int[size];
        }

        public int size() {
            return this.size;
        }

        public SocketInfo get() {
            if (this.pos == this.size) {
                return null;
            }
            this.info.socket = this.sockets[this.pos];
            this.info.timeout = this.timeouts[this.pos];
            this.info.flags = this.flags[this.pos];
            ++this.pos;
            return this.info;
        }

        public void clear() {
            this.size = 0;
            this.pos = 0;
        }

        public boolean add(Socket socket, int timeout, int flag) {
            if (this.size == this.sockets.length) {
                return false;
            }
            for (int i = 0; i < this.size; ++i) {
                if (this.sockets[i] != socket) continue;
                this.flags[i] = SocketInfo.merge(this.flags[i], flag);
                return true;
            }
            this.sockets[this.size] = socket;
            this.timeouts[this.size] = timeout;
            this.flags[this.size] = flag;
            ++this.size;
            return true;
        }

        public void duplicate(SocketList copy) {
            copy.size = this.size;
            copy.pos = this.pos;
            System.arraycopy(this.sockets, 0, copy.sockets, 0, this.size);
            System.arraycopy(this.timeouts, 0, copy.timeouts, 0, this.size);
            System.arraycopy(this.flags, 0, copy.flags, 0, this.size);
        }
    }

    public class SocketTimeouts {
        protected int size = 0;
        protected Socket[] sockets;
        protected long[] timeouts;
        protected int pos = 0;

        public SocketTimeouts(int size) {
            this.sockets = new Socket[size];
            this.timeouts = new long[size];
        }

        public void add(Socket socket, long timeout) {
            this.sockets[this.size] = socket;
            this.timeouts[this.size] = timeout;
            ++this.size;
        }

        public boolean remove(Socket socket) {
            for (int i = 0; i < this.size; ++i) {
                if (this.sockets[i] != socket) continue;
                this.sockets[i] = this.sockets[this.size - 1];
                this.timeouts[i] = this.timeouts[this.size - 1];
                --this.size;
                return true;
            }
            return false;
        }

        public Socket check(long date) {
            while (this.pos < this.size) {
                if (date >= this.timeouts[this.pos]) {
                    Socket result = this.sockets[this.pos];
                    this.sockets[this.pos] = this.sockets[this.size - 1];
                    this.timeouts[this.pos] = this.timeouts[this.size - 1];
                    --this.size;
                    return result;
                }
                ++this.pos;
            }
            this.pos = 0;
            return null;
        }
    }

    public static class SocketInfo {
        public static final int RESUME = 4;
        public static final int WAKEUP = 8;
        public Socket socket;
        public int timeout;
        public int flags;

        public boolean resume() {
            return (this.flags & 4) == 4;
        }

        public boolean wakeup() {
            return (this.flags & 8) == 8;
        }

        public static int merge(int flag1, int flag2) {
            return flag1 & 4 | flag2 & 4 | flag1 & 8 & (flag2 & 8);
        }
    }

    protected class Acceptor
    implements Runnable {
        protected Acceptor() {
        }

        @Override
        public void run() {
            while (JIoEndpoint.this.running) {
                while (JIoEndpoint.this.paused) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
                try {
                    Socket socket = JIoEndpoint.this.serverSocketFactory.acceptSocket(JIoEndpoint.this.serverSocket);
                    JIoEndpoint.this.serverSocketFactory.initSocket(socket);
                    if (JIoEndpoint.this.processSocket(socket)) continue;
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (IOException x) {
                    if (!JIoEndpoint.this.running) continue;
                    CoyoteLogger.UTIL_LOGGER.errorAcceptingSocket(x);
                }
                catch (Throwable t) {
                    CoyoteLogger.UTIL_LOGGER.errorAcceptingSocket(t);
                }
            }
        }
    }

    public static interface Handler {
        public SocketState process(Socket var1);

        public SocketState event(Socket var1, SocketStatus var2);

        public static enum SocketState {
            OPEN,
            CLOSED,
            LONG;

        }
    }
}

