/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Constants;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.OutputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.HttpMessages;
import org.apache.tomcat.util.http.MimeHeaders;

public abstract class AbstractInternalOutputBuffer
implements OutputBuffer {
    protected Response response;
    protected MimeHeaders headers;
    protected boolean committed;
    protected boolean finished;
    protected byte[] buf;
    protected int pos;
    protected OutputBuffer outputBuffer;
    protected OutputFilter[] filterLibrary;
    protected OutputFilter[] activeFilters;
    protected int lastActiveFilter;
    protected ByteBuffer bbuf = null;
    protected ByteChunk leftover = null;
    protected boolean nonBlocking = false;
    protected int writeTimeout = -1;

    public AbstractInternalOutputBuffer(Response response, int headerBufferSize) {
        this.response = response;
        this.headers = response.getMimeHeaders();
        this.buf = new byte[headerBufferSize];
        this.bbuf = headerBufferSize < org.apache.coyote.http11.Constants.DEFAULT_HTTP_HEADER_BUFFER_SIZE ? ByteBuffer.allocateDirect(9000) : ByteBuffer.allocateDirect((headerBufferSize / 1500 + 1) * 1500);
        this.outputBuffer = new OutputBufferImpl();
        this.filterLibrary = new OutputFilter[0];
        this.activeFilters = new OutputFilter[0];
        this.lastActiveFilter = -1;
        this.committed = false;
        this.finished = false;
        this.leftover = new ByteChunk();
        this.nonBlocking = false;
        HttpMessages.getMessage(200);
    }

    protected abstract void init();

    public void setNonBlocking(boolean nonBlocking) {
        this.nonBlocking = nonBlocking;
    }

    public boolean getNonBlocking() {
        return this.nonBlocking;
    }

    public void addFilter(OutputFilter filter) {
        OutputFilter[] newFilterLibrary = new OutputFilter[this.filterLibrary.length + 1];
        for (int i = 0; i < this.filterLibrary.length; ++i) {
            newFilterLibrary[i] = this.filterLibrary[i];
        }
        newFilterLibrary[this.filterLibrary.length] = filter;
        this.filterLibrary = newFilterLibrary;
        this.activeFilters = new OutputFilter[this.filterLibrary.length];
    }

    public OutputFilter[] getFilters() {
        return this.filterLibrary;
    }

    public void clearFilters() {
        this.filterLibrary = new OutputFilter[0];
        this.lastActiveFilter = -1;
    }

    protected abstract int write(long var1, TimeUnit var3);

    public void addActiveFilter(OutputFilter filter) {
        if (this.lastActiveFilter == -1) {
            filter.setBuffer(this.outputBuffer);
        } else {
            for (int i = 0; i <= this.lastActiveFilter; ++i) {
                if (this.activeFilters[i] != filter) continue;
                return;
            }
            filter.setBuffer(this.activeFilters[this.lastActiveFilter]);
        }
        this.activeFilters[++this.lastActiveFilter] = filter;
        filter.setResponse(this.response);
    }

    public void removeActiveFilters() {
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.lastActiveFilter = -1;
    }

    public void flush() throws IOException {
        if (!this.committed) {
            this.response.action(ActionCode.ACTION_COMMIT, null);
        }
        this.flushBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearBuffer() {
        ByteBuffer byteBuffer = this.bbuf;
        synchronized (byteBuffer) {
            this.bbuf.clear();
        }
    }

    public void recycle() {
        this.response.recycle();
        this.clearBuffer();
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.committed = false;
        this.finished = false;
    }

    public void nextRequest() {
        this.response.recycle();
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.leftover.recycle();
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.committed = false;
        this.finished = false;
        this.nonBlocking = false;
    }

    public void endRequest() throws IOException {
        if (!this.committed) {
            this.response.action(ActionCode.ACTION_COMMIT, null);
        }
        if (this.finished) {
            return;
        }
        if (this.lastActiveFilter != -1) {
            this.activeFilters[this.lastActiveFilter].end();
        }
        this.flushBuffer();
        this.finished = true;
    }

    public abstract void sendAck() throws Exception;

    public void sendStatus() {
        this.write(org.apache.coyote.http11.Constants.HTTP_11_BYTES);
        this.buf[this.pos++] = 32;
        int status = this.response.getStatus();
        switch (status) {
            case 200: {
                this.write(org.apache.coyote.http11.Constants._200_BYTES);
                break;
            }
            case 400: {
                this.write(org.apache.coyote.http11.Constants._400_BYTES);
                break;
            }
            case 404: {
                this.write(org.apache.coyote.http11.Constants._404_BYTES);
                break;
            }
            default: {
                this.write(status);
            }
        }
        this.buf[this.pos++] = 32;
        String message = null;
        if (Constants.USE_CUSTOM_STATUS_MSG_IN_HEADER) {
            message = this.response.getMessage();
        }
        if (message == null) {
            this.write(HttpMessages.getMessage(status));
        } else {
            this.write(message.replace('\n', ' ').replace('\r', ' '));
        }
        this.buf[this.pos++] = 13;
        this.buf[this.pos++] = 10;
    }

    public void sendHeader(MessageBytes name, MessageBytes value) {
        if (name.getLength() > 0 && !value.isNull()) {
            this.write(name);
            this.buf[this.pos++] = 58;
            this.buf[this.pos++] = 32;
            this.write(value);
            this.buf[this.pos++] = 13;
            this.buf[this.pos++] = 10;
        }
    }

    public void sendHeader(ByteChunk name, ByteChunk value) {
        this.write(name);
        this.buf[this.pos++] = 58;
        this.buf[this.pos++] = 32;
        this.write(value);
        this.buf[this.pos++] = 13;
        this.buf[this.pos++] = 10;
    }

    public void sendHeader(String name, String value) {
        this.write(name);
        this.buf[this.pos++] = 58;
        this.buf[this.pos++] = 32;
        this.write(value);
        this.buf[this.pos++] = 13;
        this.buf[this.pos++] = 10;
    }

    public void endHeaders() {
        this.buf[this.pos++] = 13;
        this.buf[this.pos++] = 10;
    }

    @Override
    public abstract int doWrite(ByteChunk var1, Response var2) throws IOException;

    protected void commit() throws IOException {
        this.committed = true;
        this.response.setCommitted(true);
        if (this.pos > 0) {
            this.bbuf.put(this.buf, 0, this.pos);
        }
    }

    protected void write(MessageBytes mb) {
        if (mb == null) {
            return;
        }
        switch (mb.getType()) {
            case 2: {
                this.write(mb.getByteChunk());
                break;
            }
            case 3: {
                this.write(mb.getCharChunk());
                break;
            }
            default: {
                this.write(mb.toString());
            }
        }
    }

    protected void write(ByteChunk bc) {
        int length = bc.getLength();
        System.arraycopy(bc.getBytes(), bc.getStart(), this.buf, this.pos, length);
        this.pos += length;
    }

    protected void write(CharChunk cc) {
        int start = cc.getStart();
        int end = cc.getEnd();
        char[] cbuf = cc.getBuffer();
        for (int i = start; i < end; ++i) {
            int c = cbuf[i];
            if (c <= 31 && c != 9 || c == 127 || c > 255) {
                c = 32;
            }
            this.buf[this.pos++] = (byte)c;
        }
    }

    public void write(byte[] b) {
        System.arraycopy(b, 0, this.buf, this.pos, b.length);
        this.pos += b.length;
    }

    protected void write(String s) {
        if (s == null) {
            return;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            int c = s.charAt(i);
            if (c <= 31 && c != 9 || c == 127 || c > 255) {
                c = 32;
            }
            this.buf[this.pos++] = (byte)c;
        }
    }

    protected void write(int i) {
        this.write(String.valueOf(i));
    }

    protected abstract void flushBuffer() throws IOException;

    public abstract boolean flushLeftover() throws IOException;

    class OutputBufferImpl
    implements OutputBuffer {
        OutputBufferImpl() {
        }

        @Override
        public int doWrite(ByteChunk chunk, Response res) throws IOException {
            if (AbstractInternalOutputBuffer.this.leftover.getLength() > 0) {
                AbstractInternalOutputBuffer.this.leftover.append(chunk);
                return chunk.getLength();
            }
            int len = chunk.getLength();
            int start = chunk.getStart();
            byte[] b = chunk.getBuffer();
            while (len > 0) {
                int thisTime = len;
                if (!AbstractInternalOutputBuffer.this.bbuf.hasRemaining()) {
                    AbstractInternalOutputBuffer.this.flushBuffer();
                    if (AbstractInternalOutputBuffer.this.leftover.getLength() > 0) {
                        int oldStart = chunk.getOffset();
                        chunk.setOffset(start);
                        AbstractInternalOutputBuffer.this.leftover.append(chunk);
                        chunk.setOffset(oldStart);
                        return chunk.getLength();
                    }
                }
                if (thisTime > AbstractInternalOutputBuffer.this.bbuf.remaining()) {
                    thisTime = AbstractInternalOutputBuffer.this.bbuf.remaining();
                }
                AbstractInternalOutputBuffer.this.bbuf.put(b, start, thisTime);
                len -= thisTime;
                start += thisTime;
            }
            return chunk.getLength();
        }
    }
}

