/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileChannel;
import java.nio.channels.WritePendingException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioServerSocketChannelFactory;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.jsse.NioJSSESocketChannelFactory;
import org.jboss.web.CoyoteLogger;

public class NioEndpoint
extends AbstractEndpoint {
    private AsynchronousServerSocketChannel listener;
    private ConcurrentHashMap<Long, NioChannel> connections;
    private ConcurrentLinkedQueue<ChannelProcessor> recycledChannelProcessors;
    private ConcurrentLinkedQueue<HandshakeHandler> recycledHandshakeProcessors;
    protected Handler handler = null;
    private EventPoller eventPoller;
    protected NioServerSocketChannelFactory serverSocketChannelFactory = null;
    protected SSLContext sslContext;
    protected Sendfile sendfile;

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public int getKeepAliveCount() {
        return this.eventPoller.channelList.size();
    }

    public int getCurrentThreadCount() {
        return this.curThreads;
    }

    public int getCurrentThreadsBusy() {
        return this.curThreadsBusy;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    @Override
    public void init() throws Exception {
        if (this.initialized) {
            return;
        }
        if (this.soTimeout < 0) {
            this.soTimeout = 60000;
        }
        if (this.keepAliveTimeout < 0) {
            this.keepAliveTimeout = this.soTimeout;
        }
        if (this.acceptorThreadCount <= 0) {
            this.acceptorThreadCount = 1;
        }
        if (this.threadFactory == null) {
            this.threadFactory = new DefaultThreadFactory(this.getName() + "-", this.threadPriority);
        }
        if (this.connections == null) {
            this.connections = new ConcurrentHashMap();
        }
        if (this.recycledChannelProcessors == null) {
            this.recycledChannelProcessors = new ConcurrentLinkedQueue();
        }
        if (this.recycledHandshakeProcessors == null) {
            this.recycledHandshakeProcessors = new ConcurrentLinkedQueue();
        }
        if (this.executor == null) {
            this.executor = Executors.newFixedThreadPool(this.maxThreads, this.threadFactory);
        }
        ExecutorService executorService = (ExecutorService)this.executor;
        AsynchronousChannelGroup threadGroup = AsynchronousChannelGroup.withThreadPool(executorService);
        if (this.serverSocketChannelFactory == null) {
            this.serverSocketChannelFactory = NioServerSocketChannelFactory.createServerSocketChannelFactory(threadGroup, this.SSLEnabled);
        } else {
            this.serverSocketChannelFactory.threadGroup = threadGroup;
        }
        if (this.SSLEnabled) {
            NioJSSESocketChannelFactory factory = (NioJSSESocketChannelFactory)this.serverSocketChannelFactory;
            this.sslContext = factory.getSslContext();
        }
        this.serverSocketChannelFactory.init();
        if (this.listener == null) {
            this.listener = this.serverSocketChannelFactory.createServerChannel(this.port, this.backlog, this.address, this.reuseAddress);
        }
        this.initialized = true;
    }

    @Override
    public void start() throws Exception {
        if (!this.initialized) {
            this.init();
        }
        if (!this.running) {
            this.running = true;
            this.paused = false;
            for (int i = 0; i < this.acceptorThreadCount; ++i) {
                Thread acceptorThread = this.newThread(new Acceptor(), "Acceptor", this.daemon);
                acceptorThread.start();
            }
            if (this.useSendfile) {
                this.sendfile = new Sendfile();
                this.sendfile.init();
                Thread sendfileThread = this.newThread(this.sendfile, "SendFile", true);
                sendfileThread.start();
            }
            this.eventPoller = new EventPoller(this.maxConnections);
            this.eventPoller.init();
            Thread eventPollerThread = this.newThread(this.eventPoller, "EventPoller", true);
            eventPollerThread.start();
        }
    }

    @Override
    public void stop() {
        if (this.running) {
            this.running = false;
            this.unlockAccept();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws Exception {
        if (this.running) {
            this.stop();
        }
        if (this.listener != null) {
            try {
                this.listener.close();
            }
            catch (IOException e) {
                CoyoteLogger.UTIL_LOGGER.errorClosingSocket(e);
            }
            finally {
                this.listener = null;
            }
        }
        if (this.sendfile != null) {
            this.sendfile.destroy();
        }
        if (this.eventPoller != null) {
            this.eventPoller.destroy();
        }
        for (NioChannel ch : this.connections.values()) {
            try {
                ch.close();
            }
            catch (Throwable throwable) {}
        }
        this.connections.clear();
        this.serverSocketChannelFactory.destroy();
        this.serverSocketChannelFactory = null;
        this.recycledChannelProcessors.clear();
        this.recycledChannelProcessors = null;
        this.recycledHandshakeProcessors.clear();
        this.recycledHandshakeProcessors = null;
        ((ExecutorService)this.executor).shutdown();
        this.initialized = false;
    }

    protected boolean setChannelOptions(NioChannel channel) {
        try {
            if (this.keepAliveTimeout > 0) {
                channel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, Boolean.TRUE);
            }
            if (this.soLinger >= 0) {
                channel.setOption((SocketOption)StandardSocketOptions.SO_LINGER, (Object)this.soLinger);
            }
            if (this.tcpNoDelay) {
                channel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)this.tcpNoDelay);
            }
            this.serverSocketChannelFactory.initChannel(channel);
            return true;
        }
        catch (Throwable t) {
            if (t instanceof SSLHandshakeException) {
                CoyoteLogger.UTIL_LOGGER.handshakeFailed(t);
            } else {
                CoyoteLogger.UTIL_LOGGER.unexpectedError(t);
            }
            return false;
        }
    }

    public void addEventChannel(NioChannel channel, long timeout, boolean read, boolean write, boolean resume, boolean wakeup) {
        int flags = (read ? 1 : 0) | (write ? 2 : 0) | (resume ? 4 : 0) | (wakeup ? 8 : 0);
        this.addEventChannel(channel, timeout, flags);
    }

    public void addEventChannel(NioChannel channel, long timeout, int flags) {
        long eventTimeout;
        long l = eventTimeout = timeout <= 0L ? (long)this.keepAliveTimeout : timeout;
        if (eventTimeout <= 0L) {
            long l2 = eventTimeout = this.soTimeout > 0 ? (long)this.soTimeout : Integer.MAX_VALUE;
        }
        if (!this.eventPoller.add(channel, eventTimeout, flags)) {
            this.closeChannel(channel);
        }
    }

    public void removeEventChannel(NioChannel channel) {
        this.eventPoller.remove(channel);
    }

    public boolean addSendfileData(SendfileData data) {
        if (this.sendfile != null) {
            return this.sendfile.add(data);
        }
        return false;
    }

    protected boolean processChannelWithOptions(NioChannel channel) {
        try {
            this.executor.execute(new ChannelWithOptionsProcessor(channel));
        }
        catch (Throwable t) {
            CoyoteLogger.UTIL_LOGGER.errorProcessingSocket(t);
            return false;
        }
        return true;
    }

    public boolean processChannel(NioChannel channel, SocketStatus status) {
        if (channel.isClosed()) {
            return false;
        }
        try {
            ChannelProcessor processor = this.getChannelProcessor(channel, status);
            this.executor.execute(processor);
            return true;
        }
        catch (Throwable t) {
            CoyoteLogger.UTIL_LOGGER.errorProcessingSocket(t);
            return false;
        }
    }

    private boolean handshake(NioChannel channel) {
        try {
            HandshakeHandler processor = this.getHandshakeProcessor(channel);
            this.executor.execute(processor);
            return true;
        }
        catch (Throwable t) {
            CoyoteLogger.UTIL_LOGGER.errorProcessingSocket(t);
            return false;
        }
    }

    private ChannelProcessor getChannelProcessor(NioChannel channel, SocketStatus status) {
        ChannelProcessor processor = this.recycledChannelProcessors.poll();
        if (processor == null) {
            processor = new ChannelProcessor(channel, status);
        } else {
            processor.setChannel(channel);
            processor.setStatus(status);
        }
        return processor;
    }

    private HandshakeHandler getHandshakeProcessor(NioChannel channel) {
        HandshakeHandler processor = this.recycledHandshakeProcessors.poll();
        if (processor == null) {
            processor = new HandshakeHandler(channel);
        } else {
            processor.setChannel(channel);
        }
        return processor;
    }

    private boolean addChannel(NioChannel channel) {
        if (this.counter.get() < this.maxConnections && channel.isOpen() && (this.connections.get(channel.getId()) == null || this.connections.get(channel.getId()).isClosed())) {
            this.connections.put(channel.getId(), channel);
            this.counter.incrementAndGet();
            return true;
        }
        return false;
    }

    public NioServerSocketChannelFactory getServerSocketChannelFactory() {
        return this.serverSocketChannelFactory;
    }

    public void setServerSocketChannelFactory(NioServerSocketChannelFactory serverSocketChannelFactory) {
        this.serverSocketChannelFactory = serverSocketChannelFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannel(NioChannel channel) {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException e) {
                CoyoteLogger.UTIL_LOGGER.errorClosingSocket(e);
            }
            finally {
                if (this.connections.remove(channel.getId()) != null) {
                    this.counter.decrementAndGet();
                }
            }
        }
    }

    public SendfileData getSendfileData() {
        return this.sendfile != null ? this.sendfile.getSendfileData() : new SendfileData();
    }

    public class Sendfile
    implements Runnable {
        protected int size;
        protected ConcurrentLinkedQueue<SendfileData> fileDatas;
        protected ConcurrentLinkedQueue<SendfileData> recycledFileDatas;
        protected AtomicInteger counter;
        private Object mutex;

        public int getSendfileCount() {
            return this.counter.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (NioEndpoint.this.running) {
                while (NioEndpoint.this.paused) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
                while (this.counter.get() < 1 && NioEndpoint.this.running && !NioEndpoint.this.paused) {
                    try {
                        Object e = this.mutex;
                        synchronized (e) {
                            this.mutex.wait();
                        }
                    }
                    catch (InterruptedException e) {
                    }
                }
                if (!NioEndpoint.this.running || NioEndpoint.this.paused) continue;
                try {
                    SendfileData data = this.poll();
                    if (data == null) continue;
                    this.sendFile(data);
                }
                catch (Throwable throwable) {}
            }
        }

        protected void init() {
            this.size = NioEndpoint.this.sendfileSize;
            this.mutex = new Object();
            this.counter = new AtomicInteger(0);
            this.fileDatas = new ConcurrentLinkedQueue();
            this.recycledFileDatas = new ConcurrentLinkedQueue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void destroy() {
            Object object = this.mutex;
            synchronized (object) {
                this.counter.incrementAndGet();
                this.fileDatas.clear();
                this.recycledFileDatas.clear();
                this.mutex.notifyAll();
            }
        }

        public void recycleSendfileData(SendfileData data) {
            data.recycle();
            this.recycledFileDatas.offer(data);
        }

        public SendfileData getSendfileData() {
            SendfileData data = this.recycledFileDatas.poll();
            return data == null ? new SendfileData() : data;
        }

        private void sendFile(final SendfileData data) throws Exception {
            data.setup();
            final NioChannel channel = data.channel;
            int BUFFER_SIZE = channel.getOption(StandardSocketOptions.SO_SNDBUF);
            final ByteBuffer buffer = ByteBuffer.allocateDirect(BUFFER_SIZE);
            int nr = data.fileChannel.read(buffer);
            if (nr >= 0) {
                buffer.flip();
                try {
                    channel.write(buffer, data, new CompletionHandler<Integer, SendfileData>(){

                        @Override
                        public void completed(Integer nw, SendfileData attachment) {
                            if (nw < 0) {
                                NioEndpoint.this.closeChannel(channel);
                                this.closeFile(attachment.fileChannel);
                                return;
                            }
                            attachment.pos += (long)nw.intValue();
                            if (attachment.pos >= attachment.end) {
                                Sendfile.this.recycleSendfileData(attachment);
                                return;
                            }
                            boolean ok = true;
                            if (!buffer.hasRemaining()) {
                                buffer.clear();
                                try {
                                    if (attachment.fileChannel.read(buffer) >= 0) {
                                        buffer.flip();
                                    } else {
                                        ok = false;
                                    }
                                }
                                catch (Throwable th) {
                                    ok = false;
                                }
                            }
                            if (ok) {
                                channel.write(buffer, attachment, this);
                            } else {
                                this.closeFile(attachment.fileChannel);
                            }
                        }

                        @Override
                        public void failed(Throwable exc, SendfileData attachment) {
                            NioEndpoint.this.closeChannel(channel);
                            this.closeFile(data.fileChannel);
                        }

                        private void closeFile(Closeable closeable) {
                            try {
                                closeable.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (WritePendingException exp) {
                    data.fileChannel.close();
                    this.add(data);
                }
            } else {
                this.recycleSendfileData(data);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(SendfileData data) {
            if (data != null && this.counter.get() < this.size) {
                Object object = this.mutex;
                synchronized (object) {
                    if (this.fileDatas.offer(data)) {
                        this.counter.incrementAndGet();
                        this.mutex.notifyAll();
                        return true;
                    }
                }
            }
            return false;
        }

        protected SendfileData poll() {
            SendfileData data = this.fileDatas.poll();
            if (data != null) {
                this.counter.decrementAndGet();
            }
            return data;
        }

        protected void remove(SendfileData data) {
            if (this.fileDatas.remove(data)) {
                this.counter.decrementAndGet();
            }
        }
    }

    public static class SendfileData {
        protected String fileName;
        protected long start;
        protected long end;
        protected NioChannel channel;
        protected FileChannel fileChannel;
        protected long pos;
        protected boolean keepAlive;

        protected void setup() throws IOException {
            this.pos = this.start;
            if (this.fileChannel == null || !this.fileChannel.isOpen()) {
                Path path = new File(this.fileName).toPath();
                this.fileChannel = FileChannel.open(path, StandardOpenOption.READ).position(this.pos);
            }
        }

        protected void recycle() {
            this.start = 0L;
            this.end = 0L;
            this.pos = 0L;
            this.channel = null;
            this.keepAlive = false;
            if (this.fileChannel != null && this.fileChannel.isOpen()) {
                try {
                    this.fileChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.fileChannel = null;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public long getStart() {
            return this.start;
        }

        public void setStart(long start) {
            this.start = start;
        }

        public long getEnd() {
            return this.end;
        }

        public void setEnd(long end) {
            this.end = end;
        }

        public NioChannel getChannel() {
            return this.channel;
        }

        public void setChannel(NioChannel channel) {
            this.channel = channel;
        }

        public long getPos() {
            return this.pos;
        }

        public void setPos(long pos) {
            this.pos = pos;
        }

        public boolean isKeepAlive() {
            return this.keepAlive;
        }

        public void setKeepAlive(boolean keepAlive) {
            this.keepAlive = keepAlive;
        }
    }

    protected static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;
        private final int threadPriority;

        public DefaultThreadFactory(String namePrefix, int threadPriority) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = namePrefix;
            this.threadPriority = threadPriority;
        }

        public DefaultThreadFactory(int threadPriority) {
            this("pool-" + poolNumber.getAndIncrement() + "-thread-", threadPriority);
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != this.threadPriority) {
                thread.setPriority(this.threadPriority);
            }
            return thread;
        }
    }

    public class EventPoller
    implements Runnable {
        protected long lastMaintain = System.currentTimeMillis();
        protected ConcurrentHashMap<Long, ChannelInfo> channelList;
        protected ConcurrentLinkedQueue<ChannelInfo> recycledChannelList;
        private ConcurrentLinkedQueue<CompletionHandler<Integer, NioChannel>> recycledCompletionHandlers;
        private Object mutex;
        private int size;

        public EventPoller(int size) {
            this.size = size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (NioEndpoint.this.running) {
                while (NioEndpoint.this.paused) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
                while (this.channelList.size() < 1 && NioEndpoint.this.running) {
                    Object e = this.mutex;
                    synchronized (e) {
                        try {
                            this.mutex.wait(10000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                while (this.channelList.size() > 0 && NioEndpoint.this.running) {
                    this.maintain();
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        public void maintain() {
            long date = System.currentTimeMillis();
            if (date - this.lastMaintain < 5000L) {
                return;
            }
            this.lastMaintain = date;
            for (ChannelInfo info : this.channelList.values()) {
                if (date < info.timeout) continue;
                NioChannel ch = info.channel;
                this.remove(info);
                if (NioEndpoint.this.processChannel(ch, SocketStatus.TIMEOUT)) continue;
                NioEndpoint.this.closeChannel(ch);
            }
        }

        protected boolean remove(long id) {
            ChannelInfo info = this.channelList.remove(id);
            return this.offer(info);
        }

        public boolean remove(NioChannel channel) {
            return channel != null ? this.remove(channel.getId()) : false;
        }

        public boolean remove(ChannelInfo info) {
            return info != null ? this.remove(info.channel) : false;
        }

        public void init() {
            this.mutex = new Object();
            this.channelList = new ConcurrentHashMap(this.size);
            this.recycledChannelList = new ConcurrentLinkedQueue();
            this.recycledCompletionHandlers = new ConcurrentLinkedQueue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            Object object = this.mutex;
            synchronized (object) {
                this.channelList.clear();
                this.recycledChannelList.clear();
                this.recycledCompletionHandlers.clear();
                this.mutex.notifyAll();
            }
        }

        protected ChannelInfo poll() {
            ChannelInfo info = this.recycledChannelList.poll();
            if (info == null) {
                info = new ChannelInfo();
            }
            return info;
        }

        protected boolean offer(ChannelInfo info) {
            if (info != null) {
                info.recycle();
                return this.recycledChannelList.offer(info);
            }
            return false;
        }

        private CompletionHandler<Integer, NioChannel> getCompletionHandler() {
            CompletionHandler<Integer, NioChannel> handler = this.recycledCompletionHandlers.poll();
            if (handler == null) {
                handler = new CompletionHandler<Integer, NioChannel>(){

                    @Override
                    public void completed(Integer nBytes, NioChannel attach) {
                        if (nBytes < 0) {
                            this.failed((Throwable)new ClosedChannelException(), attach);
                        } else {
                            EventPoller.this.remove(attach);
                            if (!NioEndpoint.this.processChannel(attach, SocketStatus.OPEN_READ)) {
                                NioEndpoint.this.closeChannel(attach);
                            }
                            EventPoller.this.recycleHanlder(this);
                        }
                    }

                    @Override
                    public void failed(Throwable exc, NioChannel attach) {
                        EventPoller.this.remove(attach);
                        NioEndpoint.this.processChannel(attach, SocketStatus.ERROR);
                        EventPoller.this.recycleHanlder(this);
                    }
                };
            }
            return handler;
        }

        private void recycleHanlder(CompletionHandler<Integer, NioChannel> handler) {
            this.recycledCompletionHandlers.offer(handler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(NioChannel channel, long timeout, int flag) {
            if (this.channelList.size() > this.size) {
                return false;
            }
            long date = timeout + System.currentTimeMillis();
            ChannelInfo info = this.channelList.get(channel.getId());
            if (info == null) {
                info = this.poll();
                info.channel = channel;
                info.flags = flag;
                this.channelList.put(channel.getId(), info);
            } else {
                info.flags = ChannelInfo.merge(info.flags, flag);
            }
            info.timeout = date;
            NioChannel ch = channel;
            if (info.resume()) {
                this.remove(info);
                if (!NioEndpoint.this.processChannel(ch, SocketStatus.OPEN_CALLBACK)) {
                    NioEndpoint.this.closeChannel(ch);
                }
            } else if (info.read()) {
                try {
                    ch.awaitRead(ch, this.getCompletionHandler());
                }
                catch (Exception e) {
                    CoyoteLogger.UTIL_LOGGER.errorAwaitingRead(e);
                }
            } else if (info.write()) {
                this.remove(info);
                if (!NioEndpoint.this.processChannel(ch, SocketStatus.OPEN_WRITE)) {
                    NioEndpoint.this.closeChannel(ch);
                }
            } else if (info.wakeup()) {
                this.remove(info);
            }
            Object object = this.mutex;
            synchronized (object) {
                this.mutex.notifyAll();
            }
            return true;
        }
    }

    protected class ChannelProcessor
    implements Runnable {
        protected NioChannel channel;
        protected SocketStatus status = null;

        public ChannelProcessor(NioChannel channel) {
            this.channel = channel;
        }

        public ChannelProcessor(NioChannel channel, SocketStatus status) {
            this(channel);
            this.status = status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Handler.SocketState state;
                Handler.SocketState socketState = state = this.status == null ? NioEndpoint.this.handler.process(this.channel) : NioEndpoint.this.handler.event(this.channel, this.status);
                if (state == Handler.SocketState.CLOSED) {
                    NioEndpoint.this.closeChannel(this.channel);
                }
            }
            catch (Throwable th) {
                CoyoteLogger.UTIL_LOGGER.errorProcessingChannelWithException(th);
            }
            finally {
                this.recycle();
            }
        }

        protected void recycle() {
            this.channel = null;
            this.status = null;
            if (NioEndpoint.this.recycledChannelProcessors != null) {
                NioEndpoint.this.recycledChannelProcessors.offer(this);
            }
        }

        protected void setup(NioChannel channel, SocketStatus status) {
            this.channel = channel;
            this.status = status;
        }

        public void setStatus(SocketStatus status) {
            this.status = status;
        }

        public void setChannel(NioChannel channel) {
            this.channel = channel;
        }
    }

    protected class ChannelWithOptionsProcessor
    extends ChannelProcessor {
        public ChannelWithOptionsProcessor(NioChannel channel) {
            super(channel);
        }

        @Override
        public void run() {
            boolean ok = true;
            if (!NioEndpoint.this.deferAccept) {
                ok = NioEndpoint.this.setChannelOptions(this.channel);
            } else {
                boolean bl = ok = NioEndpoint.this.setChannelOptions(this.channel) && NioEndpoint.this.handler.process(this.channel) != Handler.SocketState.CLOSED;
            }
            if (!ok) {
                NioEndpoint.this.closeChannel(this.channel);
            }
            this.channel = null;
        }
    }

    public static interface Handler {
        public SocketState process(NioChannel var1);

        public SocketState event(NioChannel var1, SocketStatus var2);

        public static enum SocketState {
            OPEN,
            CLOSED,
            LONG;

        }
    }

    public static class ChannelInfo {
        public static final int READ = 1;
        public static final int WRITE = 2;
        public static final int RESUME = 4;
        public static final int WAKEUP = 8;
        protected NioChannel channel;
        protected long timeout;
        protected int flags;

        public ChannelInfo() {
            this(null, 0L, 0);
        }

        public ChannelInfo(NioChannel channel, long timeout, int flags) {
            this.channel = channel;
            this.timeout = timeout;
            this.flags = flags;
        }

        public ChannelInfo(NioChannel channel, long timeout, TimeUnit unit, int flags) {
            this(channel, TimeUnit.MILLISECONDS.convert(timeout, unit), flags);
        }

        public void recycle() {
            this.channel = null;
            this.timeout = 0L;
            this.flags = 0;
        }

        public boolean read() {
            return (this.flags & 1) == 1;
        }

        public void read(boolean read) {
            this.flags = read ? this.flags | 1 : this.flags & 0xE;
        }

        public boolean write() {
            return (this.flags & 2) == 2;
        }

        public void write(boolean write) {
            this.flags = write ? this.flags | 2 : this.flags & 0xD;
        }

        public boolean resume() {
            return (this.flags & 4) == 4;
        }

        public void resume(boolean resume) {
            this.flags = resume ? this.flags | 4 : this.flags & 0xB;
        }

        public boolean wakeup() {
            return (this.flags & 8) == 8;
        }

        public void wakeup(boolean wakeup) {
            this.flags = wakeup ? this.flags | 8 : this.flags & 7;
        }

        public static int merge(int flag1, int flag2) {
            return flag1 & 1 | flag2 & 1 | (flag1 & 2 | flag2 & 2) | (flag1 & 4 | flag2 & 4) | flag1 & 8 & (flag2 & 8);
        }
    }

    protected class HandshakeHandler
    implements Runnable {
        private NioChannel channel;

        public HandshakeHandler(NioChannel channel) {
            this.channel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                NioEndpoint.this.serverSocketChannelFactory.handshake(this.channel);
                if (!NioEndpoint.this.processChannel(this.channel, null)) {
                    CoyoteLogger.UTIL_LOGGER.errorProcessingChannel();
                    NioEndpoint.this.closeChannel(this.channel);
                }
            }
            catch (Exception exp) {
                CoyoteLogger.UTIL_LOGGER.errorProcessingChannelDebug(exp);
                NioEndpoint.this.closeChannel(this.channel);
            }
            finally {
                this.recycle();
            }
        }

        private void recycle() {
            this.channel = null;
            if (NioEndpoint.this.recycledHandshakeProcessors != null) {
                NioEndpoint.this.recycledHandshakeProcessors.offer(this);
            }
        }

        public void setChannel(NioChannel channel) {
            this.channel = channel;
        }
    }

    protected class Acceptor
    implements Runnable {
        protected Acceptor() {
        }

        @Override
        public void run() {
            while (NioEndpoint.this.running) {
                while (NioEndpoint.this.paused) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
                try {
                    NioChannel channel = NioEndpoint.this.serverSocketChannelFactory.acceptChannel(NioEndpoint.this.listener);
                    boolean ok = false;
                    if (NioEndpoint.this.addChannel(channel) && NioEndpoint.this.setChannelOptions(channel) && channel.isOpen()) {
                        if (channel.isSecure()) {
                            NioEndpoint.this.handshake(channel);
                            ok = true;
                        } else {
                            ok = NioEndpoint.this.processChannel(channel, null);
                        }
                    }
                    if (ok) continue;
                    CoyoteLogger.UTIL_LOGGER.errorProcessingChannel();
                    NioEndpoint.this.closeChannel(channel);
                }
                catch (Exception exp) {
                    if (!NioEndpoint.this.running) continue;
                    CoyoteLogger.UTIL_LOGGER.errorAcceptingSocket(exp);
                }
                catch (Throwable t) {
                    CoyoteLogger.UTIL_LOGGER.errorAcceptingSocket(t);
                }
            }
        }
    }
}

