/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.jboss.web.CatalinaMessages;

public abstract class RequestFilterValve
extends ValveBase {
    private static final String info = "org.apache.catalina.valves.RequestFilterValve/1.0";
    protected String allow = null;
    protected Pattern[] allows = new Pattern[0];
    protected Pattern[] denies = new Pattern[0];
    protected String deny = null;

    public String getAllow() {
        return this.allow;
    }

    public void setAllow(String allow) {
        this.allow = allow;
        this.allows = this.precalculate(allow);
    }

    public String getDeny() {
        return this.deny;
    }

    public void setDeny(String deny) {
        this.deny = deny;
        this.denies = this.precalculate(deny);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public abstract void invoke(Request var1, Response var2) throws IOException, ServletException;

    protected Pattern[] precalculate(String list) {
        int comma;
        if (list == null) {
            return new Pattern[0];
        }
        if ((list = list.trim()).length() < 1) {
            return new Pattern[0];
        }
        list = list + ",";
        ArrayList<Pattern> reList = new ArrayList<Pattern>();
        while (list.length() > 0 && (comma = list.indexOf(44)) >= 0) {
            String pattern = list.substring(0, comma).trim();
            try {
                reList.add(Pattern.compile(pattern));
            }
            catch (PatternSyntaxException e) {
                IllegalArgumentException iae = new IllegalArgumentException(CatalinaMessages.MESSAGES.requestFilterValvePatternError(pattern));
                iae.initCause(e);
                throw iae;
            }
            list = list.substring(comma + 1);
        }
        Pattern[] reArray = new Pattern[reList.size()];
        return reList.toArray(reArray);
    }

    protected void process(String property, Request request, Response response) throws IOException, ServletException {
        int i;
        for (i = 0; i < this.denies.length; ++i) {
            if (!this.denies[i].matcher(property).matches()) continue;
            response.sendError(403);
            return;
        }
        for (i = 0; i < this.allows.length; ++i) {
            if (!this.allows[i].matcher(property).matches()) continue;
            this.getNext().invoke(request, response);
            return;
        }
        if (this.denies.length > 0 && this.allows.length == 0) {
            this.getNext().invoke(request, response);
            return;
        }
        response.sendError(403);
    }
}

