/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.websocket;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import org.apache.catalina.websocket.WsFrame;
import org.apache.catalina.websocket.WsInputStream;
import org.apache.catalina.websocket.WsOutbound;
import org.apache.tomcat.util.buf.Utf8Decoder;
import org.jboss.servlet.http.HttpEvent;

public abstract class StreamInbound {
    private final ClassLoader applicationClassLoader = Thread.currentThread().getContextClassLoader();
    private HttpEvent event = null;
    private WsOutbound outbound;
    private int outboundByteBufferSize = 8192;
    private int outboundCharBufferSize = 8192;

    public int getOutboundByteBufferSize() {
        return this.outboundByteBufferSize;
    }

    public HttpEvent getEvent() {
        return this.event;
    }

    public void setEvent(HttpEvent event) {
        this.event = event;
    }

    public void setOutboundByteBufferSize(int outboundByteBufferSize) {
        this.outboundByteBufferSize = outboundByteBufferSize;
    }

    public int getOutboundCharBufferSize() {
        return this.outboundCharBufferSize;
    }

    public void setOutboundCharBufferSize(int outboundCharBufferSize) {
        this.outboundCharBufferSize = outboundCharBufferSize;
    }

    public final WsOutbound getWsOutbound() {
        return this.outbound;
    }

    public final void onData() throws IOException {
        WsInputStream wsIs = new WsInputStream(this.event, this.getWsOutbound());
        try {
            WsFrame frame = wsIs.nextFrame(false);
            while (frame != null) {
                byte opCode;
                if (frame.getRsv() > 0) {
                    this.closeOutboundConnection(1002, null);
                    this.event.close();
                }
                if ((opCode = frame.getOpCode()) == 2) {
                    this.doOnBinaryData(wsIs);
                } else if (opCode == 1) {
                    InputStreamReader r = new InputStreamReader((InputStream)wsIs, new Utf8Decoder());
                    this.doOnTextData(r);
                } else if (opCode == 8) {
                    this.closeOutboundConnection(frame);
                    this.event.close();
                } else if (opCode == 9) {
                    this.getWsOutbound().pong(frame.getPayLoad());
                } else if (opCode == 10) {
                    this.doOnPong(frame.getPayLoad());
                } else {
                    this.closeOutboundConnection(1002, null);
                    this.event.close();
                }
                frame = wsIs.nextFrame(false);
            }
        }
        catch (MalformedInputException mie) {
            this.closeOutboundConnection(1007, null);
            this.event.close();
        }
        catch (UnmappableCharacterException uce) {
            this.closeOutboundConnection(1007, null);
            this.event.close();
        }
        catch (IOException ioe) {
            this.closeOutboundConnection(1002, null);
            this.event.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOnBinaryData(InputStream is) throws IOException {
        Thread t = Thread.currentThread();
        ClassLoader cl = t.getContextClassLoader();
        t.setContextClassLoader(this.applicationClassLoader);
        try {
            this.onBinaryData(is);
        }
        finally {
            t.setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOnTextData(Reader r) throws IOException {
        Thread t = Thread.currentThread();
        ClassLoader cl = t.getContextClassLoader();
        t.setContextClassLoader(this.applicationClassLoader);
        try {
            this.onTextData(r);
        }
        finally {
            t.setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeOutboundConnection(int status, ByteBuffer data) throws IOException {
        try {
            this.getWsOutbound().close(status, data);
        }
        finally {
            this.doOnClose(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeOutboundConnection(WsFrame frame) throws IOException {
        try {
            this.getWsOutbound().close(frame);
        }
        finally {
            this.doOnClose(1000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doOnClose(int status) {
        Thread t = Thread.currentThread();
        ClassLoader cl = t.getContextClassLoader();
        t.setContextClassLoader(this.applicationClassLoader);
        try {
            this.onClose(status);
        }
        finally {
            t.setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOnPong(ByteBuffer payload) {
        Thread t = Thread.currentThread();
        ClassLoader cl = t.getContextClassLoader();
        t.setContextClassLoader(this.applicationClassLoader);
        try {
            this.onPong(payload);
        }
        finally {
            t.setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onUpgradeComplete() {
        this.outbound = new WsOutbound(this.event, this, this.outboundByteBufferSize, this.outboundCharBufferSize);
        Thread t = Thread.currentThread();
        ClassLoader cl = t.getContextClassLoader();
        t.setContextClassLoader(this.applicationClassLoader);
        try {
            this.onOpen(this.outbound);
        }
        finally {
            t.setContextClassLoader(cl);
        }
    }

    protected void onOpen(WsOutbound outbound) {
    }

    protected void onClose(int status) {
    }

    protected void onPong(ByteBuffer payload) {
    }

    protected abstract void onBinaryData(InputStream var1) throws IOException;

    protected abstract void onTextData(Reader var1) throws IOException;

    public int getReadTimeout() {
        return -1;
    }
}

