/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.server;

import java.io.EOFException;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import org.apache.coyote.http11.upgrade.AbstractServletInputStream;
import org.apache.coyote.http11.upgrade.AbstractServletOutputStream;
import org.apache.coyote.http11.upgrade.servlet31.HttpUpgradeHandler;
import org.apache.coyote.http11.upgrade.servlet31.ReadListener;
import org.apache.coyote.http11.upgrade.servlet31.WebConnection;
import org.apache.coyote.http11.upgrade.servlet31.WriteListener;
import org.apache.tomcat.websocket.WsIOException;
import org.apache.tomcat.websocket.WsSession;
import org.apache.tomcat.websocket.server.WsFrameServer;
import org.apache.tomcat.websocket.server.WsHandshakeRequest;
import org.apache.tomcat.websocket.server.WsRemoteEndpointImplServer;
import org.apache.tomcat.websocket.server.WsServerContainer;
import org.jboss.web.WebsocketsLogger;
import org.jboss.web.WebsocketsMessages;

public class WsHttpUpgradeHandler
implements HttpUpgradeHandler {
    private final ClassLoader applicationClassLoader = Thread.currentThread().getContextClassLoader();
    private Endpoint ep;
    private EndpointConfig endpointConfig;
    private WsServerContainer webSocketContainer;
    private WsHandshakeRequest handshakeRequest;
    private String subProtocol;
    private Map<String, String> pathParameters;
    private boolean secure;
    private WebConnection connection;
    private WsSession wsSession;

    public void preInit(Endpoint ep, EndpointConfig endpointConfig, WsServerContainer wsc, WsHandshakeRequest handshakeRequest, String subProtocol, Map<String, String> pathParameters, boolean secure) {
        this.ep = ep;
        this.endpointConfig = endpointConfig;
        this.webSocketContainer = wsc;
        this.handshakeRequest = handshakeRequest;
        this.subProtocol = subProtocol;
        this.pathParameters = pathParameters;
        this.secure = secure;
    }

    @Override
    public void init(WebConnection connection) {
        AbstractServletOutputStream sos;
        AbstractServletInputStream sis;
        if (this.ep == null) {
            throw WebsocketsMessages.MESSAGES.noPreInit();
        }
        this.connection = connection;
        try {
            sis = connection.getInputStream();
            sos = connection.getOutputStream();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        String httpSessionId = null;
        Object session = this.handshakeRequest.getHttpSession();
        if (session != null) {
            httpSessionId = ((HttpSession)session).getId();
        }
        Thread t = Thread.currentThread();
        ClassLoader cl = t.getContextClassLoader();
        t.setContextClassLoader(this.applicationClassLoader);
        try {
            WsRemoteEndpointImplServer wsRemoteEndpointServer = new WsRemoteEndpointImplServer(sos, this.webSocketContainer);
            this.wsSession = new WsSession(this.ep, wsRemoteEndpointServer, this.webSocketContainer, this.handshakeRequest.getRequestURI(), this.handshakeRequest.getParameterMap(), this.handshakeRequest.getQueryString(), this.handshakeRequest.getUserPrincipal(), httpSessionId, this.subProtocol, this.pathParameters, this.secure, this.endpointConfig);
            WsFrameServer wsFrame = new WsFrameServer(sis, this.wsSession);
            sos.setWriteListener(new WsWriteListener(this, wsRemoteEndpointServer));
            this.ep.onOpen(this.wsSession, this.endpointConfig);
            this.webSocketContainer.registerSession(this.ep, this.wsSession);
            sis.setReadListener(new WsReadListener(this, wsFrame));
        }
        catch (DeploymentException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            t.setContextClassLoader(cl);
        }
    }

    @Override
    public void destroy() {
        try {
            this.connection.close();
        }
        catch (Exception e) {
            WebsocketsLogger.ROOT_LOGGER.destroyFailed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onError(Throwable throwable) {
        Thread t = Thread.currentThread();
        ClassLoader cl = t.getContextClassLoader();
        t.setContextClassLoader(this.applicationClassLoader);
        try {
            this.ep.onError(this.wsSession, throwable);
        }
        finally {
            t.setContextClassLoader(cl);
        }
    }

    private void close(CloseReason cr) {
        this.wsSession.onClose(cr);
    }

    private static class WsWriteListener
    implements WriteListener {
        private final WsHttpUpgradeHandler wsProtocolHandler;
        private final WsRemoteEndpointImplServer wsRemoteEndpointServer;

        private WsWriteListener(WsHttpUpgradeHandler wsProtocolHandler, WsRemoteEndpointImplServer wsRemoteEndpointServer) {
            this.wsProtocolHandler = wsProtocolHandler;
            this.wsRemoteEndpointServer = wsRemoteEndpointServer;
        }

        @Override
        public void onWritePossible() {
            this.wsRemoteEndpointServer.onWritePossible(false);
        }

        @Override
        public void onError(Throwable throwable) {
            this.wsProtocolHandler.onError(throwable);
            this.wsRemoteEndpointServer.close();
        }
    }

    private static class WsReadListener
    implements ReadListener {
        private final WsHttpUpgradeHandler wsProtocolHandler;
        private final WsFrameServer wsFrame;

        private WsReadListener(WsHttpUpgradeHandler wsProtocolHandler, WsFrameServer wsFrame) {
            this.wsProtocolHandler = wsProtocolHandler;
            this.wsFrame = wsFrame;
        }

        @Override
        public void onDataAvailable() {
            try {
                this.wsFrame.onDataAvailable();
            }
            catch (WsIOException ws) {
                this.wsProtocolHandler.close(ws.getCloseReason());
            }
            catch (EOFException eof) {
                CloseReason cr = new CloseReason(CloseReason.CloseCodes.CLOSED_ABNORMALLY, eof.getMessage());
                this.wsProtocolHandler.close(cr);
            }
            catch (IOException ioe) {
                this.onError(ioe);
                CloseReason cr = new CloseReason(CloseReason.CloseCodes.CLOSED_ABNORMALLY, ioe.getMessage());
                this.wsProtocolHandler.close(cr);
            }
        }

        @Override
        public void onAllDataRead() {
            throw new IllegalStateException();
        }

        @Override
        public void onError(Throwable throwable) {
            this.wsProtocolHandler.onError(throwable);
        }
    }
}

