/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.EOFException;
import java.io.IOException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ApplicationDispatcher;
import org.apache.catalina.core.ApplicationFilterChain;
import org.apache.catalina.core.ApplicationFilterFactory;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.util.InstanceSupport;
import org.apache.catalina.valves.ValveBase;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.servlet.http.HttpEventServlet;
import org.jboss.web.CatalinaMessages;

final class StandardWrapperValve
extends ValveBase {
    protected static final boolean SERVLET_STATS = Globals.STRICT_SERVLET_COMPLIANCE || Boolean.valueOf(System.getProperty("org.apache.catalina.core.StandardWrapperValve.SERVLET_STATS", "false")) != false;
    private volatile long processingTime;
    private volatile long maxTime;
    private volatile long minTime = Long.MAX_VALUE;
    private volatile int eventCount;
    private volatile int requestCount;
    private volatile int errorCount;
    private InstanceSupport support;

    StandardWrapperValve() {
    }

    @Override
    public void setContainer(Container container) {
        super.setContainer(container);
        if (container instanceof Wrapper) {
            this.support = ((Wrapper)container).getInstanceSupport();
        }
        if (this.support == null) {
            throw CatalinaMessages.MESSAGES.missingInstanceSupport(container.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void invoke(Request request, Response response) throws IOException, ServletException {
        long t1;
        block55: {
            Servlet servlet;
            StandardWrapper wrapper;
            Throwable throwable;
            block54: {
                boolean unavailable = false;
                throwable = null;
                t1 = 0L;
                if (SERVLET_STATS) {
                    t1 = System.currentTimeMillis();
                    ++this.requestCount;
                }
                wrapper = (StandardWrapper)this.getContainer();
                servlet = null;
                Context context = (Context)wrapper.getParent();
                if (!context.getAvailable()) {
                    response.sendError(503, CatalinaMessages.MESSAGES.unavailable());
                    unavailable = true;
                }
                if (!unavailable && wrapper.isUnavailable()) {
                    this.container.getLogger().info((Object)CatalinaMessages.MESSAGES.servletIsUnavailable(wrapper.getName()));
                    long available = wrapper.getAvailable();
                    if (available > 0L && available < Long.MAX_VALUE) {
                        response.setDateHeader("Retry-After", available);
                        response.sendError(503, CatalinaMessages.MESSAGES.servletIsUnavailable(wrapper.getName()));
                    } else if (available == Long.MAX_VALUE) {
                        response.sendError(404, CatalinaMessages.MESSAGES.servletIsUnavailable(wrapper.getName()));
                    }
                    unavailable = true;
                }
                try {
                    if (!unavailable) {
                        servlet = wrapper.allocate();
                    }
                }
                catch (UnavailableException e) {
                    this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.servletAllocateException(wrapper.getName()), (Throwable)e);
                    long available = wrapper.getAvailable();
                    if (available > 0L && available < Long.MAX_VALUE) {
                        response.setDateHeader("Retry-After", available);
                        response.sendError(503, CatalinaMessages.MESSAGES.servletIsUnavailable(wrapper.getName()));
                    } else if (available == Long.MAX_VALUE) {
                        response.sendError(404, CatalinaMessages.MESSAGES.servletIsUnavailable(wrapper.getName()));
                    }
                }
                catch (ServletException e) {
                    this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.servletAllocateException(wrapper.getName()), StandardWrapper.getRootCause(e));
                    throwable = e;
                    this.exception(request, response, e);
                    servlet = null;
                }
                catch (Throwable e) {
                    this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.servletAllocateException(wrapper.getName()), e);
                    throwable = e;
                    this.exception(request, response, e);
                    servlet = null;
                }
                boolean event = false;
                if (servlet instanceof HttpEventServlet && request.getConnector().hasIoEvents()) {
                    event = true;
                    request.setEventMode(true);
                }
                try {
                    response.sendAcknowledgement();
                }
                catch (IOException e) {
                    request.removeAttribute("org.apache.catalina.jsp_file");
                    this.container.getLogger().warn((Object)CatalinaMessages.MESSAGES.errorAcknowledgingRequest(wrapper.getName()), (Throwable)e);
                    throwable = e;
                    this.exception(request, response, e);
                }
                catch (Throwable e) {
                    this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.errorAcknowledgingRequest(wrapper.getName()), e);
                    throwable = e;
                    this.exception(request, response, e);
                    servlet = null;
                }
                request.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", ApplicationFilterFactory.REQUEST_INTEGER);
                request.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", request.getRequestPathMB());
                ApplicationFilterFactory factory = ApplicationFilterFactory.getInstance();
                ApplicationFilterChain filterChain = factory.createFilterChain((ServletRequest)request, wrapper, servlet);
                request.setEventMode(false);
                String jspFile = wrapper.getJspFile();
                try {
                    if (jspFile != null) {
                        request.setAttribute("org.apache.catalina.jsp_file", jspFile);
                    } else {
                        request.removeAttribute("org.apache.catalina.jsp_file");
                    }
                    this.support.fireInstanceEvent("beforeRequest", servlet, (ServletRequest)request, (ServletResponse)response);
                    if (servlet != null && filterChain != null) {
                        if (event) {
                            request.setEventMode(true);
                            request.getSession(true);
                            filterChain.doFilterEvent(request.getEvent());
                        } else {
                            filterChain.doFilter((ServletRequest)request.getRequest(), (ServletResponse)response.getResponse());
                        }
                    }
                }
                catch (ClientAbortException e) {
                    throwable = e;
                    this.exception(request, response, e);
                }
                catch (IOException e) {
                    this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.servletServiceException(wrapper.getName()), (Throwable)e);
                    throwable = e;
                    this.exception(request, response, e);
                }
                catch (UnavailableException e) {
                    this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.servletServiceException(wrapper.getName()), (Throwable)e);
                    wrapper.unavailable(e);
                    long available = wrapper.getAvailable();
                    if (available > 0L && available < Long.MAX_VALUE) {
                        response.setDateHeader("Retry-After", available);
                        response.sendError(503, CatalinaMessages.MESSAGES.servletIsUnavailable(wrapper.getName()));
                    } else if (available == Long.MAX_VALUE) {
                        response.sendError(404, CatalinaMessages.MESSAGES.servletIsUnavailable(wrapper.getName()));
                    }
                }
                catch (ServletException e) {
                    Throwable rootCause = StandardWrapper.getRootCause(e);
                    if (!(rootCause instanceof ClientAbortException)) {
                        this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.servletServiceException(wrapper.getName()), rootCause);
                    }
                    throwable = e;
                    this.exception(request, response, e);
                }
                catch (Throwable e) {
                    this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.servletServiceException(wrapper.getName()), e);
                    throwable = e;
                    this.exception(request, response, e);
                }
                finally {
                    if (jspFile != null) {
                        request.removeAttribute("org.apache.catalina.jsp_file");
                    }
                    this.support.fireInstanceEvent("afterRequest", servlet, (ServletRequest)request, (ServletResponse)response, throwable);
                }
                if (filterChain != null) {
                    if (request.isEventMode() && !request.isAsyncStarted()) {
                        filterChain.reuse();
                    } else {
                        filterChain.release();
                    }
                }
                try {
                    if (servlet != null) {
                        wrapper.deallocate(servlet);
                    }
                }
                catch (Throwable e) {
                    this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.servletDeallocateException(wrapper.getName()), e);
                    if (throwable != null) break block54;
                    throwable = e;
                    this.exception(request, response, e);
                }
            }
            try {
                if (servlet != null && wrapper.getAvailable() == Long.MAX_VALUE) {
                    wrapper.unload();
                }
            }
            catch (Throwable e) {
                this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.errorUnloadingServlet(wrapper.getName()), e);
                if (throwable != null) break block55;
                throwable = e;
                this.exception(request, response, e);
            }
        }
        if (SERVLET_STATS) {
            long time = System.currentTimeMillis() - t1;
            this.processingTime += time;
            if (time > this.maxTime) {
                this.maxTime = time;
            }
            if (time < this.minTime) {
                this.minTime = time;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void event(Request request, Response response, HttpEvent event) throws IOException, ServletException {
        long t1;
        block39: {
            Servlet servlet;
            StandardWrapper wrapper;
            Throwable throwable;
            block38: {
                AsyncContext asyncContext = request.getAsyncContext();
                if (asyncContext != null) {
                    this.async(request, response, event);
                    return;
                }
                throwable = null;
                t1 = 0L;
                if (SERVLET_STATS) {
                    t1 = System.currentTimeMillis();
                    ++this.eventCount;
                }
                wrapper = (StandardWrapper)this.getContainer();
                servlet = null;
                Context context = (Context)wrapper.getParent();
                boolean unavailable = !context.getAvailable() || wrapper.isUnavailable();
                try {
                    if (!unavailable) {
                        servlet = wrapper.allocate();
                    }
                }
                catch (UnavailableException e) {
                }
                catch (ServletException e) {
                    this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.servletAllocateException(wrapper.getName()), StandardWrapper.getRootCause(e));
                    throwable = e;
                    this.exception(request, response, e);
                    servlet = null;
                }
                catch (Throwable e) {
                    this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.servletAllocateException(wrapper.getName()), e);
                    throwable = e;
                    this.exception(request, response, e);
                    servlet = null;
                }
                request.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", ApplicationFilterFactory.ASYNC_INTEGER);
                request.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", request.getRequestPathMB());
                ApplicationFilterChain filterChain = request.getFilterChain();
                String jspFile = wrapper.getJspFile();
                try {
                    if (jspFile != null) {
                        request.setAttribute("org.apache.catalina.jsp_file", jspFile);
                    } else {
                        request.removeAttribute("org.apache.catalina.jsp_file");
                    }
                    this.support.fireInstanceEvent("beforeRequest", servlet, (ServletRequest)request, (ServletResponse)response);
                    if (servlet != null && filterChain != null) {
                        filterChain.doFilterEvent(request.getEvent());
                    }
                }
                catch (ClientAbortException e) {
                    throwable = e;
                    this.exception(request, response, e);
                }
                catch (IOException e) {
                    this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.servletServiceException(wrapper.getName()), (Throwable)e);
                    throwable = e;
                    this.exception(request, response, e);
                }
                catch (UnavailableException e) {
                    this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.servletServiceException(wrapper.getName()), (Throwable)e);
                }
                catch (ServletException e) {
                    Throwable rootCause = StandardWrapper.getRootCause(e);
                    if (!(rootCause instanceof ClientAbortException)) {
                        this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.servletServiceException(wrapper.getName()), rootCause);
                    }
                    throwable = e;
                    this.exception(request, response, e);
                }
                catch (Throwable e) {
                    this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.servletServiceException(wrapper.getName()), e);
                    throwable = e;
                    this.exception(request, response, e);
                }
                finally {
                    if (jspFile != null) {
                        request.removeAttribute("org.apache.catalina.jsp_file");
                    }
                    this.support.fireInstanceEvent("afterRequest", servlet, (ServletRequest)request, (ServletResponse)response, throwable);
                }
                if (filterChain != null) {
                    if (request.isAsyncStarted()) {
                        filterChain.release();
                    } else {
                        filterChain.reuse();
                    }
                }
                try {
                    if (servlet != null) {
                        wrapper.deallocate(servlet);
                    }
                }
                catch (Throwable e) {
                    this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.servletDeallocateException(wrapper.getName()), e);
                    if (throwable != null) break block38;
                    throwable = e;
                    this.exception(request, response, e);
                }
            }
            try {
                if (servlet != null && wrapper.getAvailable() == Long.MAX_VALUE) {
                    wrapper.unload();
                }
            }
            catch (Throwable e) {
                this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.errorUnloadingServlet(wrapper.getName()), e);
                if (throwable != null) break block39;
                throwable = e;
                this.exception(request, response, e);
            }
        }
        if (SERVLET_STATS) {
            long time = System.currentTimeMillis() - t1;
            this.processingTime += time;
            if (time > this.maxTime) {
                this.maxTime = time;
            }
            if (time < this.minTime) {
                this.minTime = time;
            }
        }
    }

    public void async(Request request, Response response, HttpEvent event) throws IOException, ServletException {
        Request.AsyncContextImpl asyncContext = (Request.AsyncContextImpl)request.getAsyncContext();
        if (asyncContext != null) {
            if (event.getType() == HttpEvent.EventType.END || event.getType() == HttpEvent.EventType.ERROR || event.getType() == HttpEvent.EventType.TIMEOUT) {
                boolean end;
                boolean timeout = event.getType() == HttpEvent.EventType.TIMEOUT;
                boolean error = event.getType() == HttpEvent.EventType.ERROR;
                for (Request.AsyncListenerRegistration asyncListenerRegistration : asyncContext.getAsyncListeners().values()) {
                    AsyncListener asyncListener = asyncListenerRegistration.getListener();
                    try {
                        AsyncEvent asyncEvent;
                        if (timeout) {
                            asyncEvent = new AsyncEvent((AsyncContext)asyncContext, asyncListenerRegistration.getRequest(), asyncListenerRegistration.getResponse());
                            asyncListener.onTimeout(asyncEvent);
                            continue;
                        }
                        if (error) {
                            asyncEvent = new AsyncEvent((AsyncContext)asyncContext, asyncListenerRegistration.getRequest(), asyncListenerRegistration.getResponse(), asyncContext.getError());
                            asyncListener.onError(asyncEvent);
                            continue;
                        }
                        asyncEvent = new AsyncEvent((AsyncContext)asyncContext, asyncListenerRegistration.getRequest(), asyncListenerRegistration.getResponse());
                        asyncListener.onComplete(asyncEvent);
                    }
                    catch (Throwable e) {
                        this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.asyncListenerError(this.getContainer().getName()), e);
                        this.exception(request, response, e);
                    }
                }
                boolean bl = end = event.getType() == HttpEvent.EventType.END || error;
                if (timeout && request.isEventMode() && asyncContext.getPath() == null) {
                    response.setStatus(500);
                    end = true;
                }
                try {
                    if (error) {
                        Throwable throwable = asyncContext.getError();
                        if (throwable == null) {
                            throwable = response.getCoyoteResponse().getErrorException();
                            if (throwable != null) {
                                if (!(throwable instanceof IOException)) {
                                    throwable = new IOException(throwable);
                                }
                            } else {
                                throwable = new EOFException();
                            }
                        }
                        if (request.getReadListener() != null) {
                            request.getReadListener().onError(throwable);
                        }
                        if (response.getWriteListener() != null) {
                            response.getWriteListener().onError(throwable);
                        }
                    }
                }
                catch (Throwable e) {
                    this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.ioListenerError(this.getContainer().getName()), e);
                    this.exception(request, response, e);
                }
                if (end && request.getUpgradeHandler() != null) {
                    try {
                        request.getUpgradeHandler().destroy();
                    }
                    catch (Throwable e) {
                        this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.upgradeHandlerDestroyError(this.getContainer().getName()), e);
                        this.exception(request, response, e);
                    }
                }
                if (error && request.isEventMode() && asyncContext.getPath() == null) {
                    this.exception(request, response, asyncContext.getError());
                }
            } else if (event.getType() == HttpEvent.EventType.READ) {
                if (request.getReadListener() != null) {
                    try {
                        request.getReadListener().onDataAvailable();
                    }
                    catch (Throwable e) {
                        this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.ioListenerError(this.getContainer().getName()), e);
                        this.exception(request, response, e);
                    }
                }
            } else if (event.getType() == HttpEvent.EventType.EOF) {
                if (request.getReadListener() != null) {
                    try {
                        request.getReadListener().onAllDataRead();
                    }
                    catch (Throwable e) {
                        this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.ioListenerError(this.getContainer().getName()), e);
                        this.exception(request, response, e);
                    }
                }
            } else if (event.getType() == HttpEvent.EventType.WRITE) {
                if (response.getWriteListener() != null) {
                    try {
                        response.getWriteListener().onWritePossible();
                    }
                    catch (Throwable e) {
                        this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.ioListenerError(this.getContainer().getName()), e);
                        this.exception(request, response, e);
                    }
                }
            } else if (asyncContext.getRunnable() != null) {
                try {
                    asyncContext.runRunnable().run();
                }
                catch (Throwable e) {
                    this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.asyncRunnableError(this.getContainer().getName()), e);
                    asyncContext.setError(e);
                }
            } else if (asyncContext.getPath() != null) {
                asyncContext.done();
                Context context = (Context)this.getContainer().getParent();
                ServletContext servletContext = context.getServletContext();
                if (asyncContext.getServletContext() != null) {
                    servletContext = asyncContext.getServletContext();
                }
                request.setCanStartAsync(true);
                ApplicationDispatcher dispatcher = (ApplicationDispatcher)servletContext.getRequestDispatcher(asyncContext.getPath());
                try {
                    dispatcher.async(asyncContext.getRequest(), asyncContext.getResponse(), asyncContext.getUseAttributes());
                }
                catch (Throwable e) {
                    this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.asyncDispatchError(this.getContainer().getName()), e);
                    asyncContext.setError(e);
                }
                request.setCanStartAsync(false);
                if (!asyncContext.isReady()) {
                    asyncContext.complete();
                }
            }
        }
    }

    private void exception(Request request, Response response, Throwable exception) {
        request.setAttribute("javax.servlet.error.exception", exception);
        response.setStatus(500);
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setProcessingTime(long processingTime) {
        this.processingTime = processingTime;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(long maxTime) {
        this.maxTime = maxTime;
    }

    public long getMinTime() {
        return this.minTime;
    }

    public void setMinTime(long minTime) {
        this.minTime = minTime;
    }

    public int getRequestCount() {
        return this.requestCount;
    }

    public void setRequestCount(int requestCount) {
        this.requestCount = requestCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    public int getEventCount() {
        return this.eventCount;
    }

    public void setEventCount(int eventCount) {
        this.eventCount = eventCount;
    }

    @Override
    public ObjectName createObjectName(String domain, ObjectName parent) throws MalformedObjectNameException {
        return null;
    }
}

