/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Constants;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.Http11AbstractProcessor;
import org.apache.coyote.http11.Http11NioProcessor;
import org.apache.coyote.http11.OutputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.HttpMessages;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.jboss.web.CoyoteLogger;
import org.jboss.web.CoyoteMessages;

public class InternalNioOutputBuffer
implements OutputBuffer {
    protected Response response;
    protected MimeHeaders headers;
    protected boolean committed;
    protected boolean finished;
    protected byte[] buf;
    protected int pos;
    protected OutputBuffer outputBuffer;
    protected OutputFilter[] filterLibrary;
    protected OutputFilter[] activeFilters;
    protected int lastActiveFilter;
    protected ByteBuffer bbuf = null;
    protected ByteChunk leftover = null;
    protected boolean nonBlocking = false;
    protected int writeTimeout = -1;
    protected NioChannel channel;
    protected NioEndpoint endpoint;
    protected Http11NioProcessor processor;
    private CompletionHandler<Integer, NioChannel> completionHandler;
    private Semaphore semaphore = new Semaphore(1);

    public InternalNioOutputBuffer(Http11NioProcessor processor, Response response, int headerBufferSize, NioEndpoint endpoint) {
        this.response = response;
        this.headers = response.getMimeHeaders();
        this.buf = new byte[headerBufferSize];
        this.bbuf = ByteBuffer.allocateDirect(headerBufferSize);
        this.outputBuffer = new OutputBufferImpl();
        this.filterLibrary = new OutputFilter[0];
        this.activeFilters = new OutputFilter[0];
        this.lastActiveFilter = -1;
        this.committed = false;
        this.finished = false;
        this.leftover = new ByteChunk();
        this.nonBlocking = false;
        this.endpoint = endpoint;
        this.processor = processor;
        this.init();
        HttpMessages.getMessage(200);
    }

    protected void init() {
        this.writeTimeout = this.endpoint.getSoTimeout() > 0 ? this.endpoint.getSoTimeout() : Integer.MAX_VALUE;
        this.completionHandler = new CompletionHandler<Integer, NioChannel>(){

            @Override
            public synchronized void completed(Integer nBytes, NioChannel attachment) {
                if (nBytes < 0) {
                    this.failed((Throwable)new IOException(CoyoteMessages.MESSAGES.failedWrite()), attachment);
                    return;
                }
                if (!InternalNioOutputBuffer.this.bbuf.hasRemaining()) {
                    InternalNioOutputBuffer.this.bbuf.clear();
                    if (InternalNioOutputBuffer.this.leftover.getLength() > 0) {
                        int n = Math.min(InternalNioOutputBuffer.this.leftover.getLength(), InternalNioOutputBuffer.this.bbuf.remaining());
                        InternalNioOutputBuffer.this.bbuf.put(InternalNioOutputBuffer.this.leftover.getBuffer(), InternalNioOutputBuffer.this.leftover.getOffset(), n).flip();
                        InternalNioOutputBuffer.this.leftover.setOffset(InternalNioOutputBuffer.this.leftover.getOffset() + n);
                    } else {
                        InternalNioOutputBuffer.this.response.setLastWrite(nBytes);
                        InternalNioOutputBuffer.this.leftover.recycle();
                        InternalNioOutputBuffer.this.semaphore.release();
                        if (!InternalNioOutputBuffer.this.processor.isProcessing() && InternalNioOutputBuffer.this.processor.getWriteNotification() && !InternalNioOutputBuffer.this.endpoint.processChannel(attachment, SocketStatus.OPEN_WRITE)) {
                            InternalNioOutputBuffer.this.endpoint.closeChannel(attachment);
                        }
                        return;
                    }
                }
                attachment.write(InternalNioOutputBuffer.this.bbuf, InternalNioOutputBuffer.this.writeTimeout, TimeUnit.MILLISECONDS, attachment, this);
            }

            @Override
            public void failed(Throwable exc, NioChannel attachment) {
                InternalNioOutputBuffer.this.processor.getResponse().setErrorException(exc);
                InternalNioOutputBuffer.this.endpoint.removeEventChannel(attachment);
                InternalNioOutputBuffer.this.semaphore.release();
                if (!InternalNioOutputBuffer.this.endpoint.processChannel(attachment, SocketStatus.ERROR)) {
                    InternalNioOutputBuffer.this.endpoint.closeChannel(attachment);
                }
            }
        };
    }

    public void setChannel(NioChannel channel) {
        this.channel = channel;
    }

    public NioChannel getChannel() {
        return this.channel;
    }

    private void close(NioChannel channel) {
        this.endpoint.closeChannel(channel);
    }

    private int blockingWrite(long timeout, TimeUnit unit) {
        int nw;
        block3: {
            nw = 0;
            try {
                nw = this.channel.writeBytes(this.bbuf, timeout, unit);
                if (nw < 0) {
                    this.close(this.channel);
                }
            }
            catch (Throwable t) {
                if (!CoyoteLogger.HTTP_LOGGER.isDebugEnabled()) break block3;
                CoyoteLogger.HTTP_LOGGER.errorWithBlockingWrite(t);
            }
        }
        return nw;
    }

    protected int write(long timeout, TimeUnit unit) {
        return this.blockingWrite(timeout, unit);
    }

    public void sendAck() throws Exception {
        if (!this.committed) {
            this.bbuf.clear();
            this.bbuf.put(org.apache.coyote.http11.Constants.ACK_BYTES).flip();
            if (this.write(this.writeTimeout, TimeUnit.MILLISECONDS) < 0) {
                throw new IOException(CoyoteMessages.MESSAGES.failedWrite());
            }
        }
    }

    @Override
    public int doWrite(ByteChunk chunk, Response res) throws IOException {
        if (!this.committed) {
            this.response.action(ActionCode.ACTION_COMMIT, null);
        }
        if (this.lastActiveFilter == -1) {
            return this.outputBuffer.doWrite(chunk, res);
        }
        return this.activeFilters[this.lastActiveFilter].doWrite(chunk, res);
    }

    protected void flushBuffer() throws IOException {
        int res = 0;
        if (!this.nonBlocking && this.bbuf.position() > 0) {
            this.bbuf.flip();
            while (this.bbuf.hasRemaining() && (res = this.blockingWrite(this.writeTimeout, TimeUnit.MILLISECONDS)) > 0) {
            }
            this.response.setLastWrite(res);
            this.clearBuffer();
            if (res < 0) {
                throw new IOException(CoyoteMessages.MESSAGES.failedWrite());
            }
        }
    }

    public void setNonBlocking(boolean nonBlocking) {
        this.nonBlocking = nonBlocking;
    }

    public boolean getNonBlocking() {
        return this.nonBlocking;
    }

    public void addFilter(OutputFilter filter) {
        OutputFilter[] newFilterLibrary = new OutputFilter[this.filterLibrary.length + 1];
        for (int i = 0; i < this.filterLibrary.length; ++i) {
            newFilterLibrary[i] = this.filterLibrary[i];
        }
        newFilterLibrary[this.filterLibrary.length] = filter;
        this.filterLibrary = newFilterLibrary;
        this.activeFilters = new OutputFilter[this.filterLibrary.length];
    }

    public OutputFilter[] getFilters() {
        return this.filterLibrary;
    }

    public void clearFilters() {
        this.filterLibrary = new OutputFilter[0];
        this.lastActiveFilter = -1;
    }

    public void addActiveFilter(OutputFilter filter) {
        if (this.lastActiveFilter == -1) {
            filter.setBuffer(this.outputBuffer);
        } else {
            for (int i = 0; i <= this.lastActiveFilter; ++i) {
                if (this.activeFilters[i] != filter) continue;
                return;
            }
            filter.setBuffer(this.activeFilters[this.lastActiveFilter]);
        }
        this.activeFilters[++this.lastActiveFilter] = filter;
        filter.setResponse(this.response);
    }

    public void removeActiveFilters() {
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.lastActiveFilter = -1;
    }

    public void flush() throws IOException {
        if (!this.committed) {
            this.response.action(ActionCode.ACTION_COMMIT, null);
        }
        this.flushBuffer();
    }

    protected void clearBuffer() {
        this.bbuf.clear();
    }

    public void recycle() {
        this.channel = null;
        this.response.recycle();
        this.clearBuffer();
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.committed = false;
        this.finished = false;
    }

    public void nextRequest() {
        this.response.recycle();
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        byte[] leftoverBuf = this.leftover.getBuffer();
        if (leftoverBuf != null && leftoverBuf.length > org.apache.coyote.http11.Constants.ASYNC_BUFFER_SIZE) {
            this.leftover = new ByteChunk();
        } else {
            this.leftover.recycle();
        }
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.committed = false;
        this.finished = false;
        if (this.nonBlocking) {
            this.semaphore.release();
        }
        this.nonBlocking = false;
    }

    public void endRequest() throws IOException {
        if (!this.committed) {
            this.response.action(ActionCode.ACTION_COMMIT, null);
        }
        if (this.finished) {
            return;
        }
        if (this.lastActiveFilter != -1) {
            this.activeFilters[this.lastActiveFilter].end();
        }
        this.flushBuffer();
        this.finished = true;
    }

    public void sendStatus() {
        this.write(org.apache.coyote.http11.Constants.HTTP_11_BYTES);
        this.buf[this.pos++] = 32;
        int status = this.response.getStatus();
        switch (status) {
            case 200: {
                this.write(org.apache.coyote.http11.Constants._200_BYTES);
                break;
            }
            case 400: {
                this.write(org.apache.coyote.http11.Constants._400_BYTES);
                break;
            }
            case 404: {
                this.write(org.apache.coyote.http11.Constants._404_BYTES);
                break;
            }
            default: {
                this.write(status);
            }
        }
        this.buf[this.pos++] = 32;
        String message = null;
        if (Constants.USE_CUSTOM_STATUS_MSG_IN_HEADER) {
            message = this.response.getMessage();
        }
        if (message == null) {
            this.write(HttpMessages.getMessage(status));
        } else {
            this.write(message.replace('\n', ' ').replace('\r', ' '));
        }
        this.buf[this.pos++] = 13;
        this.buf[this.pos++] = 10;
    }

    public void sendHeader(MessageBytes name, MessageBytes value) {
        if (name.getLength() > 0 && !value.isNull()) {
            this.write(name);
            this.buf[this.pos++] = 58;
            this.buf[this.pos++] = 32;
            this.write(value);
            this.buf[this.pos++] = 13;
            this.buf[this.pos++] = 10;
        }
    }

    public void sendHeader(ByteChunk name, ByteChunk value) {
        this.write(name);
        this.buf[this.pos++] = 58;
        this.buf[this.pos++] = 32;
        this.write(value);
        this.buf[this.pos++] = 13;
        this.buf[this.pos++] = 10;
    }

    public void sendHeader(String name, String value) {
        this.write(name);
        this.buf[this.pos++] = 58;
        this.buf[this.pos++] = 32;
        this.write(value);
        this.buf[this.pos++] = 13;
        this.buf[this.pos++] = 10;
    }

    public void endHeaders() {
        this.buf[this.pos++] = 13;
        this.buf[this.pos++] = 10;
    }

    protected void commit() throws IOException {
        this.committed = true;
        this.response.setCommitted(true);
        if (this.pos > 0) {
            this.bbuf.put(this.buf, 0, this.pos);
        }
    }

    protected void write(MessageBytes mb) {
        if (mb == null) {
            return;
        }
        switch (mb.getType()) {
            case 2: {
                this.write(mb.getByteChunk());
                break;
            }
            case 3: {
                this.write(mb.getCharChunk());
                break;
            }
            default: {
                this.write(mb.toString());
            }
        }
    }

    protected void write(ByteChunk bc) {
        int length = bc.getLength();
        System.arraycopy(bc.getBytes(), bc.getStart(), this.buf, this.pos, length);
        this.pos += length;
    }

    protected void write(CharChunk cc) {
        int start = cc.getStart();
        int end = cc.getEnd();
        char[] cbuf = cc.getBuffer();
        for (int i = start; i < end; ++i) {
            int c = cbuf[i];
            if (c <= 31 && c != 9 || c == 127 || c > 255) {
                c = 32;
            }
            this.buf[this.pos++] = (byte)c;
        }
    }

    public void write(byte[] b) {
        System.arraycopy(b, 0, this.buf, this.pos, b.length);
        this.pos += b.length;
    }

    protected void write(String s) {
        if (s == null) {
            return;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            int c = s.charAt(i);
            if (c <= 31 && c != 9 || c == 127 || c > 255) {
                c = 32;
            }
            this.buf[this.pos++] = (byte)c;
        }
    }

    protected void write(int i) {
        this.write(String.valueOf(i));
    }

    class OutputBufferImpl
    implements OutputBuffer {
        OutputBufferImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int doWrite(ByteChunk chunk, Response res) throws IOException {
            if (InternalNioOutputBuffer.this.nonBlocking) {
                if (InternalNioOutputBuffer.this.leftover.getLength() > org.apache.coyote.http11.Constants.ASYNC_BUFFER_SIZE && InternalNioOutputBuffer.this.response.getFlushLeftovers() && Http11AbstractProcessor.containerThread.get() == Boolean.TRUE) {
                    try {
                        if (InternalNioOutputBuffer.this.semaphore.tryAcquire(InternalNioOutputBuffer.this.writeTimeout, TimeUnit.MILLISECONDS)) {
                            InternalNioOutputBuffer.this.semaphore.release();
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                CompletionHandler e = InternalNioOutputBuffer.this.completionHandler;
                synchronized (e) {
                    block15: {
                        InternalNioOutputBuffer.this.leftover.append(chunk);
                        if (InternalNioOutputBuffer.this.leftover.getLength() > org.apache.coyote.http11.Constants.ASYNC_BUFFER_SIZE) {
                            InternalNioOutputBuffer.this.response.setLastWrite(0);
                        }
                        if (InternalNioOutputBuffer.this.semaphore.tryAcquire()) {
                            int n = Math.min(InternalNioOutputBuffer.this.leftover.getLength(), InternalNioOutputBuffer.this.bbuf.capacity() - InternalNioOutputBuffer.this.bbuf.position());
                            InternalNioOutputBuffer.this.bbuf.put(InternalNioOutputBuffer.this.leftover.getBuffer(), InternalNioOutputBuffer.this.leftover.getOffset(), n).flip();
                            InternalNioOutputBuffer.this.leftover.setOffset(InternalNioOutputBuffer.this.leftover.getOffset() + n);
                            try {
                                InternalNioOutputBuffer.this.channel.write(InternalNioOutputBuffer.this.bbuf, InternalNioOutputBuffer.this.writeTimeout, TimeUnit.MILLISECONDS, InternalNioOutputBuffer.this.channel, InternalNioOutputBuffer.this.completionHandler);
                            }
                            catch (Exception e2) {
                                InternalNioOutputBuffer.this.processor.getResponse().setErrorException(e2);
                                if (!CoyoteLogger.HTTP_LOGGER.isDebugEnabled()) break block15;
                                CoyoteLogger.HTTP_LOGGER.errorWithNonBlockingWrite(e2);
                            }
                        }
                    }
                }
            }
            int len = chunk.getLength();
            int start = chunk.getStart();
            byte[] b = chunk.getBuffer();
            while (len > 0) {
                int thisTime = len;
                if (!InternalNioOutputBuffer.this.bbuf.hasRemaining()) {
                    InternalNioOutputBuffer.this.flushBuffer();
                }
                if (thisTime > InternalNioOutputBuffer.this.bbuf.remaining()) {
                    thisTime = InternalNioOutputBuffer.this.bbuf.remaining();
                }
                InternalNioOutputBuffer.this.bbuf.put(b, start, thisTime);
                len -= thisTime;
                start += thisTime;
            }
            return chunk.getLength();
        }
    }
}

