/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.tomcat.util.net.jsse.openssl.OpenSSLCipherConfigurationParser;

public final class JSSEUtils {
    public static String[] getEnabledCiphers(String[] cipherSuites, String[] supportedCiphers) {
        return JSSEUtils.resolveEnabledCipherSuite(cipherSuites, new HashSet<String>(Arrays.asList(supportedCiphers)));
    }

    static String[] resolveEnabledCipherSuite(String[] cipherSuites, Set<String> supportedCiphers) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (cipherSuites.length == 1) {
            List<String> enabledCiphers = OpenSSLCipherConfigurationParser.parseExpression(cipherSuites[0]);
            for (String enabledCipher : enabledCiphers) {
                if (!supportedCiphers.contains(enabledCipher)) continue;
                result.add(enabledCipher);
            }
        } else {
            for (String enabledCipher : cipherSuites) {
                if (!supportedCiphers.contains(enabledCipher)) continue;
                result.add(enabledCipher);
            }
        }
        return result.toArray(new String[result.size()]);
    }
}

