/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.modeler.modules;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.modeler.modules.ModelerSource;
import org.jboss.web.CoyoteLogger;
import org.jboss.web.CoyoteMessages;

public class MbeansDescriptorsSerSource
extends ModelerSource {
    Registry registry;
    String location;
    String type;
    Object source;
    List mbeans = new ArrayList();

    public void setRegistry(Registry reg) {
        this.registry = reg;
    }

    public void setLocation(String loc) {
        this.location = loc;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    @Override
    public List loadDescriptors(Registry registry, String location, String type, Object source) throws Exception {
        this.setRegistry(registry);
        this.setLocation(location);
        this.setType(type);
        this.setSource(source);
        this.execute();
        return this.mbeans;
    }

    public void execute() throws Exception {
        if (this.registry == null) {
            this.registry = Registry.getRegistry();
        }
        long t1 = System.currentTimeMillis();
        try {
            InputStream stream = null;
            if (this.source instanceof URL) {
                stream = ((URL)this.source).openStream();
            }
            if (this.source instanceof InputStream) {
                stream = (InputStream)this.source;
            }
            if (stream == null) {
                throw CoyoteMessages.MESSAGES.invalidSource(this.source);
            }
            ObjectInputStream ois = new ObjectInputStream(stream);
            Thread.currentThread().setContextClassLoader(ManagedBean.class.getClassLoader());
            Object obj = ois.readObject();
            ManagedBean[] beans = (ManagedBean[])obj;
            for (int i = 0; i < beans.length; ++i) {
                this.mbeans.add(beans[i]);
            }
        }
        catch (Exception ex) {
            CoyoteLogger.MODELER_LOGGER.errorReadingDescriptors(ex);
            throw ex;
        }
        long t2 = System.currentTimeMillis();
        CoyoteLogger.MODELER_LOGGER.debug("Reading descriptors ( ser ) " + (t2 - t1));
    }
}

