/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.servlet.http.Part;
import org.apache.catalina.deploy.Multipart;
import org.apache.tomcat.util.http.fileupload.FileItem;
import org.apache.tomcat.util.http.fileupload.disk.DiskFileItem;

public class StandardPart
implements Part {
    private FileItem fileItem;
    private Multipart config;

    public StandardPart(FileItem fileItem, Multipart config) {
        this.fileItem = fileItem;
        this.config = config;
    }

    public void delete() throws IOException {
        this.fileItem.delete();
    }

    public String getContentType() {
        return this.fileItem.getContentType();
    }

    public String getHeader(String name) {
        if (this.fileItem instanceof DiskFileItem) {
            return ((DiskFileItem)this.fileItem).getHeaders().getHeader(name);
        }
        return null;
    }

    public Collection<String> getHeaderNames() {
        if (this.fileItem instanceof DiskFileItem) {
            HashSet<String> headerNames = new HashSet<String>();
            Iterator<String> iter = ((DiskFileItem)this.fileItem).getHeaders().getHeaderNames();
            while (iter.hasNext()) {
                headerNames.add(iter.next());
            }
            return headerNames;
        }
        return Collections.emptyList();
    }

    public Collection<String> getHeaders(String name) {
        if (this.fileItem instanceof DiskFileItem) {
            HashSet<String> headers = new HashSet<String>();
            Iterator<String> iter = ((DiskFileItem)this.fileItem).getHeaders().getHeaders(name);
            while (iter.hasNext()) {
                headers.add(iter.next());
            }
            return headers;
        }
        return Collections.emptyList();
    }

    public InputStream getInputStream() throws IOException {
        return this.fileItem.getInputStream();
    }

    public String getName() {
        return this.fileItem.getFieldName();
    }

    public long getSize() {
        return this.fileItem.getSize();
    }

    public void write(String fileName) throws IOException {
        File file = new File(fileName);
        if (!file.isAbsolute()) {
            file = new File(this.config.getLocation(), fileName);
        }
        try {
            this.fileItem.write(file);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

