/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.nio.channels.CompletionHandler;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Request;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.Response;
import org.apache.coyote.http11.Constants;
import org.apache.coyote.http11.Http11AbstractProcessor;
import org.apache.coyote.http11.InputFilter;
import org.apache.coyote.http11.InternalNioInputBuffer;
import org.apache.coyote.http11.InternalNioOutputBuffer;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.BufferedInputFilter;
import org.apache.coyote.http11.filters.ChunkedInputFilter;
import org.apache.coyote.http11.filters.ChunkedOutputFilter;
import org.apache.coyote.http11.filters.GzipOutputFilter;
import org.apache.coyote.http11.filters.IdentityInputFilter;
import org.apache.coyote.http11.filters.IdentityOutputFilter;
import org.apache.coyote.http11.filters.SavedRequestInputFilter;
import org.apache.coyote.http11.filters.VoidInputFilter;
import org.apache.coyote.http11.filters.VoidOutputFilter;
import org.apache.coyote.http11.upgrade.servlet31.WriteListener;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.jboss.web.CoyoteLogger;

public class Http11NioProcessor
extends Http11AbstractProcessor {
    protected InternalNioInputBuffer inputBuffer = null;
    protected InternalNioOutputBuffer outputBuffer = null;
    protected NioEndpoint.SendfileData sendfileData = null;
    protected NioChannel channel;
    protected NioEndpoint endpoint;

    public Http11NioProcessor(int headerBufferSize, NioEndpoint endpoint) {
        this.endpoint = endpoint;
        this.request = new Request();
        this.inputBuffer = new InternalNioInputBuffer(this, this.request, headerBufferSize, endpoint);
        this.request.setInputBuffer(this.inputBuffer);
        if (endpoint.getUseSendfile()) {
            this.request.setSendfile(true);
        }
        this.response = new Response();
        this.response.setHook(this);
        this.outputBuffer = new InternalNioOutputBuffer(this, this.response, headerBufferSize, endpoint);
        this.response.setOutputBuffer(this.outputBuffer);
        this.request.setResponse(this.response);
        this.sslEnabled = endpoint.getSSLEnabled();
        this.initializeFilters();
        int foo = HexUtils.DEC[0];
        FastHttpDateFormat.getCurrentDate();
    }

    public void startProcessing() {
        this.processing = true;
    }

    public void endProcessing() {
        this.processing = false;
    }

    public boolean isAvailable() {
        return this.inputBuffer.available();
    }

    public boolean isProcessing() {
        return this.processing;
    }

    @Override
    protected void addFilter(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Object obj = clazz.newInstance();
            if (obj instanceof InputFilter) {
                this.inputBuffer.addFilter((InputFilter)obj);
            } else if (obj instanceof OutputFilter) {
                this.outputBuffer.addFilter((OutputFilter)obj);
            } else {
                CoyoteLogger.HTTP_LOGGER.unknownFilter(className);
            }
        }
        catch (Exception e) {
            CoyoteLogger.HTTP_LOGGER.errorInitializingFilter(className, e);
        }
    }

    @Override
    protected String[] addStringArray(String[] sArray, String value) {
        String[] result = null;
        if (sArray == null) {
            result = new String[]{value};
        } else {
            result = new String[sArray.length + 1];
            System.arraycopy(sArray, 0, result, 0, sArray.length);
            result[sArray.length] = value;
        }
        return result;
    }

    private void setChannel(NioChannel channel) {
        this.channel = channel;
        this.inputBuffer.setChannel(channel);
        this.outputBuffer.setChannel(channel);
    }

    @Override
    public NioEndpoint.Handler.SocketState event(SocketStatus status) throws IOException {
        RequestInfo rp = this.request.getRequestProcessor();
        try {
            if (status == SocketStatus.OPEN_WRITE) {
                this.writeNotification = false;
                this.response.setFlushLeftovers(true);
            } else if (status == SocketStatus.OPEN_CALLBACK) {
                this.resumeNotification = false;
            } else if (status == SocketStatus.ERROR) {
                this.error = true;
            }
            containerThread.set(Boolean.TRUE);
            rp.setStage(3);
            this.error = !this.adapter.event(this.request, this.response, status);
        }
        catch (InterruptedIOException e) {
            this.error = true;
        }
        catch (Throwable t) {
            CoyoteLogger.HTTP_LOGGER.errorProcessingRequest(t);
            this.response.setStatus(500);
            this.error = true;
        }
        rp.setStage(7);
        if (this.error) {
            this.inputBuffer.nextRequest();
            this.outputBuffer.nextRequest();
            this.recycle();
            return NioEndpoint.Handler.SocketState.CLOSED;
        }
        if (!this.event) {
            this.endRequest();
            boolean pipelined = this.inputBuffer.nextRequest();
            this.outputBuffer.nextRequest();
            this.recycle();
            return pipelined || !this.keepAlive ? NioEndpoint.Handler.SocketState.CLOSED : NioEndpoint.Handler.SocketState.OPEN;
        }
        return NioEndpoint.Handler.SocketState.LONG;
    }

    public NioEndpoint.Handler.SocketState process(NioChannel channel) throws IOException {
        RequestInfo rp = this.request.getRequestProcessor();
        rp.setStage(1);
        this.reset();
        this.setChannel(channel);
        int keepAliveLeft = this.maxKeepAliveRequests;
        int soTimeout = this.endpoint.getSoTimeout();
        boolean keptAlive = false;
        boolean openChannel = false;
        while (!this.error && this.keepAlive && !this.event) {
            try {
                if (!this.disableUploadTimeout && keptAlive && soTimeout > 0) {
                    this.endpoint.setSoTimeout(soTimeout * 1000);
                }
                if (!this.inputBuffer.parseRequestLine(keptAlive)) {
                    NioChannel ch = channel;
                    ch.awaitRead(soTimeout, TimeUnit.MILLISECONDS, ch, new CompletionHandler<Integer, NioChannel>(){

                        @Override
                        public void completed(Integer nBytes, NioChannel attachment) {
                            if (nBytes < 0) {
                                this.failed((Throwable)null, attachment);
                            } else if (!Http11NioProcessor.this.endpoint.processChannel(attachment, null)) {
                                Http11NioProcessor.this.closeChannel(attachment);
                            }
                        }

                        @Override
                        public void failed(Throwable exc, NioChannel attachment) {
                            Http11NioProcessor.this.closeChannel(attachment);
                        }
                    });
                    openChannel = true;
                    break;
                }
                this.request.setStartTime(System.currentTimeMillis());
                keptAlive = true;
                if (!this.disableUploadTimeout) {
                    this.endpoint.setSoTimeout(this.timeout * 1000);
                }
                this.inputBuffer.parseHeaders();
            }
            catch (IOException e) {
                this.error = true;
                break;
            }
            catch (Throwable t) {
                CoyoteLogger.HTTP_LOGGER.errorParsingHeader(t);
                this.response.setStatus(400);
                this.error = true;
            }
            rp.setStage(2);
            try {
                this.prepareRequest();
            }
            catch (Throwable t) {
                CoyoteLogger.HTTP_LOGGER.errorPreparingRequest(t);
                this.response.setStatus(500);
                this.error = true;
            }
            if (this.maxKeepAliveRequests > 0 && --keepAliveLeft == 0) {
                this.keepAlive = false;
            }
            if (!this.error) {
                try {
                    rp.setStage(3);
                    this.adapter.service(this.request, this.response);
                    if (this.keepAlive && !this.error) {
                        this.error = this.response.getErrorException() != null || this.statusDropsConnection(this.response.getStatus());
                    }
                }
                catch (InterruptedIOException e) {
                    this.error = true;
                }
                catch (Throwable t) {
                    CoyoteLogger.HTTP_LOGGER.errorProcessingRequest(t);
                    this.response.setStatus(500);
                    this.error = true;
                }
            }
            if (this.error) {
                this.inputBuffer.setSwallowInput(false);
            }
            if (!this.event) {
                this.endRequest();
            }
            if (this.error) {
                this.response.setStatus(500);
            }
            this.request.updateCounters();
            boolean pipelined = false;
            if (!this.event) {
                pipelined = this.inputBuffer.nextRequest();
                this.outputBuffer.nextRequest();
            }
            if (this.sendfileData != null && !this.error) {
                this.sendfileData.setChannel(channel);
                this.sendfileData.setKeepAlive(this.keepAlive && !pipelined);
                if (!this.endpoint.addSendfileData(this.sendfileData)) {
                    if (this.sendfileData.getChannel() == null) {
                        this.error = true;
                        break;
                    }
                    openChannel = true;
                    break;
                }
            }
            rp.setStage(6);
        }
        rp.setStage(7);
        if (this.event) {
            if (this.error) {
                this.inputBuffer.nextRequest();
                this.outputBuffer.nextRequest();
                this.recycle();
                return NioEndpoint.Handler.SocketState.CLOSED;
            }
            return NioEndpoint.Handler.SocketState.LONG;
        }
        this.recycle();
        return openChannel ? NioEndpoint.Handler.SocketState.OPEN : NioEndpoint.Handler.SocketState.CLOSED;
    }

    @Override
    public void endRequest() {
        try {
            this.inputBuffer.endRequest();
        }
        catch (IOException e) {
            this.error = true;
        }
        catch (Throwable t) {
            CoyoteLogger.HTTP_LOGGER.errorFinishingRequest(t);
            this.response.setStatus(500);
            this.error = true;
        }
        try {
            this.outputBuffer.endRequest();
        }
        catch (IOException e) {
            this.error = true;
        }
        catch (Throwable t) {
            CoyoteLogger.HTTP_LOGGER.errorFinishingResponse(t);
            this.error = true;
        }
    }

    @Override
    public void recycle() {
        this.inputBuffer.recycle();
        this.outputBuffer.recycle();
        this.channel = null;
        super.recycle();
    }

    private void commit(Object param) {
        if (!this.response.isCommitted()) {
            this.prepareResponse();
            try {
                this.outputBuffer.commit();
            }
            catch (IOException e) {
                this.error = true;
            }
        }
    }

    private void sendAck(Object param) {
        if (this.response.isCommitted() || !this.expectation) {
            return;
        }
        this.inputBuffer.setSwallowInput(true);
        try {
            this.outputBuffer.sendAck();
        }
        catch (Exception e) {
            this.error = true;
        }
    }

    private void flush() {
        try {
            this.outputBuffer.flush();
        }
        catch (IOException e) {
            this.error = true;
            this.response.setErrorException(e);
        }
    }

    private void close() {
        this.event = false;
        try {
            this.outputBuffer.endRequest();
        }
        catch (IOException e) {
            this.error = true;
        }
    }

    private void closeChannel(NioChannel ch) {
        this.endpoint.closeChannel(ch);
    }

    private void requestHostAddressAttr() {
        if (this.remoteAddr == null && this.channel != null) {
            try {
                this.remoteAddr = ((InetSocketAddress)this.channel.getRemoteAddress()).getAddress().getHostAddress();
            }
            catch (Exception e) {
                CoyoteLogger.HTTP_LOGGER.errorGettingSocketInformation(e);
            }
        }
        this.request.remoteAddr().setString(this.remoteAddr);
    }

    private void requestLocalNameAttr() {
        if (this.localName == null && this.channel != null) {
            try {
                this.localName = ((InetSocketAddress)this.channel.getLocalAddress()).getHostName();
            }
            catch (Exception e) {
                CoyoteLogger.HTTP_LOGGER.errorGettingSocketInformation(e);
            }
        }
        this.request.localName().setString(this.localName);
    }

    private void requestHostAttribute() {
        if (this.remoteHost == null && this.channel != null) {
            try {
                this.remoteHost = ((InetSocketAddress)this.channel.getRemoteAddress()).getHostName();
                if (this.remoteHost == null) {
                    this.remoteHost = this.remoteAddr = ((InetSocketAddress)this.channel.getRemoteAddress()).getAddress().getHostAddress();
                }
            }
            catch (Exception e) {
                CoyoteLogger.HTTP_LOGGER.errorGettingSocketInformation(e);
            }
        }
        this.request.remoteHost().setString(this.remoteHost);
    }

    private void requestLocalHostAddressAttr() {
        if (this.localAddr == null && this.channel != null) {
            try {
                this.localAddr = ((InetSocketAddress)this.channel.getLocalAddress()).getAddress().getHostAddress();
            }
            catch (Exception e) {
                CoyoteLogger.HTTP_LOGGER.errorGettingSocketInformation(e);
            }
        }
        this.request.localAddr().setString(this.localAddr);
    }

    private void requestRemotePortAttr() {
        if (this.remotePort == -1 && this.channel != null) {
            try {
                this.remotePort = ((InetSocketAddress)this.channel.getRemoteAddress()).getPort();
            }
            catch (Exception e) {
                CoyoteLogger.HTTP_LOGGER.errorGettingSocketInformation(e);
            }
        }
        this.request.setRemotePort(this.remotePort);
    }

    private void requestLocalPortAttr() {
        if (this.localPort == -1 && this.channel != null) {
            try {
                this.localPort = ((InetSocketAddress)this.channel.getLocalAddress()).getPort();
            }
            catch (Exception e) {
                CoyoteLogger.HTTP_LOGGER.errorGettingSocketInformation(e);
            }
        }
        this.request.setLocalPort(this.localPort);
    }

    private void requestSSLAttr() {
        try {
            if (this.sslSupport != null) {
                Object sslO = this.sslSupport.getCipherSuite();
                if (sslO != null) {
                    this.request.setAttribute("javax.servlet.request.cipher_suite", sslO);
                }
                if ((sslO = this.sslSupport.getPeerCertificateChain(false)) != null) {
                    this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                }
                if ((sslO = this.sslSupport.getKeySize()) != null) {
                    this.request.setAttribute("javax.servlet.request.key_size", sslO);
                }
                if ((sslO = this.sslSupport.getSessionId()) != null) {
                    this.request.setAttribute("javax.servlet.request.ssl_session_id", sslO);
                }
            }
        }
        catch (Exception e) {
            CoyoteLogger.HTTP_LOGGER.errorGettingSslAttributes(e);
        }
    }

    private void requestSSLCertificate() {
        if (this.sslSupport != null) {
            if (this.maxSavePostSize != 0) {
                BufferedInputFilter buffredInputFilter = new BufferedInputFilter();
                buffredInputFilter.setLimit(this.maxSavePostSize);
                this.inputBuffer.addActiveFilter(buffredInputFilter);
            }
            try {
                Object[] sslO = this.sslSupport.getPeerCertificateChain(true);
                if (sslO != null) {
                    this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                }
            }
            catch (Exception e) {
                CoyoteLogger.HTTP_LOGGER.errorGettingSslAttributes(e);
            }
        }
    }

    private void requestSetBodyReplay(Object param) {
        ByteChunk body = (ByteChunk)param;
        SavedRequestInputFilter savedBody = new SavedRequestInputFilter(body);
        savedBody.setRequest(this.request);
        InternalNioInputBuffer internalBuffer = (InternalNioInputBuffer)this.request.getInputBuffer();
        internalBuffer.addActiveFilter(savedBody);
    }

    private void beginEvent(Object param) {
        this.event = true;
        if (param == Boolean.TRUE) {
            this.outputBuffer.setNonBlocking(true);
            this.inputBuffer.setNonBlocking(true);
            this.readNotifications = true;
        }
    }

    private void endEvent(Object param) {
        this.event = false;
        if (this.outputBuffer.getNonBlocking()) {
            this.outputBuffer.setNonBlocking(false);
            this.inputBuffer.setNonBlocking(false);
        }
    }

    private synchronized void resumeEvent(Object param, boolean read) {
        if (read) {
            this.readNotifications = true;
        }
        if (!this.processing && !this.resumeNotification) {
            this.endpoint.addEventChannel(this.channel, this.keepAliveTimeout, false, false, true, true);
        }
        this.resumeNotification = true;
    }

    private synchronized void writeEvent(Object param) {
        if (!this.processing && !this.writeNotification) {
            this.endpoint.addEventChannel(this.channel, this.timeout, false, true, false, true);
        }
        this.writeNotification = true;
    }

    private void suspendEvent() {
        this.readNotifications = false;
    }

    private void timeoutEvent(Object param) {
        this.timeout = (Integer)param;
    }

    private void makeAvailable() {
        this.inputBuffer.useAvailable();
    }

    @Override
    public void action(ActionCode actionCode, Object param) {
        if (actionCode == ActionCode.ACTION_COMMIT) {
            this.commit(param);
        } else if (actionCode == ActionCode.ACTION_ACK) {
            this.sendAck(param);
        } else if (actionCode == ActionCode.ACTION_CLIENT_FLUSH) {
            this.flush();
        } else if (actionCode == ActionCode.ACTION_CLOSE) {
            this.close();
        } else if (actionCode != ActionCode.ACTION_CUSTOM) {
            if (actionCode == ActionCode.ACTION_REQ_HOST_ADDR_ATTRIBUTE) {
                this.requestHostAddressAttr();
            } else if (actionCode == ActionCode.ACTION_REQ_LOCAL_NAME_ATTRIBUTE) {
                this.requestLocalNameAttr();
            } else if (actionCode == ActionCode.ACTION_REQ_HOST_ATTRIBUTE) {
                this.requestHostAttribute();
            } else if (actionCode == ActionCode.ACTION_REQ_LOCAL_ADDR_ATTRIBUTE) {
                this.requestLocalHostAddressAttr();
            } else if (actionCode == ActionCode.ACTION_REQ_REMOTEPORT_ATTRIBUTE) {
                this.requestRemotePortAttr();
            } else if (actionCode == ActionCode.ACTION_REQ_LOCALPORT_ATTRIBUTE) {
                this.requestLocalPortAttr();
            } else if (actionCode == ActionCode.ACTION_REQ_SSL_ATTRIBUTE) {
                this.requestSSLAttr();
            } else if (actionCode == ActionCode.ACTION_REQ_SSL_CERTIFICATE) {
                this.requestSSLCertificate();
            } else if (actionCode == ActionCode.ACTION_REQ_SET_BODY_REPLAY) {
                this.requestSetBodyReplay(param);
            } else if (actionCode == ActionCode.ACTION_AVAILABLE) {
                this.makeAvailable();
            } else if (actionCode == ActionCode.ACTION_EVENT_BEGIN) {
                this.beginEvent(param);
            } else if (actionCode == ActionCode.ACTION_EVENT_END) {
                this.endEvent(param);
            } else if (actionCode == ActionCode.ACTION_EVENT_SUSPEND) {
                this.suspendEvent();
            } else if (actionCode == ActionCode.ACTION_EVENT_RESUME) {
                this.resumeEvent(param, true);
            } else if (actionCode == ActionCode.ACTION_EVENT_WAKEUP) {
                this.resumeEvent(param, false);
            } else if (actionCode == ActionCode.ACTION_EVENT_WRITE) {
                this.writeEvent(param);
            } else if (actionCode == ActionCode.ACTION_EVENT_TIMEOUT) {
                this.timeoutEvent(param);
            } else if (actionCode == ActionCode.ACTION_EVENT_READ_BEGIN) {
                this.inputBuffer.setNonBlocking(true);
                this.readNotifications = true;
            } else if (actionCode == ActionCode.ACTION_EVENT_WRITE_BEGIN) {
                this.outputBuffer.setNonBlocking(true);
                this.outputBuffer.setWriteListener((WriteListener)param);
                this.writeEvent(param);
            } else if (actionCode == ActionCode.UPGRADE) {
                this.inputBuffer.removeActiveFilters();
                this.outputBuffer.removeActiveFilters();
            }
        }
    }

    @Override
    protected void prepareRequest() {
        long contentLength;
        ByteChunk uriBC;
        MessageBytes userAgentValueMB;
        MessageBytes protocolMB;
        this.http11 = true;
        this.http09 = false;
        this.contentDelimitation = false;
        this.expectation = false;
        this.sendfileData = null;
        if (this.sslEnabled) {
            this.request.scheme().setString("https");
        }
        if ((protocolMB = this.request.protocol()).equals("HTTP/1.1")) {
            this.http11 = true;
            protocolMB.setString("HTTP/1.1");
        } else if (protocolMB.equals("HTTP/1.0")) {
            this.http11 = false;
            this.keepAlive = false;
            protocolMB.setString("HTTP/1.0");
        } else if (protocolMB.equals("")) {
            this.http09 = true;
            this.http11 = false;
            this.keepAlive = false;
        } else {
            this.http11 = false;
            this.error = true;
            this.response.setStatus(505);
        }
        MessageBytes methodMB = this.request.method();
        if (methodMB.equals("GET")) {
            methodMB.setString("GET");
        } else if (methodMB.equals("POST")) {
            methodMB.setString("POST");
        }
        MimeHeaders headers = this.request.getMimeHeaders();
        MessageBytes connectionValueMB = headers.getValue("connection");
        if (connectionValueMB != null) {
            ByteChunk connectionValueBC = connectionValueMB.getByteChunk();
            if (this.findBytes(connectionValueBC, Constants.CLOSE_BYTES) != -1) {
                this.keepAlive = false;
            } else if (this.findBytes(connectionValueBC, Constants.KEEPALIVE_BYTES) != -1) {
                this.keepAlive = true;
            }
        }
        MessageBytes expectMB = null;
        if (this.http11) {
            expectMB = headers.getValue("expect");
        }
        if (expectMB != null && expectMB.indexOfIgnoreCase("100-continue", 0) != -1) {
            this.inputBuffer.setSwallowInput(false);
            this.expectation = true;
        }
        if (this.restrictedUserAgents != null && (this.http11 || this.keepAlive) && (userAgentValueMB = headers.getValue("user-agent")) != null) {
            String userAgentValue = userAgentValueMB.toString();
            for (int i = 0; i < this.restrictedUserAgents.length; ++i) {
                if (!this.restrictedUserAgents[i].matcher(userAgentValue).matches()) continue;
                this.http11 = false;
                this.keepAlive = false;
                break;
            }
        }
        if ((uriBC = this.request.requestURI().getByteChunk()).startsWithIgnoreCase("http", 0)) {
            int pos = uriBC.indexOf("://", 0, 3, 4);
            int uriBCStart = uriBC.getStart();
            int slashPos = -1;
            if (pos != -1) {
                byte[] uriB = uriBC.getBytes();
                slashPos = uriBC.indexOf('/', pos + 3);
                if (slashPos == -1) {
                    slashPos = uriBC.getLength();
                    this.request.requestURI().setBytes(uriB, uriBCStart + pos + 1, 1);
                } else {
                    this.request.requestURI().setBytes(uriB, uriBCStart + slashPos, uriBC.getLength() - slashPos);
                }
                MessageBytes hostMB = headers.setValue("host");
                hostMB.setBytes(uriB, uriBCStart + pos + 3, slashPos - pos - 3);
            }
        }
        InputFilter[] inputFilters = this.inputBuffer.getFilters();
        MessageBytes transferEncodingValueMB = null;
        if (this.http11) {
            transferEncodingValueMB = headers.getValue("transfer-encoding");
        }
        if (transferEncodingValueMB != null) {
            String transferEncodingValue = transferEncodingValueMB.toString();
            int startPos = 0;
            int commaPos = transferEncodingValue.indexOf(44);
            String encodingName = null;
            while (commaPos != -1) {
                encodingName = transferEncodingValue.substring(startPos, commaPos).toLowerCase(Locale.ENGLISH).trim();
                if (!this.addInputFilter(inputFilters, encodingName)) {
                    this.error = true;
                    this.response.setStatus(501);
                }
                startPos = commaPos + 1;
                commaPos = transferEncodingValue.indexOf(44, startPos);
            }
            encodingName = transferEncodingValue.substring(startPos).toLowerCase(Locale.ENGLISH).trim();
            if (!this.addInputFilter(inputFilters, encodingName)) {
                this.error = true;
                this.response.setStatus(501);
            }
        }
        if ((contentLength = this.request.getContentLengthLong()) >= 0L) {
            if (this.contentDelimitation) {
                headers.removeHeader("content-length");
                this.request.setContentLength(-1L);
            } else {
                this.inputBuffer.addActiveFilter(inputFilters[0]);
                this.contentDelimitation = true;
            }
        }
        MessageBytes valueMB = headers.getValue("host");
        if (this.http11 && valueMB == null) {
            this.error = true;
            this.response.setStatus(400);
        }
        this.parseHost(valueMB);
        if (!this.contentDelimitation) {
            this.inputBuffer.addActiveFilter(inputFilters[2]);
            this.contentDelimitation = true;
        }
    }

    protected void parseHost(MessageBytes valueMB) {
        if (valueMB == null || valueMB.isNull()) {
            this.request.setServerPort(this.endpoint.getPort());
            return;
        }
        ByteChunk valueBC = valueMB.getByteChunk();
        byte[] valueB = valueBC.getBytes();
        int valueL = valueBC.getLength();
        int valueS = valueBC.getStart();
        int colonPos = -1;
        if (this.hostNameC.length < valueL) {
            this.hostNameC = new char[valueL];
        }
        boolean ipv6 = valueB[valueS] == 91;
        boolean bracketClosed = false;
        for (int i = 0; i < valueL; ++i) {
            char b;
            this.hostNameC[i] = b = (char)valueB[i + valueS];
            if (b == ']') {
                bracketClosed = true;
                continue;
            }
            if (b != ':' || ipv6 && !bracketClosed) continue;
            colonPos = i;
            break;
        }
        if (colonPos < 0) {
            if (!this.sslEnabled) {
                this.request.setServerPort(80);
            } else {
                this.request.setServerPort(443);
            }
            this.request.serverName().setChars(this.hostNameC, 0, valueL);
        } else {
            this.request.serverName().setChars(this.hostNameC, 0, colonPos);
            int port = 0;
            int mult = 1;
            for (int i = valueL - 1; i > colonPos; --i) {
                int charValue = HexUtils.DEC[valueB[i + valueS] & 0xFF];
                if (charValue == -1) {
                    this.error = true;
                    this.response.setStatus(400);
                    break;
                }
                port += charValue * mult;
                mult = 10 * mult;
            }
            this.request.setServerPort(port);
        }
    }

    @Override
    protected void prepareResponse() {
        MessageBytes methodMB;
        boolean entityBody = true;
        this.contentDelimitation = false;
        OutputFilter[] outputFilters = this.outputBuffer.getFilters();
        if (this.http09) {
            this.outputBuffer.addActiveFilter(outputFilters[0]);
            return;
        }
        int statusCode = this.response.getStatus();
        if (statusCode == 204 || statusCode == 205 || statusCode == 304) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            entityBody = false;
            this.contentDelimitation = true;
        }
        if (statusCode >= 100 && statusCode < 200) {
            entityBody = false;
            this.contentDelimitation = true;
        }
        if ((methodMB = this.request.method()).equals("HEAD")) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            this.contentDelimitation = true;
        }
        if (this.response.getSendfilePath() != null && this.endpoint.getUseSendfile()) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            this.contentDelimitation = true;
            this.sendfileData = this.endpoint.getSendfileData();
            this.sendfileData.setFileName(this.response.getSendfilePath());
            this.sendfileData.setStart(this.response.getSendfileStart());
            this.sendfileData.setEnd(this.response.getSendfileEnd());
            this.sendfileData.setKeepAlive(this.keepAlive);
        }
        boolean useCompression = false;
        if (entityBody && this.compressionLevel > 0 && this.sendfileData == null && (useCompression = this.isCompressable())) {
            this.response.setContentLength(-1);
        }
        MimeHeaders headers = this.response.getMimeHeaders();
        if (!entityBody) {
            this.response.setContentLength(-1);
        } else {
            String contentLanguage;
            String contentType = this.response.getContentType();
            if (contentType != null) {
                headers.setValue("Content-Type").setString(contentType);
            }
            if ((contentLanguage = this.response.getContentLanguage()) != null) {
                headers.setValue("Content-Language").setString(contentLanguage);
            }
        }
        long contentLength = this.response.getContentLengthLong();
        boolean connectionClosePresent = false;
        if (Constants.DISABLE_KEEPALIVE_ON_CONCLOSE) {
            connectionClosePresent = this.isConnectionClose(headers);
            boolean bl = this.keepAlive = this.keepAlive && !connectionClosePresent;
        }
        if (contentLength != -1L) {
            headers.setValue("Content-Length").setLong(contentLength);
            this.outputBuffer.addActiveFilter(outputFilters[0]);
            this.contentDelimitation = true;
        } else if (entityBody && this.http11 && (this.keepAlive || CHUNK_ON_CLOSE)) {
            this.outputBuffer.addActiveFilter(outputFilters[1]);
            this.contentDelimitation = true;
            headers.addValue("Transfer-Encoding").setString("chunked");
        } else {
            this.outputBuffer.addActiveFilter(outputFilters[0]);
        }
        if (useCompression) {
            this.outputBuffer.addActiveFilter(outputFilters[3]);
            headers.setValue("Content-Encoding").setString("gzip");
            headers.addValue("Vary").setString("Accept-Encoding");
        }
        headers.setValue("Date").setString(FastHttpDateFormat.getCurrentDate());
        if (entityBody && !this.contentDelimitation) {
            this.keepAlive = false;
        }
        boolean bl = this.keepAlive = this.keepAlive && !this.statusDropsConnection(statusCode);
        if (!this.keepAlive) {
            if (!connectionClosePresent) {
                headers.addValue("Connection").setString("close");
            }
        } else if (!this.http11 && !this.error) {
            headers.addValue("Connection").setString("keep-alive");
        }
        this.outputBuffer.sendStatus();
        if (this.server != null) {
            headers.setValue("Server").setString(this.server);
        } else {
            this.outputBuffer.write(Constants.SERVER_BYTES);
        }
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            this.outputBuffer.sendHeader(headers.getName(i), headers.getValue(i));
        }
        this.outputBuffer.endHeaders();
    }

    private boolean isConnectionClose(MimeHeaders headers) {
        MessageBytes connection = headers.getValue("Connection");
        if (connection == null) {
            return false;
        }
        return connection.equals("close");
    }

    @Override
    protected void initializeFilters() {
        this.inputBuffer.addFilter(new IdentityInputFilter());
        this.outputBuffer.addFilter(new IdentityOutputFilter());
        this.inputBuffer.addFilter(new ChunkedInputFilter());
        this.outputBuffer.addFilter(new ChunkedOutputFilter());
        this.inputBuffer.addFilter(new VoidInputFilter());
        this.outputBuffer.addFilter(new VoidOutputFilter());
        this.outputBuffer.addFilter(new GzipOutputFilter());
    }

    protected boolean addInputFilter(InputFilter[] inputFilters, String encodingName) {
        if (!encodingName.equals("identity")) {
            if (encodingName.equals("chunked")) {
                this.inputBuffer.addActiveFilter(inputFilters[1]);
                this.contentDelimitation = true;
            } else {
                for (int i = 2; i < inputFilters.length; ++i) {
                    if (!inputFilters[i].getEncodingName().toString().equals(encodingName)) continue;
                    this.inputBuffer.addActiveFilter(inputFilters[i]);
                    return true;
                }
                return false;
            }
        }
        return true;
    }
}

