/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web;

import org.jboss.logging.Message;
import org.jboss.logging.MessageBundle;
import org.jboss.logging.Messages;

@MessageBundle(projectCode="JBWEB")
public interface FileUploadMessages {
    public static final FileUploadMessages MESSAGES = (FileUploadMessages)Messages.getBundle(FileUploadMessages.class);

    @Message(id=8200, value="Negative initial size: %s")
    public IllegalArgumentException negativeBufferSize(int var1);

    @Message(id=8201, value="Temporary file prefix is missing")
    public IllegalArgumentException missingTemporaryFilePrefix();

    @Message(id=8202, value="Stream not closed")
    public String streamNotClosed();

    @Message(id=8203, value="Null file")
    public NullPointerException nullFile();

    @Message(id=8204, value="Null path")
    public NullPointerException nullPath();

    @Message(id=8205, value="No new trackers can be added once finished")
    public IllegalStateException cannotAddTrackersOnceFinished();

    @Message(id=8206, value="Deletion failed: %s")
    public String failedToDelete(String var1);

    @Message(id=8207, value="No FileItemFactory has been set")
    public NullPointerException nullFactory();

    @Message(id=8208, value="Processing of %s request failed: %s")
    public String multipartProcessingFailed(String var1, String var2);

    @Message(id=8209, value="Expected headers to be terminated by an empty line")
    public IllegalStateException emptyLineAfterHeaders();

    @Message(id=8210, value="The field %s exceeds its maximum permitted size of %s bytes")
    public String maxFieldSizeExceeded(String var1, long var2);

    @Message(id=8211, value="The stream was already opened")
    public IllegalStateException streamAlreadyOpened();

    @Message(id=8212, value="Null context")
    public NullPointerException nullContext();

    @Message(id=8213, value="The request doesn't contain a %s or %s stream, content type header is %s")
    public String invalidContentType(String var1, String var2, String var3);

    @Message(id=8214, value="The request was rejected because its size (%s) exceeds the configured maximum (%s)")
    public String maxRequestSizeExceeded(long var1, long var3);

    @Message(id=8215, value="The request was rejected because no multipart boundary was found")
    public String missingMultipartBoundary();

    @Message(id=8216, value="Unable to delete directory %s")
    public String failedToDeleteDirectory(String var1);

    @Message(id=8217, value="Directory %s does not exist")
    public IllegalArgumentException missingDirectory(String var1);

    @Message(id=8218, value="Path %s is not a directory")
    public IllegalArgumentException notDirectory(String var1);

    @Message(id=8219, value="Failed listing contents of directory %s")
    public String failedListingDirectory(String var1);

    @Message(id=8220, value="File %s does not exist")
    public String missingFile(String var1);

    @Message(id=8221, value="Unable to delete file %s")
    public String failedToDeleteFile(String var1);

    @Message(id=8222, value="No more data is available")
    public String noDataAvailable();

    @Message(id=8223, value="Unexpected characters follow a boundary")
    public String unexpectedCharactersAfterBoundary();

    @Message(id=8224, value="Stream ended unexpectedly")
    public String unexpectedEndOfStream();

    @Message(id=8225, value="The length of a boundary token can not be changed")
    public String invalidBoundaryToken();

    @Message(id=8226, value="Header section has more than %s bytes (maybe it is not properly terminated)")
    public String invalidHeader(int var1);

    @Message(id=8227, value="Cannot write uploaded file to disk")
    public String errorWritingUpload();

    @Message(id=8228, value="Invalid file name: %s")
    public String invalidFileName(String var1);

    @Message(id=8229, value="The boundary specified in the %s header is too long")
    public String invalidBoundary(String var1);

    @Message(id=8230, value="The buffer size specified for the MultipartStream is too small")
    public IllegalArgumentException multipartStreamBufferSizeTooSmall();
}

