/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import org.jboss.web.JasperMessages;

public class CharBuffer {
    private static final int DEFAULT_INITIAL_CAPACITY = 512;
    private LinkedList bufList;
    private int listSize = 0;
    private char[] currentBuf;
    private int index;
    private int minimumGrowth;

    public CharBuffer(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public CharBuffer(int initialCapacity, int minimumGrowth) {
        if (initialCapacity == 0) {
            initialCapacity = 512;
        }
        if (minimumGrowth == 0) {
            minimumGrowth = initialCapacity;
        }
        this.bufList = new LinkedList();
        this.currentBuf = new char[initialCapacity];
        this.index = 0;
        this.minimumGrowth = minimumGrowth;
        this.listSize = 0;
    }

    public void buffer(char character) {
        if (this.getCapacity() == 0) {
            this.grow();
        }
        this.currentBuf[this.index++] = character;
    }

    public void buffer(String text, int start, int length) throws IllegalArgumentException {
        if (length <= 0) {
            return;
        }
        if (text == null) {
            throw JasperMessages.MESSAGES.nullCharBufferTextArgument();
        }
        if (start > text.length()) {
            throw JasperMessages.MESSAGES.invalidCharBufferStartPosition();
        }
        if (start + length > text.length()) {
            throw JasperMessages.MESSAGES.invalidCharBufferLength();
        }
        int charsToCopy = 0;
        while (length != 0) {
            charsToCopy = this.getCapacity();
            if (charsToCopy > length) {
                charsToCopy = length;
            }
            if (charsToCopy > 0) {
                text.getChars(start, start + charsToCopy, this.currentBuf, this.index);
                start += charsToCopy;
                length -= charsToCopy;
                this.index += charsToCopy;
            }
            if (length == 0) continue;
            this.grow(length);
        }
    }

    public void buffer(char[] characters, int start, int length) throws IllegalArgumentException {
        if (length <= 0) {
            return;
        }
        if (characters == null) {
            throw JasperMessages.MESSAGES.nullCharBufferCharactersArgument();
        }
        if (start > characters.length) {
            throw JasperMessages.MESSAGES.invalidCharBufferStartPosition();
        }
        if (start + length > characters.length) {
            throw JasperMessages.MESSAGES.invalidCharBufferLength();
        }
        int charsToCopy = 0;
        while (length != 0) {
            charsToCopy = this.getCapacity();
            if (charsToCopy > length) {
                charsToCopy = length;
            }
            if (charsToCopy > 0) {
                System.arraycopy(characters, start, this.currentBuf, this.index, charsToCopy);
                start += charsToCopy;
                length -= charsToCopy;
                this.index += charsToCopy;
            }
            if (length == 0) continue;
            this.grow(length);
        }
    }

    public char[] toArray() {
        char[] result = new char[this.size()];
        int offset = 0;
        for (char[] curBuf : this.bufList) {
            System.arraycopy(curBuf, 0, result, offset, curBuf.length);
            offset += curBuf.length;
        }
        System.arraycopy(this.currentBuf, 0, result, offset, this.index);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.size());
        for (char[] curBuf : this.bufList) {
            sb.append(curBuf);
        }
        sb.append(this.currentBuf, 0, this.index);
        return sb.toString();
    }

    public int getCapacity() {
        return this.currentBuf.length - this.index;
    }

    public int size() {
        return this.listSize + this.index;
    }

    public void clear() {
        this.bufList.clear();
        this.index = 0;
        this.listSize = 0;
    }

    public void writeOut(Writer writer) throws IOException, IllegalArgumentException {
        if (writer == null) {
            throw JasperMessages.MESSAGES.nullCharBufferWriterArgument();
        }
        for (char[] curBuf : this.bufList) {
            writer.write(curBuf);
        }
        writer.write(this.currentBuf, 0, this.index);
    }

    private void grow() {
        this.grow(this.minimumGrowth);
    }

    private void grow(int requiredChars) {
        if (requiredChars < this.minimumGrowth) {
            requiredChars = this.minimumGrowth;
        }
        this.bufList.add(this.currentBuf);
        this.listSize += this.currentBuf.length;
        this.currentBuf = new char[requiredChars];
        this.index = 0;
    }
}

