/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.servlet.HttpMethodConstraintElement;
import javax.servlet.ServletSecurityElement;
import javax.servlet.annotation.ServletSecurity;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.startup.ExpandWar;
import org.jboss.web.CatalinaLogger;

public class ContextConfig
implements LifecycleListener {
    protected Map customAuthenticators;
    protected static Properties authenticators = null;
    protected Context context = null;
    protected boolean ok = false;
    protected static long deploymentCount;
    protected static final LoginConfig DUMMY_LOGIN_CONFIG;

    public void setCustomAuthenticators(Map customAuthenticators) {
        this.customAuthenticators = customAuthenticators;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        this.context = (Context)((Object)event.getLifecycle());
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("before_start")) {
            this.beforeStart();
        } else if (!event.getType().equals("after_start")) {
            if (event.getType().equals("complete-config")) {
                this.completeConfig();
            } else if (event.getType().equals("stop")) {
                this.stop();
            } else if (event.getType().equals("init")) {
                this.init();
            } else if (event.getType().equals("destroy")) {
                this.destroy();
            }
        }
    }

    protected void applicationWebConfig() {
    }

    protected void applicationTldConfig() {
    }

    protected void authenticatorConfig() {
        Pipeline pipeline;
        SecurityConstraint[] constraints = this.context.findConstraints();
        if (constraints == null || constraints.length == 0) {
            return;
        }
        LoginConfig loginConfig = this.context.getLoginConfig();
        if (loginConfig == null) {
            loginConfig = DUMMY_LOGIN_CONFIG;
            this.context.setLoginConfig(loginConfig);
        }
        if (this.context instanceof Authenticator) {
            return;
        }
        if (this.context instanceof ContainerBase) {
            Pipeline pipeline2 = ((ContainerBase)((Object)this.context)).getPipeline();
            if (pipeline2 != null) {
                Valve basic = pipeline2.getBasic();
                if (basic != null && basic instanceof Authenticator) {
                    if (this.context.getAuthenticator() == null) {
                        this.context.setAuthenticator((Authenticator)((Object)basic));
                    }
                    return;
                }
                Valve[] valves = pipeline2.getValves();
                for (int i = 0; i < valves.length; ++i) {
                    if (!(valves[i] instanceof Authenticator)) continue;
                    if (this.context.getAuthenticator() == null) {
                        this.context.setAuthenticator((Authenticator)((Object)valves[i]));
                    }
                    return;
                }
            }
        } else {
            return;
        }
        if (this.context.getRealm() == null) {
            CatalinaLogger.STARTUP_LOGGER.noRealmFound();
            this.ok = false;
            return;
        }
        Valve authenticator = null;
        if (this.customAuthenticators != null) {
            authenticator = (Valve)this.customAuthenticators.get(loginConfig.getAuthMethod());
        }
        if (authenticator == null) {
            String authenticatorName = null;
            authenticatorName = authenticators.getProperty(loginConfig.getAuthMethod());
            if (authenticatorName == null) {
                CatalinaLogger.STARTUP_LOGGER.noAuthenticatorForAuthMethod(loginConfig.getAuthMethod());
                this.ok = false;
                return;
            }
            try {
                Class<?> authenticatorClass = Class.forName(authenticatorName);
                authenticator = (Valve)authenticatorClass.newInstance();
            }
            catch (Throwable t) {
                CatalinaLogger.STARTUP_LOGGER.failedLoadingAuthenticator(authenticatorName, t);
                this.ok = false;
            }
        }
        if (authenticator instanceof Authenticator) {
            this.context.setAuthenticator((Authenticator)((Object)authenticator));
        }
        if (authenticator != null && this.context instanceof ContainerBase && (pipeline = ((ContainerBase)((Object)this.context)).getPipeline()) != null) {
            ((ContainerBase)((Object)this.context)).addValve(authenticator);
            CatalinaLogger.STARTUP_LOGGER.authenticatorConfigured(loginConfig.getAuthMethod());
        }
    }

    protected String getBaseDir() {
        Container engineC = this.context.getParent().getParent();
        if (engineC instanceof StandardEngine) {
            return ((StandardEngine)engineC).getBaseDir();
        }
        return System.getProperty("catalina.base");
    }

    protected void defaultWebConfig() {
    }

    protected void createFragmentsOrder() {
    }

    protected void applicationExtraDescriptorsConfig() {
    }

    public void applicationServletContainerInitializerConfig() {
    }

    protected void init() {
        this.context.setConfigured(false);
        this.ok = true;
    }

    protected void beforeStart() {
    }

    protected void start() {
        if (this.ok) {
            this.defaultWebConfig();
        }
        if (this.ok) {
            this.applicationWebConfig();
        }
        if (this.ok) {
            this.applicationServletContainerInitializerConfig();
        }
        if (this.ok) {
            this.createFragmentsOrder();
        }
        if (this.ok) {
            this.applicationExtraDescriptorsConfig();
        }
        if (this.ok) {
            this.applicationTldConfig();
        }
        if (CatalinaLogger.STARTUP_LOGGER.isDebugEnabled() && this.context instanceof ContainerBase) {
            CatalinaLogger.STARTUP_LOGGER.debug("Pipeline Configuration:");
            Pipeline pipeline = ((ContainerBase)((Object)this.context)).getPipeline();
            Valve[] valves = null;
            if (pipeline != null) {
                valves = pipeline.getValves();
            }
            if (valves != null) {
                for (int i = 0; i < valves.length; ++i) {
                    CatalinaLogger.STARTUP_LOGGER.debug("  " + valves[i].getInfo());
                }
            }
            CatalinaLogger.STARTUP_LOGGER.debug("======================");
        }
        if (this.ok) {
            this.context.setConfigured(true);
        } else {
            CatalinaLogger.STARTUP_LOGGER.contextUnavailable();
            this.context.setConfigured(false);
        }
    }

    protected void completeConfig() {
    }

    protected void stop() {
        int i;
        Container[] children = this.context.findChildren();
        for (i = 0; i < children.length; ++i) {
            this.context.removeChild(children[i]);
        }
        SecurityConstraint[] securityConstraints = this.context.findConstraints();
        for (i = 0; i < securityConstraints.length; ++i) {
            this.context.removeConstraint(securityConstraints[i]);
        }
        ErrorPage[] errorPages = this.context.findErrorPages();
        for (i = 0; i < errorPages.length; ++i) {
            this.context.removeErrorPage(errorPages[i]);
        }
        FilterDef[] filterDefs = this.context.findFilterDefs();
        for (i = 0; i < filterDefs.length; ++i) {
            this.context.removeFilterDef(filterDefs[i]);
        }
        FilterMap[] filterMaps = this.context.findFilterMaps();
        for (i = 0; i < filterMaps.length; ++i) {
            this.context.removeFilterMap(filterMaps[i]);
        }
        String[] mimeMappings = this.context.findMimeMappings();
        for (i = 0; i < mimeMappings.length; ++i) {
            this.context.removeMimeMapping(mimeMappings[i]);
        }
        String[] parameters = this.context.findParameters();
        for (i = 0; i < parameters.length; ++i) {
            this.context.removeParameter(parameters[i]);
        }
        String[] securityRoles = this.context.findSecurityRoles();
        for (i = 0; i < securityRoles.length; ++i) {
            this.context.removeSecurityRole(securityRoles[i]);
        }
        String[] servletMappings = this.context.findServletMappings();
        for (i = 0; i < servletMappings.length; ++i) {
            this.context.removeServletMapping(servletMappings[i]);
        }
        String[] taglibs = this.context.findTaglibs();
        for (i = 0; i < taglibs.length; ++i) {
            this.context.removeTaglib(taglibs[i]);
        }
        String[] welcomeFiles = this.context.findWelcomeFiles();
        for (i = 0; i < welcomeFiles.length; ++i) {
            this.context.removeWelcomeFile(welcomeFiles[i]);
        }
        String[] wrapperLifecycles = this.context.findWrapperLifecycles();
        for (i = 0; i < wrapperLifecycles.length; ++i) {
            this.context.removeWrapperLifecycle(wrapperLifecycles[i]);
        }
        String[] wrapperListeners = this.context.findWrapperListeners();
        for (i = 0; i < wrapperListeners.length; ++i) {
            this.context.removeWrapperListener(wrapperListeners[i]);
        }
        this.ok = true;
    }

    protected void destroy() {
        String workDir = ((StandardContext)this.context).getWorkPath();
        if (workDir != null) {
            ExpandWar.delete(new File(workDir));
        }
    }

    protected void resolveServletSecurity() {
        SecurityConstraint[] staticConstraints;
        HashSet<String> excludedPatterns = new HashSet<String>();
        for (SecurityConstraint staticConstraint : staticConstraints = this.context.findConstraints()) {
            for (SecurityCollection collection : staticConstraint.findCollections()) {
                for (String urlPattern : collection.findPatterns()) {
                    excludedPatterns.add(urlPattern);
                }
            }
        }
        Container[] wrappers = this.context.findChildren();
        for (int i = 0; i < wrappers.length; ++i) {
            Wrapper wrapper = (Wrapper)wrappers[i];
            ServletSecurityElement servletSecurity = wrapper.getServletSecurity();
            if (servletSecurity == null) continue;
            ArrayList<String> methodOmissions = new ArrayList<String>();
            boolean classPA = servletSecurity.getEmptyRoleSemantic().equals((Object)ServletSecurity.EmptyRoleSemantic.PERMIT);
            boolean classDA = servletSecurity.getEmptyRoleSemantic().equals((Object)ServletSecurity.EmptyRoleSemantic.DENY);
            boolean classTP = servletSecurity.getTransportGuarantee().equals((Object)ServletSecurity.TransportGuarantee.CONFIDENTIAL);
            String[] classRA = servletSecurity.getRolesAllowed();
            Collection httpMethodConstraints = servletSecurity.getHttpMethodConstraints();
            if (httpMethodConstraints != null && httpMethodConstraints.size() > 0) {
                for (HttpMethodConstraintElement httpMethodConstraint : httpMethodConstraints) {
                    String method = this.toHttpMethod(httpMethodConstraint.getMethodName());
                    methodOmissions.add(method);
                    boolean methodPA = httpMethodConstraint.getEmptyRoleSemantic().equals((Object)ServletSecurity.EmptyRoleSemantic.PERMIT);
                    boolean methodDA = httpMethodConstraint.getEmptyRoleSemantic().equals((Object)ServletSecurity.EmptyRoleSemantic.DENY);
                    boolean methodTP = httpMethodConstraint.getTransportGuarantee().equals((Object)ServletSecurity.TransportGuarantee.CONFIDENTIAL);
                    String[] methodRA = httpMethodConstraint.getRolesAllowed();
                    if (!methodDA && !methodTP && (methodRA == null || methodRA.length <= 0)) continue;
                    SecurityConstraint constraint = new SecurityConstraint();
                    if (methodDA) {
                        constraint.setAuthConstraint(true);
                    }
                    if (methodPA && (methodRA == null || methodRA.length == 0)) {
                        constraint.addAuthRole("*");
                    }
                    if (methodRA != null) {
                        for (String role : methodRA) {
                            constraint.addAuthRole(role);
                        }
                    }
                    if (methodTP) {
                        constraint.setUserConstraint("CONFIDENTIAL");
                    }
                    SecurityCollection collection = new SecurityCollection();
                    collection.addMethod(method);
                    String[] urlPatterns = wrapper.findMappings();
                    HashSet<String> servletSecurityPatterns = new HashSet<String>();
                    for (String urlPattern : urlPatterns) {
                        if (excludedPatterns.contains(urlPattern)) continue;
                        servletSecurityPatterns.add(urlPattern);
                    }
                    for (String urlPattern : servletSecurityPatterns) {
                        collection.addPattern(urlPattern);
                    }
                    constraint.addCollection(collection);
                    this.context.addConstraint(constraint);
                }
            }
            if (!classDA && !classTP && (classRA == null || classRA.length <= 0)) continue;
            SecurityConstraint constraint = new SecurityConstraint();
            if (classPA && (classRA == null || classRA.length == 0)) {
                constraint.addAuthRole("*");
            }
            if (classDA) {
                constraint.setAuthConstraint(true);
            }
            if (classRA != null) {
                for (String role : classRA) {
                    constraint.addAuthRole(role);
                }
            }
            if (classTP) {
                constraint.setUserConstraint("CONFIDENTIAL");
            }
            SecurityCollection collection = new SecurityCollection();
            String[] urlPatterns = wrapper.findMappings();
            HashSet<String> servletSecurityPatterns = new HashSet<String>();
            for (String urlPattern : urlPatterns) {
                if (excludedPatterns.contains(urlPattern)) continue;
                servletSecurityPatterns.add(urlPattern);
            }
            for (String urlPattern : servletSecurityPatterns) {
                collection.addPattern(urlPattern);
            }
            for (String methodOmission : methodOmissions) {
                collection.addMethodOmission(methodOmission);
            }
            constraint.addCollection(collection);
            this.context.addConstraint(constraint);
        }
    }

    protected String toHttpMethod(String method) {
        if (method == null || method.length() < 3 || !method.startsWith("do")) {
            return method;
        }
        return method.substring(2).toUpperCase();
    }

    protected void validateSecurityRoles() {
        SecurityConstraint[] constraints = this.context.findConstraints();
        for (int i = 0; i < constraints.length; ++i) {
            String[] roles = constraints[i].findAuthRoles();
            for (int j = 0; j < roles.length; ++j) {
                if ("*".equals(roles[j]) || this.context.findSecurityRole(roles[j])) continue;
                CatalinaLogger.STARTUP_LOGGER.roleValidationAuth(roles[j]);
                this.context.addSecurityRole(roles[j]);
            }
        }
        Container[] wrappers = this.context.findChildren();
        for (int i = 0; i < wrappers.length; ++i) {
            Wrapper wrapper = (Wrapper)wrappers[i];
            String runAs = wrapper.getRunAs();
            if (runAs != null && !this.context.findSecurityRole(runAs)) {
                CatalinaLogger.STARTUP_LOGGER.roleValidationRunAs(runAs);
                this.context.addSecurityRole(runAs);
            }
            String[] names = wrapper.findSecurityReferences();
            for (int j = 0; j < names.length; ++j) {
                String link = wrapper.findSecurityReference(names[j]);
                if (link == null || this.context.findSecurityRole(link)) continue;
                CatalinaLogger.STARTUP_LOGGER.roleValidationLink(link);
                this.context.addSecurityRole(link);
            }
        }
    }

    protected String getHostConfigPath(String resourceName) {
        StringBuilder result = new StringBuilder();
        Context host = null;
        Container engine = null;
        for (Container container = this.context; container != null; container = container.getParent()) {
            if (container instanceof Host) {
                host = container;
            }
            if (!(container instanceof Engine)) continue;
            engine = container;
        }
        if (engine != null) {
            result.append(engine.getName()).append('/');
        }
        if (host != null) {
            result.append(host.getName()).append('/');
        }
        result.append(resourceName);
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        authenticators = new Properties();
        InputStream is = null;
        try {
            is = ContextConfig.class.getClassLoader().getResourceAsStream("org/apache/catalina/startup/Authenticators.properties");
            if (is != null) {
                authenticators.load(is);
            } else {
                CatalinaLogger.STARTUP_LOGGER.cannotFindAuthenticatoMappings();
            }
        }
        catch (IOException e) {
            CatalinaLogger.STARTUP_LOGGER.failedLoadingAuthenticatoMappings(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        deploymentCount = 0L;
        DUMMY_LOGIN_CONFIG = new LoginConfig("NONE", null, null, null);
    }
}

