/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.naming.resources.ProxyDirContext;

public class ProxyDirContextFacade
implements DirContext {
    protected ProxyDirContext dirContext;
    protected String path;
    protected Name pathName;

    public ProxyDirContextFacade(ProxyDirContext dirContext, String path) {
        this.dirContext = dirContext;
        this.path = path;
        try {
            this.pathName = new CompositeName(path);
        }
        catch (InvalidNameException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public ProxyDirContext getDirContext() {
        return this.dirContext;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.dirContext.lookup(this.composeName(name, this.pathName));
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.dirContext.lookup(this.composeName(name, this.path));
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.dirContext.bind(this.composeName(name, this.pathName), obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.dirContext.bind(this.composeName(name, this.path), obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.dirContext.rebind(this.composeName(name, this.pathName), obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.dirContext.rebind(this.composeName(name, this.path), obj);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.dirContext.unbind(this.composeName(name, this.pathName));
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.dirContext.unbind(this.composeName(name, this.path));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.dirContext.rename(this.composeName(oldName, this.pathName), this.composeName(newName, this.pathName));
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.dirContext.rename(this.composeName(oldName, this.path), this.composeName(newName, this.path));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.dirContext.list(this.composeName(name, this.pathName));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.dirContext.list(this.composeName(name, this.path));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.dirContext.listBindings(this.composeName(name, this.pathName));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.dirContext.listBindings(this.composeName(name, this.path));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.dirContext.destroySubcontext(this.composeName(name, this.pathName));
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.dirContext.destroySubcontext(this.composeName(name, this.path));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.dirContext.createSubcontext(this.composeName(name, this.pathName));
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.dirContext.createSubcontext(this.composeName(name, this.path));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.dirContext.lookupLink(this.composeName(name, this.pathName));
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.dirContext.lookupLink(this.composeName(name, this.path));
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.dirContext.getNameParser(this.composeName(name, this.pathName));
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.dirContext.getNameParser(this.composeName(name, this.path));
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        prefix = (Name)prefix.clone();
        return prefix.addAll(name);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return prefix + "/" + name;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.dirContext.addToEnvironment(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.dirContext.removeFromEnvironment(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.dirContext.getEnvironment();
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.dirContext.getNameInNamespace();
    }

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        return this.dirContext.getAttributes(this.composeName(name, this.pathName));
    }

    @Override
    public Attributes getAttributes(String name) throws NamingException {
        return this.dirContext.getAttributes(this.composeName(name, this.path));
    }

    @Override
    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        return this.dirContext.getAttributes(this.composeName(name, this.pathName), attrIds);
    }

    @Override
    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        return this.dirContext.getAttributes(this.composeName(name, this.path), attrIds);
    }

    @Override
    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        this.dirContext.modifyAttributes(this.composeName(name, this.pathName), mod_op, attrs);
    }

    @Override
    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        this.dirContext.modifyAttributes(this.composeName(name, this.path), mod_op, attrs);
    }

    @Override
    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        this.dirContext.modifyAttributes(this.composeName(name, this.pathName), mods);
    }

    @Override
    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        this.dirContext.modifyAttributes(this.composeName(name, this.path), mods);
    }

    @Override
    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.dirContext.bind(this.composeName(name, this.pathName), obj, attrs);
    }

    @Override
    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        this.dirContext.bind(this.composeName(name, this.path), obj, attrs);
    }

    @Override
    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.dirContext.rebind(this.composeName(name, this.pathName), obj, attrs);
    }

    @Override
    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        this.dirContext.rebind(this.composeName(name, this.path), obj, attrs);
    }

    @Override
    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        return this.dirContext.createSubcontext(this.composeName(name, this.pathName), attrs);
    }

    @Override
    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        return this.dirContext.createSubcontext(this.composeName(name, this.path), attrs);
    }

    @Override
    public DirContext getSchema(Name name) throws NamingException {
        return this.dirContext.getSchema(this.composeName(name, this.pathName));
    }

    @Override
    public DirContext getSchema(String name) throws NamingException {
        return this.dirContext.getSchema(this.composeName(name, this.path));
    }

    @Override
    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        return this.dirContext.getSchemaClassDefinition(this.composeName(name, this.pathName));
    }

    @Override
    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        return this.dirContext.getSchemaClassDefinition(this.composeName(name, this.path));
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.dirContext.search(this.composeName(name, this.pathName), matchingAttributes, attributesToReturn);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.dirContext.search(this.composeName(name, this.path), matchingAttributes, attributesToReturn);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes) throws NamingException {
        return this.dirContext.search(this.composeName(name, this.pathName), matchingAttributes);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes) throws NamingException {
        return this.dirContext.search(this.composeName(name, this.path), matchingAttributes);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filter, SearchControls cons) throws NamingException {
        return this.dirContext.search(this.composeName(name, this.pathName), filter, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls cons) throws NamingException {
        return this.dirContext.search(this.composeName(name, this.path), filter, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.dirContext.search(this.composeName(name, this.pathName), filterExpr, filterArgs, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.dirContext.search(this.composeName(name, this.path), filterExpr, filterArgs, cons);
    }
}

