/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.modeler.modules;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.tomcat.util.DomUtil;
import org.apache.tomcat.util.modeler.AttributeInfo;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.NotificationInfo;
import org.apache.tomcat.util.modeler.OperationInfo;
import org.apache.tomcat.util.modeler.ParameterInfo;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.modeler.modules.ModelerSource;
import org.jboss.web.CoyoteLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MbeansDescriptorsDOMSource
extends ModelerSource {
    Registry registry;
    String location;
    String type;
    Object source;
    List mbeans = new ArrayList();

    public void setRegistry(Registry reg) {
        this.registry = reg;
    }

    public void setLocation(String loc) {
        this.location = loc;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    @Override
    public List loadDescriptors(Registry registry, String location, String type, Object source) throws Exception {
        this.setRegistry(registry);
        this.setLocation(location);
        this.setType(type);
        this.setSource(source);
        this.execute();
        return this.mbeans;
    }

    public void execute() throws Exception {
        if (this.registry == null) {
            this.registry = Registry.getRegistry();
        }
        try {
            InputStream stream = (InputStream)this.source;
            long t1 = System.currentTimeMillis();
            Document doc = DomUtil.readXml(stream);
            Element descriptorsN = doc.getDocumentElement();
            if (descriptorsN == null) {
                CoyoteLogger.MODELER_LOGGER.noDescriptorsFound();
                return;
            }
            Node firstMbeanN = null;
            firstMbeanN = "mbean".equals(descriptorsN.getNodeName()) ? descriptorsN : DomUtil.getChild((Node)descriptorsN, "mbean");
            if (firstMbeanN == null) {
                CoyoteLogger.MODELER_LOGGER.noMbeansFound();
                return;
            }
            Node mbeanN = firstMbeanN;
            while (mbeanN != null) {
                Node paramN;
                Node firstParamN;
                Node firstN;
                ManagedBean managed = new ManagedBean();
                DomUtil.setAttributes(managed, mbeanN);
                Node descN = firstN = DomUtil.getChild(mbeanN, "attribute");
                while (descN != null) {
                    AttributeInfo ai = new AttributeInfo();
                    DomUtil.setAttributes(ai, descN);
                    managed.addAttribute(ai);
                    if (CoyoteLogger.MODELER_LOGGER.isTraceEnabled()) {
                        CoyoteLogger.MODELER_LOGGER.trace("Create attribute " + ai);
                    }
                    descN = DomUtil.getNext(descN);
                }
                descN = firstN = DomUtil.getChild(mbeanN, "notification");
                while (descN != null) {
                    NotificationInfo ni = new NotificationInfo();
                    DomUtil.setAttributes(ni, descN);
                    paramN = firstParamN = DomUtil.getChild(descN, "notification-type");
                    while (paramN != null) {
                        ni.addNotifType(DomUtil.getContent(paramN));
                        paramN = DomUtil.getNext(paramN);
                    }
                    managed.addNotification(ni);
                    if (CoyoteLogger.MODELER_LOGGER.isTraceEnabled()) {
                        CoyoteLogger.MODELER_LOGGER.trace("Created notification " + ni);
                    }
                    descN = DomUtil.getNext(descN);
                }
                descN = firstN = DomUtil.getChild(mbeanN, "operation");
                while (descN != null) {
                    OperationInfo oi = new OperationInfo();
                    DomUtil.setAttributes(oi, descN);
                    paramN = firstParamN = DomUtil.getChild(descN, "parameter");
                    while (paramN != null) {
                        ParameterInfo pi = new ParameterInfo();
                        DomUtil.setAttributes(pi, paramN);
                        if (CoyoteLogger.MODELER_LOGGER.isTraceEnabled()) {
                            CoyoteLogger.MODELER_LOGGER.trace("Add param " + pi.getName());
                        }
                        oi.addParameter(pi);
                        paramN = DomUtil.getNext(paramN);
                    }
                    managed.addOperation(oi);
                    if (CoyoteLogger.MODELER_LOGGER.isTraceEnabled()) {
                        CoyoteLogger.MODELER_LOGGER.trace("Create operation " + oi);
                    }
                    descN = DomUtil.getNext(descN);
                }
                this.mbeans.add(managed);
                mbeanN = DomUtil.getNext(mbeanN);
            }
            long t2 = System.currentTimeMillis();
            CoyoteLogger.MODELER_LOGGER.debug("Reading descriptors ( dom ) " + (t2 - t1));
        }
        catch (Exception ex) {
            CoyoteLogger.MODELER_LOGGER.errorReadingDescriptors(ex);
        }
    }
}

