/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.rewrite;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.net.URL;
import org.jboss.web.WebMessages;
import org.jboss.web.rewrite.RewriteCond;
import org.jboss.web.rewrite.RewriteMap;
import org.jboss.web.rewrite.RewriteRule;
import org.jboss.web.rewrite.TomcatResolver;

public class RewriteValve
extends ValveBase
implements Lifecycle {
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected RewriteRule[] rules = null;
    protected ThreadLocal<Boolean> invoked = new ThreadLocal();
    protected String resourcePath = "rewrite.properties";
    protected boolean context = false;
    protected Map<String, RewriteMap> maps = new Hashtable<String, RewriteMap>();

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws LifecycleException {
        InputStream is = null;
        if (this.getContainer() instanceof Context) {
            this.context = true;
            is = ((Context)this.getContainer()).getServletContext().getResourceAsStream("/WEB-INF/" + this.resourcePath);
            if (this.container.getLogger().isDebugEnabled()) {
                if (is == null) {
                    this.container.getLogger().debug((Object)("No configuration resource found: /WEB-INF/" + this.resourcePath));
                } else {
                    this.container.getLogger().debug((Object)("Read configuration from: /WEB-INF/" + this.resourcePath));
                }
            }
        }
        if (is == null) {
            String resourceName = this.getHostConfigPath(this.resourcePath);
            File file = new File(this.getConfigBase(), resourceName);
            try {
                if (!file.exists()) {
                    if (resourceName != null && (is = this.getClass().getClassLoader().getResourceAsStream(resourceName)) != null && this.container.getLogger().isDebugEnabled()) {
                        this.container.getLogger().debug((Object)("Read configuration from CL at " + resourceName));
                    }
                } else {
                    if (this.container.getLogger().isDebugEnabled()) {
                        this.container.getLogger().debug((Object)("Read configuration from " + file.getAbsolutePath()));
                    }
                    is = new FileInputStream(file);
                }
                if (is == null && this.container.getLogger().isDebugEnabled()) {
                    this.container.getLogger().debug((Object)("No configuration resource found: " + resourceName + " in " + this.getConfigBase() + " or in the classloader"));
                }
            }
            catch (Exception e) {
                this.container.getLogger().error((Object)WebMessages.MESSAGES.errorOpeningRewriteConfiguration(), (Throwable)e);
            }
        }
        if (is == null) {
            return;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            this.parse(reader);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {}
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void setConfiguration(String configuration) throws Exception {
        this.maps.clear();
        this.parse(new BufferedReader(new StringReader(configuration)));
    }

    public String getConfiguration() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.rules.length; ++i) {
            for (int j = 0; j < this.rules[i].getConditions().length; ++j) {
                buffer.append(this.rules[i].getConditions()[j].toString()).append("\r\n");
            }
            buffer.append(this.rules[i].toString()).append("\r\n").append("\r\n");
        }
        return buffer.toString();
    }

    protected void parse(BufferedReader reader) throws LifecycleException {
        ArrayList<RewriteRule> rules = new ArrayList<RewriteRule>();
        ArrayList<RewriteCond> conditions = new ArrayList<RewriteCond>();
        while (true) {
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    Object result = RewriteValve.parse(line);
                    if (result instanceof RewriteRule) {
                        int i;
                        RewriteRule rule = (RewriteRule)result;
                        if (this.container.getLogger().isDebugEnabled()) {
                            this.container.getLogger().debug((Object)("Add rule with pattern " + rule.getPatternString() + " and substitution " + rule.getSubstitutionString()));
                        }
                        for (i = conditions.size() - 1; i > 0; --i) {
                            if (!((RewriteCond)conditions.get(i - 1)).isOrnext()) continue;
                            ((RewriteCond)conditions.get(i)).setOrnext(true);
                        }
                        for (i = 0; i < conditions.size(); ++i) {
                            if (this.container.getLogger().isDebugEnabled()) {
                                RewriteCond cond = (RewriteCond)conditions.get(i);
                                this.container.getLogger().debug((Object)("Add condition " + cond.getCondPattern() + " test " + cond.getTestString() + " to rule with pattern " + rule.getPatternString() + " and substitution " + rule.getSubstitutionString() + (cond.isOrnext() ? " [OR]" : "") + (cond.isNocase() ? " [NC]" : "")));
                            }
                            rule.addCondition((RewriteCond)conditions.get(i));
                        }
                        conditions.clear();
                        rules.add(rule);
                        continue;
                    }
                    if (result instanceof RewriteCond) {
                        conditions.add((RewriteCond)result);
                        continue;
                    }
                    if (!(result instanceof Object[])) continue;
                    String mapName = (String)((Object[])result)[0];
                    RewriteMap map = (RewriteMap)((Object[])result)[1];
                    this.maps.put(mapName, map);
                    if (!(map instanceof Lifecycle)) continue;
                    ((Lifecycle)((Object)map)).start();
                }
            }
            catch (IOException e) {
                this.container.getLogger().error((Object)WebMessages.MESSAGES.errorReadingRewriteConfiguration(), (Throwable)e);
                continue;
            }
            break;
        }
        this.rules = rules.toArray(new RewriteRule[0]);
        for (int i = 0; i < this.rules.length; ++i) {
            this.rules[i].parse(this.maps);
        }
    }

    @Override
    public void stop() throws LifecycleException {
        for (RewriteMap map : this.maps.values()) {
            if (!(map instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)map)).stop();
        }
        this.maps.clear();
        this.rules = null;
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.rules == null || this.rules.length == 0) {
            this.getNext().invoke(request, response);
            return;
        }
        if (this.invoked.get() == Boolean.TRUE) {
            this.getNext().invoke(request, response);
            this.invoked.set(null);
            return;
        }
        TomcatResolver resolver = new TomcatResolver(request);
        this.invoked.set(Boolean.TRUE);
        MessageBytes urlMB = this.context ? request.getRequestPathMB() : request.getDecodedRequestURIMB();
        urlMB.toChars();
        CharSequence url = urlMB.getCharChunk();
        CharSequence host = request.getServerName();
        boolean rewritten = false;
        boolean done = false;
        block2: for (int i = 0; i < this.rules.length; ++i) {
            CharSequence urlString;
            CharSequence test = this.rules[i].isHost() ? host : url;
            CharSequence newtest = this.rules[i].evaluate(test, resolver);
            if (newtest != null && !test.equals(newtest.toString())) {
                if (this.container.getLogger().isDebugEnabled()) {
                    this.container.getLogger().debug((Object)("Rewrote " + test + " as " + newtest + " with rule pattern " + this.rules[i].getPatternString()));
                }
                if (this.rules[i].isHost()) {
                    host = newtest;
                } else {
                    url = newtest;
                }
                rewritten = true;
            }
            if (this.rules[i].isForbidden() && newtest != null) {
                response.sendError(403);
                done = true;
                break;
            }
            if (this.rules[i].isGone() && newtest != null) {
                response.sendError(410);
                done = true;
                break;
            }
            if (this.rules[i].isRedirect() && newtest != null) {
                String queryString = request.getQueryString();
                urlString = new StringBuffer(url);
                if (queryString != null && queryString.length() > 0) {
                    int index = ((StringBuffer)urlString).indexOf("?");
                    if (index != -1) {
                        if (this.rules[i].isQsappend()) {
                            ((StringBuffer)urlString).append('&');
                            ((StringBuffer)urlString).append(queryString);
                        } else if (index == ((StringBuffer)urlString).length() - 1) {
                            ((StringBuffer)urlString).deleteCharAt(index);
                        }
                    } else {
                        ((StringBuffer)urlString).append('?');
                        ((StringBuffer)urlString).append(queryString);
                    }
                }
                if (this.context && ((StringBuffer)urlString).charAt(0) == '/' && !RewriteValve.hasScheme((StringBuffer)urlString)) {
                    ((StringBuffer)urlString).insert(0, request.getContext().getEncodedPath());
                }
                response.sendRedirect(((StringBuffer)urlString).toString());
                response.setStatus(this.rules[i].getRedirectCode());
                done = true;
                break;
            }
            if (this.rules[i].isCookie() && newtest != null) {
                Cookie cookie = new Cookie(this.rules[i].getCookieName(), this.rules[i].getCookieResult());
                cookie.setDomain(this.rules[i].getCookieDomain());
                cookie.setMaxAge(this.rules[i].getCookieLifetime());
                cookie.setPath(this.rules[i].getCookiePath());
                cookie.setSecure(this.rules[i].isCookieSecure());
                cookie.setHttpOnly(this.rules[i].isCookieHttpOnly());
                response.addCookie(cookie);
            }
            if (this.rules[i].isEnv() && newtest != null) {
                for (int j = 0; j < this.rules[i].getEnvSize(); ++j) {
                    request.setAttribute(this.rules[i].getEnvName(j), this.rules[i].getEnvResult(j));
                }
            }
            if (this.rules[i].isType() && newtest != null) {
                request.setContentType(this.rules[i].getTypeValue());
            }
            if (this.rules[i].isQsappend() && newtest != null) {
                String queryString = request.getQueryString();
                urlString = url.toString();
                if (((String)urlString).indexOf(63) != -1 && queryString != null) {
                    url = (String)urlString + "&" + queryString;
                }
            }
            if (this.rules[i].isChain() && newtest == null) {
                for (int j = i; j < this.rules.length; ++j) {
                    if (this.rules[j].isChain()) continue;
                    i = j;
                    continue block2;
                }
                continue;
            }
            if (this.rules[i].isLast() && newtest != null) break;
            if (this.rules[i].isNext() && newtest != null) {
                i = 0;
                continue;
            }
            if (newtest == null) continue;
            i += this.rules[i].getSkip();
        }
        if (rewritten) {
            if (!done) {
                String urlString = url.toString();
                String queryString = null;
                int queryIndex = urlString.indexOf(63);
                if (queryIndex != -1) {
                    queryString = urlString.substring(queryIndex + 1);
                    urlString = urlString.substring(0, queryIndex);
                }
                request.getCoyoteRequest().requestURI().setString(null);
                CharChunk chunk = request.getCoyoteRequest().requestURI().getCharChunk();
                chunk.recycle();
                if (this.context) {
                    chunk.append(request.getContextPath());
                }
                chunk.append(urlString);
                request.getCoyoteRequest().requestURI().toChars();
                if (queryString != null) {
                    request.getCoyoteRequest().queryString().setString(null);
                    chunk = request.getCoyoteRequest().queryString().getCharChunk();
                    chunk.recycle();
                    chunk.append(queryString);
                    request.getCoyoteRequest().queryString().toChars();
                }
                if (!host.equals(request.getServerName())) {
                    request.getCoyoteRequest().serverName().setString(null);
                    chunk = request.getCoyoteRequest().serverName().getCharChunk();
                    chunk.recycle();
                    chunk.append(host.toString());
                    request.getCoyoteRequest().serverName().toChars();
                }
                request.getMappingData().recycle();
                try {
                    request.getConnector().getProtocolHandler().getAdapter().service(request.getCoyoteRequest(), response.getCoyoteResponse());
                }
                catch (Exception e) {}
            }
        } else {
            this.getNext().invoke(request, response);
        }
        this.invoked.set(null);
    }

    protected File getConfigBase() {
        File configBase = new File(System.getProperty("catalina.base"), "conf");
        if (!configBase.exists()) {
            return null;
        }
        return configBase;
    }

    protected String getHostConfigPath(String resourceName) {
        StringBuffer result = new StringBuffer();
        Container host = null;
        Container engine = null;
        for (Container container = this.getContainer(); container != null; container = container.getParent()) {
            if (container instanceof Host) {
                host = container;
            }
            if (!(container instanceof Engine)) continue;
            engine = container;
        }
        if (engine != null) {
            result.append(engine.getName()).append('/');
        }
        if (host != null) {
            result.append(host.getName()).append('/');
        }
        result.append(resourceName);
        return result.toString();
    }

    public static Object parse(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line);
        if (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("RewriteCond")) {
                RewriteCond condition = new RewriteCond();
                if (tokenizer.countTokens() < 2) {
                    throw WebMessages.MESSAGES.invalidRewriteConfiguration(line);
                }
                condition.setTestString(tokenizer.nextToken());
                condition.setCondPattern(tokenizer.nextToken());
                if (tokenizer.hasMoreTokens()) {
                    String flags = tokenizer.nextToken();
                    if (flags.startsWith("[") && flags.endsWith("]")) {
                        flags = flags.substring(1, flags.length() - 1);
                    }
                    StringTokenizer flagsTokenizer = new StringTokenizer(flags, ",");
                    while (flagsTokenizer.hasMoreElements()) {
                        RewriteValve.parseCondFlag(line, condition, flagsTokenizer.nextToken());
                    }
                }
                return condition;
            }
            if (token.equals("RewriteRule")) {
                RewriteRule rule = new RewriteRule();
                if (tokenizer.countTokens() < 2) {
                    throw WebMessages.MESSAGES.invalidRewriteConfiguration(line);
                }
                rule.setPatternString(tokenizer.nextToken());
                rule.setSubstitutionString(tokenizer.nextToken());
                if (tokenizer.hasMoreTokens()) {
                    String flags = tokenizer.nextToken();
                    if (flags.startsWith("[") && flags.endsWith("]")) {
                        flags = flags.substring(1, flags.length() - 1);
                    }
                    StringTokenizer flagsTokenizer = new StringTokenizer(flags, ",");
                    while (flagsTokenizer.hasMoreElements()) {
                        RewriteValve.parseRuleFlag(line, rule, flagsTokenizer.nextToken());
                    }
                }
                return rule;
            }
            if (token.equals("RewriteMap")) {
                if (tokenizer.countTokens() < 2) {
                    throw WebMessages.MESSAGES.invalidRewriteConfiguration(line);
                }
                String name = tokenizer.nextToken();
                String rewriteMapClassName = tokenizer.nextToken();
                RewriteMap map = null;
                try {
                    map = (RewriteMap)Class.forName(rewriteMapClassName).newInstance();
                }
                catch (Exception e) {
                    throw WebMessages.MESSAGES.invalidRewriteMap(rewriteMapClassName);
                }
                if (tokenizer.hasMoreTokens()) {
                    map.setParameters(tokenizer.nextToken());
                }
                Object[] result = new Object[]{name, map};
                return result;
            }
            if (!token.startsWith("#")) {
                throw WebMessages.MESSAGES.invalidRewriteConfiguration(line);
            }
        }
        return null;
    }

    protected static void parseCondFlag(String line, RewriteCond condition, String flag) {
        if (flag.equals("NC") || flag.equals("nocase")) {
            condition.setNocase(true);
        } else if (flag.equals("OR") || flag.equals("ornext")) {
            condition.setOrnext(true);
        } else {
            throw WebMessages.MESSAGES.invalidRewriteFlags(line, flag);
        }
    }

    protected static void parseRuleFlag(String line, RewriteRule rule, String flag) {
        if (flag.equals("chain") || flag.equals("C")) {
            rule.setChain(true);
        } else if (flag.startsWith("cookie=") || flag.startsWith("C=")) {
            rule.setCookie(true);
            if (flag.startsWith("cookie")) {
                flag = flag.substring("cookie=".length());
            } else if (flag.startsWith("C=")) {
                flag = flag.substring("C=".length());
            }
            StringTokenizer tokenizer = new StringTokenizer(flag, ":");
            if (tokenizer.countTokens() < 2) {
                throw WebMessages.MESSAGES.invalidRewriteFlags(line);
            }
            rule.setCookieName(tokenizer.nextToken());
            rule.setCookieValue(tokenizer.nextToken());
            if (tokenizer.hasMoreTokens()) {
                rule.setCookieDomain(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                try {
                    rule.setCookieLifetime(Integer.parseInt(tokenizer.nextToken()));
                }
                catch (NumberFormatException e) {
                    throw WebMessages.MESSAGES.invalidRewriteFlags(line);
                }
            }
            if (tokenizer.hasMoreTokens()) {
                rule.setCookiePath(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                rule.setCookieSecure(Boolean.parseBoolean(tokenizer.nextToken()));
            }
            if (tokenizer.hasMoreTokens()) {
                rule.setCookieHttpOnly(Boolean.parseBoolean(tokenizer.nextToken()));
            }
        } else if (flag.startsWith("env=") || flag.startsWith("E=")) {
            rule.setEnv(true);
            if (flag.startsWith("env=")) {
                flag = flag.substring("env=".length());
            } else if (flag.startsWith("E=")) {
                flag = flag.substring("E=".length());
            }
            int pos = flag.indexOf(58);
            if (pos == -1 || pos + 1 == flag.length()) {
                throw WebMessages.MESSAGES.invalidRewriteFlags(line);
            }
            rule.addEnvName(flag.substring(0, pos));
            rule.addEnvValue(flag.substring(pos + 1));
        } else if (flag.startsWith("forbidden") || flag.startsWith("F")) {
            rule.setForbidden(true);
        } else if (flag.startsWith("gone") || flag.startsWith("G")) {
            rule.setGone(true);
        } else if (flag.startsWith("host") || flag.startsWith("H")) {
            rule.setHost(true);
        } else if (flag.startsWith("last") || flag.startsWith("L")) {
            rule.setLast(true);
        } else if (flag.startsWith("next") || flag.startsWith("N")) {
            rule.setNext(true);
        } else if (flag.startsWith("nocase") || flag.startsWith("NC")) {
            rule.setNocase(true);
        } else if (flag.startsWith("noescape") || flag.startsWith("NE")) {
            rule.setNoescape(true);
        } else if (flag.startsWith("qsappend") || flag.startsWith("QSA")) {
            rule.setQsappend(true);
        } else if (flag.startsWith("redirect") || flag.startsWith("R")) {
            if (flag.startsWith("redirect=")) {
                flag = flag.substring("redirect=".length());
                rule.setRedirect(true);
                rule.setRedirectCode(Integer.parseInt(flag));
            } else if (flag.startsWith("R=")) {
                flag = flag.substring("R=".length());
                rule.setRedirect(true);
                rule.setRedirectCode(Integer.parseInt(flag));
            } else {
                rule.setRedirect(true);
                rule.setRedirectCode(302);
            }
        } else if (flag.startsWith("skip") || flag.startsWith("S")) {
            if (flag.startsWith("skip=")) {
                flag = flag.substring("skip=".length());
            } else if (flag.startsWith("S=")) {
                flag = flag.substring("S=".length());
            }
            rule.setSkip(Integer.parseInt(flag));
        } else if (flag.startsWith("type") || flag.startsWith("T")) {
            if (flag.startsWith("type=")) {
                flag = flag.substring("type=".length());
            } else if (flag.startsWith("T=")) {
                flag = flag.substring("T=".length());
            }
            rule.setType(true);
            rule.setTypeValue(flag);
        } else {
            throw WebMessages.MESSAGES.invalidRewriteFlags(line, flag);
        }
    }

    protected static boolean hasScheme(StringBuffer uri) {
        int len = uri.length();
        for (int i = 0; i < len; ++i) {
            char c = uri.charAt(i);
            if (c == ':') {
                return i > 0;
            }
            if (URL.isSchemeChar(c)) continue;
            return false;
        }
        return false;
    }
}

