/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;
import org.jboss.web.CatalinaLogger;
import org.jboss.web.CatalinaMessages;

public class CrawlerSessionManagerValve
extends ValveBase
implements Lifecycle {
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected boolean started = false;
    private final Map<String, String> clientIpSessionId = new ConcurrentHashMap<String, String>();
    private final Map<String, String> sessionIdClientIp = new ConcurrentHashMap<String, String>();
    private String crawlerUserAgents = ".*[bB]ot.*|.*Yahoo! Slurp.*|.*Feedfetcher-Google.*";
    private Pattern uaPattern = null;
    private int sessionInactiveInterval = 60;

    public void setCrawlerUserAgents(String crawlerUserAgents) {
        this.crawlerUserAgents = crawlerUserAgents;
        this.uaPattern = crawlerUserAgents == null || crawlerUserAgents.length() == 0 ? null : Pattern.compile(crawlerUserAgents);
    }

    public String getCrawlerUserAgents() {
        return this.crawlerUserAgents;
    }

    public void setSessionInactiveInterval(int sessionInactiveInterval) {
        this.sessionInactiveInterval = sessionInactiveInterval;
    }

    public int getSessionInactiveInterval() {
        return this.sessionInactiveInterval;
    }

    public Map<String, String> getClientIpSessionId() {
        return this.clientIpSessionId;
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    @Override
    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(CatalinaMessages.MESSAGES.valveAlreadyStarted());
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        this.uaPattern = Pattern.compile(this.crawlerUserAgents);
    }

    @Override
    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(CatalinaMessages.MESSAGES.valveNotStarted());
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        boolean isBot = false;
        String sessionId = null;
        String clientIp = null;
        if (CatalinaLogger.VALVES_LOGGER.isDebugEnabled()) {
            CatalinaLogger.VALVES_LOGGER.debug(request.hashCode() + ": ClientIp=" + request.getRemoteAddr() + ", RequestedSessionId=" + request.getRequestedSessionId());
        }
        if (request.getSession(false) == null) {
            Enumeration uaHeaders = request.getHeaders("user-agent");
            String uaHeader = null;
            if (uaHeaders.hasMoreElements()) {
                uaHeader = (String)uaHeaders.nextElement();
            }
            if (uaHeader != null && !uaHeaders.hasMoreElements()) {
                if (CatalinaLogger.VALVES_LOGGER.isDebugEnabled()) {
                    CatalinaLogger.VALVES_LOGGER.debug(request.hashCode() + ": UserAgent=" + uaHeader);
                }
                if (this.uaPattern.matcher(uaHeader).matches()) {
                    isBot = true;
                    if (CatalinaLogger.VALVES_LOGGER.isDebugEnabled()) {
                        CatalinaLogger.VALVES_LOGGER.debug(request.hashCode() + ": Bot found. UserAgent=" + uaHeader);
                    }
                }
            }
            if (isBot && (sessionId = this.clientIpSessionId.get(clientIp = request.getRemoteAddr())) != null) {
                request.setRequestedSessionId(sessionId);
                if (CatalinaLogger.VALVES_LOGGER.isDebugEnabled()) {
                    CatalinaLogger.VALVES_LOGGER.debug(request.hashCode() + ": SessionID=" + sessionId);
                }
            }
        }
        this.getNext().invoke(request, response);
        if (isBot) {
            if (sessionId == null) {
                HttpSession s = request.getSession(false);
                if (s != null) {
                    this.clientIpSessionId.put(clientIp, s.getId());
                    this.sessionIdClientIp.put(s.getId(), clientIp);
                    s.setAttribute(this.getClass().getName(), (Object)new CrawlerBindingListener());
                    s.setMaxInactiveInterval(this.sessionInactiveInterval);
                    if (CatalinaLogger.VALVES_LOGGER.isDebugEnabled()) {
                        CatalinaLogger.VALVES_LOGGER.debug(request.hashCode() + ": New bot session. SessionID=" + s.getId());
                    }
                }
            } else if (CatalinaLogger.VALVES_LOGGER.isDebugEnabled()) {
                CatalinaLogger.VALVES_LOGGER.debug(request.hashCode() + ": Bot session accessed. SessionID=" + sessionId);
            }
        }
    }

    protected class CrawlerBindingListener
    implements HttpSessionBindingListener,
    Serializable {
        private static final long serialVersionUID = -3775762684177732270L;

        protected CrawlerBindingListener() {
        }

        public void valueBound(HttpSessionBindingEvent event) {
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            String clientIp = (String)CrawlerSessionManagerValve.this.sessionIdClientIp.remove(event.getSession().getId());
            if (clientIp != null) {
                CrawlerSessionManagerValve.this.clientIpSessionId.remove(clientIp);
            }
        }
    }
}

