/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Scanner;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.valves.ValveBase;
import org.jboss.web.CatalinaMessages;

public class ErrorReportValve
extends ValveBase {
    private static final String info = "org.apache.catalina.valves.ErrorReportValve/1.0";

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.getNext().invoke(request, response);
        Throwable throwable = (Throwable)request.getAttribute("javax.servlet.error.exception");
        if (response.isCommitted()) {
            return;
        }
        if (throwable != null) {
            response.setError();
            try {
                response.reset();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            response.sendError(500);
        }
        response.setSuspended(false);
        try {
            this.report(request, response, throwable);
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    protected void report(Request request, Response response, Throwable throwable) {
        int statusCode = response.getStatus();
        if (statusCode < 400 || response.getContentCount() > 0) {
            return;
        }
        String message = RequestUtil.filter(response.getMessage());
        if (message == null) {
            String exceptionMessage;
            if (throwable != null && (exceptionMessage = throwable.getMessage()) != null && exceptionMessage.length() > 0) {
                message = RequestUtil.filter(new Scanner(exceptionMessage).nextLine());
            }
            if (message == null) {
                message = "";
            }
        }
        String report = null;
        switch (statusCode) {
            case 404: {
                report = CatalinaMessages.MESSAGES.http404();
                break;
            }
            case 500: {
                report = CatalinaMessages.MESSAGES.http500();
                break;
            }
            case 400: {
                report = CatalinaMessages.MESSAGES.http400();
                break;
            }
            case 403: {
                report = CatalinaMessages.MESSAGES.http403();
                break;
            }
            case 401: {
                report = CatalinaMessages.MESSAGES.http401();
                break;
            }
            case 402: {
                report = CatalinaMessages.MESSAGES.http402();
                break;
            }
            case 405: {
                report = CatalinaMessages.MESSAGES.http405();
                break;
            }
            case 406: {
                report = CatalinaMessages.MESSAGES.http406();
                break;
            }
            case 407: {
                report = CatalinaMessages.MESSAGES.http407();
                break;
            }
            case 408: {
                report = CatalinaMessages.MESSAGES.http408();
                break;
            }
            case 409: {
                report = CatalinaMessages.MESSAGES.http409();
                break;
            }
            case 410: {
                report = CatalinaMessages.MESSAGES.http410();
                break;
            }
            case 411: {
                report = CatalinaMessages.MESSAGES.http411();
                break;
            }
            case 412: {
                report = CatalinaMessages.MESSAGES.http412();
                break;
            }
            case 413: {
                report = CatalinaMessages.MESSAGES.http413();
                break;
            }
            case 414: {
                report = CatalinaMessages.MESSAGES.http414();
                break;
            }
            case 415: {
                report = CatalinaMessages.MESSAGES.http415();
                break;
            }
            case 416: {
                report = CatalinaMessages.MESSAGES.http416();
                break;
            }
            case 417: {
                report = CatalinaMessages.MESSAGES.http417();
                break;
            }
            case 422: {
                report = CatalinaMessages.MESSAGES.http422();
                break;
            }
            case 423: {
                report = CatalinaMessages.MESSAGES.http423();
                break;
            }
            case 424: {
                report = CatalinaMessages.MESSAGES.http424();
                break;
            }
            case 426: {
                report = CatalinaMessages.MESSAGES.http426();
                break;
            }
            case 428: {
                report = CatalinaMessages.MESSAGES.http428();
                break;
            }
            case 429: {
                report = CatalinaMessages.MESSAGES.http429();
                break;
            }
            case 431: {
                report = CatalinaMessages.MESSAGES.http431();
                break;
            }
            case 501: {
                report = CatalinaMessages.MESSAGES.http501();
                break;
            }
            case 502: {
                report = CatalinaMessages.MESSAGES.http502();
                break;
            }
            case 503: {
                report = CatalinaMessages.MESSAGES.http503();
                break;
            }
            case 504: {
                report = CatalinaMessages.MESSAGES.http504();
                break;
            }
            case 505: {
                report = CatalinaMessages.MESSAGES.http505();
                break;
            }
            case 506: {
                report = CatalinaMessages.MESSAGES.http506();
                break;
            }
            case 507: {
                report = CatalinaMessages.MESSAGES.http507();
                break;
            }
            case 508: {
                report = CatalinaMessages.MESSAGES.http508();
                break;
            }
            case 510: {
                report = CatalinaMessages.MESSAGES.http510();
                break;
            }
            case 511: {
                report = CatalinaMessages.MESSAGES.http511();
                break;
            }
            default: {
                return;
            }
        }
        if (report == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head><title>");
        sb.append(ServerInfo.getServerInfo()).append(" - ");
        sb.append(CatalinaMessages.MESSAGES.errorReport());
        sb.append("</title>");
        sb.append("<style><!--");
        sb.append("H1 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:22px;} H2 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:16px;} H3 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:14px;} BODY {font-family:Tahoma,Arial,sans-serif;color:black;background-color:white;} B {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;} P {font-family:Tahoma,Arial,sans-serif;background:white;color:black;font-size:12px;}A {color : black;}A.name {color : black;}HR {color : #525D76;}");
        sb.append("--></style> ");
        sb.append("</head><body>");
        sb.append("<h1>");
        sb.append(CatalinaMessages.MESSAGES.statusHeader(statusCode, message)).append("</h1>");
        sb.append("<HR size=\"1\" noshade=\"noshade\">");
        sb.append("<p><b>");
        sb.append(CatalinaMessages.MESSAGES.statusType());
        sb.append("</b> ");
        if (throwable != null) {
            sb.append(CatalinaMessages.MESSAGES.exceptionReport());
        } else {
            sb.append(CatalinaMessages.MESSAGES.statusReport());
        }
        sb.append("</p>");
        sb.append("<p><b>");
        sb.append(CatalinaMessages.MESSAGES.statusMessage());
        sb.append("</b> <u>");
        sb.append(message).append("</u></p>");
        sb.append("<p><b>");
        sb.append(CatalinaMessages.MESSAGES.statusDescritpion());
        sb.append("</b> <u>");
        sb.append(report);
        sb.append("</u></p>");
        if (throwable != null) {
            String stackTrace = this.getPartialServletStackTrace(throwable);
            sb.append("<p><b>");
            sb.append(CatalinaMessages.MESSAGES.statusException());
            sb.append("</b> <pre>");
            sb.append(RequestUtil.filter(stackTrace));
            sb.append("</pre></p>");
            int loops = 0;
            for (Throwable rootCause = throwable.getCause(); rootCause != null && loops < 10; rootCause = rootCause.getCause(), ++loops) {
                stackTrace = this.getPartialServletStackTrace(rootCause);
                sb.append("<p><b>");
                sb.append(CatalinaMessages.MESSAGES.statusRootCause());
                sb.append("</b> <pre>");
                sb.append(RequestUtil.filter(stackTrace));
                sb.append("</pre></p>");
            }
            sb.append("<p><b>");
            sb.append(CatalinaMessages.MESSAGES.statusNote());
            sb.append("</b> <u>");
            sb.append(CatalinaMessages.MESSAGES.statusRootCauseInLogs(ServerInfo.getServerInfo()));
            sb.append("</u></p>");
        }
        sb.append("<HR size=\"1\" noshade=\"noshade\">");
        sb.append("<h3>").append(ServerInfo.getServerInfo()).append("</h3>");
        sb.append("</body></html>");
        try {
            block53: {
                try {
                    response.setContentType("text/html");
                    response.setCharacterEncoding("utf-8");
                }
                catch (Throwable t) {
                    if (!this.container.getLogger().isDebugEnabled()) break block53;
                    this.container.getLogger().debug((Object)"status.setContentType", t);
                }
            }
            PrintWriter writer = response.getReporter();
            if (writer != null) {
                ((Writer)writer).write(sb.toString());
            }
        }
        catch (IOException iOException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected String getPartialServletStackTrace(Throwable t) {
        int i;
        StringBuilder trace = new StringBuilder();
        trace.append(t.toString()).append('\n');
        StackTraceElement[] elements = t.getStackTrace();
        int pos = elements.length;
        for (i = 0; i < elements.length; ++i) {
            if (!elements[i].getClassName().startsWith("org.apache.catalina.core.ApplicationFilterChain") || !elements[i].getMethodName().equals("internalDoFilter")) continue;
            pos = i;
        }
        for (i = 0; i < pos; ++i) {
            if (elements[i].getClassName().startsWith("org.apache.catalina.core.")) continue;
            trace.append('\t').append(elements[i].toString()).append('\n');
        }
        return trace.toString();
    }
}

