/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.tomcat.util.net.jsse.JSSELogger;
import org.apache.tomcat.util.net.jsse.openssl.OpenSSLCipherConfigurationParser;

public final class JSSEUtils {
    public static String[] getEnabledCiphers(String[] cipherSuites, String[] supportedCiphers) {
        return JSSEUtils.resolveEnabledCipherSuite(cipherSuites, new HashSet<String>(Arrays.asList(supportedCiphers)));
    }

    static String[] resolveEnabledCipherSuite(String[] cipherSuites, Set<String> supportedCiphers) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (cipherSuites.length == 1) {
            List<String> enabledCiphers = OpenSSLCipherConfigurationParser.parseExpression(cipherSuites[0]);
            if (enabledCiphers.isEmpty()) {
                result.addAll(JSSEUtils.filter(Arrays.asList(cipherSuites), supportedCiphers));
            } else {
                for (String enabledCipher : enabledCiphers) {
                    if (!supportedCiphers.contains(enabledCipher)) continue;
                    result.add(enabledCipher);
                }
            }
        } else {
            result.addAll(JSSEUtils.filter(Arrays.asList(cipherSuites), supportedCiphers));
        }
        if (!result.isEmpty()) {
            StringBuilder builder = new StringBuilder(result.size() * 16);
            for (String cipher : result) {
                builder.append(cipher);
                builder.append(",");
            }
            JSSELogger.ROOT_LOGGER.logUseableCiphers(builder.toString().substring(0, builder.length() - 1));
        }
        return result.toArray(new String[result.size()]);
    }

    private static Set<String> filter(List<String> enabledCiphers, Set<String> supportedCiphers) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String enabledCipher : enabledCiphers) {
            if (!supportedCiphers.contains(enabledCipher)) continue;
            result.add(enabledCipher);
        }
        return result;
    }
}

