/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.tomcat.util.net.ServerSocketFactory;
import org.apache.tomcat.util.net.jsse.JSSEKeyManager;
import org.apache.tomcat.util.net.jsse.JSSEUtils;
import org.jboss.web.CoyoteLogger;
import org.jboss.web.CoyoteMessages;

public class JSSESocketFactory
extends ServerSocketFactory {
    private static final boolean RFC_5746_SUPPORTED;
    public static final String[] DEFAULT_SERVER_PROTOCOLS;
    static String defaultProtocol;
    static boolean defaultClientAuth;
    static String defaultKeystoreType;
    private static final String defaultKeystoreFile;
    private static final String defaultKeyPass = "changeit";
    private static final int defaultSessionCacheSize = 0;
    private static final int defaultSessionTimeout = 86400;
    protected boolean initialized;
    protected String clientAuth = "false";
    protected SSLServerSocketFactory sslProxy = null;
    protected String[] enabledCiphers;
    protected boolean allowUnsafeLegacyRenegotiation = false;
    protected boolean requireClientAuth = false;
    protected boolean wantClientAuth = false;

    @Override
    public ServerSocket createSocket(int port) throws IOException {
        if (!this.initialized) {
            this.init();
        }
        ServerSocket socket = this.sslProxy.createServerSocket(port);
        this.initServerSocket(socket);
        return socket;
    }

    @Override
    public ServerSocket createSocket(int port, int backlog) throws IOException {
        if (!this.initialized) {
            this.init();
        }
        ServerSocket socket = this.sslProxy.createServerSocket(port, backlog);
        this.initServerSocket(socket);
        return socket;
    }

    @Override
    public ServerSocket createSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        if (!this.initialized) {
            this.init();
        }
        ServerSocket socket = this.sslProxy.createServerSocket(port, backlog, ifAddress);
        this.initServerSocket(socket);
        return socket;
    }

    @Override
    public Socket acceptSocket(ServerSocket socket) throws IOException {
        SSLSocket asock = null;
        try {
            asock = (SSLSocket)socket.accept();
        }
        catch (SSLException e) {
            throw new IOException(CoyoteMessages.MESSAGES.sslHandshakeError(), e);
        }
        return asock;
    }

    @Override
    public void handshake(Socket sock) throws IOException {
        SSLSession session = ((SSLSocket)sock).getSession();
        if (session.getCipherSuite().equals("SSL_NULL_WITH_NULL_NULL")) {
            throw new IOException(CoyoteMessages.MESSAGES.invalidSslCipherSuite());
        }
        if (!this.allowUnsafeLegacyRenegotiation && !RFC_5746_SUPPORTED) {
            ((SSLSocket)sock).setEnabledCipherSuites(new String[0]);
        }
    }

    protected String[] getEnabledCiphers(String requestedCiphers, String[] supportedCiphers) throws IOException {
        String[] enabledCiphers = null;
        if (requestedCiphers != null) {
            String[] ciphers = requestedCiphers.split(",");
            enabledCiphers = JSSEUtils.getEnabledCiphers(ciphers, supportedCiphers);
            if (enabledCiphers == null || enabledCiphers.length == 0) {
                throw new IOException(CoyoteMessages.MESSAGES.noCipherMatch());
            }
        } else {
            enabledCiphers = this.sslProxy.getDefaultCipherSuites();
        }
        return enabledCiphers;
    }

    protected String getKeystorePassword() {
        String keystorePass;
        String keyPass = (String)this.attributes.get("keypass");
        if (keyPass == null) {
            keyPass = defaultKeyPass;
        }
        if ((keystorePass = (String)this.attributes.get("keystorePass")) == null) {
            keystorePass = keyPass;
        }
        return keystorePass;
    }

    protected KeyStore getKeystore(String type, String provider, String pass) throws IOException {
        String keystoreFile = (String)this.attributes.get("keystore");
        if ("Windows-MY".equalsIgnoreCase(type)) {
            keystoreFile = "";
        } else if (keystoreFile == null) {
            keystoreFile = defaultKeystoreFile;
        }
        return this.getStore(type, provider, keystoreFile, pass);
    }

    protected KeyStore getTrustStore(String keystoreType, String keystoreProvider) throws IOException {
        String truststoreProvider;
        String truststoreType;
        String truststorePassword;
        KeyStore trustStore = null;
        String truststoreFile = (String)this.attributes.get("truststoreFile");
        if (truststoreFile == null) {
            truststoreFile = System.getProperty("javax.net.ssl.trustStore");
        }
        if (CoyoteLogger.UTIL_LOGGER.isDebugEnabled()) {
            CoyoteLogger.UTIL_LOGGER.debug("Truststore = " + truststoreFile);
        }
        if ((truststorePassword = (String)this.attributes.get("truststorePass")) == null) {
            truststorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
        }
        if (CoyoteLogger.UTIL_LOGGER.isDebugEnabled()) {
            CoyoteLogger.UTIL_LOGGER.debug("TrustPass = " + truststorePassword);
        }
        if ((truststoreType = (String)this.attributes.get("truststoreType")) == null) {
            truststoreType = System.getProperty("javax.net.ssl.trustStoreType");
        }
        if (truststoreType == null) {
            truststoreType = keystoreType;
        }
        if ("Windows-ROOT".equalsIgnoreCase(truststoreType)) {
            truststoreFile = "";
        }
        if (CoyoteLogger.UTIL_LOGGER.isDebugEnabled()) {
            CoyoteLogger.UTIL_LOGGER.debug("trustType = " + truststoreType);
        }
        if ((truststoreProvider = (String)this.attributes.get("truststoreProvider")) == null) {
            truststoreProvider = System.getProperty("javax.net.ssl.trustStoreProvider");
        }
        if (truststoreProvider == null) {
            truststoreProvider = keystoreProvider;
        }
        if (CoyoteLogger.UTIL_LOGGER.isDebugEnabled()) {
            CoyoteLogger.UTIL_LOGGER.debug("trustProvider = " + truststoreProvider);
        }
        if (truststoreFile != null) {
            trustStore = this.getStore(truststoreType, truststoreProvider, truststoreFile, truststorePassword);
        }
        return trustStore;
    }

    private KeyStore getStore(String type, String provider, String path, String pass) throws IOException {
        KeyStore ks = null;
        InputStream istream = null;
        try {
            ks = provider == null ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
            if (!"PKCS11".equalsIgnoreCase(type) && !"".equalsIgnoreCase(path)) {
                File keyStoreFile = new File(path);
                if (!keyStoreFile.isAbsolute()) {
                    keyStoreFile = new File(System.getProperty("catalina.base"), path);
                }
                istream = new FileInputStream(keyStoreFile);
            }
            char[] storePass = null;
            if (pass != null) {
                storePass = pass.toCharArray();
            }
            ks.load(istream, storePass);
        }
        catch (FileNotFoundException fnfe) {
            CoyoteLogger.UTIL_LOGGER.errorLoadingKeystore(type, path, fnfe.getMessage());
            throw fnfe;
        }
        catch (IOException ioe) {
            CoyoteLogger.UTIL_LOGGER.errorLoadingKeystoreWithException(type, path, ioe.getMessage(), ioe);
            throw ioe;
        }
        catch (Exception ex) {
            CoyoteLogger.UTIL_LOGGER.errorLoadingKeystoreWithException(type, path, ex.getMessage(), ex);
            throw new IOException(ex);
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException ioe) {}
            }
        }
        return ks;
    }

    void init() throws IOException {
        try {
            SSLContext context;
            String keystoreType;
            String algorithm;
            String clientAuthStr = (String)this.attributes.get("clientauth");
            if ("true".equalsIgnoreCase(clientAuthStr) || "yes".equalsIgnoreCase(clientAuthStr)) {
                this.requireClientAuth = true;
            } else if ("want".equalsIgnoreCase(clientAuthStr)) {
                this.wantClientAuth = true;
            }
            String protocol = (String)this.attributes.get("protocol");
            if (protocol == null) {
                protocol = defaultProtocol;
            }
            if ((algorithm = (String)this.attributes.get("algorithm")) == null) {
                algorithm = KeyManagerFactory.getDefaultAlgorithm();
            }
            if ((keystoreType = (String)this.attributes.get("keystoreType")) == null) {
                keystoreType = defaultKeystoreType;
            }
            String keystoreProvider = (String)this.attributes.get("keystoreProvider");
            String trustAlgorithm = (String)this.attributes.get("truststoreAlgorithm");
            if (trustAlgorithm == null) {
                trustAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            }
            if ((context = (SSLContext)this.attributes.get("SSLContext")) == null) {
                context = SSLContext.getInstance(protocol);
                context.init(this.getKeyManagers(keystoreType, keystoreProvider, algorithm, (String)this.attributes.get("keyAlias")), this.getTrustManagers(keystoreType, keystoreProvider, trustAlgorithm), new SecureRandom());
            }
            int sessionCacheSize = this.attributes.get("sessionCacheSize") != null ? Integer.parseInt((String)this.attributes.get("sessionCacheSize")) : 0;
            int sessionCacheTimeout = this.attributes.get("sessionCacheTimeout") != null ? Integer.parseInt((String)this.attributes.get("sessionCacheTimeout")) : 86400;
            SSLSessionContext sessionContext = context.getServerSessionContext();
            if (sessionContext != null) {
                sessionContext.setSessionCacheSize(sessionCacheSize);
                sessionContext.setSessionTimeout(sessionCacheTimeout);
            }
            this.sslProxy = context.getServerSocketFactory();
            String requestedCiphers = (String)this.attributes.get("ciphers");
            this.enabledCiphers = this.getEnabledCiphers(requestedCiphers, this.sslProxy.getSupportedCipherSuites());
            this.allowUnsafeLegacyRenegotiation = "true".equals(this.attributes.get("allowUnsafeLegacyRenegotiation"));
            this.checkConfig();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
    }

    protected KeyManager[] getKeyManagers(String keystoreType, String keystoreProvider, String algorithm, String keyAlias) throws Exception {
        KeyManager[] kms = null;
        String keystorePass = this.getKeystorePassword();
        KeyStore ks = this.getKeystore(keystoreType, keystoreProvider, keystorePass);
        if (keyAlias != null && !ks.isKeyEntry(keyAlias)) {
            throw new IOException(CoyoteMessages.MESSAGES.noKeyAlias(keyAlias));
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
        kmf.init(ks, keystorePass.toCharArray());
        kms = kmf.getKeyManagers();
        if (keyAlias != null) {
            if (defaultKeystoreType.equals(keystoreType)) {
                keyAlias = keyAlias.toLowerCase(Locale.ENGLISH);
            }
            for (int i = 0; i < kms.length; ++i) {
                kms[i] = new JSSEKeyManager((X509KeyManager)kms[i], keyAlias);
            }
        }
        return kms;
    }

    protected TrustManager[] getTrustManagers(String keystoreType, String keystoreProvider, String algorithm) throws Exception {
        String crlf = (String)this.attributes.get("crlFile");
        TrustManager[] tms = null;
        KeyStore trustStore = this.getTrustStore(keystoreType, keystoreProvider);
        if (trustStore != null) {
            if (crlf == null) {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                tmf.init(trustStore);
                tms = tmf.getTrustManagers();
            } else {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                CertPathParameters params = this.getParameters(algorithm, crlf, trustStore);
                CertPathTrustManagerParameters mfp = new CertPathTrustManagerParameters(params);
                tmf.init(mfp);
                tms = tmf.getTrustManagers();
            }
        }
        return tms;
    }

    protected CertPathParameters getParameters(String algorithm, String crlf, KeyStore trustStore) throws Exception {
        PKIXBuilderParameters xparams;
        PKIXBuilderParameters params = null;
        if ("PKIX".equalsIgnoreCase(algorithm)) {
            xparams = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
            Collection<? extends CRL> crls = this.getCRLs(crlf);
            CollectionCertStoreParameters csp = new CollectionCertStoreParameters(crls);
            CertStore store = CertStore.getInstance("Collection", csp);
            xparams.addCertStore(store);
            xparams.setRevocationEnabled(true);
            String trustLength = (String)this.attributes.get("trustMaxCertLength");
            if (trustLength != null) {
                try {
                    xparams.setMaxPathLength(Integer.parseInt(trustLength));
                }
                catch (Exception ex) {
                    CoyoteLogger.UTIL_LOGGER.invalidMaxCertLength(trustLength);
                }
            }
        } else {
            throw new CRLException(CoyoteMessages.MESSAGES.unsupportedCrl(algorithm));
        }
        params = xparams;
        return params;
    }

    protected Collection<? extends CRL> getCRLs(String crlf) throws IOException, CRLException, CertificateException {
        File crlFile = new File(crlf);
        if (!crlFile.isAbsolute()) {
            crlFile = new File(System.getProperty("catalina.base"), crlf);
        }
        Collection<? extends CRL> crls = null;
        InputStream is = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            is = new FileInputStream(crlFile);
            crls = cf.generateCRLs(is);
        }
        catch (IOException iex) {
            throw iex;
        }
        catch (CRLException crle) {
            throw crle;
        }
        catch (CertificateException ce) {
            throw ce;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ex) {}
            }
        }
        return crls;
    }

    protected void setEnabledProtocols(SSLServerSocket socket, String[] protocols) {
        if (protocols == null) {
            socket.setEnabledProtocols(DEFAULT_SERVER_PROTOCOLS);
        } else {
            socket.setEnabledProtocols(protocols);
        }
    }

    protected String[] getEnabledProtocols(SSLServerSocket socket, String requestedProtocols) {
        HashSet<String> supportedProtocols = new HashSet<String>();
        for (String supportedProtocol : socket.getSupportedProtocols()) {
            supportedProtocols.add(supportedProtocol);
        }
        if (requestedProtocols == null) {
            return DEFAULT_SERVER_PROTOCOLS;
        }
        String[] requestedProtocolsArr = requestedProtocols.split(",");
        ArrayList<String> enabledProtocols = new ArrayList<String>(requestedProtocolsArr.length);
        for (String requestedProtocol : requestedProtocolsArr) {
            String requestedProtocolTrim = requestedProtocol.trim();
            if (supportedProtocols.contains(requestedProtocolTrim)) {
                enabledProtocols.add(requestedProtocolTrim);
                continue;
            }
            CoyoteLogger.UTIL_LOGGER.unsupportedProtocol(requestedProtocolTrim);
        }
        return enabledProtocols.toArray(new String[enabledProtocols.size()]);
    }

    protected void configureClientAuth(SSLServerSocket socket) {
        if (this.wantClientAuth) {
            socket.setWantClientAuth(this.wantClientAuth);
        } else {
            socket.setNeedClientAuth(this.requireClientAuth);
        }
    }

    protected void configureClientAuth(SSLSocket socket) {
    }

    private void initServerSocket(ServerSocket ssocket) {
        SSLServerSocket socket = (SSLServerSocket)ssocket;
        if (this.enabledCiphers != null) {
            socket.setEnabledCipherSuites(this.enabledCiphers);
        }
        String requestedProtocols = (String)this.attributes.get("protocols");
        socket.setEnabledProtocols(this.getEnabledProtocols(socket, requestedProtocols));
        this.configureClientAuth(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConfig() throws IOException {
        ServerSocket socket = this.sslProxy.createServerSocket();
        this.initServerSocket(socket);
        try {
            socket.setSoTimeout(1);
            socket.accept();
        }
        catch (SSLException ssle) {
            IOException ioe = new IOException(CoyoteMessages.MESSAGES.invalidSSLConfiguration(ssle.getMessage()));
            ioe.initCause(ssle);
            throw ioe;
        }
        catch (Exception exception) {
        }
        finally {
            if (!socket.isClosed()) {
                socket.close();
            }
        }
    }

    public static String[] filterInsecureProcotols(String[] protocols) {
        if (protocols == null) {
            return null;
        }
        String vmVersion = System.getProperty("java.runtime.version");
        boolean isJava6JVM = vmVersion != null && vmVersion.startsWith("1.6");
        ArrayList<String> result = new ArrayList<String>(protocols.length);
        for (String protocol : protocols) {
            if (protocol == null || protocol.toUpperCase(Locale.ENGLISH).contains("SSL")) {
                if (CoyoteLogger.UTIL_LOGGER.isDebugEnabled()) {
                    CoyoteLogger.UTIL_LOGGER.debug("Exclude protocol: " + protocol);
                }
                if (protocol == null || !isJava6JVM || !protocol.equalsIgnoreCase("SSLv2Hello")) continue;
                result.add(protocol);
                continue;
            }
            result.add(protocol);
        }
        return result.toArray(new String[result.size()]);
    }

    static {
        defaultProtocol = "TLS";
        defaultClientAuth = false;
        defaultKeystoreType = "JKS";
        defaultKeystoreFile = System.getProperty("user.home") + "/.keystore";
        boolean result = false;
        String[] protocols = null;
        try {
            String[] ciphers;
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, null, new SecureRandom());
            SSLServerSocketFactory ssf = context.getServerSocketFactory();
            for (String cipher : ciphers = ssf.getSupportedCipherSuites()) {
                if (!"TLS_EMPTY_RENEGOTIATION_INFO_SCSV".equals(cipher)) continue;
                result = true;
                break;
            }
            SSLServerSocket socket = (SSLServerSocket)ssf.createServerSocket();
            protocols = JSSESocketFactory.filterInsecureProcotols(socket.getEnabledProtocols());
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (KeyManagementException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        RFC_5746_SUPPORTED = result;
        DEFAULT_SERVER_PROTOCOLS = protocols;
    }
}

