/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.util.ArrayList;
import org.apache.coyote.RequestInfo;

public class RequestGroupInfo {
    ArrayList processors = new ArrayList();
    private long deadMaxTime = 0L;
    private long deadProcessingTime = 0L;
    private int deadRequestCount = 0;
    private int deadErrorCount = 0;
    private long deadBytesReceived = 0L;
    private long deadBytesSent = 0L;

    public synchronized void addRequestProcessor(RequestInfo rp) {
        this.processors.add(rp);
    }

    public synchronized void removeRequestProcessor(RequestInfo rp) {
        if (rp != null) {
            if (this.deadMaxTime < rp.getMaxTime()) {
                this.deadMaxTime = rp.getMaxTime();
            }
            this.deadProcessingTime += rp.getProcessingTime();
            this.deadRequestCount += rp.getRequestCount();
            this.deadErrorCount += rp.getErrorCount();
            this.deadBytesReceived += rp.getBytesReceived();
            this.deadBytesSent += rp.getBytesSent();
            this.processors.remove(rp);
        }
    }

    public synchronized RequestInfo[] getRequestProcessors() {
        return this.processors.toArray(new RequestInfo[0]);
    }

    public synchronized long getMaxTime() {
        long maxTime = this.deadMaxTime;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo rp = (RequestInfo)this.processors.get(i);
            if (maxTime >= rp.getMaxTime()) continue;
            maxTime = rp.getMaxTime();
        }
        return maxTime;
    }

    public synchronized void setMaxTime(long maxTime) {
        this.deadMaxTime = maxTime;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo rp = (RequestInfo)this.processors.get(i);
            rp.setMaxTime(maxTime);
        }
    }

    public synchronized long getProcessingTime() {
        long time = this.deadProcessingTime;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo rp = (RequestInfo)this.processors.get(i);
            time += rp.getProcessingTime();
        }
        return time;
    }

    public synchronized void setProcessingTime(long totalTime) {
        this.deadProcessingTime = totalTime;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo rp = (RequestInfo)this.processors.get(i);
            rp.setProcessingTime(totalTime);
        }
    }

    public synchronized int getRequestCount() {
        int requestCount = this.deadRequestCount;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo rp = (RequestInfo)this.processors.get(i);
            requestCount += rp.getRequestCount();
        }
        return requestCount;
    }

    public synchronized void setRequestCount(int requestCount) {
        this.deadRequestCount = requestCount;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo rp = (RequestInfo)this.processors.get(i);
            rp.setRequestCount(requestCount);
        }
    }

    public synchronized int getErrorCount() {
        int requestCount = this.deadErrorCount;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo rp = (RequestInfo)this.processors.get(i);
            requestCount += rp.getErrorCount();
        }
        return requestCount;
    }

    public synchronized void setErrorCount(int errorCount) {
        this.deadErrorCount = errorCount;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo rp = (RequestInfo)this.processors.get(i);
            rp.setErrorCount(errorCount);
        }
    }

    public synchronized long getBytesReceived() {
        long bytes = this.deadBytesReceived;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo rp = (RequestInfo)this.processors.get(i);
            bytes += rp.getBytesReceived();
        }
        return bytes;
    }

    public synchronized void setBytesReceived(long bytesReceived) {
        this.deadBytesReceived = bytesReceived;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo rp = (RequestInfo)this.processors.get(i);
            rp.setBytesReceived(bytesReceived);
        }
    }

    public synchronized long getBytesSent() {
        long bytes = this.deadBytesSent;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo rp = (RequestInfo)this.processors.get(i);
            bytes += rp.getBytesSent();
        }
        return bytes;
    }

    public synchronized void setBytesSent(long bytesSent) {
        this.deadBytesSent = bytesSent;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo rp = (RequestInfo)this.processors.get(i);
            rp.setBytesSent(bytesSent);
        }
    }

    public void resetCounters() {
        this.setBytesReceived(0L);
        this.setBytesSent(0L);
        this.setRequestCount(0);
        this.setProcessingTime(0L);
        this.setMaxTime(0L);
        this.setErrorCount(0);
    }
}

