/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.php;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.util.IOTools;
import org.jboss.web.WebLogger;

public class ScriptEnvironment {
    private static final String CERTIFICATE_KEY = "javax.servlet.request.X509Certificate";
    private static final String CIPHER_SUITE = "javax.servlet.request.cipher_suite";
    private static final String SSL_SESSION = "javax.servlet.request.ssl_session";
    private static final String KEY_SIZE = "javax.servlet.request.key_size";
    private ServletContext context = null;
    private String scriptFullPath = null;
    private String contextPath = null;
    private String servletPath = null;
    private String pathInfo = null;
    private String webAppRootDir = null;
    private File tempDir = null;
    private Hashtable env = null;
    private File workingDirectory = null;
    private File scriptFile = null;
    private ArrayList queryParameters = new ArrayList();
    private boolean valid = false;
    private static Object expandFileLock = new Object();
    private String scriptPathPrefix = null;

    protected String[] findScript(String pathInfo, String webAppRootDir, String contextPath, String servletPath, String scriptPathPrefix) {
        String path = null;
        String name = null;
        String scriptName = null;
        String fullName = null;
        if (webAppRootDir != null && webAppRootDir.lastIndexOf(File.separator) == webAppRootDir.length() - 1) {
            webAppRootDir = webAppRootDir.substring(0, webAppRootDir.length() - 1);
        }
        if (scriptPathPrefix != null) {
            webAppRootDir = webAppRootDir + File.separator + scriptPathPrefix;
        }
        File currentLocation = new File(webAppRootDir);
        StringTokenizer dirWalker = new StringTokenizer(pathInfo, "/");
        while (!currentLocation.isFile() && dirWalker.hasMoreElements()) {
            currentLocation = new File(currentLocation, (String)dirWalker.nextElement());
        }
        if (!currentLocation.isFile()) {
            return new String[]{null, null, null, null};
        }
        path = currentLocation.getAbsolutePath();
        name = currentLocation.getName();
        fullName = currentLocation.getParent().substring(webAppRootDir.length()) + File.separator + name;
        fullName = fullName.replace(File.separatorChar, '/');
        scriptName = contextPath != null && !"".equals(contextPath) && !"/".equals(contextPath) ? contextPath + fullName : fullName;
        return new String[]{path, scriptName, fullName, name};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expandScript() {
        block12: {
            StringBuffer srcPath = new StringBuffer();
            StringBuffer dstPath = new StringBuffer();
            InputStream is = null;
            if (this.scriptPathPrefix == null) {
                srcPath.append(this.pathInfo);
                is = this.context.getResourceAsStream(srcPath.toString());
                dstPath.append(this.tempDir);
                dstPath.append(this.pathInfo);
            } else {
                srcPath.append(this.scriptPathPrefix);
                StringTokenizer dirWalker = new StringTokenizer(this.pathInfo, "/");
                while (dirWalker.hasMoreElements() && is == null) {
                    srcPath.append("/");
                    srcPath.append(dirWalker.nextElement());
                    is = this.context.getResourceAsStream(srcPath.toString());
                }
                dstPath.append(this.tempDir);
                dstPath.append("/");
                dstPath.append(srcPath);
            }
            if (is == null) {
                return;
            }
            File f = new File(dstPath.toString());
            if (f.exists()) {
                return;
            }
            String dirPath = new String(dstPath.toString().substring(0, dstPath.toString().lastIndexOf("/")));
            File dir = new File(dirPath);
            dir.mkdirs();
            try {
                Object object = expandFileLock;
                synchronized (object) {
                    if (f.exists()) {
                        return;
                    }
                    if (!f.createNewFile()) {
                        return;
                    }
                    FileOutputStream fos = new FileOutputStream(f);
                    IOTools.flow(is, fos);
                    is.close();
                    fos.close();
                }
            }
            catch (IOException ioe) {
                if (!f.exists()) break block12;
                f.delete();
            }
        }
    }

    protected boolean setEnvironment(HttpServletRequest req) throws IOException {
        Hashtable<String, Object> envp = new Hashtable<String, Object>();
        String sPathInfoOrig = null;
        String sPathTranslatedOrig = null;
        String sPathInfo = null;
        String sPathTranslated = null;
        String sFullPath = null;
        String sScriptName = null;
        String sFullName = null;
        String sName = null;
        sPathInfoOrig = this.pathInfo;
        sPathInfoOrig = sPathInfoOrig == null ? "" : sPathInfoOrig;
        sPathTranslatedOrig = req.getPathTranslated();
        String string = sPathTranslatedOrig = sPathTranslatedOrig == null ? "" : sPathTranslatedOrig;
        if (this.webAppRootDir == null) {
            this.webAppRootDir = this.tempDir.toString();
            this.expandScript();
        }
        String[] sScriptNames = this.findScript(sPathInfoOrig, this.webAppRootDir, this.contextPath, this.servletPath, this.scriptPathPrefix);
        sFullPath = sScriptNames[0];
        sScriptName = sScriptNames[1];
        sFullName = sScriptNames[2];
        sName = sScriptNames[3];
        if (sFullPath == null || sScriptName == null || sFullName == null || sName == null) {
            WebLogger.ROOT_LOGGER.invalidScriptNames();
            return false;
        }
        envp.put("SERVER_SOFTWARE", "JBossWebServer");
        envp.put("SERVER_NAME", this.nullsToBlanks(req.getServerName()));
        envp.put("GATEWAY_INTERFACE", "CGI/1.1");
        envp.put("SERVER_PROTOCOL", this.nullsToBlanks(req.getProtocol()));
        int port = req.getServerPort();
        Integer sPort = port == 0 ? new Integer(-1) : new Integer(port);
        envp.put("SERVER_PORT", sPort.toString());
        envp.put("LOCAL_NAME", this.nullsToBlanks(req.getLocalName()));
        port = req.getLocalPort();
        Integer iPort = port == 0 ? new Integer(-1) : new Integer(port);
        envp.put("LOCAL_PORT", iPort.toString());
        envp.put("LOCAL_ADDR", this.nullsToBlanks(req.getLocalAddr()));
        envp.put("REQUEST_METHOD", this.nullsToBlanks(req.getMethod()));
        sPathInfo = this.pathInfo == null || this.pathInfo.substring(sFullName.length()).length() <= 0 ? "" : this.pathInfo.substring(sFullName.length());
        envp.put("PATH_INFO", sPathInfo);
        sPathTranslated = sPathInfo != null && !"".equals(sPathInfo) ? this.context.getRealPath(sPathInfo) : null;
        if (sPathTranslated != null && !"".equals(sPathTranslated)) {
            envp.put("PATH_TRANSLATED", this.nullsToBlanks(sPathTranslated));
        }
        envp.put("SCRIPT_NAME", this.nullsToBlanks(sScriptName));
        envp.put("QUERY_STRING", this.nullsToBlanks(req.getQueryString()));
        envp.put("REMOTE_HOST", this.nullsToBlanks(req.getRemoteHost()));
        envp.put("REMOTE_ADDR", this.nullsToBlanks(req.getRemoteAddr()));
        envp.put("AUTH_TYPE", this.nullsToBlanks(req.getAuthType()));
        envp.put("REMOTE_USER", this.nullsToBlanks(req.getRemoteUser()));
        envp.put("REMOTE_IDENT", "");
        envp.put("CONTENT_TYPE", this.nullsToBlanks(req.getContentType()));
        int contentLength = req.getContentLength();
        String sContentLength = contentLength <= 0 ? "" : new Integer(contentLength).toString();
        envp.put("CONTENT_LENGTH", sContentLength);
        Enumeration headers = req.getHeaderNames();
        String header = null;
        while (headers.hasMoreElements()) {
            header = null;
            header = ((String)headers.nextElement()).toUpperCase(Locale.ENGLISH);
            if ("AUTHORIZATION".equalsIgnoreCase(header) || "PROXY_AUTHORIZATION".equalsIgnoreCase(header)) continue;
            envp.put("HTTP_" + header.replace('-', '_'), req.getHeader(header));
        }
        this.scriptFile = new File(sFullPath);
        this.scriptFullPath = this.scriptFile.getCanonicalPath();
        this.workingDirectory = new File(this.scriptFullPath.substring(0, this.scriptFullPath.lastIndexOf(File.separator)));
        envp.put("SCRIPT_FILENAME", this.scriptFullPath);
        envp.put("CONTEXT_PATH", this.nullsToBlanks(this.contextPath));
        String self = "";
        if (this.contextPath != null && !"".equals(this.contextPath) && !"/".equals(this.contextPath)) {
            self = this.contextPath;
        }
        if (this.servletPath != null && !"".equals(this.servletPath) && !"/".equals(this.servletPath)) {
            self = self.concat(this.servletPath);
        }
        envp.put("PHP_SELF", this.nullsToBlanks(self));
        if (req.isSecure()) {
            envp.put("HTTPS", "ON");
            envp.put("SSL_CIPHER", req.getAttribute(CIPHER_SUITE));
            envp.put("SSL_SESSION_ID", req.getAttribute(SSL_SESSION));
            envp.put("SSL_CIPHER_USEKEYSIZE", String.valueOf(req.getAttribute(KEY_SIZE)));
            X509Certificate[] certs = (X509Certificate[])req.getAttribute(CERTIFICATE_KEY);
            if (certs != null) {
                String[] pprs;
                int c;
                envp.put("SSL_SERVER_V_START", certs[0].getNotAfter().toString());
                envp.put("SSL_SERVER_V_END", certs[0].getNotBefore().toString());
                envp.put("SSL_CLIENT_A_KEY", certs[0].getSigAlgName());
                envp.put("SSL_SERVER_M_SERIAL", certs[0].getSerialNumber().toString());
                envp.put("SSL_SERVER_M_VERSION", String.valueOf(certs[0].getVersion()));
                envp.put("SSL_CLIENT_S_DN", certs[0].getSubjectX500Principal().getName());
                String pr = certs[0].getSubjectX500Principal().getName();
                String[] prs = pr.split(", ");
                for (c = 0; c < prs.length; ++c) {
                    pprs = prs[c].split("=");
                    envp.put("SSL_CLIENT_S_DN_" + pprs[0], pprs[1]);
                }
                envp.put("SSL_CLIENT_I_DN", certs[0].getIssuerX500Principal().getName());
                pr = certs[0].getSubjectX500Principal().getName();
                prs = pr.split(", ");
                for (c = 0; c < prs.length; ++c) {
                    pprs = prs[c].split("=");
                    envp.put("SSL_CLIENT_I_DN_" + pprs[0], pprs[1]);
                }
            }
        }
        this.env = envp;
        return true;
    }

    public ScriptEnvironment(HttpServletRequest req, ServletContext context, String scriptPathPrefix) throws IOException {
        this.scriptPathPrefix = scriptPathPrefix;
        this.context = context;
        this.webAppRootDir = context.getRealPath("/");
        this.tempDir = (File)context.getAttribute("javax.servlet.context.tempdir");
        if (req.getAttribute("javax.servlet.include.context_path") != null) {
            this.contextPath = (String)req.getAttribute("javax.servlet.include.context_path");
            this.servletPath = (String)req.getAttribute("javax.servlet.include.servlet_path");
            this.pathInfo = (String)req.getAttribute("javax.servlet.include.path_info");
        } else {
            this.contextPath = req.getContextPath();
            this.servletPath = req.getServletPath();
            this.pathInfo = req.getPathInfo();
        }
        if (this.pathInfo == null) {
            this.pathInfo = this.servletPath;
        }
        this.valid = this.setEnvironment(req);
    }

    public String getFullPath() {
        return this.scriptFullPath;
    }

    public File getScriptFile() {
        return this.scriptFile;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public Hashtable getEnvironment() {
        return this.env;
    }

    public ArrayList getParameters() {
        return this.queryParameters;
    }

    public boolean isValid() {
        return this.valid;
    }

    protected String nullsToBlanks(String s) {
        return this.nullsToString(s, "");
    }

    protected String nullsToString(String couldBeNull, String subForNulls) {
        return couldBeNull == null ? subForNulls : couldBeNull;
    }

    protected String blanksToString(String couldBeBlank, String subForBlanks) {
        return "".equals(couldBeBlank) || couldBeBlank == null ? subForBlanks : couldBeBlank;
    }

    public String[] getEnvironmentArray() throws NullPointerException {
        return ScriptEnvironment.hashToStringArray(this.env);
    }

    public static String[] hashToStringArray(Hashtable h) throws NullPointerException {
        Vector<String> v = new Vector<String>();
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            String k = e.nextElement().toString();
            v.add(k);
            v.add((String)h.get(k));
        }
        Object[] strArr = new String[v.size()];
        v.copyInto(strArr);
        return strArr;
    }
}

