/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.InputStream;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.tagplugin.TagPlugin;
import org.apache.jasper.compiler.tagplugin.TagPluginContext;
import org.jboss.web.JasperMessages;

public class TagPluginManager {
    private static final String TAG_PLUGINS_XML = "/WEB-INF/tagPlugins.xml";
    private static final String TAG_PLUGINS_ROOT_ELEM = "tag-plugins";
    private boolean initialized = false;
    private HashMap<String, TagPlugin> tagPlugins = null;
    private ServletContext ctxt;
    private PageInfo pageInfo;

    public TagPluginManager(ServletContext ctxt) {
        this.ctxt = ctxt;
    }

    public void apply(Node.Nodes page, ErrorDispatcher err, PageInfo pageInfo) throws JasperException {
        this.init(err);
        if (this.tagPlugins == null || this.tagPlugins.size() == 0) {
            return;
        }
        this.pageInfo = pageInfo;
        page.visit(new Node.Visitor(){

            @Override
            public void visit(Node.CustomTag n) throws JasperException {
                TagPluginManager.this.invokePlugin(n);
                this.visitBody(n);
            }
        });
    }

    private void init(ErrorDispatcher err) throws JasperException {
        if (this.initialized) {
            return;
        }
        InputStream is = this.ctxt.getResourceAsStream(TAG_PLUGINS_XML);
        if (is == null) {
            return;
        }
        try {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(is);
            reader.require(7, null, null);
            reader.require(7, null, null);
            while (reader.hasNext() && reader.next() != 1) {
            }
            if (!TAG_PLUGINS_ROOT_ELEM.equals(reader.getLocalName())) {
                err.jspError(JasperMessages.MESSAGES.wrongRootElement(TAG_PLUGINS_XML, TAG_PLUGINS_ROOT_ELEM));
            }
            this.tagPlugins = new HashMap();
            while (reader.hasNext() && reader.nextTag() != 2) {
                String elementName = reader.getLocalName();
                if ("tag-plugin".equals(elementName)) {
                    String tagClassName = null;
                    String pluginClassName = null;
                    while (reader.hasNext() && reader.nextTag() != 2) {
                        String childClementName = reader.getLocalName();
                        if ("tag-class".equals(childClementName)) {
                            tagClassName = reader.getElementText().trim();
                            continue;
                        }
                        if ("plugin-class".equals(childClementName)) {
                            pluginClassName = reader.getElementText().trim();
                            continue;
                        }
                        err.jspError(JasperMessages.MESSAGES.invalidTagPlugin(TAG_PLUGINS_XML));
                    }
                    if (tagClassName == null || pluginClassName == null) {
                        err.jspError(JasperMessages.MESSAGES.invalidTagPlugin(TAG_PLUGINS_XML));
                    }
                    TagPlugin tagPlugin = null;
                    try {
                        Class<?> pluginClass = Thread.currentThread().getContextClassLoader().loadClass(pluginClassName);
                        tagPlugin = (TagPlugin)pluginClass.newInstance();
                    }
                    catch (Exception e) {
                        throw new JasperException(e);
                    }
                    if (tagPlugin == null) {
                        return;
                    }
                    this.tagPlugins.put(tagClassName, tagPlugin);
                    continue;
                }
                err.jspError(JasperMessages.MESSAGES.invalidTagPlugin(TAG_PLUGINS_XML));
            }
        }
        catch (XMLStreamException e) {
            err.jspError(JasperMessages.MESSAGES.invalidTagPlugin(TAG_PLUGINS_XML), e);
        }
        catch (FactoryConfigurationError e) {
            throw new JasperException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable e) {}
            }
        }
        this.initialized = true;
    }

    private void invokePlugin(Node.CustomTag n) {
        TagPlugin tagPlugin = this.tagPlugins.get(n.getTagHandlerClass().getName());
        if (tagPlugin == null) {
            return;
        }
        TagPluginContextImpl tagPluginContext = new TagPluginContextImpl(n, this.pageInfo);
        n.setTagPluginContext(tagPluginContext);
        tagPlugin.doTag(tagPluginContext);
    }

    static class TagPluginContextImpl
    implements TagPluginContext {
        private Node.CustomTag node;
        private Node.Nodes curNodes;
        private PageInfo pageInfo;
        private HashMap pluginAttributes;

        TagPluginContextImpl(Node.CustomTag n, PageInfo pageInfo) {
            this.node = n;
            this.pageInfo = pageInfo;
            this.curNodes = new Node.Nodes();
            n.setAtETag(this.curNodes);
            this.curNodes = new Node.Nodes();
            n.setAtSTag(this.curNodes);
            n.setUseTagPlugin(true);
            this.pluginAttributes = new HashMap();
        }

        @Override
        public TagPluginContext getParentContext() {
            Node parent = this.node.getParent();
            if (!(parent instanceof Node.CustomTag)) {
                return null;
            }
            return ((Node.CustomTag)parent).getTagPluginContext();
        }

        @Override
        public void setPluginAttribute(String key, Object value) {
            this.pluginAttributes.put(key, value);
        }

        @Override
        public Object getPluginAttribute(String key) {
            return this.pluginAttributes.get(key);
        }

        @Override
        public boolean isScriptless() {
            return this.node.getChildInfo().isScriptless();
        }

        @Override
        public boolean isConstantAttribute(String attribute) {
            Node.JspAttribute attr = this.getNodeAttribute(attribute);
            if (attr == null) {
                return false;
            }
            return attr.isLiteral();
        }

        @Override
        public String getConstantAttribute(String attribute) {
            Node.JspAttribute attr = this.getNodeAttribute(attribute);
            if (attr == null) {
                return null;
            }
            return attr.getValue();
        }

        @Override
        public boolean isAttributeSpecified(String attribute) {
            return this.getNodeAttribute(attribute) != null;
        }

        @Override
        public String getTemporaryVariableName() {
            return this.node.getRoot().nextTemporaryVariableName();
        }

        @Override
        public void generateImport(String imp) {
            this.pageInfo.addImport(imp);
        }

        @Override
        public void generateDeclaration(String id, String text) {
            if (this.pageInfo.isPluginDeclared(id)) {
                return;
            }
            this.curNodes.add(new Node.Declaration(text, this.node.getStart(), null));
        }

        @Override
        public void generateJavaSource(String sourceCode) {
            this.curNodes.add(new Node.Scriptlet(sourceCode, this.node.getStart(), null));
        }

        @Override
        public void generateAttribute(String attributeName) {
            this.curNodes.add(new Node.AttributeGenerator(this.node.getStart(), attributeName, this.node));
        }

        @Override
        public void dontUseTagPlugin() {
            this.node.setUseTagPlugin(false);
        }

        @Override
        public void generateBody() {
            this.curNodes = this.node.getAtETag();
        }

        @Override
        public boolean isTagFile() {
            return this.pageInfo.isTagFile();
        }

        private Node.JspAttribute getNodeAttribute(String attribute) {
            Node.JspAttribute[] attrs = this.node.getJspAttributes();
            for (int i = 0; attrs != null && i < attrs.length; ++i) {
                if (!attrs[i].getName().equals(attribute)) continue;
                return attrs[i];
            }
            return null;
        }
    }
}

