/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2012 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.web.php;

import java.lang.reflect.Method;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.jboss.web.WebLogger;

/**
 * Implementation of <code>LifecycleListener</code> that will init and
 * and destroy PHP.
 *
 * @author Mladen Turk
 * @version $Revision: 515 $ $Date: 2008-03-17 22:02:23 +0100 (Mon, 17 Mar 2008) $
 * @since 1.0
 */

public class LifecycleListener
    implements org.apache.catalina.LifecycleListener {

    // -------------------------------------------------------------- Constants


    protected static final int REQUIRED_MAJOR = 5;
    protected static final int REQUIRED_MINOR = 2;
    protected static final int REQUIRED_PATCH = 3;


    // ---------------------------------------------- LifecycleListener Methods


    /**
     * Primary entry point for startup and shutdown events.
     *
     * @param event The event that has occurred
     */
    public void lifecycleEvent(LifecycleEvent event) {

        if (Lifecycle.INIT_EVENT.equals(event.getType())) {
            int major = 0;
            int minor = 0;
            int patch = 0;
            try {
                String methodName = "initialize";
                Class paramTypes[] = new Class[1];
                paramTypes[0] = String.class;
                Object paramValues[] = new Object[1];
                paramValues[0] = null;
                Class clazz = Class.forName("org.jboss.web.php.Library");
                Method method = clazz.getMethod(methodName, paramTypes);
                // TODO: Use sm to obtain optional library name.
                method.invoke(null, paramValues);
                major = clazz.getField("PHP_MAJOR_VERSION").getInt(null);
                minor = clazz.getField("PHP_MINOR_VERSION").getInt(null);
                patch = clazz.getField("PHP_PATCH_VERSION").getInt(null);
            } catch (Throwable t) {
                WebLogger.ROOT_LOGGER.errorInitializingPhpLibrary(System.getProperty("java.library.path"), t);
                return;
            }
            // Check if the PHP Native module matches required version.
            if ((major != REQUIRED_MAJOR) ||
                (minor != REQUIRED_MINOR) ||
                (patch <  REQUIRED_PATCH)) {
                WebLogger.ROOT_LOGGER.invalidPhpLibrary(major, minor, patch, 
                        REQUIRED_MAJOR, REQUIRED_MINOR, REQUIRED_PATCH);
            }
        }
        else if (Lifecycle.AFTER_STOP_EVENT.equals(event.getType())) {
            try {
                String methodName = "terminate";
                Method method = Class.forName("org.jboss.php.servlets.php.Library")
                    .getMethod(methodName, (Class [])null);
                method.invoke(null, (Object []) null);
            }
            catch (Throwable t) {
                WebLogger.ROOT_LOGGER.errorTerminatingPhpLibrary(t);
            }
        }
    }
}
