/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jni;

import java.io.File;
import org.apache.tomcat.jni.LibraryLoader;
import org.jboss.web.CoyoteMessages;

public final class Library {
    private static String[] NAMES = new String[]{"tcnative-1", "libtcnative-1"};
    private static Library _instance = null;
    public static int TCN_MAJOR_VERSION = 0;
    public static int TCN_MINOR_VERSION = 0;
    public static int TCN_PATCH_VERSION = 0;
    public static int TCN_IS_DEV_VERSION = 0;
    public static int APR_MAJOR_VERSION = 0;
    public static int APR_MINOR_VERSION = 0;
    public static int APR_PATCH_VERSION = 0;
    public static int APR_IS_DEV_VERSION = 0;
    public static boolean APR_HAVE_IPV6 = false;
    public static boolean APR_HAS_SHARED_MEMORY = false;
    public static boolean APR_HAS_THREADS = false;
    public static boolean APR_HAS_SENDFILE = false;
    public static boolean APR_HAS_MMAP = false;
    public static boolean APR_HAS_FORK = false;
    public static boolean APR_HAS_RANDOM = false;
    public static boolean APR_HAS_OTHER_CHILD = false;
    public static boolean APR_HAS_DSO = false;
    public static boolean APR_HAS_SO_ACCEPTFILTER = false;
    public static boolean APR_HAS_UNICODE_FS = false;
    public static boolean APR_HAS_PROC_INVOKED = false;
    public static boolean APR_HAS_USER = false;
    public static boolean APR_HAS_LARGE_FILES = false;
    public static boolean APR_HAS_XTHREAD_FILES = false;
    public static boolean APR_HAS_OS_UUID = false;
    public static boolean APR_IS_BIGENDIAN = false;
    public static boolean APR_FILES_AS_SOCKETS = false;
    public static boolean APR_CHARSET_EBCDIC = false;
    public static boolean APR_TCP_NODELAY_INHERITED = false;
    public static boolean APR_O_NONBLOCK_INHERITED = false;
    public static int APR_SIZEOF_VOIDP;
    public static int APR_PATH_MAX;
    public static int APRMAXHOSTLEN;
    public static int APR_MAX_IOVEC_SIZE;
    public static int APR_MAX_SECS_TO_LINGER;
    public static int APR_MMAP_THRESHOLD;
    public static int APR_MMAP_LIMIT;

    private Library() throws Exception {
        boolean loaded = false;
        String err = "";
        try {
            LibraryLoader.load(System.getProperty("catalina.home"));
            loaded = true;
        }
        catch (Throwable e) {
            err = err + e.getMessage();
        }
        if (!loaded) {
            for (int i = 0; i < NAMES.length; ++i) {
                try {
                    System.loadLibrary(NAMES[i]);
                    loaded = true;
                }
                catch (Throwable e) {
                    if (i > 0) {
                        err = err + ", ";
                    }
                    String name = System.mapLibraryName(NAMES[i]);
                    String path = System.getProperty("java.library.path");
                    String sep = System.getProperty("path.separator");
                    String[] paths = path.split(sep);
                    for (int j = 0; j < paths.length; ++j) {
                        File fd = new File(paths[j] + System.getProperty("file.separator") + name);
                        if (!fd.exists()) continue;
                        err = err + CoyoteMessages.MESSAGES.aprError() + paths[j] + System.getProperty("file.separator") + name + ")";
                    }
                    err = err + e.getMessage();
                }
                if (loaded) break;
            }
        }
        if (!loaded) {
            err = err + "(";
            err = err + System.getProperty("java.library.path");
            err = err + ")";
            throw new UnsatisfiedLinkError(err);
        }
    }

    private Library(String libraryName) {
        System.loadLibrary(libraryName);
    }

    private static native boolean initialize();

    public static native void terminate();

    private static native boolean has(int var0);

    private static native int version(int var0);

    private static native int size(int var0);

    public static native String versionString();

    public static native String aprVersionString();

    public static native long globalPool();

    public static boolean initialize(String libraryName) throws Exception {
        if (_instance == null) {
            _instance = libraryName == null ? new Library() : new Library(libraryName);
            TCN_MAJOR_VERSION = Library.version(1);
            TCN_MINOR_VERSION = Library.version(2);
            TCN_PATCH_VERSION = Library.version(3);
            TCN_IS_DEV_VERSION = Library.version(4);
            APR_MAJOR_VERSION = Library.version(17);
            APR_MINOR_VERSION = Library.version(18);
            APR_PATCH_VERSION = Library.version(19);
            APR_IS_DEV_VERSION = Library.version(20);
            APR_SIZEOF_VOIDP = Library.size(1);
            APR_PATH_MAX = Library.size(2);
            APRMAXHOSTLEN = Library.size(3);
            APR_MAX_IOVEC_SIZE = Library.size(4);
            APR_MAX_SECS_TO_LINGER = Library.size(5);
            APR_MMAP_THRESHOLD = Library.size(6);
            APR_MMAP_LIMIT = Library.size(7);
            APR_HAVE_IPV6 = Library.has(0);
            APR_HAS_SHARED_MEMORY = Library.has(1);
            APR_HAS_THREADS = Library.has(2);
            APR_HAS_SENDFILE = Library.has(3);
            APR_HAS_MMAP = Library.has(4);
            APR_HAS_FORK = Library.has(5);
            APR_HAS_RANDOM = Library.has(6);
            APR_HAS_OTHER_CHILD = Library.has(7);
            APR_HAS_DSO = Library.has(8);
            APR_HAS_SO_ACCEPTFILTER = Library.has(9);
            APR_HAS_UNICODE_FS = Library.has(10);
            APR_HAS_PROC_INVOKED = Library.has(11);
            APR_HAS_USER = Library.has(12);
            APR_HAS_LARGE_FILES = Library.has(13);
            APR_HAS_XTHREAD_FILES = Library.has(14);
            APR_HAS_OS_UUID = Library.has(15);
            APR_IS_BIGENDIAN = Library.has(16);
            APR_FILES_AS_SOCKETS = Library.has(17);
            APR_CHARSET_EBCDIC = Library.has(18);
            APR_TCP_NODELAY_INHERITED = Library.has(19);
            APR_O_NONBLOCK_INHERITED = Library.has(20);
            if (APR_MAJOR_VERSION < 1) {
                throw CoyoteMessages.MESSAGES.unsupportedAprVersion(Library.aprVersionString());
            }
            if (!APR_HAS_THREADS) {
                throw CoyoteMessages.MESSAGES.missingAprThreadsSupport();
            }
        }
        return Library.initialize();
    }
}

