/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.util.HashMap;
import java.util.Set;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Service;
import org.apache.catalina.connector.CoyoteAdapter;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.AprLifecycleListener;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolHandler;
import org.apache.tomcat.util.Constants;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.web.CatalinaLogger;
import org.jboss.web.CatalinaMessages;

public class Connector
implements Lifecycle,
MBeanRegistration {
    public static final boolean RECYCLE_FACADES = Boolean.valueOf(System.getProperty("org.apache.catalina.connector.RECYCLE_FACADES", Constants.LOW_MEMORY ? "true" : "false"));
    protected static final boolean X_POWERED_BY = Boolean.valueOf(System.getProperty("org.apache.catalina.connector.X_POWERED_BY", "false"));
    protected static final String URI_ENCODING = System.getProperty("org.apache.catalina.connector.URI_ENCODING");
    protected static final boolean USE_BODY_ENCODING_FOR_QUERY_STRING = Boolean.valueOf(System.getProperty("org.apache.catalina.connector.USE_BODY_ENCODING_FOR_QUERY_STRING", "false"));
    protected Service service = null;
    protected boolean allowTrace = false;
    protected Container container = null;
    protected boolean enableLookups = false;
    protected boolean xpoweredBy = X_POWERED_BY;
    protected static final String info = "org.apache.catalina.connector.Connector/2.1";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected int port = 0;
    protected String proxyName = null;
    protected int proxyPort = 0;
    protected int redirectPort = 443;
    protected String scheme = "http";
    protected boolean secure = false;
    protected int maxPostSize = 0x200000;
    protected int maxSavePostSize = 4096;
    protected boolean initialized = false;
    protected boolean started = false;
    protected boolean stopped = false;
    protected boolean useIPVHosts = false;
    protected Thread thread = null;
    protected String protocolHandlerClassName = "org.apache.coyote.http11.Http11Protocol";
    protected ProtocolHandler protocolHandler = null;
    protected Adapter adapter = null;
    protected String URIEncoding = URI_ENCODING;
    protected boolean useBodyEncodingForURI = USE_BODY_ENCODING_FOR_QUERY_STRING;
    protected Set<String> allowedHosts = null;
    protected static HashMap<String, String> replacements = new HashMap();
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;
    ObjectName controller;

    public Connector(String protocol) throws Exception {
        this.setProtocol(protocol);
        try {
            Class<?> clazz = Class.forName(this.protocolHandlerClassName);
            this.protocolHandler = (ProtocolHandler)clazz.newInstance();
        }
        catch (Exception e) {
            throw CatalinaMessages.MESSAGES.protocolHandlerInstantiationFailed(e);
        }
    }

    public Object getProperty(String name) {
        String repl = name;
        if (replacements.get(name) != null) {
            repl = replacements.get(name);
        }
        return IntrospectionUtils.getProperty(this.protocolHandler, repl);
    }

    public boolean setProperty(String name, String value) {
        String repl = name;
        if (replacements.get(name) != null) {
            repl = replacements.get(name);
        }
        return IntrospectionUtils.setProperty(this.protocolHandler, repl, value);
    }

    public Object getAttribute(String name) {
        return this.getProperty(name);
    }

    public void setAttribute(String name, Object value) {
        this.setProperty(name, String.valueOf(value));
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public boolean getAllowTrace() {
        return this.allowTrace;
    }

    public void setAllowTrace(boolean allowTrace) {
        this.allowTrace = allowTrace;
        this.setProperty("allowTrace", String.valueOf(allowTrace));
    }

    public Set<String> getAllowedHosts() {
        return this.allowedHosts;
    }

    public void setAllowedHosts(Set<String> allowedHosts) {
        this.allowedHosts = allowedHosts;
    }

    public boolean isAvailable() {
        return this.started;
    }

    public int getBufferSize() {
        return 2048;
    }

    public void setBufferSize(int bufferSize) {
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public boolean getEnableLookups() {
        return this.enableLookups;
    }

    public void setEnableLookups(boolean enableLookups) {
        this.enableLookups = enableLookups;
        this.setProperty("enableLookups", String.valueOf(enableLookups));
    }

    public String getInfo() {
        return info;
    }

    public int getMaxPostSize() {
        return this.maxPostSize;
    }

    public void setMaxPostSize(int maxPostSize) {
        this.maxPostSize = maxPostSize;
    }

    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setMaxSavePostSize(int maxSavePostSize) {
        this.maxSavePostSize = maxSavePostSize;
        this.setProperty("maxSavePostSize", String.valueOf(maxSavePostSize));
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        this.setProperty("port", String.valueOf(port));
    }

    public String getProtocol() {
        if ("org.apache.coyote.http11.Http11Protocol".equals(this.getProtocolHandlerClassName()) || "org.apache.coyote.http11.Http11AprProtocol".equals(this.getProtocolHandlerClassName()) || "org.apache.coyote.http11.Http11NioProtocol".equals(this.getProtocolHandlerClassName())) {
            return "HTTP/1.1";
        }
        if ("org.apache.coyote.ajp.AjpProtocol".equals(this.getProtocolHandlerClassName()) || "org.apache.coyote.ajp.AjpAprProtocol".equals(this.getProtocolHandlerClassName())) {
            return "AJP/1.3";
        }
        return this.getProtocolHandlerClassName();
    }

    protected void setProtocol(String protocol) {
        if (AprLifecycleListener.isAprInitialized()) {
            if ("HTTP/1.1".equals(protocol) || "http".equals(protocol)) {
                this.setProtocolHandlerClassName("org.apache.coyote.http11.Http11AprProtocol");
            } else if ("AJP/1.3".equals(protocol) || "ajp".equals(protocol)) {
                this.setProtocolHandlerClassName("org.apache.coyote.ajp.AjpAprProtocol");
            } else if (protocol != null) {
                this.setProtocolHandlerClassName(protocol);
            } else {
                this.setProtocolHandlerClassName("org.apache.coyote.http11.Http11AprProtocol");
            }
        } else if ("HTTP/1.1".equals(protocol) || "http".equals(protocol)) {
            this.setProtocolHandlerClassName("org.apache.coyote.http11.Http11NioProtocol");
        } else if ("AJP/1.3".equals(protocol) || "ajp".equals(protocol)) {
            this.setProtocolHandlerClassName("org.apache.coyote.ajp.AjpProtocol");
        } else if (protocol != null) {
            this.setProtocolHandlerClassName(protocol);
        }
    }

    public String getProtocolHandlerClassName() {
        return this.protocolHandlerClassName;
    }

    public void setProtocolHandlerClassName(String protocolHandlerClassName) {
        this.protocolHandlerClassName = protocolHandlerClassName;
    }

    public ProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    public String getProxyName() {
        return this.proxyName;
    }

    public void setProxyName(String proxyName) {
        if (proxyName != null && proxyName.length() > 0) {
            this.proxyName = proxyName;
            this.setProperty("proxyName", proxyName);
        } else {
            this.proxyName = null;
            this.setProperty("proxyName", null);
        }
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        this.setProperty("proxyPort", String.valueOf(proxyPort));
    }

    public int getRedirectPort() {
        return this.redirectPort;
    }

    public void setRedirectPort(int redirectPort) {
        this.redirectPort = redirectPort;
        this.setProperty("redirectPort", String.valueOf(redirectPort));
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
        this.setProperty("secure", Boolean.toString(secure));
    }

    public String getURIEncoding() {
        return this.URIEncoding;
    }

    public void setURIEncoding(String URIEncoding) {
        this.URIEncoding = URIEncoding;
        this.setProperty("uRIEncoding", URIEncoding);
    }

    public boolean getUseBodyEncodingForURI() {
        return this.useBodyEncodingForURI;
    }

    public void setUseBodyEncodingForURI(boolean useBodyEncodingForURI) {
        this.useBodyEncodingForURI = useBodyEncodingForURI;
        this.setProperty("useBodyEncodingForURI", String.valueOf(useBodyEncodingForURI));
    }

    public boolean getXpoweredBy() {
        return this.xpoweredBy;
    }

    public boolean hasIoEvents() {
        return this.protocolHandler.hasIoEvents();
    }

    public void setXpoweredBy(boolean xpoweredBy) {
        this.xpoweredBy = xpoweredBy;
        this.setProperty("xpoweredBy", String.valueOf(xpoweredBy));
    }

    public void setUseIPVHosts(boolean useIPVHosts) {
        this.useIPVHosts = useIPVHosts;
        this.setProperty("useIPVHosts", String.valueOf(useIPVHosts));
    }

    public boolean getUseIPVHosts() {
        return this.useIPVHosts;
    }

    public Request createRequest() {
        Request request = new Request();
        request.setConnector(this);
        return request;
    }

    public Response createResponse() {
        Response response = new Response();
        response.setConnector(this);
        return response;
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    protected ObjectName createObjectName(String domain, String type) throws MalformedObjectNameException {
        String encodedAddr = null;
        if (this.getProperty("address") != null) {
            encodedAddr = ObjectName.quote(this.getProperty("address").toString());
        }
        String addSuffix = this.getProperty("address") == null ? "" : ",address=" + encodedAddr;
        ObjectName _oname = new ObjectName(domain + ":type=" + type + ",port=" + this.getPort() + addSuffix);
        return _oname;
    }

    public void init() throws LifecycleException {
        if (this.initialized) {
            CatalinaLogger.CONNECTOR_LOGGER.connectorAlreadyInitialized();
            return;
        }
        this.initialized = true;
        if (Constants.ENABLE_MODELER && this.oname == null) {
            try {
                this.oname = this.createObjectName(this.container.getName(), "Connector");
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
                this.controller = this.oname;
            }
            catch (Exception e) {
                CatalinaLogger.CONNECTOR_LOGGER.failedConnectorJmxRegistration(this.oname, e);
            }
        }
        this.adapter = new CoyoteAdapter(this);
        this.protocolHandler.setAdapter(this.adapter);
        IntrospectionUtils.setProperty(this.protocolHandler, "jkHome", System.getProperty("catalina.base"));
        try {
            this.protocolHandler.init();
        }
        catch (Exception e) {
            throw new LifecycleException(CatalinaMessages.MESSAGES.protocolHandlerInitFailed(e));
        }
    }

    public void pause() throws LifecycleException {
        try {
            this.protocolHandler.pause();
        }
        catch (Exception e) {
            CatalinaLogger.CONNECTOR_LOGGER.protocolHandlerPauseFailed(e);
        }
    }

    public void resume() throws LifecycleException {
        try {
            this.protocolHandler.resume();
        }
        catch (Exception e) {
            CatalinaLogger.CONNECTOR_LOGGER.protocolHandlerResumeFailed(e);
        }
    }

    @Override
    public void start() throws LifecycleException {
        if (!this.initialized) {
            this.init();
        }
        if (this.started) {
            CatalinaLogger.CONNECTOR_LOGGER.connectorAlreadyStarted();
            return;
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (Constants.ENABLE_MODELER) {
            if (this.oname != null) {
                try {
                    Registry.getRegistry(null, null).registerComponent((Object)this.protocolHandler, this.createObjectName(this.domain, "ProtocolHandler"), null);
                }
                catch (Exception ex) {
                    CatalinaLogger.CONNECTOR_LOGGER.failedProtocolJmxRegistration(this.oname, ex);
                }
            } else {
                CatalinaLogger.CONNECTOR_LOGGER.failedProtocolJmxRegistration();
            }
        }
        try {
            this.protocolHandler.start();
        }
        catch (Exception e) {
            throw new LifecycleException(CatalinaMessages.MESSAGES.protocolHandlerStartFailed(e));
        }
    }

    @Override
    public void stop() throws LifecycleException {
        if (!this.started) {
            CatalinaLogger.CONNECTOR_LOGGER.connectorNotStarted();
            return;
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (Constants.ENABLE_MODELER) {
            try {
                Registry.getRegistry(null, null).unregisterComponent(this.createObjectName(this.domain, "ProtocolHandler"));
            }
            catch (MalformedObjectNameException e) {
                CatalinaLogger.CONNECTOR_LOGGER.failedProtocolJmxUnregistration(this.oname, e);
            }
        }
        try {
            this.protocolHandler.destroy();
        }
        catch (Exception e) {
            throw new LifecycleException(CatalinaMessages.MESSAGES.protocolHandlerDestroyFailed(e));
        }
    }

    public ObjectName getController() {
        return this.controller;
    }

    public void setController(ObjectName controller) {
        this.controller = controller;
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
        try {
            if (this.started) {
                this.stop();
            }
        }
        catch (Throwable t) {
            CatalinaLogger.CONNECTOR_LOGGER.connectorStopFailed(t);
        }
    }

    public void destroy() throws Exception {
        if (Constants.ENABLE_MODELER && this.oname != null && this.controller == this.oname) {
            Registry.getRegistry(null, null).unregisterComponent(this.oname);
        }
        if (this.getService() == null) {
            return;
        }
        this.getService().removeConnector(this);
    }

    static {
        replacements.put("acceptCount", "backlog");
        replacements.put("connectionLinger", "soLinger");
        replacements.put("connectionTimeout", "soTimeout");
        replacements.put("connectionUploadTimeout", "timeout");
        replacements.put("clientAuth", "clientauth");
        replacements.put("keystoreFile", "keystore");
        replacements.put("randomFile", "randomfile");
        replacements.put("rootFile", "rootfile");
        replacements.put("keystorePass", "keypass");
        replacements.put("keystoreType", "keytype");
        replacements.put("sslProtocol", "protocol");
        replacements.put("sslProtocols", "protocols");
    }
}

