/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.bayeux.request;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.cometd.bayeux.Channel;
import org.apache.tomcat.bayeux.BayeuxException;
import org.apache.tomcat.bayeux.BayeuxRequest;
import org.apache.tomcat.bayeux.ChannelImpl;
import org.apache.tomcat.bayeux.ClientImpl;
import org.apache.tomcat.bayeux.HttpError;
import org.apache.tomcat.bayeux.RequestBase;
import org.apache.tomcat.bayeux.TomcatBayeux;
import org.apache.tomcat.util.json.JSONException;
import org.apache.tomcat.util.json.JSONObject;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.web.CoyoteMessages;

public class MetaSubscribeRequest
extends RequestBase
implements BayeuxRequest {
    protected static HashMap<String, Object> responseTemplate = new HashMap();

    public MetaSubscribeRequest(TomcatBayeux tb, HttpEvent event, JSONObject jsReq) throws JSONException {
        super(tb, event, jsReq);
    }

    @Override
    public HttpError validate() {
        if (this.clientId == null || !this.getTomcatBayeux().hasClient(this.clientId)) {
            return new HttpError(400, CoyoteMessages.MESSAGES.invalidBayeuxClientId(), null);
        }
        if (this.subscription == null || this.subscription.length() == 0) {
            return new HttpError(400, CoyoteMessages.MESSAGES.noBayeuxSubscription(), null);
        }
        return null;
    }

    @Override
    public int process(int prevops) throws BayeuxException {
        prevops = super.process(prevops);
        this.response = (HashMap)responseTemplate.clone();
        ClientImpl client = (ClientImpl)this.getTomcatBayeux().getClient(this.clientId);
        HttpError error = this.validate();
        if (error == null) {
            boolean wildcard = this.subscription.indexOf(42) != -1;
            boolean subscribed = false;
            if (wildcard) {
                List<Channel> channels = this.getTomcatBayeux().getChannels();
                for (ChannelImpl channelImpl : channels) {
                    if (!channelImpl.matches(this.subscription)) continue;
                    channelImpl.subscribe(client);
                    subscribed = true;
                }
            } else {
                ChannelImpl ch = (ChannelImpl)this.getTomcatBayeux().getChannel(this.subscription, true);
                ch.subscribe(client);
                subscribed = true;
            }
            this.response.put("successful", subscribed);
            this.response.put("subscription", this.subscription);
            ((HashMap)this.response.get("advice")).put("reconnect", "retry");
            ((HashMap)this.response.get("advice")).put("interval", this.getReconnectInterval());
        } else {
            this.response.put("successful", Boolean.FALSE);
            this.response.put("error", error.toString());
            ((HashMap)this.response.get("advice")).put("reconnect", "handshake");
            if (client == null) {
                client = TomcatBayeux.getErrorClient();
            }
        }
        this.response.put("clientId", client.getId());
        this.response.put("timestamp", this.getTimeStamp());
        try {
            JSONObject obj = new JSONObject(this.response);
            this.addToDeliveryQueue(client, obj);
        }
        catch (ServletException x) {
            throw new BayeuxException(x);
        }
        catch (IOException x) {
            throw new BayeuxException(x);
        }
        return 0;
    }

    static {
        responseTemplate.put("channel", "/meta/subscribe");
        responseTemplate.put("successful", Boolean.TRUE);
        responseTemplate.put("advice", new HashMap());
    }
}

