/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.modeler;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.RegistryMBean;
import org.apache.tomcat.util.modeler.modules.ModelerSource;
import org.jboss.web.CoyoteLogger;

public class Registry
implements RegistryMBean,
MBeanRegistration {
    private static HashMap perLoaderRegistries = null;
    private static Registry registry = null;
    private MBeanServer server = null;
    private HashMap descriptors = new HashMap();
    private HashMap descriptorsByClass = new HashMap();
    private HashMap searchedPaths = new HashMap();
    private Object guard;
    private Hashtable idDomains = new Hashtable();
    private Hashtable ids = new Hashtable();

    public static synchronized Registry getRegistry(Object key, Object guard) {
        if (perLoaderRegistries != null) {
            if (key == null) {
                key = Thread.currentThread().getContextClassLoader();
            }
            if (key != null) {
                Registry localRegistry = (Registry)perLoaderRegistries.get(key);
                if (localRegistry == null) {
                    localRegistry = new Registry();
                    localRegistry.guard = guard;
                    perLoaderRegistries.put(key, localRegistry);
                    return localRegistry;
                }
                if (localRegistry.guard != null && localRegistry.guard != guard) {
                    return null;
                }
                return localRegistry;
            }
        }
        if (registry == null) {
            registry = new Registry();
        }
        if (Registry.registry.guard != null && Registry.registry.guard != guard) {
            return null;
        }
        return registry;
    }

    public static void setUseContextClassLoader(boolean enable) {
        if (enable) {
            perLoaderRegistries = new HashMap();
        }
    }

    @Override
    public void stop() {
        this.descriptorsByClass = new HashMap();
        this.descriptors = new HashMap();
        this.searchedPaths = new HashMap();
    }

    @Override
    public List loadMBeans(Object source, ClassLoader cl) throws Exception {
        return this.load("MbeansSource", source, null);
    }

    @Override
    public void loadMetadata(Object source) throws Exception {
        this.loadDescriptors(null, source, null);
    }

    @Override
    public void registerComponent(Object bean, String oname, String type) throws Exception {
        this.registerComponent(bean, new ObjectName(oname), type);
    }

    @Override
    public void unregisterComponent(String oname) {
        try {
            this.unregisterComponent(new ObjectName(oname));
        }
        catch (MalformedObjectNameException e) {
            CoyoteLogger.MODELER_LOGGER.errorCreatingObjectName(e);
        }
    }

    @Override
    public void invoke(List mbeans, String operation, boolean failFirst) throws Exception {
        if (mbeans == null) {
            return;
        }
        for (Object current : mbeans) {
            ObjectName oN = null;
            try {
                if (current instanceof ObjectName) {
                    oN = (ObjectName)current;
                }
                if (current instanceof String) {
                    oN = new ObjectName((String)current);
                }
                if (oN == null || this.getMethodInfo(oN, operation) == null) continue;
                this.getMBeanServer().invoke(oN, operation, new Object[0], new String[0]);
            }
            catch (Exception t) {
                if (failFirst) {
                    throw t;
                }
                CoyoteLogger.MODELER_LOGGER.errorInvokingOperation(operation, current);
            }
        }
    }

    @Override
    public synchronized int getId(String domain, String name) {
        Integer i;
        Hashtable<String, Integer> domainTable;
        if (domain == null) {
            domain = "";
        }
        if ((domainTable = (Hashtable<String, Integer>)this.idDomains.get(domain)) == null) {
            domainTable = new Hashtable<String, Integer>();
            this.idDomains.put(domain, domainTable);
        }
        if (name == null) {
            name = "";
        }
        if ((i = (Integer)domainTable.get(name)) != null) {
            return i;
        }
        int[] id = (int[])this.ids.get(domain);
        if (id == null) {
            id = new int[1];
            this.ids.put(domain, id);
        }
        int n = id[0];
        id[0] = n + 1;
        int code = n;
        domainTable.put(name, new Integer(code));
        return code;
    }

    public void addManagedBean(ManagedBean bean) {
        this.descriptors.put(bean.getName(), bean);
        if (bean.getType() != null) {
            this.descriptorsByClass.put(bean.getType(), bean);
        }
    }

    public ManagedBean findManagedBean(String name) {
        ManagedBean mb = (ManagedBean)this.descriptors.get(name);
        if (mb == null) {
            mb = (ManagedBean)this.descriptorsByClass.get(name);
        }
        return mb;
    }

    public String[] findManagedBeans() {
        return this.descriptors.keySet().toArray(new String[0]);
    }

    public String[] findManagedBeans(String group) {
        ArrayList<String> results = new ArrayList<String>();
        for (ManagedBean item : this.descriptors.values()) {
            if (group == null && item.getGroup() == null) {
                results.add(item.getName());
                continue;
            }
            if (!group.equals(item.getGroup())) continue;
            results.add(item.getName());
        }
        String[] values = new String[results.size()];
        return results.toArray(values);
    }

    public void removeManagedBean(ManagedBean bean) {
        this.descriptors.remove(bean.getName());
        this.descriptorsByClass.remove(bean.getType());
    }

    public static MBeanServer getServer() {
        return Registry.getRegistry().getMBeanServer();
    }

    public static void setServer(MBeanServer mbeanServer) {
        Registry.getRegistry().setMBeanServer(mbeanServer);
    }

    public static void loadRegistry(InputStream stream) throws Exception {
        Registry registry = Registry.getRegistry();
        registry.loadMetadata(stream);
    }

    public static synchronized Registry getRegistry() {
        return Registry.getRegistry(null, null);
    }

    public String getType(ObjectName oname, String attName) {
        String type = null;
        MBeanInfo info = null;
        try {
            info = this.server.getMBeanInfo(oname);
        }
        catch (Exception e) {
            CoyoteLogger.MODELER_LOGGER.noMetadata(oname);
            return null;
        }
        MBeanAttributeInfo[] attInfo = info.getAttributes();
        for (int i = 0; i < attInfo.length; ++i) {
            if (!attName.equals(attInfo[i].getName())) continue;
            type = attInfo[i].getType();
            return type;
        }
        return null;
    }

    public MBeanOperationInfo getMethodInfo(ObjectName oname, String opName) {
        Object type = null;
        MBeanInfo info = null;
        try {
            info = this.server.getMBeanInfo(oname);
        }
        catch (Exception e) {
            CoyoteLogger.MODELER_LOGGER.noMetadata(oname);
            return null;
        }
        MBeanOperationInfo[] attInfo = info.getOperations();
        for (int i = 0; i < attInfo.length; ++i) {
            if (!opName.equals(attInfo[i].getName())) continue;
            return attInfo[i];
        }
        return null;
    }

    public void unregisterComponent(ObjectName oname) {
        try {
            if (this.getMBeanServer().isRegistered(oname)) {
                this.getMBeanServer().unregisterMBean(oname);
            }
        }
        catch (Throwable t) {
            CoyoteLogger.MODELER_LOGGER.errorUnregisteringMbean(oname, t);
        }
    }

    public synchronized MBeanServer getMBeanServer() {
        long t1 = System.currentTimeMillis();
        if (this.server == null) {
            if (MBeanServerFactory.findMBeanServer(null).size() > 0) {
                this.server = MBeanServerFactory.findMBeanServer(null).get(0);
                if (CoyoteLogger.MODELER_LOGGER.isDebugEnabled()) {
                    CoyoteLogger.MODELER_LOGGER.debug("Using existing MBeanServer " + (System.currentTimeMillis() - t1));
                }
            } else {
                this.server = MBeanServerFactory.createMBeanServer();
                if (CoyoteLogger.MODELER_LOGGER.isDebugEnabled()) {
                    CoyoteLogger.MODELER_LOGGER.debug("Creating MBeanServer" + (System.currentTimeMillis() - t1));
                }
            }
        }
        return this.server;
    }

    public ManagedBean findManagedBean(Object bean, Class beanClass, String type) throws Exception {
        ManagedBean managed;
        if (bean != null && beanClass == null) {
            beanClass = bean.getClass();
        }
        if (type == null) {
            type = beanClass.getName();
        }
        if ((managed = this.findManagedBean(type)) == null) {
            if (CoyoteLogger.MODELER_LOGGER.isDebugEnabled()) {
                CoyoteLogger.MODELER_LOGGER.debug("Looking for descriptor ");
            }
            this.findDescriptor(beanClass, type);
            managed = this.findManagedBean(type);
        }
        if (bean instanceof DynamicMBean) {
            if (CoyoteLogger.MODELER_LOGGER.isDebugEnabled()) {
                CoyoteLogger.MODELER_LOGGER.debug("Dynamic mbean support ");
            }
            this.loadDescriptors("MbeansDescriptorsDynamicMBeanSource", bean, type);
            managed = this.findManagedBean(type);
        }
        if (managed == null) {
            if (CoyoteLogger.MODELER_LOGGER.isDebugEnabled()) {
                CoyoteLogger.MODELER_LOGGER.debug("Introspecting ");
            }
            this.loadDescriptors("MbeansDescriptorsIntrospectionSource", beanClass, type);
            managed = this.findManagedBean(type);
            if (managed == null) {
                CoyoteLogger.MODELER_LOGGER.noMetadata(type);
                return null;
            }
            managed.setName(type);
            this.addManagedBean(managed);
        }
        return managed;
    }

    public Object convertValue(String type, String value) {
        Object objValue = value;
        if (type == null || "java.lang.String".equals(type)) {
            objValue = value;
        } else if ("javax.management.ObjectName".equals(type) || "ObjectName".equals(type)) {
            try {
                objValue = new ObjectName(value);
            }
            catch (MalformedObjectNameException e) {
                return null;
            }
        } else if ("java.lang.Integer".equals(type) || "int".equals(type)) {
            objValue = new Integer(value);
        } else if ("java.lang.Long".equals(type) || "long".equals(type)) {
            objValue = new Long(value);
        } else if ("java.lang.Boolean".equals(type) || "boolean".equals(type)) {
            objValue = new Boolean(value);
        }
        return objValue;
    }

    public List load(String sourceType, Object source, String param) throws Exception {
        if (CoyoteLogger.MODELER_LOGGER.isTraceEnabled()) {
            CoyoteLogger.MODELER_LOGGER.trace("load " + source);
        }
        String location = null;
        String type = null;
        Object inputsource = null;
        if (source instanceof DynamicMBean) {
            sourceType = "MbeansDescriptorsDynamicMBeanSource";
            inputsource = source;
        } else if (source instanceof URL) {
            URL url = (URL)source;
            location = url.toString();
            type = param;
            inputsource = url.openStream();
            if (sourceType == null) {
                sourceType = this.sourceTypeFromExt(location);
            }
        } else if (source instanceof File) {
            location = ((File)source).getAbsolutePath();
            inputsource = new FileInputStream((File)source);
            type = param;
            if (sourceType == null) {
                sourceType = this.sourceTypeFromExt(location);
            }
        } else if (source instanceof InputStream) {
            type = param;
            inputsource = source;
        } else if (source instanceof Class) {
            location = ((Class)source).getName();
            type = param;
            inputsource = source;
            if (sourceType == null) {
                sourceType = "MbeansDescriptorsIntrospectionSource";
            }
        }
        if (sourceType == null) {
            sourceType = "MbeansDescriptorsDOMSource";
        }
        ModelerSource ds = this.getModelerSource(sourceType);
        List mbeans = ds.loadDescriptors(this, location, type, inputsource);
        return mbeans;
    }

    private String sourceTypeFromExt(String s) {
        if (s.endsWith(".ser")) {
            return "MbeansDescriptorsSerSource";
        }
        if (s.endsWith(".xml")) {
            return "MbeansDescriptorsDOMSource";
        }
        return null;
    }

    public void registerComponent(Object bean, ObjectName oname, String type) throws Exception {
        if (CoyoteLogger.MODELER_LOGGER.isDebugEnabled()) {
            CoyoteLogger.MODELER_LOGGER.debug("Managed= " + oname);
        }
        if (bean == null) {
            CoyoteLogger.MODELER_LOGGER.nullComponent(oname);
            return;
        }
        try {
            if (type == null) {
                type = bean.getClass().getName();
            }
            ManagedBean managed = this.findManagedBean(bean.getClass(), type);
            DynamicMBean mbean = managed.createMBean(bean);
            if (this.getMBeanServer().isRegistered(oname)) {
                if (CoyoteLogger.MODELER_LOGGER.isDebugEnabled()) {
                    CoyoteLogger.MODELER_LOGGER.debug("Unregistering existing component " + oname);
                }
                this.getMBeanServer().unregisterMBean(oname);
            }
            this.getMBeanServer().registerMBean(mbean, oname);
        }
        catch (Exception ex) {
            CoyoteLogger.MODELER_LOGGER.errorRegisteringMbean(oname, ex);
            throw ex;
        }
    }

    public void loadDescriptors(String packageName, ClassLoader classLoader) {
        String res = packageName.replace('.', '/');
        if (CoyoteLogger.MODELER_LOGGER.isTraceEnabled()) {
            CoyoteLogger.MODELER_LOGGER.trace("Finding descriptor " + res);
        }
        if (this.searchedPaths.get(packageName) != null) {
            return;
        }
        String descriptors = res + "/mbeans-descriptors.ser";
        URL dURL = classLoader.getResource(descriptors);
        if (dURL == null) {
            descriptors = res + "/mbeans-descriptors.xml";
            dURL = classLoader.getResource(descriptors);
        }
        if (dURL == null) {
            return;
        }
        if (CoyoteLogger.MODELER_LOGGER.isDebugEnabled()) {
            CoyoteLogger.MODELER_LOGGER.debug("Found " + dURL);
        }
        this.searchedPaths.put(packageName, dURL);
        try {
            if (descriptors.endsWith(".xml")) {
                this.loadDescriptors("MbeansDescriptorsDOMSource", dURL, null);
            } else {
                this.loadDescriptors("MbeansDescriptorsSerSource", dURL, null);
            }
            return;
        }
        catch (Exception ex) {
            CoyoteLogger.MODELER_LOGGER.errorLoading(dURL);
            return;
        }
    }

    public void loadDescriptors(String sourceType, Object source, String param) throws Exception {
        List mbeans = this.load(sourceType, source, param);
        if (mbeans == null) {
            return;
        }
        for (Object mb : mbeans) {
            if (!(mb instanceof ManagedBean)) continue;
            this.addManagedBean((ManagedBean)mb);
        }
    }

    private void findDescriptor(Class beanClass, String type) {
        String className;
        if (type == null) {
            type = beanClass.getName();
        }
        ClassLoader classLoader = null;
        if (beanClass != null) {
            classLoader = beanClass.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        String pkg = className = type;
        while (pkg.indexOf(".") > 0) {
            int lastComp = pkg.lastIndexOf(".");
            if (lastComp <= 0) {
                return;
            }
            if (this.searchedPaths.get(pkg = pkg.substring(0, lastComp)) != null) {
                return;
            }
            this.loadDescriptors(pkg, classLoader);
        }
    }

    private ModelerSource getModelerSource(String type) throws Exception {
        if (type == null) {
            type = "MbeansDescriptorsDOMSource";
        }
        if (type.indexOf(".") < 0) {
            type = "org.apache.tomcat.util.modeler.modules." + type;
        }
        Class<?> c = Class.forName(type);
        ModelerSource ds = (ModelerSource)c.newInstance();
        return ds;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    public void unregisterRegistry(ClassLoader loader) {
        perLoaderRegistries.remove(loader);
    }

    public ManagedBean findManagedBean(Class beanClass, String type) throws Exception {
        return this.findManagedBean(null, beanClass, type);
    }

    public void setMBeanServer(MBeanServer server) {
        this.server = server;
    }

    public void resetMetadata() {
        this.stop();
    }

    public void loadDescriptors(Object source) throws Exception {
        this.loadDescriptors("MbeansDescriptorsDOMSource", source, null);
    }

    public void registerComponent(Object bean, String domain, String type, String name) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(domain).append(":");
        sb.append(name);
        String nameStr = sb.toString();
        ObjectName oname = new ObjectName(nameStr);
        this.registerComponent(bean, oname, type);
    }

    public void unregisterComponent(String domain, String name) {
        ObjectName oname = null;
        try {
            oname = new ObjectName(domain + ":" + name);
            this.getMBeanServer().unregisterMBean(oname);
        }
        catch (Throwable t) {
            CoyoteLogger.MODELER_LOGGER.errorUnregisteringMbean(oname, t);
        }
    }

    public void loadCachedDescriptors(Object source) throws Exception {
        this.loadDescriptors("MbeansDescriptorsSerSource", source, null);
    }
}

